/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;

public abstract class DispatchNode
extends RubyNode {
    private final DispatchAction dispatchAction;
    public static final Object MISSING = new Object();

    public DispatchNode(RubyContext context, DispatchAction dispatchAction) {
        super(context, null);
        this.dispatchAction = dispatchAction;
        assert (dispatchAction != null);
    }

    public DispatchNode(DispatchNode prev) {
        super(prev);
        this.dispatchAction = prev.dispatchAction;
    }

    public abstract Object executeDispatch(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

    @CompilerDirectives.TruffleBoundary
    protected RubyConstant lookupConstant(RubyModule module, String name2, boolean ignoreVisibility) {
        LexicalScope lexicalScope = this.getHeadNode().getLexicalScope();
        RubyConstant constant = ModuleOperations.lookupConstant(this.getContext(), lexicalScope, module, name2);
        if (constant == null) {
            return null;
        }
        if (!ignoreVisibility && !constant.isVisibleTo(this.getContext(), lexicalScope, module)) {
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorPrivateConstant(module, name2, this));
        }
        return constant;
    }

    @CompilerDirectives.TruffleBoundary
    protected InternalMethod lookup(RubyClass callerClass, Object receiver2, String name2, boolean ignoreVisibility) {
        InternalMethod method = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver2), name2);
        if (method == null) {
            return null;
        }
        if (method.isUndefined()) {
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(name2, receiver2.toString(), this));
        }
        if (!ignoreVisibility && !method.isVisibleTo(this, callerClass)) {
            DispatchAction dispatchAction = this.getHeadNode().getDispatchAction();
            if (dispatchAction == DispatchAction.CALL_METHOD) {
                throw new RaiseException(this.getContext().getCoreLibrary().privateMethodError(name2, receiver2.toString(), this));
            }
            if (dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
                return null;
            }
            throw new UnsupportedOperationException();
        }
        return method;
    }

    protected Object resetAndDispatch(VirtualFrame frame, Object receiverObject, Object methodName, RubyProc blockObject, Object argumentsObjects, String reason2) {
        DispatchHeadNode head = this.getHeadNode();
        head.reset(reason2);
        return head.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    protected DispatchHeadNode getHeadNode() {
        return (DispatchHeadNode)((Object)NodeUtil.findParent((Node)this, DispatchHeadNode.class));
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        throw new IllegalStateException("do not call execute on dispatch nodes");
    }

    public DispatchAction getDispatchAction() {
        return this.dispatchAction;
    }
}

