/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.RubyGC;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.util.Memo;

@CoreClass(name="Truffle::Primitive")
public abstract class TrufflePrimitiveNodes {

    @CoreMethod(names={"gc_time"}, onSingleton=true)
    public static abstract class GCTimeNode
    extends CoreMethodNode {
        public GCTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GCTimeNode(GCTimeNode prev) {
            super(prev);
        }

        @Specialization
        public long gcTime() {
            return RubyGC.getCollectionTime();
        }
    }

    @CoreMethod(names={"gc_count"}, onSingleton=true)
    public static abstract class GCCountNode
    extends CoreMethodNode {
        public GCCountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GCCountNode(GCCountNode prev) {
            super(prev);
        }

        @Specialization
        public int gcCount() {
            return RubyGC.getCollectionCount();
        }
    }

    @CoreMethod(names={"binding_of_caller"}, onSingleton=true)
    public static abstract class BindingOfCallerNode
    extends CoreMethodNode {
        public BindingOfCallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BindingOfCallerNode(BindingOfCallerNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBinding bindingOfCaller() {
            BindingOfCallerNode.notDesignedForCompilation();
            final Memo<Integer> frameCount = new Memo<Integer>(0);
            MaterializedFrame frame = (MaterializedFrame)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<MaterializedFrame>(){

                public MaterializedFrame visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE, false).materialize();
                    }
                    frameCount.set((Integer)frameCount.get() + 1);
                    return null;
                }
            });
            return new RubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(frame.getArguments()), frame);
        }
    }
}

