/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=StringNodes.class)
public final class StringNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AddNodeFactory.getInstance(), MulNodeFactory.getInstance(), EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), ConcatNodeFactory.getInstance(), FormatNodeFactory.getInstance(), GetIndexNodeFactory.getInstance(), ElementSetNodeFactory.getInstance(), MatchOperatorNodeFactory.getInstance(), BNodeFactory.getInstance(), BytesNodeFactory.getInstance(), ChompNodeFactory.getInstance(), ChompBangNodeFactory.getInstance(), CountNodeFactory.getInstance(), DowncaseNodeFactory.getInstance(), DowncaseBangNodeFactory.getInstance(), EachLineNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), EncodeNodeFactory.getInstance(), EncodingNodeFactory.getInstance(), EndWithNodeFactory.getInstance(), ForceEncodingNodeFactory.getInstance(), GsubNodeFactory.getInstance(), GetByteNodeFactory.getInstance(), InspectNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InsertNodeFactory.getInstance(), LjustNodeFactory.getInstance(), MatchNodeFactory.getInstance(), OrdNodeFactory.getInstance(), RindexNodeFactory.getInstance(), RjustNodeFactory.getInstance(), RStripNodeFactory.getInstance(), DumpNodeFactory.getInstance(), ScanNodeFactory.getInstance(), SetByteNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SplitNodeFactory.getInstance(), StartWithNodeFactory.getInstance(), SubNodeFactory.getInstance(), SuccNodeFactory.getInstance(), SuccBangNodeFactory.getInstance(), SumNodeFactory.getInstance(), ToFNodeFactory.getInstance(), ToINodeFactory.getInstance(), ToSNodeFactory.getInstance(), ToSymNodeFactory.getInstance(), ReverseNodeFactory.getInstance(), ReverseBangNodeFactory.getInstance(), UnpackNodeFactory.getInstance(), UpcaseNodeFactory.getInstance(), UpcaseBangNodeFactory.getInstance(), CapitalizeBangNodeFactory.getInstance(), CapitalizeNodeFactory.getInstance(), ClearNodeFactory.getInstance(), ChrNodeFactory.getInstance());
    }

    @GeneratedBy(value=StringNodes.ChrNode.class)
    public static final class ChrNodeFactory
    extends NodeFactoryBase<StringNodes.ChrNode> {
        private static ChrNodeFactory chrNodeFactoryInstance;

        private ChrNodeFactory() {
            super(StringNodes.ChrNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ChrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ChrNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ChrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ChrUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ChrNode> getInstance() {
            if (chrNodeFactoryInstance == null) {
                chrNodeFactoryInstance = new ChrNodeFactory();
            }
            return chrNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ChrNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ChrPolymorphicNode
        extends ChrBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ChrPolymorphicNode(ChrBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ChrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ChrRubyStringNode
        extends ChrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChrRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ChrRubyStringNode(ChrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.chr(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.chr(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ChrNode create0(StringNodes.ChrNode current2) {
                return new ChrRubyStringNode((ChrBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ChrNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ChrUninitializedNode
        extends ChrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChrUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ChrUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ChrUninitializedNode(ChrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ChrBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ChrBaseNode rootNode = (ChrBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ChrBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ChrNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ChrUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ChrNode.class)
        private static abstract class ChrBaseNode
        extends StringNodes.ChrNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ChrBaseNode next0;

            ChrBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ChrBaseNode(ChrBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ChrBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ChrBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ChrUninitializedNode(this);
                    ((ChrUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ChrBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ChrBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ChrBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ChrUninitializedNode(this), (Node)new ChrPolymorphicNode(this), (DSLNode)((ChrBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ChrBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ChrBaseNode)ChrRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ChrBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ChrBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<StringNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(StringNodes.ClearNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ClearNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClearNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ClearNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClearUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClearPolymorphicNode
        extends ClearBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ClearPolymorphicNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClearRubyStringNode
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ClearRubyStringNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.clear(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.clear(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ClearNode create0(StringNodes.ClearNode current2) {
                return new ClearRubyStringNode((ClearBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClearUninitializedNode
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClearUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClearUninitializedNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ClearBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClearBaseNode rootNode = (ClearBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClearBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ClearNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClearUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ClearNode.class)
        private static abstract class ClearBaseNode
        extends StringNodes.ClearNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClearBaseNode next0;

            ClearBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClearBaseNode(ClearBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ClearBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClearBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ClearUninitializedNode(this);
                    ((ClearUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClearBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ClearBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ClearBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClearUninitializedNode(this), (Node)new ClearPolymorphicNode(this), (DSLNode)((ClearBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClearBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ClearBaseNode)ClearRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ClearBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ClearBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.CapitalizeNode.class)
    public static final class CapitalizeNodeFactory
    extends NodeFactoryBase<StringNodes.CapitalizeNode> {
        private static CapitalizeNodeFactory capitalizeNodeFactoryInstance;

        private CapitalizeNodeFactory() {
            super(StringNodes.CapitalizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CapitalizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CapitalizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.CapitalizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CapitalizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.CapitalizeNode> getInstance() {
            if (capitalizeNodeFactoryInstance == null) {
                capitalizeNodeFactoryInstance = new CapitalizeNodeFactory();
            }
            return capitalizeNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.CapitalizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CapitalizePolymorphicNode
        extends CapitalizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CapitalizePolymorphicNode(CapitalizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CapitalizeRubyStringNode
        extends CapitalizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapitalizeRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            CapitalizeRubyStringNode(CapitalizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.capitalize(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.capitalize(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.CapitalizeNode create0(StringNodes.CapitalizeNode current2) {
                return new CapitalizeRubyStringNode((CapitalizeBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CapitalizeUninitializedNode
        extends CapitalizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapitalizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CapitalizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CapitalizeUninitializedNode(CapitalizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CapitalizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CapitalizeBaseNode rootNode = (CapitalizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CapitalizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.CapitalizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CapitalizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeNode.class)
        private static abstract class CapitalizeBaseNode
        extends StringNodes.CapitalizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CapitalizeBaseNode next0;

            CapitalizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CapitalizeBaseNode(CapitalizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                CapitalizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CapitalizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CapitalizeUninitializedNode(this);
                    ((CapitalizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CapitalizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = CapitalizeBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (CapitalizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CapitalizeUninitializedNode(this), (Node)new CapitalizePolymorphicNode(this), (DSLNode)((CapitalizeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CapitalizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (CapitalizeBaseNode)CapitalizeRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CapitalizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CapitalizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
    public static final class CapitalizeBangNodeFactory
    extends NodeFactoryBase<StringNodes.CapitalizeBangNode> {
        private static CapitalizeBangNodeFactory capitalizeBangNodeFactoryInstance;

        private CapitalizeBangNodeFactory() {
            super(StringNodes.CapitalizeBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CapitalizeBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CapitalizeBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.CapitalizeBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CapitalizeBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.CapitalizeBangNode> getInstance() {
            if (capitalizeBangNodeFactoryInstance == null) {
                capitalizeBangNodeFactoryInstance = new CapitalizeBangNodeFactory();
            }
            return capitalizeBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CapitalizeBangPolymorphicNode
        extends CapitalizeBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CapitalizeBangPolymorphicNode(CapitalizeBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CapitalizeBangRubyStringNode
        extends CapitalizeBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapitalizeBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            CapitalizeBangRubyStringNode(CapitalizeBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.capitalizeBang(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.capitalizeBang(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.CapitalizeBangNode create0(StringNodes.CapitalizeBangNode current2) {
                return new CapitalizeBangRubyStringNode((CapitalizeBangBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CapitalizeBangUninitializedNode
        extends CapitalizeBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapitalizeBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CapitalizeBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CapitalizeBangUninitializedNode(CapitalizeBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CapitalizeBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CapitalizeBangBaseNode rootNode = (CapitalizeBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CapitalizeBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.CapitalizeBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CapitalizeBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
        private static abstract class CapitalizeBangBaseNode
        extends StringNodes.CapitalizeBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CapitalizeBangBaseNode next0;

            CapitalizeBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CapitalizeBangBaseNode(CapitalizeBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                CapitalizeBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CapitalizeBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CapitalizeBangUninitializedNode(this);
                    ((CapitalizeBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CapitalizeBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = CapitalizeBangBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (CapitalizeBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CapitalizeBangUninitializedNode(this), (Node)new CapitalizeBangPolymorphicNode(this), (DSLNode)((CapitalizeBangBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CapitalizeBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (CapitalizeBangBaseNode)CapitalizeBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CapitalizeBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CapitalizeBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
    public static final class UpcaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.UpcaseBangNode> {
        private static UpcaseBangNodeFactory upcaseBangNodeFactoryInstance;

        private UpcaseBangNodeFactory() {
            super(StringNodes.UpcaseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.UpcaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpcaseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.UpcaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UpcaseBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.UpcaseBangNode> getInstance() {
            if (upcaseBangNodeFactoryInstance == null) {
                upcaseBangNodeFactoryInstance = new UpcaseBangNodeFactory();
            }
            return upcaseBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UpcaseBangPolymorphicNode
        extends UpcaseBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            UpcaseBangPolymorphicNode(UpcaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UpcaseBangRubyStringNode
        extends UpcaseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpcaseBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            UpcaseBangRubyStringNode(UpcaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.upcaseBang(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.upcaseBang(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.UpcaseBangNode create0(StringNodes.UpcaseBangNode current2) {
                return new UpcaseBangRubyStringNode((UpcaseBangBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UpcaseBangUninitializedNode
        extends UpcaseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpcaseBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UpcaseBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UpcaseBangUninitializedNode(UpcaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                UpcaseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UpcaseBangBaseNode rootNode = (UpcaseBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UpcaseBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.UpcaseBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UpcaseBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
        private static abstract class UpcaseBangBaseNode
        extends StringNodes.UpcaseBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UpcaseBangBaseNode next0;

            UpcaseBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UpcaseBangBaseNode(UpcaseBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                UpcaseBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UpcaseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new UpcaseBangUninitializedNode(this);
                    ((UpcaseBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UpcaseBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = UpcaseBangBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (UpcaseBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UpcaseBangUninitializedNode(this), (Node)new UpcaseBangPolymorphicNode(this), (DSLNode)((UpcaseBangBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UpcaseBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (UpcaseBangBaseNode)UpcaseBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((UpcaseBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (UpcaseBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.UpcaseNode.class)
    public static final class UpcaseNodeFactory
    extends NodeFactoryBase<StringNodes.UpcaseNode> {
        private static UpcaseNodeFactory upcaseNodeFactoryInstance;

        private UpcaseNodeFactory() {
            super(StringNodes.UpcaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.UpcaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpcaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.UpcaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UpcaseUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.UpcaseNode> getInstance() {
            if (upcaseNodeFactoryInstance == null) {
                upcaseNodeFactoryInstance = new UpcaseNodeFactory();
            }
            return upcaseNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.UpcaseNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UpcasePolymorphicNode
        extends UpcaseBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            UpcasePolymorphicNode(UpcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UpcaseRubyStringNode
        extends UpcaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpcaseRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            UpcaseRubyStringNode(UpcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.upcase(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.upcase(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.UpcaseNode create0(StringNodes.UpcaseNode current2) {
                return new UpcaseRubyStringNode((UpcaseBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UpcaseUninitializedNode
        extends UpcaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpcaseUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UpcaseUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UpcaseUninitializedNode(UpcaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                UpcaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UpcaseBaseNode rootNode = (UpcaseBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UpcaseBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.UpcaseNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UpcaseUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.UpcaseNode.class)
        private static abstract class UpcaseBaseNode
        extends StringNodes.UpcaseNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UpcaseBaseNode next0;

            UpcaseBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UpcaseBaseNode(UpcaseBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                UpcaseBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UpcaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new UpcaseUninitializedNode(this);
                    ((UpcaseUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UpcaseBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = UpcaseBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (UpcaseBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UpcaseUninitializedNode(this), (Node)new UpcasePolymorphicNode(this), (DSLNode)((UpcaseBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UpcaseBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (UpcaseBaseNode)UpcaseRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((UpcaseBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (UpcaseBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.UnpackNode.class)
    public static final class UnpackNodeFactory
    extends NodeFactoryBase<StringNodes.UnpackNode> {
        private static UnpackNodeFactory unpackNodeFactoryInstance;

        private UnpackNodeFactory() {
            super(StringNodes.UnpackNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.UnpackNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UnpackNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.UnpackNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UnpackUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.UnpackNode> getInstance() {
            if (unpackNodeFactoryInstance == null) {
                unpackNodeFactoryInstance = new UnpackNodeFactory();
            }
            return unpackNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.UnpackNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UnpackPolymorphicNode
        extends UnpackBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            UnpackPolymorphicNode(UnpackBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.UnpackNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UnpackRubyStringNode
        extends UnpackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnpackRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            UnpackRubyStringNode(UnpackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.unpack(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.unpack(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.UnpackNode create0(StringNodes.UnpackNode current2) {
                return new UnpackRubyStringNode((UnpackBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.UnpackNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UnpackUninitializedNode
        extends UnpackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnpackUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UnpackUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UnpackUninitializedNode(UnpackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                UnpackBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UnpackBaseNode rootNode = (UnpackBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UnpackBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.UnpackNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UnpackUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.UnpackNode.class)
        private static abstract class UnpackBaseNode
        extends StringNodes.UnpackNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UnpackBaseNode next0;

            UnpackBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UnpackBaseNode(UnpackBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                UnpackBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UnpackBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new UnpackUninitializedNode(this);
                    ((UnpackUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UnpackBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = UnpackBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (UnpackBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UnpackUninitializedNode(this), (Node)new UnpackPolymorphicNode(this), (DSLNode)((UnpackBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UnpackBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (UnpackBaseNode)UnpackRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    UnpackBaseNode otherCast = (UnpackBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (UnpackBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ReverseBangNode.class)
    public static final class ReverseBangNodeFactory
    extends NodeFactoryBase<StringNodes.ReverseBangNode> {
        private static ReverseBangNodeFactory reverseBangNodeFactoryInstance;

        private ReverseBangNodeFactory() {
            super(StringNodes.ReverseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ReverseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReverseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ReverseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ReverseBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ReverseBangNode> getInstance() {
            if (reverseBangNodeFactoryInstance == null) {
                reverseBangNodeFactoryInstance = new ReverseBangNodeFactory();
            }
            return reverseBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReverseBangPolymorphicNode
        extends ReverseBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ReverseBangPolymorphicNode(ReverseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReverseBangRubyStringNode
        extends ReverseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReverseBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ReverseBangRubyStringNode(ReverseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.reverse(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.reverse(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ReverseBangNode create0(StringNodes.ReverseBangNode current2) {
                return new ReverseBangRubyStringNode((ReverseBangBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReverseBangUninitializedNode
        extends ReverseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReverseBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReverseBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ReverseBangUninitializedNode(ReverseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ReverseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReverseBangBaseNode rootNode = (ReverseBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ReverseBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ReverseBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ReverseBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        private static abstract class ReverseBangBaseNode
        extends StringNodes.ReverseBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ReverseBangBaseNode next0;

            ReverseBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ReverseBangBaseNode(ReverseBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ReverseBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReverseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ReverseBangUninitializedNode(this);
                    ((ReverseBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ReverseBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ReverseBangBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ReverseBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ReverseBangUninitializedNode(this), (Node)new ReverseBangPolymorphicNode(this), (DSLNode)((ReverseBangBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReverseBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ReverseBangBaseNode)ReverseBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ReverseBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ReverseBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ReverseNode.class)
    public static final class ReverseNodeFactory
    extends NodeFactoryBase<StringNodes.ReverseNode> {
        private static ReverseNodeFactory reverseNodeFactoryInstance;

        private ReverseNodeFactory() {
            super(StringNodes.ReverseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ReverseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReverseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ReverseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ReverseUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ReverseNode> getInstance() {
            if (reverseNodeFactoryInstance == null) {
                reverseNodeFactoryInstance = new ReverseNodeFactory();
            }
            return reverseNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ReverseNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReversePolymorphicNode
        extends ReverseBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ReversePolymorphicNode(ReverseBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReverseRubyStringNode
        extends ReverseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReverseRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ReverseRubyStringNode(ReverseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.reverse(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.reverse(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ReverseNode create0(StringNodes.ReverseNode current2) {
                return new ReverseRubyStringNode((ReverseBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReverseUninitializedNode
        extends ReverseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReverseUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReverseUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ReverseUninitializedNode(ReverseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ReverseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReverseBaseNode rootNode = (ReverseBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ReverseBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ReverseNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ReverseUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ReverseNode.class)
        private static abstract class ReverseBaseNode
        extends StringNodes.ReverseNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ReverseBaseNode next0;

            ReverseBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ReverseBaseNode(ReverseBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ReverseBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReverseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ReverseUninitializedNode(this);
                    ((ReverseUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ReverseBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ReverseBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ReverseBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ReverseUninitializedNode(this), (Node)new ReversePolymorphicNode(this), (DSLNode)((ReverseBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReverseBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ReverseBaseNode)ReverseRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ReverseBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ReverseBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToSymNode.class)
    public static final class ToSymNodeFactory
    extends NodeFactoryBase<StringNodes.ToSymNode> {
        private static ToSymNodeFactory toSymNodeFactoryInstance;

        private ToSymNodeFactory() {
            super(StringNodes.ToSymNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ToSymNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSymNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ToSymNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSymUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ToSymNode> getInstance() {
            if (toSymNodeFactoryInstance == null) {
                toSymNodeFactoryInstance = new ToSymNodeFactory();
            }
            return toSymNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ToSymNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSymPolymorphicNode
        extends ToSymBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSymPolymorphicNode(ToSymBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ToSymNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSymRubyStringNode
        extends ToSymBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSymRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ToSymRubyStringNode(ToSymBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.toSym(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.toSym(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToSymNode create0(StringNodes.ToSymNode current2) {
                return new ToSymRubyStringNode((ToSymBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ToSymNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSymUninitializedNode
        extends ToSymBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSymUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSymUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSymUninitializedNode(ToSymBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value2;
                try {
                    value2 = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSymBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSymBaseNode rootNode = (ToSymBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSymBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToSymNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSymUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ToSymNode.class)
        private static abstract class ToSymBaseNode
        extends StringNodes.ToSymNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSymBaseNode next0;

            ToSymBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSymBaseNode(ToSymBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToSymBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSymBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSymUninitializedNode(this);
                    ((ToSymUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSymBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToSymBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ToSymBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSymUninitializedNode(this), (Node)new ToSymPolymorphicNode(this), (DSLNode)((ToSymBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSymBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ToSymBaseNode)ToSymRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSymBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSymBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<StringNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(StringNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSPolymorphicNode
        extends ToSBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSPolymorphicNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSRubyStringNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ToSRubyStringNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.toS(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.toS(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToSNode create0(StringNodes.ToSNode current2) {
                return new ToSRubyStringNode((ToSBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSUninitializedNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSUninitializedNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSBaseNode rootNode = (ToSBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends StringNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSBaseNode next0;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSBaseNode(ToSBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToSBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSUninitializedNode(this);
                    ((ToSUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToSBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ToSBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSUninitializedNode(this), (Node)new ToSPolymorphicNode(this), (DSLNode)((ToSBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ToSBaseNode)ToSRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToINode.class)
    public static final class ToINodeFactory
    extends NodeFactoryBase<StringNodes.ToINode> {
        private static ToINodeFactory toINodeFactoryInstance;

        private ToINodeFactory() {
            super(StringNodes.ToINode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ToINode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToINodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ToINode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToIUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ToINode> getInstance() {
            if (toINodeFactoryInstance == null) {
                toINodeFactoryInstance = new ToINodeFactory();
            }
            return toINodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToIPolymorphicNode
        extends ToIBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToIPolymorphicNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToIRubyStringNode
        extends ToIBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToIRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ToIRubyStringNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.toI(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.toI(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToINode create0(StringNodes.ToINode current2) {
                return new ToIRubyStringNode((ToIBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToIUninitializedNode
        extends ToIBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToIUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToIUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToIUninitializedNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToIBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToIBaseNode rootNode = (ToIBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToIBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToINode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToIUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ToINode.class)
        private static abstract class ToIBaseNode
        extends StringNodes.ToINode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToIBaseNode next0;

            ToIBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToIBaseNode(ToIBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToIBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToIBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToIUninitializedNode(this);
                    ((ToIUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToIBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToIBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ToIBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToIUninitializedNode(this), (Node)new ToIPolymorphicNode(this), (DSLNode)((ToIBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToIBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ToIBaseNode)ToIRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToIBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToIBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToFNode.class)
    public static final class ToFNodeFactory
    extends NodeFactoryBase<StringNodes.ToFNode> {
        private static ToFNodeFactory toFNodeFactoryInstance;

        private ToFNodeFactory() {
            super(StringNodes.ToFNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ToFNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToFNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ToFNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToFUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ToFNode> getInstance() {
            if (toFNodeFactoryInstance == null) {
                toFNodeFactoryInstance = new ToFNodeFactory();
            }
            return toFNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToFPolymorphicNode
        extends ToFBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToFPolymorphicNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToFRubyStringNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ToFRubyStringNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.toF(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.toF(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToFNode create0(StringNodes.ToFNode current2) {
                return new ToFRubyStringNode((ToFBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToFUninitializedNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToFUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToFUninitializedNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToFBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToFBaseNode rootNode = (ToFBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToFBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ToFNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToFUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ToFNode.class)
        private static abstract class ToFBaseNode
        extends StringNodes.ToFNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToFBaseNode next0;

            ToFBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToFBaseNode(ToFBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToFBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToFBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToFUninitializedNode(this);
                    ((ToFUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToFBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToFBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ToFBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToFUninitializedNode(this), (Node)new ToFPolymorphicNode(this), (DSLNode)((ToFBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToFBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ToFBaseNode)ToFRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToFBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToFBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SumNode.class)
    public static final class SumNodeFactory
    extends NodeFactoryBase<StringNodes.SumNode> {
        private static SumNodeFactory sumNodeFactoryInstance;

        private SumNodeFactory() {
            super(StringNodes.SumNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SumNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SumNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SumNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SumUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SumNode> getInstance() {
            if (sumNodeFactoryInstance == null) {
                sumNodeFactoryInstance = new SumNodeFactory();
            }
            return sumNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SumPolymorphicNode
        extends SumBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SumPolymorphicNode(SumBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SumRubyStringNode
        extends SumBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SumRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SumRubyStringNode(SumBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.sum(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.sum(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SumNode create0(StringNodes.SumNode current2) {
                return new SumRubyStringNode((SumBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SumUninitializedNode
        extends SumBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SumUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SumUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SumUninitializedNode(SumBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SumBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SumBaseNode rootNode = (SumBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SumBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SumNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SumUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        private static abstract class SumBaseNode
        extends StringNodes.SumNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SumBaseNode next0;

            SumBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SumBaseNode(SumBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SumBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SumBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SumUninitializedNode(this);
                    ((SumUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SumBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SumBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SumBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SumUninitializedNode(this), (Node)new SumPolymorphicNode(this), (DSLNode)((SumBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SumBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (SumBaseNode)SumRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SumBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SumBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SuccBangNode.class)
    public static final class SuccBangNodeFactory
    extends NodeFactoryBase<StringNodes.SuccBangNode> {
        private static SuccBangNodeFactory succBangNodeFactoryInstance;

        private SuccBangNodeFactory() {
            super(StringNodes.SuccBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SuccBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SuccBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SuccBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SuccBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SuccBangNode> getInstance() {
            if (succBangNodeFactoryInstance == null) {
                succBangNodeFactoryInstance = new SuccBangNodeFactory();
            }
            return succBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SuccBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SuccBangPolymorphicNode
        extends SuccBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SuccBangPolymorphicNode(SuccBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.SuccBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SuccBangRubyStringNode
        extends SuccBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SuccBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SuccBangRubyStringNode(SuccBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.succBang(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.succBang(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SuccBangNode create0(StringNodes.SuccBangNode current2) {
                return new SuccBangRubyStringNode((SuccBangBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.SuccBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SuccBangUninitializedNode
        extends SuccBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SuccBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SuccBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SuccBangUninitializedNode(SuccBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SuccBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SuccBangBaseNode rootNode = (SuccBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SuccBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SuccBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SuccBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SuccBangNode.class)
        private static abstract class SuccBangBaseNode
        extends StringNodes.SuccBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SuccBangBaseNode next0;

            SuccBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SuccBangBaseNode(SuccBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SuccBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SuccBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SuccBangUninitializedNode(this);
                    ((SuccBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SuccBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SuccBangBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SuccBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SuccBangUninitializedNode(this), (Node)new SuccBangPolymorphicNode(this), (DSLNode)((SuccBangBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SuccBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (SuccBangBaseNode)SuccBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SuccBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SuccBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SuccNode.class)
    public static final class SuccNodeFactory
    extends NodeFactoryBase<StringNodes.SuccNode> {
        private static SuccNodeFactory succNodeFactoryInstance;

        private SuccNodeFactory() {
            super(StringNodes.SuccNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SuccNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SuccNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SuccNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SuccUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SuccNode> getInstance() {
            if (succNodeFactoryInstance == null) {
                succNodeFactoryInstance = new SuccNodeFactory();
            }
            return succNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SuccNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SuccPolymorphicNode
        extends SuccBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SuccPolymorphicNode(SuccBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.SuccNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SuccRubyStringNode
        extends SuccBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SuccRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SuccRubyStringNode(SuccBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.succ(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.succ(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SuccNode create0(StringNodes.SuccNode current2) {
                return new SuccRubyStringNode((SuccBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.SuccNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SuccUninitializedNode
        extends SuccBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SuccUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SuccUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SuccUninitializedNode(SuccBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SuccBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SuccBaseNode rootNode = (SuccBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SuccBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SuccNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SuccUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SuccNode.class)
        private static abstract class SuccBaseNode
        extends StringNodes.SuccNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SuccBaseNode next0;

            SuccBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SuccBaseNode(SuccBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SuccBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SuccBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SuccUninitializedNode(this);
                    ((SuccUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SuccBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SuccBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SuccBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SuccUninitializedNode(this), (Node)new SuccPolymorphicNode(this), (DSLNode)((SuccBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SuccBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (SuccBaseNode)SuccRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SuccBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SuccBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SubNode.class)
    public static final class SubNodeFactory
    extends NodeFactoryBase<StringNodes.SubNode> {
        private static SubNodeFactory subNodeFactoryInstance;

        private SubNodeFactory() {
            super(StringNodes.SubNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SubNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SubNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SubNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SubUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SubNode> getInstance() {
            if (subNodeFactoryInstance == null) {
                subNodeFactoryInstance = new SubNodeFactory();
            }
            return subNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SubPolymorphicNode
        extends SubBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            SubPolymorphicNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyRegexp.class ? this.arguments[1].executeRubyRegexp(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value);
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubRubyStringRubyRegexpNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubRubyStringRubyRegexpNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class, RubyString.class}, 0, 0);

            SubRubyStringRubyRegexpNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyRegexp");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.sub(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.SubNode create0(StringNodes.SubNode current2) {
                return new SubRubyStringRubyRegexpNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubRubyStringNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, RubyString.class}, 0, 0);

            SubRubyStringNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.sub(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.sub(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.SubNode create0(StringNodes.SubNode current2) {
                return new SubRubyStringNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SubUninitializedNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SubUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SubUninitializedNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                SubBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SubBaseNode rootNode = (SubBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SubBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.SubNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SubUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SubNode.class)
        private static abstract class SubBaseNode
        extends StringNodes.SubNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SubBaseNode next0;

            SubBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SubBaseNode(SubBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                SubBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SubBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new SubUninitializedNode(this);
                    ((SubUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SubBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SubBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (SubBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SubUninitializedNode(this), (Node)new SubPolymorphicNode(this), (DSLNode)((SubBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SubBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (SubBaseNode)SubRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                        return (SubBaseNode)SubRubyStringRubyRegexpNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    SubBaseNode otherCast = (SubBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (SubBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.StartWithNode.class)
    public static final class StartWithNodeFactory
    extends NodeFactoryBase<StringNodes.StartWithNode> {
        private static StartWithNodeFactory startWithNodeFactoryInstance;

        private StartWithNodeFactory() {
            super(StringNodes.StartWithNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.StartWithNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StartWithNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.StartWithNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StartWithUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.StartWithNode> getInstance() {
            if (startWithNodeFactoryInstance == null) {
                startWithNodeFactoryInstance = new StartWithNodeFactory();
            }
            return startWithNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.StartWithNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StartWithPolymorphicNode
        extends StartWithBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            StartWithPolymorphicNode(StartWithBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.StartWithNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StartWithRubyStringNode
        extends StartWithBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StartWithRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            StartWithRubyStringNode(StartWithBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.endWith(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.endWith(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.StartWithNode create0(StringNodes.StartWithNode current2) {
                return new StartWithRubyStringNode((StartWithBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.StartWithNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StartWithUninitializedNode
        extends StartWithBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StartWithUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StartWithUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StartWithUninitializedNode(StartWithBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                StartWithBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StartWithBaseNode rootNode = (StartWithBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StartWithBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.StartWithNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StartWithUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.StartWithNode.class)
        private static abstract class StartWithBaseNode
        extends StringNodes.StartWithNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StartWithBaseNode next0;

            StartWithBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StartWithBaseNode(StartWithBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                StartWithBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StartWithBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new StartWithUninitializedNode(this);
                    ((StartWithUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StartWithBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = StartWithBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (StartWithBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StartWithUninitializedNode(this), (Node)new StartWithPolymorphicNode(this), (DSLNode)((StartWithBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StartWithBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (StartWithBaseNode)StartWithRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    StartWithBaseNode otherCast = (StartWithBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (StartWithBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SplitNode.class)
    public static final class SplitNodeFactory
    extends NodeFactoryBase<StringNodes.SplitNode> {
        private static SplitNodeFactory splitNodeFactoryInstance;

        private SplitNodeFactory() {
            super(StringNodes.SplitNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SplitNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SplitNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SplitNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SplitUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SplitNode> getInstance() {
            if (splitNodeFactoryInstance == null) {
                splitNodeFactoryInstance = new SplitNodeFactory();
            }
            return splitNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SplitNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SplitPolymorphicNode
        extends SplitBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SplitPolymorphicNode(SplitBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyRegexp.class ? this.arguments[1].executeRubyRegexp(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.SplitNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SplitRubyStringUndefinedPlaceholderNode
        extends SplitBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SplitRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            SplitRubyStringUndefinedPlaceholderNode(SplitBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.split(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.split(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SplitNode create0(StringNodes.SplitNode current2) {
                return new SplitRubyStringUndefinedPlaceholderNode((SplitBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.SplitNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SplitRubyStringRubyRegexpNode
        extends SplitBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SplitRubyStringRubyRegexpNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class}, 0, 0);

            SplitRubyStringRubyRegexpNode(SplitBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyRegexp");
                }
                return super.split(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    return super.split(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SplitNode create0(StringNodes.SplitNode current2) {
                return new SplitRubyStringRubyRegexpNode((SplitBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.SplitNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SplitRubyStringNode
        extends SplitBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SplitRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            SplitRubyStringNode(SplitBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.split(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.split(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SplitNode create0(StringNodes.SplitNode current2) {
                return new SplitRubyStringNode((SplitBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.SplitNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SplitUninitializedNode
        extends SplitBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SplitUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SplitUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SplitUninitializedNode(SplitBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SplitBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SplitBaseNode rootNode = (SplitBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SplitBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.SplitNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SplitUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SplitNode.class)
        private static abstract class SplitBaseNode
        extends StringNodes.SplitNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SplitBaseNode next0;

            SplitBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SplitBaseNode(SplitBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                SplitBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SplitBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SplitUninitializedNode(this);
                    ((SplitUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SplitBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SplitBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SplitBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SplitUninitializedNode(this), (Node)new SplitPolymorphicNode(this), (DSLNode)((SplitBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SplitBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (SplitBaseNode)SplitRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                        return (SplitBaseNode)SplitRubyStringRubyRegexpNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (SplitBaseNode)SplitRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SplitBaseNode otherCast = (SplitBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SplitBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<StringNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(StringNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SizePolymorphicNode
        extends SizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SizePolymorphicNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubyStringNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SizeRubyStringNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.size(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.size(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SizeNode create0(StringNodes.SizeNode current2) {
                return new SizeRubyStringNode((SizeBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SizeUninitializedNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SizeUninitializedNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SizeBaseNode rootNode = (SizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.SizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        private static abstract class SizeBaseNode
        extends StringNodes.SizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SizeBaseNode next0;

            SizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SizeBaseNode(SizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SizeUninitializedNode(this);
                    ((SizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SizeBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SizeUninitializedNode(this), (Node)new SizePolymorphicNode(this), (DSLNode)((SizeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (SizeBaseNode)SizeRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.SetByteNode.class)
    public static final class SetByteNodeFactory
    extends NodeFactoryBase<StringNodes.SetByteNode> {
        private static SetByteNodeFactory setByteNodeFactoryInstance;

        private SetByteNodeFactory() {
            super(StringNodes.SetByteNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SetByteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetByteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.SetByteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SetByteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.SetByteNode> getInstance() {
            if (setByteNodeFactoryInstance == null) {
                setByteNodeFactoryInstance = new SetByteNodeFactory();
            }
            return setByteNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.SetByteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetBytePolymorphicNode
        extends SetByteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            SetBytePolymorphicNode(SetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.SetByteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetByteRubyStringObjectNode
        extends SetByteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetByteRubyStringObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Object.class}, 0, 0);

            SetByteRubyStringObjectNode(SetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof int");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return super.setByte(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.setByte(arguments0ValueCast, arguments1ValueCast, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.SetByteNode create0(StringNodes.SetByteNode current2) {
                return new SetByteRubyStringObjectNode((SetByteBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.SetByteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetByteUninitializedNode
        extends SetByteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetByteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetByteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SetByteUninitializedNode(SetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                SetByteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetByteBaseNode rootNode = (SetByteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetByteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.SetByteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SetByteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.SetByteNode.class)
        private static abstract class SetByteBaseNode
        extends StringNodes.SetByteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SetByteBaseNode next0;

            SetByteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SetByteBaseNode(SetByteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                SetByteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetByteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new SetByteUninitializedNode(this);
                    ((SetByteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetByteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SetByteBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (SetByteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetByteUninitializedNode(this), (Node)new SetBytePolymorphicNode(this), (DSLNode)((SetByteBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetByteBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (SetByteBaseNode)SetByteRubyStringObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    SetByteBaseNode otherCast = (SetByteBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (SetByteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ScanNode.class)
    public static final class ScanNodeFactory
    extends NodeFactoryBase<StringNodes.ScanNode> {
        private static ScanNodeFactory scanNodeFactoryInstance;

        private ScanNodeFactory() {
            super(StringNodes.ScanNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ScanNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ScanNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ScanNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ScanUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ScanNode> getInstance() {
            if (scanNodeFactoryInstance == null) {
                scanNodeFactoryInstance = new ScanNodeFactory();
            }
            return scanNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ScanPolymorphicNode
        extends ScanBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            ScanPolymorphicNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyRegexp.class ? this.arguments[1].executeRubyRegexp(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ScanRubyStringRubyRegexpRubyProcNode
        extends ScanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ScanRubyStringRubyRegexpRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class, RubyProc.class}, 0, 0);

            ScanRubyStringRubyRegexpRubyProcNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments2Value;
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyRegexp"));
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc"));
                }
                return super.scan(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.scan(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ScanNode create0(StringNodes.ScanNode current2) {
                return new ScanRubyStringRubyRegexpRubyProcNode((ScanBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ScanRubyArrayRubyRegexpUndefinedPlaceholderNode
        extends ScanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ScanRubyArrayRubyRegexpUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class, UndefinedPlaceholder.class}, 0, 0);

            ScanRubyArrayRubyRegexpUndefinedPlaceholderNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyRegexp"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                return super.scan(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.scan(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ScanNode create0(StringNodes.ScanNode current2) {
                return new ScanRubyArrayRubyRegexpUndefinedPlaceholderNode((ScanBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ScanRubyStringRubyStringRubyProcNode
        extends ScanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ScanRubyStringRubyStringRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, RubyProc.class}, 0, 0);

            ScanRubyStringRubyStringRubyProcNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString"));
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc"));
                }
                return super.scan(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.scan(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ScanNode create0(StringNodes.ScanNode current2) {
                return new ScanRubyStringRubyStringRubyProcNode((ScanBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ScanRubyArrayRubyStringUndefinedPlaceholderNode
        extends ScanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ScanRubyArrayRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            ScanRubyArrayRubyStringUndefinedPlaceholderNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                return super.scan(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.scan(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ScanNode create0(StringNodes.ScanNode current2) {
                return new ScanRubyArrayRubyStringUndefinedPlaceholderNode((ScanBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ScanUninitializedNode
        extends ScanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ScanUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ScanUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ScanUninitializedNode(ScanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                ScanBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ScanBaseNode rootNode = (ScanBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ScanBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ScanNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ScanUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ScanNode.class)
        private static abstract class ScanBaseNode
        extends StringNodes.ScanNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ScanBaseNode next0;

            ScanBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ScanBaseNode(ScanBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                ScanBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ScanBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new ScanUninitializedNode(this);
                    ((ScanUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ScanBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ScanBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (ScanBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ScanUninitializedNode(this), (Node)new ScanPolymorphicNode(this), (DSLNode)((ScanBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ScanBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (ScanBaseNode)ScanRubyArrayRubyStringUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                            return (ScanBaseNode)ScanRubyStringRubyStringRubyProcNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (ScanBaseNode)ScanRubyArrayRubyRegexpUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                            return (ScanBaseNode)ScanRubyStringRubyRegexpRubyProcNode.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    ScanBaseNode otherCast = (ScanBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (ScanBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.DumpNode.class)
    public static final class DumpNodeFactory
    extends NodeFactoryBase<StringNodes.DumpNode> {
        private static DumpNodeFactory dumpNodeFactoryInstance;

        private DumpNodeFactory() {
            super(StringNodes.DumpNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DumpNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DumpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.DumpNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DumpUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.DumpNode> getInstance() {
            if (dumpNodeFactoryInstance == null) {
                dumpNodeFactoryInstance = new DumpNodeFactory();
            }
            return dumpNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DumpPolymorphicNode
        extends DumpBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DumpPolymorphicNode(DumpBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DumpRubyStringNode
        extends DumpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DumpRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DumpRubyStringNode(DumpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.rstrip(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.rstrip(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DumpNode create0(StringNodes.DumpNode current2) {
                return new DumpRubyStringNode((DumpBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DumpUninitializedNode
        extends DumpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DumpUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DumpUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DumpUninitializedNode(DumpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DumpBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DumpBaseNode rootNode = (DumpBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DumpBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DumpNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DumpUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        private static abstract class DumpBaseNode
        extends StringNodes.DumpNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DumpBaseNode next0;

            DumpBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DumpBaseNode(DumpBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                DumpBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DumpBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DumpUninitializedNode(this);
                    ((DumpUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DumpBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DumpBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (DumpBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DumpUninitializedNode(this), (Node)new DumpPolymorphicNode(this), (DSLNode)((DumpBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DumpBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DumpBaseNode)DumpRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DumpBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DumpBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.RStripNode.class)
    public static final class RStripNodeFactory
    extends NodeFactoryBase<StringNodes.RStripNode> {
        private static RStripNodeFactory rStripNodeFactoryInstance;

        private RStripNodeFactory() {
            super(StringNodes.RStripNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.RStripNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RStripNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.RStripNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RStripUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.RStripNode> getInstance() {
            if (rStripNodeFactoryInstance == null) {
                rStripNodeFactoryInstance = new RStripNodeFactory();
            }
            return rStripNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.RStripNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RStripPolymorphicNode
        extends RStripBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            RStripPolymorphicNode(RStripBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.RStripNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RStripRubyStringNode
        extends RStripBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RStripRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            RStripRubyStringNode(RStripBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.rstrip(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.rstrip(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.RStripNode create0(StringNodes.RStripNode current2) {
                return new RStripRubyStringNode((RStripBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.RStripNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RStripUninitializedNode
        extends RStripBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RStripUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RStripUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RStripUninitializedNode(RStripBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                RStripBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RStripBaseNode rootNode = (RStripBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RStripBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.RStripNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RStripUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.RStripNode.class)
        private static abstract class RStripBaseNode
        extends StringNodes.RStripNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RStripBaseNode next0;

            RStripBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RStripBaseNode(RStripBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                RStripBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RStripBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new RStripUninitializedNode(this);
                    ((RStripUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RStripBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = RStripBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (RStripBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RStripUninitializedNode(this), (Node)new RStripPolymorphicNode(this), (DSLNode)((RStripBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RStripBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (RStripBaseNode)RStripRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((RStripBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (RStripBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.RjustNode.class)
    public static final class RjustNodeFactory
    extends NodeFactoryBase<StringNodes.RjustNode> {
        private static RjustNodeFactory rjustNodeFactoryInstance;

        private RjustNodeFactory() {
            super(StringNodes.RjustNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.RjustNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RjustNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.RjustNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RjustUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.RjustNode> getInstance() {
            if (rjustNodeFactoryInstance == null) {
                rjustNodeFactoryInstance = new RjustNodeFactory();
            }
            return rjustNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.RjustNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RjustPolymorphicNode
        extends RjustBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            RjustPolymorphicNode(RjustBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyString.class ? this.arguments[2].executeRubyString(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.RjustNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RjustRubyStringNode
        extends RjustBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RjustRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, RubyString.class}, 0, 0);

            RjustRubyStringNode(RjustBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.rjust(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.rjust(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.RjustNode create0(StringNodes.RjustNode current2) {
                return new RjustRubyStringNode((RjustBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.RjustNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RjustRubyStringUndefinedPlaceholderNode
        extends RjustBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RjustRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            RjustRubyStringUndefinedPlaceholderNode(RjustBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.rjust(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.rjust(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.RjustNode create0(StringNodes.RjustNode current2) {
                return new RjustRubyStringUndefinedPlaceholderNode((RjustBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.RjustNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RjustUninitializedNode
        extends RjustBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RjustUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RjustUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RjustUninitializedNode(RjustBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RjustBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RjustBaseNode rootNode = (RjustBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RjustBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.RjustNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RjustUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.RjustNode.class)
        private static abstract class RjustBaseNode
        extends StringNodes.RjustNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RjustBaseNode next0;

            RjustBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RjustBaseNode(RjustBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                RjustBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RjustBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new RjustUninitializedNode(this);
                    ((RjustUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RjustBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = RjustBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (RjustBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RjustUninitializedNode(this), (Node)new RjustPolymorphicNode(this), (DSLNode)((RjustBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RjustBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (RjustBaseNode)RjustRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                        return (RjustBaseNode)RjustRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    RjustBaseNode otherCast = (RjustBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (RjustBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.RindexNode.class)
    public static final class RindexNodeFactory
    extends NodeFactoryBase<StringNodes.RindexNode> {
        private static RindexNodeFactory rindexNodeFactoryInstance;

        private RindexNodeFactory() {
            super(StringNodes.RindexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.RindexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RindexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.RindexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RindexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.RindexNode> getInstance() {
            if (rindexNodeFactoryInstance == null) {
                rindexNodeFactoryInstance = new RindexNodeFactory();
            }
            return rindexNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.RindexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RindexPolymorphicNode
        extends RindexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            RindexPolymorphicNode(RindexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.RindexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RindexRubyStringIntNode
        extends RindexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RindexRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, Integer.TYPE}, 0, 0);

            RindexRubyStringIntNode(RindexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.rindex(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.rindex(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.RindexNode create0(StringNodes.RindexNode current2) {
                return new RindexRubyStringIntNode((RindexBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.RindexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RindexRubyStringUndefinedPlaceholderNode
        extends RindexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RindexRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            RindexRubyStringUndefinedPlaceholderNode(RindexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.rindex(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.rindex(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.RindexNode create0(StringNodes.RindexNode current2) {
                return new RindexRubyStringUndefinedPlaceholderNode((RindexBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.RindexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RindexUninitializedNode
        extends RindexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RindexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RindexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RindexUninitializedNode(RindexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RindexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RindexBaseNode rootNode = (RindexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RindexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.RindexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RindexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.RindexNode.class)
        private static abstract class RindexBaseNode
        extends StringNodes.RindexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RindexBaseNode next0;

            RindexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RindexBaseNode(RindexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                RindexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RindexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new RindexUninitializedNode(this);
                    ((RindexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RindexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = RindexBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (RindexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RindexUninitializedNode(this), (Node)new RindexPolymorphicNode(this), (DSLNode)((RindexBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RindexBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (RindexBaseNode)RindexRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                        return (RindexBaseNode)RindexRubyStringIntNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    RindexBaseNode otherCast = (RindexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (RindexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.OrdNode.class)
    public static final class OrdNodeFactory
    extends NodeFactoryBase<StringNodes.OrdNode> {
        private static OrdNodeFactory ordNodeFactoryInstance;

        private OrdNodeFactory() {
            super(StringNodes.OrdNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.OrdNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return OrdNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.OrdNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return OrdUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.OrdNode> getInstance() {
            if (ordNodeFactoryInstance == null) {
                ordNodeFactoryInstance = new OrdNodeFactory();
            }
            return ordNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.OrdNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class OrdPolymorphicNode
        extends OrdBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            OrdPolymorphicNode(OrdBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.OrdNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class OrdRubyStringNode
        extends OrdBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OrdRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            OrdRubyStringNode(OrdBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.ord(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.ord(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.OrdNode create0(StringNodes.OrdNode current2) {
                return new OrdRubyStringNode((OrdBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.OrdNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class OrdUninitializedNode
        extends OrdBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OrdUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            OrdUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            OrdUninitializedNode(OrdBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                OrdBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    OrdBaseNode rootNode = (OrdBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((OrdBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.OrdNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new OrdUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.OrdNode.class)
        private static abstract class OrdBaseNode
        extends StringNodes.OrdNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected OrdBaseNode next0;

            OrdBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            OrdBaseNode(OrdBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                OrdBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                OrdBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new OrdUninitializedNode(this);
                    ((OrdUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (OrdBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = OrdBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (OrdBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new OrdUninitializedNode(this), (Node)new OrdPolymorphicNode(this), (DSLNode)((OrdBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final OrdBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (OrdBaseNode)OrdRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((OrdBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (OrdBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.MatchNode.class)
    public static final class MatchNodeFactory
    extends NodeFactoryBase<StringNodes.MatchNode> {
        private static MatchNodeFactory matchNodeFactoryInstance;

        private MatchNodeFactory() {
            super(StringNodes.MatchNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.MatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MatchNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.MatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MatchUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.MatchNode> getInstance() {
            if (matchNodeFactoryInstance == null) {
                matchNodeFactoryInstance = new MatchNodeFactory();
            }
            return matchNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.MatchNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MatchPolymorphicNode
        extends MatchBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MatchPolymorphicNode(MatchBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyRegexp.class ? this.arguments[1].executeRubyRegexp(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.MatchNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MatchRubyStringRubyRegexpNode
        extends MatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchRubyStringRubyRegexpNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class}, 0, 0);

            MatchRubyStringRubyRegexpNode(MatchBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyRegexp");
                }
                return super.match(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    return super.match(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MatchNode create0(StringNodes.MatchNode current2) {
                return new MatchRubyStringRubyRegexpNode((MatchBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.MatchNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MatchRubyStringNode
        extends MatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            MatchRubyStringNode(MatchBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.match(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.match(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MatchNode create0(StringNodes.MatchNode current2) {
                return new MatchRubyStringNode((MatchBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.MatchNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MatchUninitializedNode
        extends MatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MatchUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MatchUninitializedNode(MatchBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MatchBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MatchBaseNode rootNode = (MatchBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MatchBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MatchNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MatchUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.MatchNode.class)
        private static abstract class MatchBaseNode
        extends StringNodes.MatchNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MatchBaseNode next0;

            MatchBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MatchBaseNode(MatchBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                MatchBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MatchBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MatchUninitializedNode(this);
                    ((MatchUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MatchBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MatchBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MatchBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MatchUninitializedNode(this), (Node)new MatchPolymorphicNode(this), (DSLNode)((MatchBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MatchBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (MatchBaseNode)MatchRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                        return (MatchBaseNode)MatchRubyStringRubyRegexpNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MatchBaseNode otherCast = (MatchBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MatchBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.LjustNode.class)
    public static final class LjustNodeFactory
    extends NodeFactoryBase<StringNodes.LjustNode> {
        private static LjustNodeFactory ljustNodeFactoryInstance;

        private LjustNodeFactory() {
            super(StringNodes.LjustNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.LjustNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LjustNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.LjustNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LjustUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.LjustNode> getInstance() {
            if (ljustNodeFactoryInstance == null) {
                ljustNodeFactoryInstance = new LjustNodeFactory();
            }
            return ljustNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.LjustNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LjustPolymorphicNode
        extends LjustBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            LjustPolymorphicNode(LjustBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyString.class ? this.arguments[2].executeRubyString(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.LjustNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LjustRubyStringNode
        extends LjustBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LjustRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, RubyString.class}, 0, 0);

            LjustRubyStringNode(LjustBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.ljust(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.ljust(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.LjustNode create0(StringNodes.LjustNode current2) {
                return new LjustRubyStringNode((LjustBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.LjustNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LjustRubyStringUndefinedPlaceholderNode
        extends LjustBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LjustRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            LjustRubyStringUndefinedPlaceholderNode(LjustBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.ljust(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.ljust(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.LjustNode create0(StringNodes.LjustNode current2) {
                return new LjustRubyStringUndefinedPlaceholderNode((LjustBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.LjustNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LjustUninitializedNode
        extends LjustBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LjustUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LjustUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LjustUninitializedNode(LjustBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                LjustBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LjustBaseNode rootNode = (LjustBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LjustBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.LjustNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LjustUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.LjustNode.class)
        private static abstract class LjustBaseNode
        extends StringNodes.LjustNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LjustBaseNode next0;

            LjustBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LjustBaseNode(LjustBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                LjustBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LjustBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new LjustUninitializedNode(this);
                    ((LjustUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LjustBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = LjustBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (LjustBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LjustUninitializedNode(this), (Node)new LjustPolymorphicNode(this), (DSLNode)((LjustBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LjustBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (LjustBaseNode)LjustRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                        return (LjustBaseNode)LjustRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    LjustBaseNode otherCast = (LjustBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (LjustBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.InsertNode.class)
    public static final class InsertNodeFactory
    extends NodeFactoryBase<StringNodes.InsertNode> {
        private static InsertNodeFactory insertNodeFactoryInstance;

        private InsertNodeFactory() {
            super(StringNodes.InsertNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.InsertNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InsertNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.InsertNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InsertUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.InsertNode> getInstance() {
            if (insertNodeFactoryInstance == null) {
                insertNodeFactoryInstance = new InsertNodeFactory();
            }
            return insertNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InsertPolymorphicNode
        extends InsertBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            InsertPolymorphicNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InsertRubyStringNode
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, RubyString.class}, 0, 0);

            InsertRubyStringNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.insert(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.insert(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.InsertNode create0(StringNodes.InsertNode current2) {
                return new InsertRubyStringNode((InsertBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InsertUninitializedNode
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InsertUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InsertUninitializedNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                InsertBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InsertBaseNode rootNode = (InsertBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InsertBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.InsertNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InsertUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.InsertNode.class)
        private static abstract class InsertBaseNode
        extends StringNodes.InsertNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InsertBaseNode next0;

            InsertBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InsertBaseNode(InsertBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                InsertBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InsertBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new InsertUninitializedNode(this);
                    ((InsertUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InsertBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InsertBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (InsertBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InsertUninitializedNode(this), (Node)new InsertPolymorphicNode(this), (DSLNode)((InsertBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InsertBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    return (InsertBaseNode)InsertRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    InsertBaseNode otherCast = (InsertBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (InsertBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<StringNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(StringNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeCopyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeCopyPolymorphicNode
        extends InitializeCopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializeCopyPolymorphicNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyStringNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            InitializeCopyRubyStringNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.initializeCopy(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.initializeCopy(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeCopyNode create0(StringNodes.InitializeCopyNode current2) {
                return new InitializeCopyRubyStringNode((InitializeCopyBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeCopyUninitializedNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeCopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeCopyUninitializedNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeCopyBaseNode rootNode = (InitializeCopyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeCopyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeCopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeCopyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
        private static abstract class InitializeCopyBaseNode
        extends StringNodes.InitializeCopyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeCopyBaseNode next0;

            InitializeCopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeCopyBaseNode(InitializeCopyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                InitializeCopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeCopyUninitializedNode(this);
                    ((InitializeCopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeCopyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InitializeCopyBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeCopyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeCopyUninitializedNode(this), (Node)new InitializeCopyPolymorphicNode(this), (DSLNode)((InitializeCopyBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeCopyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (InitializeCopyBaseNode)InitializeCopyRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeCopyBaseNode otherCast = (InitializeCopyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeCopyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<StringNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(StringNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyStringNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            InitializeRubyStringNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.initialize(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeNode create0(StringNodes.InitializeNode current2) {
                return new InitializeRubyStringNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyStringUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyStringUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeNode create0(StringNodes.InitializeNode current2) {
                return new InitializeRubyStringUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = (InitializeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends StringNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InitializeBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeUninitializedNode(this), (Node)new InitializePolymorphicNode(this), (DSLNode)((InitializeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (InitializeBaseNode)InitializeRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (InitializeBaseNode)InitializeRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.InspectNode.class)
    public static final class InspectNodeFactory
    extends NodeFactoryBase<StringNodes.InspectNode> {
        private static InspectNodeFactory inspectNodeFactoryInstance;

        private InspectNodeFactory() {
            super(StringNodes.InspectNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.InspectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InspectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.InspectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InspectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.InspectNode> getInstance() {
            if (inspectNodeFactoryInstance == null) {
                inspectNodeFactoryInstance = new InspectNodeFactory();
            }
            return inspectNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InspectPolymorphicNode
        extends InspectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            InspectPolymorphicNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InspectRubyStringNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            InspectRubyStringNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.inspect(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.inspect(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.InspectNode create0(StringNodes.InspectNode current2) {
                return new InspectRubyStringNode((InspectBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InspectUninitializedNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InspectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InspectUninitializedNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InspectBaseNode rootNode = (InspectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InspectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.InspectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InspectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.InspectNode.class)
        private static abstract class InspectBaseNode
        extends StringNodes.InspectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InspectBaseNode next0;

            InspectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InspectBaseNode(InspectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                InspectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new InspectUninitializedNode(this);
                    ((InspectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InspectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InspectBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (InspectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InspectUninitializedNode(this), (Node)new InspectPolymorphicNode(this), (DSLNode)((InspectBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InspectBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (InspectBaseNode)InspectRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((InspectBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (InspectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.GetByteNode.class)
    public static final class GetByteNodeFactory
    extends NodeFactoryBase<StringNodes.GetByteNode> {
        private static GetByteNodeFactory getByteNodeFactoryInstance;

        private GetByteNodeFactory() {
            super(StringNodes.GetByteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.GetByteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetByteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.GetByteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetByteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.GetByteNode> getInstance() {
            if (getByteNodeFactoryInstance == null) {
                getByteNodeFactoryInstance = new GetByteNodeFactory();
            }
            return getByteNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.GetByteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GetBytePolymorphicNode
        extends GetByteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GetBytePolymorphicNode(GetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.GetByteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetByteRubyStringNode
        extends GetByteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetByteRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            GetByteRubyStringNode(GetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.getByte(arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.getByte(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.GetByteNode create0(StringNodes.GetByteNode current2) {
                return new GetByteRubyStringNode((GetByteBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GetByteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GetByteUninitializedNode
        extends GetByteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetByteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GetByteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GetByteUninitializedNode(GetByteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GetByteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GetByteBaseNode rootNode = (GetByteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GetByteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.GetByteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetByteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.GetByteNode.class)
        private static abstract class GetByteBaseNode
        extends StringNodes.GetByteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GetByteBaseNode next0;

            GetByteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GetByteBaseNode(GetByteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                GetByteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GetByteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GetByteUninitializedNode(this);
                    ((GetByteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GetByteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = GetByteBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GetByteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GetByteUninitializedNode(this), (Node)new GetBytePolymorphicNode(this), (DSLNode)((GetByteBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GetByteBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (GetByteBaseNode)GetByteRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GetByteBaseNode otherCast = (GetByteBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GetByteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.GsubNode.class)
    public static final class GsubNodeFactory
    extends NodeFactoryBase<StringNodes.GsubNode> {
        private static GsubNodeFactory gsubNodeFactoryInstance;

        private GsubNodeFactory() {
            super(StringNodes.GsubNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.GsubNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GsubNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.GsubNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GsubUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.GsubNode> getInstance() {
            if (gsubNodeFactoryInstance == null) {
                gsubNodeFactoryInstance = new GsubNodeFactory();
            }
            return gsubNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.GsubNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GsubPolymorphicNode
        extends GsubBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;

            GsubPolymorphicNode(GsubBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments3Value;
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyRegexp.class ? this.arguments[1].executeRubyRegexp(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, arguments3Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyString.class ? this.arguments[2].executeRubyString(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value3);
                }
                try {
                    arguments3Value = this.arguments3PolymorphicType == UndefinedPlaceholder.class ? this.arguments[3].executeUndefinedPlaceholder(frameValue) : (this.arguments3PolymorphicType == RubyProc.class ? this.arguments[3].executeRubyProc(frameValue) : this.arguments[3].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments3PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }
        }

        @GeneratedBy(value=StringNodes.GsubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GsubRubyStringRubyRegexpUndefinedPlaceholderRubyProcNode
        extends GsubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GsubRubyStringRubyRegexpUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            GsubRubyStringRubyRegexpUndefinedPlaceholderRubyProcNode(GsubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments3Value;
                UndefinedPlaceholder arguments2Value;
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyRegexp");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                return super.gsub(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    return super.gsub(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static StringNodes.GsubNode create0(StringNodes.GsubNode current2) {
                return new GsubRubyStringRubyRegexpUndefinedPlaceholderRubyProcNode((GsubBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GsubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GsubRubyStringRubyStringUndefinedPlaceholderRubyProcNode
        extends GsubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GsubRubyStringRubyStringUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            GsubRubyStringRubyStringUndefinedPlaceholderRubyProcNode(GsubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments3Value;
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                return super.gsub(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    return super.gsub(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static StringNodes.GsubNode create0(StringNodes.GsubNode current2) {
                return new GsubRubyStringRubyStringUndefinedPlaceholderRubyProcNode((GsubBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GsubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GsubRubyStringRubyRegexpRubyStringRubyProcNode
        extends GsubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GsubRubyStringRubyRegexpRubyStringRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class, RubyString.class, RubyProc.class}, 0, 0);

            GsubRubyStringRubyRegexpRubyStringRubyProcNode(GsubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments3Value;
                RubyString arguments2Value;
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyRegexp");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof RubyString");
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                return super.gsub(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    return super.gsub(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static StringNodes.GsubNode create0(StringNodes.GsubNode current2) {
                return new GsubRubyStringRubyRegexpRubyStringRubyProcNode((GsubBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GsubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GsubRubyStringRubyStringRubyStringRubyProcNode
        extends GsubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GsubRubyStringRubyStringRubyStringRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, RubyString.class, RubyProc.class}, 0, 0);

            GsubRubyStringRubyStringRubyStringRubyProcNode(GsubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments3Value;
                RubyString arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof RubyString");
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                return super.gsub(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    return super.gsub(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static StringNodes.GsubNode create0(StringNodes.GsubNode current2) {
                return new GsubRubyStringRubyStringRubyStringRubyProcNode((GsubBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GsubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GsubRubyStringRubyRegexpRubyStringUndefinedPlaceholderNode
        extends GsubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GsubRubyStringRubyRegexpRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            GsubRubyStringRubyRegexpRubyStringUndefinedPlaceholderNode(GsubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                RubyString arguments2Value;
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyRegexp");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof RubyString");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.gsub(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.gsub(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static StringNodes.GsubNode create0(StringNodes.GsubNode current2) {
                return new GsubRubyStringRubyRegexpRubyStringUndefinedPlaceholderNode((GsubBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GsubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GsubRubyStringRubyStringRubyStringUndefinedPlaceholderNode
        extends GsubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GsubRubyStringRubyStringRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            GsubRubyStringRubyStringRubyStringUndefinedPlaceholderNode(GsubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                RubyString arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof RubyString");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.gsub(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.gsub(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static StringNodes.GsubNode create0(StringNodes.GsubNode current2) {
                return new GsubRubyStringRubyStringRubyStringUndefinedPlaceholderNode((GsubBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GsubNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GsubUninitializedNode
        extends GsubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GsubUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GsubUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GsubUninitializedNode(GsubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                GsubBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GsubBaseNode rootNode = (GsubBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3]}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GsubBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static StringNodes.GsubNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GsubUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.GsubNode.class)
        private static abstract class GsubBaseNode
        extends StringNodes.GsubNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GsubBaseNode next0;

            GsubBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GsubBaseNode(GsubBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, String reason2) {
                String message2;
                GsubBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GsubBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    newNode = new GsubUninitializedNode(this);
                    ((GsubUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GsubBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = GsubBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value, arguments3Value)))) == null) {
                    returnNode = (GsubBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GsubUninitializedNode(this), (Node)new GsubPolymorphicNode(this), (DSLNode)((GsubBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GsubBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                                return (GsubBaseNode)GsubRubyStringRubyStringRubyStringUndefinedPlaceholderNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                                return (GsubBaseNode)GsubRubyStringRubyRegexpRubyStringUndefinedPlaceholderNode.create0(this);
                            }
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                            if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                                return (GsubBaseNode)GsubRubyStringRubyStringRubyStringRubyProcNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                                return (GsubBaseNode)GsubRubyStringRubyRegexpRubyStringRubyProcNode.create0(this);
                            }
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                        if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                            return (GsubBaseNode)GsubRubyStringRubyStringUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                            return (GsubBaseNode)GsubRubyStringRubyRegexpUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                } else {
                    GsubBaseNode otherCast = (GsubBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                }
                this.next0 = newNext == null ? null : (GsubBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
    public static final class ForceEncodingNodeFactory
    extends NodeFactoryBase<StringNodes.ForceEncodingNode> {
        private static ForceEncodingNodeFactory forceEncodingNodeFactoryInstance;

        private ForceEncodingNodeFactory() {
            super(StringNodes.ForceEncodingNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ForceEncodingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ForceEncodingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ForceEncodingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ForceEncodingUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ForceEncodingNode> getInstance() {
            if (forceEncodingNodeFactoryInstance == null) {
                forceEncodingNodeFactoryInstance = new ForceEncodingNodeFactory();
            }
            return forceEncodingNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ForceEncodingPolymorphicNode
        extends ForceEncodingBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ForceEncodingPolymorphicNode(ForceEncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubyEncoding.class ? this.arguments[1].executeRubyEncoding(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ForceEncodingRubyStringRubyEncodingNode
        extends ForceEncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ForceEncodingRubyStringRubyEncodingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyEncoding.class}, 0, 0);

            ForceEncodingRubyStringRubyEncodingNode(ForceEncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyEncoding");
                }
                return super.forceEncoding(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyEncoding arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments1Value);
                    return super.forceEncoding(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ForceEncodingNode create0(StringNodes.ForceEncodingNode current2) {
                return new ForceEncodingRubyStringRubyEncodingNode((ForceEncodingBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ForceEncodingRubyStringNode
        extends ForceEncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ForceEncodingRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            ForceEncodingRubyStringNode(ForceEncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.forceEncoding(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.forceEncoding(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ForceEncodingNode create0(StringNodes.ForceEncodingNode current2) {
                return new ForceEncodingRubyStringNode((ForceEncodingBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ForceEncodingUninitializedNode
        extends ForceEncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ForceEncodingUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ForceEncodingUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ForceEncodingUninitializedNode(ForceEncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ForceEncodingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ForceEncodingBaseNode rootNode = (ForceEncodingBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ForceEncodingBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ForceEncodingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ForceEncodingUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        private static abstract class ForceEncodingBaseNode
        extends StringNodes.ForceEncodingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ForceEncodingBaseNode next0;

            ForceEncodingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ForceEncodingBaseNode(ForceEncodingBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ForceEncodingBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ForceEncodingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ForceEncodingUninitializedNode(this);
                    ((ForceEncodingUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ForceEncodingBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ForceEncodingBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ForceEncodingBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ForceEncodingUninitializedNode(this), (Node)new ForceEncodingPolymorphicNode(this), (DSLNode)((ForceEncodingBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ForceEncodingBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (ForceEncodingBaseNode)ForceEncodingRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value)) {
                        return (ForceEncodingBaseNode)ForceEncodingRubyStringRubyEncodingNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ForceEncodingBaseNode otherCast = (ForceEncodingBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ForceEncodingBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EndWithNode.class)
    public static final class EndWithNodeFactory
    extends NodeFactoryBase<StringNodes.EndWithNode> {
        private static EndWithNodeFactory endWithNodeFactoryInstance;

        private EndWithNodeFactory() {
            super(StringNodes.EndWithNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EndWithNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EndWithNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EndWithNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EndWithUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EndWithNode> getInstance() {
            if (endWithNodeFactoryInstance == null) {
                endWithNodeFactoryInstance = new EndWithNodeFactory();
            }
            return endWithNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EndWithNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EndWithPolymorphicNode
        extends EndWithBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EndWithPolymorphicNode(EndWithBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.EndWithNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EndWithRubyStringNode
        extends EndWithBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EndWithRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            EndWithRubyStringNode(EndWithBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.endWith(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.endWith(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EndWithNode create0(StringNodes.EndWithNode current2) {
                return new EndWithRubyStringNode((EndWithBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.EndWithNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EndWithUninitializedNode
        extends EndWithBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EndWithUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EndWithUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EndWithUninitializedNode(EndWithBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EndWithBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EndWithBaseNode rootNode = (EndWithBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EndWithBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EndWithNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EndWithUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EndWithNode.class)
        private static abstract class EndWithBaseNode
        extends StringNodes.EndWithNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EndWithBaseNode next0;

            EndWithBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EndWithBaseNode(EndWithBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EndWithBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EndWithBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EndWithUninitializedNode(this);
                    ((EndWithUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EndWithBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EndWithBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EndWithBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EndWithUninitializedNode(this), (Node)new EndWithPolymorphicNode(this), (DSLNode)((EndWithBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EndWithBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (EndWithBaseNode)EndWithRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EndWithBaseNode otherCast = (EndWithBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EndWithBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EncodingNode.class)
    public static final class EncodingNodeFactory
    extends NodeFactoryBase<StringNodes.EncodingNode> {
        private static EncodingNodeFactory encodingNodeFactoryInstance;

        private EncodingNodeFactory() {
            super(StringNodes.EncodingNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EncodingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EncodingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EncodingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EncodingUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EncodingNode> getInstance() {
            if (encodingNodeFactoryInstance == null) {
                encodingNodeFactoryInstance = new EncodingNodeFactory();
            }
            return encodingNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EncodingNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EncodingPolymorphicNode
        extends EncodingBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EncodingPolymorphicNode(EncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.EncodingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EncodingRubyStringNode
        extends EncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EncodingRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            EncodingRubyStringNode(EncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.encoding(arguments0Value);
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.encoding(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.EncodingNode create0(StringNodes.EncodingNode current2) {
                return new EncodingRubyStringNode((EncodingBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.EncodingNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EncodingUninitializedNode
        extends EncodingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EncodingUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EncodingUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EncodingUninitializedNode(EncodingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyEncoding executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EncodingBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EncodingBaseNode rootNode = (EncodingBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EncodingBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.EncodingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EncodingUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EncodingNode.class)
        private static abstract class EncodingBaseNode
        extends StringNodes.EncodingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EncodingBaseNode next0;

            EncodingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EncodingBaseNode(EncodingBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyEncoding executeChained0(VirtualFrame var1, Object var2);

            protected final RubyEncoding rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                EncodingBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EncodingBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EncodingUninitializedNode(this);
                    ((EncodingUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EncodingBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EncodingBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (EncodingBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EncodingUninitializedNode(this), (Node)new EncodingPolymorphicNode(this), (DSLNode)((EncodingBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EncodingBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (EncodingBaseNode)EncodingRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EncodingBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EncodingBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EncodeNode.class)
    public static final class EncodeNodeFactory
    extends NodeFactoryBase<StringNodes.EncodeNode> {
        private static EncodeNodeFactory encodeNodeFactoryInstance;

        private EncodeNodeFactory() {
            super(StringNodes.EncodeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EncodeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EncodeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EncodeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EncodeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EncodeNode> getInstance() {
            if (encodeNodeFactoryInstance == null) {
                encodeNodeFactoryInstance = new EncodeNodeFactory();
            }
            return encodeNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EncodeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EncodePolymorphicNode
        extends EncodeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EncodePolymorphicNode(EncodeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubyEncoding.class ? this.arguments[1].executeRubyEncoding(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.EncodeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EncodeRubyStringRubyEncodingNode
        extends EncodeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EncodeRubyStringRubyEncodingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyEncoding.class}, 0, 0);

            EncodeRubyStringRubyEncodingNode(EncodeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyEncoding");
                }
                return super.encode(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyEncoding arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments1Value);
                    return super.encode(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EncodeNode create0(StringNodes.EncodeNode current2) {
                return new EncodeRubyStringRubyEncodingNode((EncodeBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.EncodeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EncodeRubyStringNode
        extends EncodeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EncodeRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            EncodeRubyStringNode(EncodeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.encode(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.encode(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EncodeNode create0(StringNodes.EncodeNode current2) {
                return new EncodeRubyStringNode((EncodeBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.EncodeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EncodeUninitializedNode
        extends EncodeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EncodeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EncodeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EncodeUninitializedNode(EncodeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EncodeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EncodeBaseNode rootNode = (EncodeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EncodeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EncodeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EncodeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EncodeNode.class)
        private static abstract class EncodeBaseNode
        extends StringNodes.EncodeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EncodeBaseNode next0;

            EncodeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EncodeBaseNode(EncodeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EncodeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EncodeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EncodeUninitializedNode(this);
                    ((EncodeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EncodeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EncodeBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EncodeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EncodeUninitializedNode(this), (Node)new EncodePolymorphicNode(this), (DSLNode)((EncodeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EncodeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (EncodeBaseNode)EncodeRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value)) {
                        return (EncodeBaseNode)EncodeRubyStringRubyEncodingNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EncodeBaseNode otherCast = (EncodeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EncodeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<StringNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(StringNodes.EmptyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EmptyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EmptyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EmptyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EmptyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EmptyPolymorphicNode
        extends EmptyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EmptyPolymorphicNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EmptyRubyStringNode
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            EmptyRubyStringNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.empty(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.empty(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.EmptyNode create0(StringNodes.EmptyNode current2) {
                return new EmptyRubyStringNode((EmptyBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EmptyUninitializedNode
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EmptyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EmptyUninitializedNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EmptyBaseNode rootNode = (EmptyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EmptyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.EmptyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EmptyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EmptyNode.class)
        private static abstract class EmptyBaseNode
        extends StringNodes.EmptyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EmptyBaseNode next0;

            EmptyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EmptyBaseNode(EmptyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                EmptyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EmptyUninitializedNode(this);
                    ((EmptyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EmptyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EmptyBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (EmptyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EmptyUninitializedNode(this), (Node)new EmptyPolymorphicNode(this), (DSLNode)((EmptyBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EmptyBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (EmptyBaseNode)EmptyRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EmptyBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EmptyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EachLineNode.class)
    public static final class EachLineNodeFactory
    extends NodeFactoryBase<StringNodes.EachLineNode> {
        private static EachLineNodeFactory eachLineNodeFactoryInstance;

        private EachLineNodeFactory() {
            super(StringNodes.EachLineNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EachLineNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachLineNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EachLineNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachLineUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EachLineNode> getInstance() {
            if (eachLineNodeFactoryInstance == null) {
                eachLineNodeFactoryInstance = new EachLineNodeFactory();
            }
            return eachLineNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EachLineNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachLinePolymorphicNode
        extends EachLineBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EachLinePolymorphicNode(EachLineBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.EachLineNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachLineRubyStringNode
        extends EachLineBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachLineRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            EachLineRubyStringNode(EachLineBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.eachLine(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.eachLine(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.EachLineNode create0(StringNodes.EachLineNode current2) {
                return new EachLineRubyStringNode((EachLineBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.EachLineNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachLineUninitializedNode
        extends EachLineBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachLineUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachLineUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachLineUninitializedNode(EachLineBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EachLineBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachLineBaseNode rootNode = (EachLineBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachLineBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.EachLineNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachLineUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EachLineNode.class)
        private static abstract class EachLineBaseNode
        extends StringNodes.EachLineNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachLineBaseNode next0;

            EachLineBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachLineBaseNode(EachLineBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                EachLineBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachLineBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EachLineUninitializedNode(this);
                    ((EachLineUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachLineBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EachLineBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (EachLineBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachLineUninitializedNode(this), (Node)new EachLinePolymorphicNode(this), (DSLNode)((EachLineBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachLineBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (EachLineBaseNode)EachLineRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EachLineBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EachLineBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
    public static final class DowncaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.DowncaseBangNode> {
        private static DowncaseBangNodeFactory downcaseBangNodeFactoryInstance;

        private DowncaseBangNodeFactory() {
            super(StringNodes.DowncaseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DowncaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DowncaseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.DowncaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DowncaseBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.DowncaseBangNode> getInstance() {
            if (downcaseBangNodeFactoryInstance == null) {
                downcaseBangNodeFactoryInstance = new DowncaseBangNodeFactory();
            }
            return downcaseBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DowncaseBangPolymorphicNode
        extends DowncaseBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DowncaseBangPolymorphicNode(DowncaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value2;
                try {
                    value2 = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DowncaseBangRubyStringNode
        extends DowncaseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DowncaseBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DowncaseBangRubyStringNode(DowncaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value2;
                try {
                    value2 = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.downcase(arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.downcase(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DowncaseBangNode create0(StringNodes.DowncaseBangNode current2) {
                return new DowncaseBangRubyStringNode((DowncaseBangBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DowncaseBangUninitializedNode
        extends DowncaseBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DowncaseBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DowncaseBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DowncaseBangUninitializedNode(DowncaseBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value2;
                try {
                    value2 = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DowncaseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DowncaseBangBaseNode rootNode = (DowncaseBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DowncaseBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DowncaseBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DowncaseBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
        private static abstract class DowncaseBangBaseNode
        extends StringNodes.DowncaseBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DowncaseBangBaseNode next0;

            DowncaseBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DowncaseBangBaseNode(DowncaseBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                DowncaseBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DowncaseBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DowncaseBangUninitializedNode(this);
                    ((DowncaseBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DowncaseBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DowncaseBangBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (DowncaseBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DowncaseBangUninitializedNode(this), (Node)new DowncaseBangPolymorphicNode(this), (DSLNode)((DowncaseBangBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DowncaseBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DowncaseBangBaseNode)DowncaseBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DowncaseBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DowncaseBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.DowncaseNode.class)
    public static final class DowncaseNodeFactory
    extends NodeFactoryBase<StringNodes.DowncaseNode> {
        private static DowncaseNodeFactory downcaseNodeFactoryInstance;

        private DowncaseNodeFactory() {
            super(StringNodes.DowncaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DowncaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DowncaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.DowncaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DowncaseUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.DowncaseNode> getInstance() {
            if (downcaseNodeFactoryInstance == null) {
                downcaseNodeFactoryInstance = new DowncaseNodeFactory();
            }
            return downcaseNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.DowncaseNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DowncasePolymorphicNode
        extends DowncaseBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DowncasePolymorphicNode(DowncaseBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DowncaseRubyStringNode
        extends DowncaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DowncaseRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DowncaseRubyStringNode(DowncaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.downcase(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.downcase(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DowncaseNode create0(StringNodes.DowncaseNode current2) {
                return new DowncaseRubyStringNode((DowncaseBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DowncaseUninitializedNode
        extends DowncaseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DowncaseUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DowncaseUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DowncaseUninitializedNode(DowncaseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DowncaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DowncaseBaseNode rootNode = (DowncaseBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DowncaseBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.DowncaseNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DowncaseUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.DowncaseNode.class)
        private static abstract class DowncaseBaseNode
        extends StringNodes.DowncaseNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DowncaseBaseNode next0;

            DowncaseBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DowncaseBaseNode(DowncaseBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                DowncaseBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DowncaseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DowncaseUninitializedNode(this);
                    ((DowncaseUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DowncaseBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DowncaseBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (DowncaseBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DowncaseUninitializedNode(this), (Node)new DowncasePolymorphicNode(this), (DSLNode)((DowncaseBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DowncaseBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DowncaseBaseNode)DowncaseRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DowncaseBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DowncaseBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.CountNode.class)
    public static final class CountNodeFactory
    extends NodeFactoryBase<StringNodes.CountNode> {
        private static CountNodeFactory countNodeFactoryInstance;

        private CountNodeFactory() {
            super(StringNodes.CountNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CountNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CountNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.CountNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CountUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.CountNode> getInstance() {
            if (countNodeFactoryInstance == null) {
                countNodeFactoryInstance = new CountNodeFactory();
            }
            return countNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.CountNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CountPolymorphicNode
        extends CountBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            CountPolymorphicNode(CountBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.CountNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CountRubyStringNode
        extends CountBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CountRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object[].class}, 0, 0);

            CountRubyStringNode(CountBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.count(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.count(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.CountNode create0(StringNodes.CountNode current2) {
                return new CountRubyStringNode((CountBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.CountNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CountUninitializedNode
        extends CountBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CountUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CountUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CountUninitializedNode(CountBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CountBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CountBaseNode rootNode = (CountBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CountBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.CountNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CountUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.CountNode.class)
        private static abstract class CountBaseNode
        extends StringNodes.CountNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CountBaseNode next0;

            CountBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CountBaseNode(CountBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                CountBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CountBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CountUninitializedNode(this);
                    ((CountUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CountBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = CountBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CountBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CountUninitializedNode(this), (Node)new CountPolymorphicNode(this), (DSLNode)((CountBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CountBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (CountBaseNode)CountRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CountBaseNode otherCast = (CountBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CountBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ChompBangNode.class)
    public static final class ChompBangNodeFactory
    extends NodeFactoryBase<StringNodes.ChompBangNode> {
        private static ChompBangNodeFactory chompBangNodeFactoryInstance;

        private ChompBangNodeFactory() {
            super(StringNodes.ChompBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ChompBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ChompBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ChompBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ChompBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ChompBangNode> getInstance() {
            if (chompBangNodeFactoryInstance == null) {
                chompBangNodeFactoryInstance = new ChompBangNodeFactory();
            }
            return chompBangNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ChompBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ChompBangPolymorphicNode
        extends ChompBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ChompBangPolymorphicNode(ChompBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.ChompBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ChompBangRubyStringNode
        extends ChompBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChompBangRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ChompBangRubyStringNode(ChompBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.chompBang(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.chompBang(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ChompBangNode create0(StringNodes.ChompBangNode current2) {
                return new ChompBangRubyStringNode((ChompBangBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ChompBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ChompBangUninitializedNode
        extends ChompBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChompBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ChompBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ChompBangUninitializedNode(ChompBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ChompBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ChompBangBaseNode rootNode = (ChompBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ChompBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.ChompBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ChompBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ChompBangNode.class)
        private static abstract class ChompBangBaseNode
        extends StringNodes.ChompBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ChompBangBaseNode next0;

            ChompBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ChompBangBaseNode(ChompBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ChompBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ChompBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ChompBangUninitializedNode(this);
                    ((ChompBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ChompBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ChompBangBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ChompBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ChompBangUninitializedNode(this), (Node)new ChompBangPolymorphicNode(this), (DSLNode)((ChompBangBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ChompBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ChompBangBaseNode)ChompBangRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ChompBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ChompBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ChompNode.class)
    public static final class ChompNodeFactory
    extends NodeFactoryBase<StringNodes.ChompNode> {
        private static ChompNodeFactory chompNodeFactoryInstance;

        private ChompNodeFactory() {
            super(StringNodes.ChompNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ChompNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ChompNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ChompNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ChompUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ChompNode> getInstance() {
            if (chompNodeFactoryInstance == null) {
                chompNodeFactoryInstance = new ChompNodeFactory();
            }
            return chompNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ChompNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ChompPolymorphicNode
        extends ChompBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ChompPolymorphicNode(ChompBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.ChompNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ChompRubyStringNode
        extends ChompBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChompRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            ChompRubyStringNode(ChompBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.chompWithString(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.chompWithString(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ChompNode create0(StringNodes.ChompNode current2) {
                return new ChompRubyStringNode((ChompBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ChompNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ChompRubyStringUndefinedPlaceholderNode
        extends ChompBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChompRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            ChompRubyStringUndefinedPlaceholderNode(ChompBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.chomp(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.chomp(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ChompNode create0(StringNodes.ChompNode current2) {
                return new ChompRubyStringUndefinedPlaceholderNode((ChompBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ChompNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ChompUninitializedNode
        extends ChompBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChompUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ChompUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ChompUninitializedNode(ChompBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ChompBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ChompBaseNode rootNode = (ChompBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ChompBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ChompNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ChompUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ChompNode.class)
        private static abstract class ChompBaseNode
        extends StringNodes.ChompNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ChompBaseNode next0;

            ChompBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ChompBaseNode(ChompBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ChompBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ChompBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ChompUninitializedNode(this);
                    ((ChompUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ChompBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ChompBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ChompBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ChompUninitializedNode(this), (Node)new ChompPolymorphicNode(this), (DSLNode)((ChompBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ChompBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (ChompBaseNode)ChompRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (ChompBaseNode)ChompRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ChompBaseNode otherCast = (ChompBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ChompBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.BytesNode.class)
    public static final class BytesNodeFactory
    extends NodeFactoryBase<StringNodes.BytesNode> {
        private static BytesNodeFactory bytesNodeFactoryInstance;

        private BytesNodeFactory() {
            super(StringNodes.BytesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.BytesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BytesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.BytesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BytesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.BytesNode> getInstance() {
            if (bytesNodeFactoryInstance == null) {
                bytesNodeFactoryInstance = new BytesNodeFactory();
            }
            return bytesNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.BytesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BytesPolymorphicNode
        extends BytesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            BytesPolymorphicNode(BytesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.BytesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BytesRubyStringNode
        extends BytesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BytesRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            BytesRubyStringNode(BytesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.bytes(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.bytes(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.BytesNode create0(StringNodes.BytesNode current2) {
                return new BytesRubyStringNode((BytesBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.BytesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BytesUninitializedNode
        extends BytesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BytesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BytesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BytesUninitializedNode(BytesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                BytesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BytesBaseNode rootNode = (BytesBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BytesBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.BytesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BytesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.BytesNode.class)
        private static abstract class BytesBaseNode
        extends StringNodes.BytesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BytesBaseNode next0;

            BytesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BytesBaseNode(BytesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                BytesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BytesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new BytesUninitializedNode(this);
                    ((BytesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BytesBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = BytesBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (BytesBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BytesUninitializedNode(this), (Node)new BytesPolymorphicNode(this), (DSLNode)((BytesBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BytesBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (BytesBaseNode)BytesRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((BytesBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (BytesBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.BNode.class)
    public static final class BNodeFactory
    extends NodeFactoryBase<StringNodes.BNode> {
        private static BNodeFactory bNodeFactoryInstance;

        private BNodeFactory() {
            super(StringNodes.BNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.BNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.BNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.BNode> getInstance() {
            if (bNodeFactoryInstance == null) {
                bNodeFactoryInstance = new BNodeFactory();
            }
            return bNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.BNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BPolymorphicNode
        extends BBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            BPolymorphicNode(BBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=StringNodes.BNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BRubyStringNode
        extends BBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            BRubyStringNode(BBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.b(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.b(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.BNode create0(StringNodes.BNode current2) {
                return new BRubyStringNode((BBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.BNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BUninitializedNode
        extends BBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BUninitializedNode(BBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                BBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BBaseNode rootNode = (BBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static StringNodes.BNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.BNode.class)
        private static abstract class BBaseNode
        extends StringNodes.BNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BBaseNode next0;

            BBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BBaseNode(BBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                BBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new BUninitializedNode(this);
                    ((BUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = BBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (BBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BUninitializedNode(this), (Node)new BPolymorphicNode(this), (DSLNode)((BBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (BBaseNode)BRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((BBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (BBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.MatchOperatorNode.class)
    public static final class MatchOperatorNodeFactory
    extends NodeFactoryBase<StringNodes.MatchOperatorNode> {
        private static MatchOperatorNodeFactory matchOperatorNodeFactoryInstance;

        private MatchOperatorNodeFactory() {
            super(StringNodes.MatchOperatorNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.MatchOperatorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MatchOperatorNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.MatchOperatorNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MatchOperatorUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.MatchOperatorNode> getInstance() {
            if (matchOperatorNodeFactoryInstance == null) {
                matchOperatorNodeFactoryInstance = new MatchOperatorNodeFactory();
            }
            return matchOperatorNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.MatchOperatorNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MatchOperatorPolymorphicNode
        extends MatchOperatorBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MatchOperatorPolymorphicNode(MatchOperatorBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.MatchOperatorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MatchOperatorRubyStringNode
        extends MatchOperatorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchOperatorRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRegexp.class}, 0, 0);

            MatchOperatorRubyStringNode(MatchOperatorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRegexp arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyRegexp(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyRegexp");
                }
                return super.match(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRegexp arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyRegexp(arguments1Value);
                    return super.match(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MatchOperatorNode create0(StringNodes.MatchOperatorNode current2) {
                return new MatchOperatorRubyStringNode((MatchOperatorBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.MatchOperatorNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MatchOperatorUninitializedNode
        extends MatchOperatorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchOperatorUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MatchOperatorUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MatchOperatorUninitializedNode(MatchOperatorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MatchOperatorBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MatchOperatorBaseNode rootNode = (MatchOperatorBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MatchOperatorBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MatchOperatorNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MatchOperatorUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.MatchOperatorNode.class)
        private static abstract class MatchOperatorBaseNode
        extends StringNodes.MatchOperatorNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MatchOperatorBaseNode next0;

            MatchOperatorBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MatchOperatorBaseNode(MatchOperatorBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                MatchOperatorBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MatchOperatorBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MatchOperatorUninitializedNode(this);
                    ((MatchOperatorUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MatchOperatorBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MatchOperatorBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MatchOperatorBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MatchOperatorUninitializedNode(this), (Node)new MatchOperatorPolymorphicNode(this), (DSLNode)((MatchOperatorBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MatchOperatorBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyRegexp(arguments1Value)) {
                    return (MatchOperatorBaseNode)MatchOperatorRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MatchOperatorBaseNode otherCast = (MatchOperatorBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MatchOperatorBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ElementSetNode.class)
    public static final class ElementSetNodeFactory
    extends NodeFactoryBase<StringNodes.ElementSetNode> {
        private static ElementSetNodeFactory elementSetNodeFactoryInstance;

        private ElementSetNodeFactory() {
            super(StringNodes.ElementSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ElementSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ElementSetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ElementSetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ElementSetUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ElementSetNode> getInstance() {
            if (elementSetNodeFactoryInstance == null) {
                elementSetNodeFactoryInstance = new ElementSetNodeFactory();
            }
            return elementSetNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ElementSetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ElementSetPolymorphicNode
        extends ElementSetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            ElementSetPolymorphicNode(ElementSetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[1].executeIntegerFixnumRange(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value);
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.ElementSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ElementSetRubyStringIntegerFixnumRangeNode
        extends ElementSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ElementSetRubyStringIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRange.IntegerFixnumRange.class, RubyString.class}, 0, 0);

            ElementSetRubyStringIntegerFixnumRangeNode(ElementSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                RubyRange.IntegerFixnumRange arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.elementSet(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRange.IntegerFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.elementSet(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ElementSetNode create0(StringNodes.ElementSetNode current2) {
                return new ElementSetRubyStringIntegerFixnumRangeNode((ElementSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ElementSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ElementSetRubyStringIntNode
        extends ElementSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ElementSetRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, RubyString.class}, 0, 0);

            ElementSetRubyStringIntNode(ElementSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.elementSet(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.elementSet(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ElementSetNode create0(StringNodes.ElementSetNode current2) {
                return new ElementSetRubyStringIntNode((ElementSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ElementSetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ElementSetUninitializedNode
        extends ElementSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ElementSetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ElementSetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ElementSetUninitializedNode(ElementSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                ElementSetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ElementSetBaseNode rootNode = (ElementSetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ElementSetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.ElementSetNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ElementSetUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ElementSetNode.class)
        private static abstract class ElementSetBaseNode
        extends StringNodes.ElementSetNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ElementSetBaseNode next0;

            ElementSetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ElementSetBaseNode(ElementSetBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                ElementSetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ElementSetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new ElementSetUninitializedNode(this);
                    ((ElementSetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ElementSetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ElementSetBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (ElementSetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ElementSetUninitializedNode(this), (Node)new ElementSetPolymorphicNode(this), (DSLNode)((ElementSetBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ElementSetBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (ElementSetBaseNode)ElementSetRubyStringIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value)) {
                        return (ElementSetBaseNode)ElementSetRubyStringIntegerFixnumRangeNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    ElementSetBaseNode otherCast = (ElementSetBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (ElementSetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    extends NodeFactoryBase<StringNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
            super(StringNodes.GetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.GetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.GetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetIndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GetIndexPolymorphicNode
        extends GetIndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            GetIndexPolymorphicNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[1].executeIntegerFixnumRange(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexObjectIntIntNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexObjectIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            GetIndexObjectIntIntNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.slice(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.slice(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current2) {
                return new GetIndexObjectIntIntNode((GetIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexObjectIntegerFixnumRangeUndefinedPlaceholderNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexObjectIntegerFixnumRangeUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyRange.IntegerFixnumRange.class, UndefinedPlaceholder.class}, 0, 0);

            GetIndexObjectIntegerFixnumRangeUndefinedPlaceholderNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyRange.IntegerFixnumRange arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.slice(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyRange.IntegerFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.slice(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current2) {
                return new GetIndexObjectIntegerFixnumRangeUndefinedPlaceholderNode((GetIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexObjectIntUndefinedPlaceholderNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexObjectIntUndefinedPlaceholderNode.class, new Class[]{GetIndexRubyStringIntUndefinedPlaceholderNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            GetIndexObjectIntUndefinedPlaceholderNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.getIndex(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.getIndex(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current2) {
                return new GetIndexObjectIntUndefinedPlaceholderNode((GetIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyStringIntUndefinedPlaceholderNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyStringIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{GetIndexObjectIntUndefinedPlaceholderNode.class}, new Class[]{RubyString.class, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            GetIndexRubyStringIntUndefinedPlaceholderNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                try {
                    return super.getIndexInBounds(arguments0Value, arguments1Value, arguments2Value);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "Thrown UnexpectedResultException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    try {
                        return super.getIndexInBounds(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(StringNodes.GetIndexNode current2) {
                return new GetIndexRubyStringIntUndefinedPlaceholderNode((GetIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GetIndexUninitializedNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GetIndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GetIndexUninitializedNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                GetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GetIndexBaseNode rootNode = (GetIndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GetIndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static StringNodes.GetIndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetIndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        private static abstract class GetIndexBaseNode
        extends StringNodes.GetIndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GetIndexBaseNode next0;

            GetIndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GetIndexBaseNode(GetIndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                GetIndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new GetIndexUninitializedNode(this);
                    ((GetIndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GetIndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = GetIndexBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (GetIndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GetIndexUninitializedNode(this), (Node)new GetIndexPolymorphicNode(this), (DSLNode)((GetIndexBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GetIndexBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)GetIndexRubyStringIntUndefinedPlaceholderNode.METADATA)) {
                                return (GetIndexBaseNode)GetIndexRubyStringIntUndefinedPlaceholderNode.create0(this);
                            }
                            return (GetIndexBaseNode)GetIndexObjectIntUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value)) {
                            return (GetIndexBaseNode)GetIndexObjectIntegerFixnumRangeUndefinedPlaceholderNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                        return (GetIndexBaseNode)GetIndexObjectIntIntNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    GetIndexBaseNode otherCast = (GetIndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (GetIndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.FormatNode.class)
    public static final class FormatNodeFactory
    extends NodeFactoryBase<StringNodes.FormatNode> {
        private static FormatNodeFactory formatNodeFactoryInstance;

        private FormatNodeFactory() {
            super(StringNodes.FormatNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.FormatNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FormatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.FormatNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FormatUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.FormatNode> getInstance() {
            if (formatNodeFactoryInstance == null) {
                formatNodeFactoryInstance = new FormatNodeFactory();
            }
            return formatNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.FormatNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FormatPolymorphicNode
        extends FormatBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            FormatPolymorphicNode(FormatBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.FormatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FormatRubyStringNode
        extends FormatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FormatRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object[].class}, 0, 0);

            FormatRubyStringNode(FormatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.format(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.format(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.FormatNode create0(StringNodes.FormatNode current2) {
                return new FormatRubyStringNode((FormatBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.FormatNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FormatUninitializedNode
        extends FormatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FormatUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FormatUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FormatUninitializedNode(FormatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                FormatBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FormatBaseNode rootNode = (FormatBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((FormatBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.FormatNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FormatUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.FormatNode.class)
        private static abstract class FormatBaseNode
        extends StringNodes.FormatNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FormatBaseNode next0;

            FormatBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FormatBaseNode(FormatBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                FormatBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FormatBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new FormatUninitializedNode(this);
                    ((FormatUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (FormatBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = FormatBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (FormatBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FormatUninitializedNode(this), (Node)new FormatPolymorphicNode(this), (DSLNode)((FormatBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FormatBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (FormatBaseNode)FormatRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    FormatBaseNode otherCast = (FormatBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (FormatBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.ConcatNode.class)
    public static final class ConcatNodeFactory
    extends NodeFactoryBase<StringNodes.ConcatNode> {
        private static ConcatNodeFactory concatNodeFactoryInstance;

        private ConcatNodeFactory() {
            super(StringNodes.ConcatNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ConcatNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConcatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.ConcatNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConcatUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.ConcatNode> getInstance() {
            if (concatNodeFactoryInstance == null) {
                concatNodeFactoryInstance = new ConcatNodeFactory();
            }
            return concatNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConcatPolymorphicNode
        extends ConcatBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ConcatPolymorphicNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyStringNode
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            ConcatRubyStringNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.concat(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.concat(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ConcatNode create0(StringNodes.ConcatNode current2) {
                return new ConcatRubyStringNode((ConcatBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConcatUninitializedNode
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConcatUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConcatUninitializedNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ConcatBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConcatBaseNode rootNode = (ConcatBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ConcatBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.ConcatNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConcatUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        private static abstract class ConcatBaseNode
        extends StringNodes.ConcatNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConcatBaseNode next0;

            ConcatBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConcatBaseNode(ConcatBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ConcatBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConcatBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ConcatUninitializedNode(this);
                    ((ConcatUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ConcatBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ConcatBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ConcatBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ConcatUninitializedNode(this), (Node)new ConcatPolymorphicNode(this), (DSLNode)((ConcatBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConcatBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (ConcatBaseNode)ConcatRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ConcatBaseNode otherCast = (ConcatBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ConcatBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<StringNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(StringNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompareUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ComparePolymorphicNode
        extends CompareBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ComparePolymorphicNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyStringNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            CompareRubyStringNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.CompareNode create0(StringNodes.CompareNode current2) {
                return new CompareRubyStringNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompareUninitializedNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompareUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompareUninitializedNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompareBaseNode rootNode = (CompareBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CompareBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.CompareNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompareUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        private static abstract class CompareBaseNode
        extends StringNodes.CompareNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompareBaseNode next0;

            CompareBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompareBaseNode(CompareBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                CompareBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CompareUninitializedNode(this);
                    ((CompareUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CompareBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = CompareBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CompareBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CompareUninitializedNode(this), (Node)new ComparePolymorphicNode(this), (DSLNode)((CompareBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompareBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (CompareBaseNode)CompareRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CompareBaseNode otherCast = (CompareBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CompareBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<StringNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(StringNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyStringObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyStringObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Object.class}, 0, 0);

            EqualRubyStringObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyString");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyString(arguments1Value)) {
                    return super.equal(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyString] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && !super.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.equal(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EqualNode create0(StringNodes.EqualNode current2) {
                return new EqualRubyStringObjectNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyStringNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            EqualRubyStringNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EqualNode create0(StringNodes.EqualNode current2) {
                return new EqualRubyStringNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = (EqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends StringNodes.EqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EqualBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EqualUninitializedNode(this), (Node)new EqualPolymorphicNode(this), (DSLNode)((EqualBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyStringNode.create0(this);
                    }
                    if (!super.isRubyString(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyStringObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<StringNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(StringNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MulUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MulPolymorphicNode
        extends MulBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MulPolymorphicNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulRubyStringNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            MulRubyStringNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MulNode create0(StringNodes.MulNode current2) {
                return new MulRubyStringNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MulUninitializedNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MulUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MulUninitializedNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MulBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MulBaseNode rootNode = (MulBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MulBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.MulNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MulUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        private static abstract class MulBaseNode
        extends StringNodes.MulNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MulBaseNode next0;

            MulBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MulBaseNode(MulBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                MulBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MulBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MulUninitializedNode(this);
                    ((MulUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MulBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MulBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MulBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MulUninitializedNode(this), (Node)new MulPolymorphicNode(this), (DSLNode)((MulBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MulBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (MulBaseNode)MulRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MulBaseNode otherCast = (MulBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MulBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=StringNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<StringNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(StringNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AddNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static StringNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AddUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<StringNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        @GeneratedBy(value=StringNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AddPolymorphicNode
        extends AddBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AddPolymorphicNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=StringNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddRubyStringNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            AddRubyStringNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.AddNode create0(StringNodes.AddNode current2) {
                return new AddRubyStringNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=StringNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AddUninitializedNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AddUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AddUninitializedNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AddBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AddBaseNode rootNode = (AddBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AddBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static StringNodes.AddNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AddUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=StringNodes.AddNode.class)
        private static abstract class AddBaseNode
        extends StringNodes.AddNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AddBaseNode next0;

            AddBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AddBaseNode(AddBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                AddBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AddBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AddUninitializedNode(this);
                    ((AddUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AddBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = AddBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (AddBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AddUninitializedNode(this), (Node)new AddPolymorphicNode(this), (DSLNode)((AddBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AddBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (AddBaseNode)AddRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AddBaseNode otherCast = (AddBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AddBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

