/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.RegexpNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.util.ByteList;

@CoreClass(name="Regexp")
public abstract class RegexpNodes {

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString to_s(org.jruby.truffle.runtime.core.RubyRegexp regexp2) {
            return new org.jruby.truffle.runtime.core.RubyString(this.getContext().getCoreLibrary().getStringClass(), ((RubyString)RubyRegexp.newRegexp(this.getContext().getRuntime(), regexp2.getSource(), regexp2.getRegex().getOptions()).to_s()).getByteList());
        }
    }

    @CoreMethod(names={"source"})
    public static abstract class SourceNode
    extends CoreMethodNode {
        public SourceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SourceNode(SourceNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString source(org.jruby.truffle.runtime.core.RubyRegexp regexp2) {
            return this.getContext().makeString(regexp2.getSource().toString());
        }
    }

    @CoreMethod(names={"quote", "escape"}, needsSelf=false, onSingleton=true, required=1)
    public static abstract class QuoteNode
    extends CoreMethodNode {
        public QuoteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public QuoteNode(QuoteNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString quote(org.jruby.truffle.runtime.core.RubyString raw) {
            QuoteNode.notDesignedForCompilation();
            boolean isAsciiOnly = raw.getByteList().getEncoding().isAsciiCompatible() && raw.scanForCodeRange() == 16;
            return this.getContext().makeString(RubyRegexp.quote19(raw.getBytes(), isAsciiOnly));
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString quote(RubySymbol raw) {
            QuoteNode.notDesignedForCompilation();
            return this.quote(raw.toRubyString());
        }
    }

    @CoreMethod(names={"options"})
    public static abstract class OptionsNode
    extends CoreMethodNode {
        private final ConditionProfile notYetInitializedProfile = ConditionProfile.createBinaryProfile();

        public OptionsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public OptionsNode(OptionsNode prev) {
            super(prev);
        }

        @Specialization
        public int options(org.jruby.truffle.runtime.core.RubyRegexp regexp2) {
            OptionsNode.notDesignedForCompilation();
            if (this.notYetInitializedProfile.profile(regexp2.getRegex() == null)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("uninitialized Regexp", this));
            }
            return regexp2.getRegex().getOptions();
        }
    }

    @CoreMethod(names={"match"}, required=1)
    public static abstract class MatchNode
    extends CoreMethodNode {
        public MatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MatchNode(MatchNode prev) {
            super(prev);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString string2) {
            return regexp2.matchCommon(string2.getBytes(), false, false);
        }
    }

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString match(org.jruby.truffle.runtime.core.RubyRegexp regexp2) {
            return new org.jruby.truffle.runtime.core.RubyString(this.getContext().getCoreLibrary().getStringClass(), ((RubyString)RubyRegexp.newRegexp(this.getContext().getRuntime(), regexp2.getSource(), regexp2.getRegex().getOptions()).inspect19()).getByteList());
        }
    }

    @CoreMethod(names={"initialize_copy"}, visibility=Visibility.PRIVATE, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization
        public Object initializeCopy(org.jruby.truffle.runtime.core.RubyRegexp self2, org.jruby.truffle.runtime.core.RubyRegexp from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self2 == from) {
                return self2;
            }
            self2.initialize(this, from.getSource());
            return self2;
        }
    }

    @CoreMethod(names={"initialize"}, required=1, optional=1, lowerFixnumParameters={2})
    public static abstract class InitializeNode
    extends CoreMethodNode {
        private ConditionProfile booleanOptionsProfile = ConditionProfile.createBinaryProfile();

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyRegexp initialize(org.jruby.truffle.runtime.core.RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString string2, UndefinedPlaceholder options2) {
            InitializeNode.notDesignedForCompilation();
            regexp2.initialize(this, string2.getBytes());
            return regexp2;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyRegexp initialize(org.jruby.truffle.runtime.core.RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString string2, RubyNilClass options2) {
            InitializeNode.notDesignedForCompilation();
            return this.initialize(regexp2, string2, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyRegexp initialize(org.jruby.truffle.runtime.core.RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString string2, boolean options2) {
            InitializeNode.notDesignedForCompilation();
            if (this.booleanOptionsProfile.profile(options2)) {
                return this.initialize(regexp2, string2, 1);
            }
            return this.initialize(regexp2, string2, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyRegexp initialize(org.jruby.truffle.runtime.core.RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString string2, int options2) {
            InitializeNode.notDesignedForCompilation();
            regexp2.initialize(this, string2.getBytes(), options2);
            return regexp2;
        }

        @Specialization(guards={"!isRubyNilClass(arguments[2])"})
        public org.jruby.truffle.runtime.core.RubyRegexp initialize(org.jruby.truffle.runtime.core.RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString string2, Object options2) {
            InitializeNode.notDesignedForCompilation();
            return this.initialize(regexp2, string2, 1);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyRegexp initialize(org.jruby.truffle.runtime.core.RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyRegexp from, UndefinedPlaceholder options2) {
            InitializeNode.notDesignedForCompilation();
            regexp2.initialize(this, from.getSource(), from.getRegex().getOptions());
            return regexp2;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyRegexp initialize(org.jruby.truffle.runtime.core.RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyRegexp from, Object options2) {
            InitializeNode.notDesignedForCompilation();
            this.getContext().getWarnings().warn("flags ignored");
            return this.initialize(regexp2, from, UndefinedPlaceholder.INSTANCE);
        }
    }

    @CoreMethod(names={"escape"}, onSingleton=true, required=1)
    public static abstract class EscapeNode
    extends CoreMethodNode {
        public EscapeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EscapeNode(EscapeNode prev) {
            super(prev);
        }

        public abstract org.jruby.truffle.runtime.core.RubyString executeEscape(VirtualFrame var1, org.jruby.truffle.runtime.core.RubyString var2);

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString escape(org.jruby.truffle.runtime.core.RubyString pattern) {
            EscapeNode.notDesignedForCompilation();
            return this.getContext().makeString(RubyRegexp.quote19(new ByteList(pattern.getBytes()), true).toString());
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodNode {
        public EncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EncodingNode(EncodingNode prev) {
            super(prev);
        }

        @Specialization
        public RubyEncoding encoding(org.jruby.truffle.runtime.core.RubyRegexp regexp2) {
            EncodingNode.notDesignedForCompilation();
            return regexp2.getEncoding();
        }
    }

    @CoreMethod(names={"=~"}, required=1)
    public static abstract class MatchOperatorNode
    extends CoreMethodNode {
        public MatchOperatorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MatchOperatorNode(MatchOperatorNode prev) {
            super(prev);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString string2) {
            return regexp2.matchCommon(string2.getBytes(), true, true);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyRegexp regexp2, RubyBasicObject other) {
            MatchOperatorNode.notDesignedForCompilation();
            if (other instanceof org.jruby.truffle.runtime.core.RubyString) {
                return this.match(regexp2, (org.jruby.truffle.runtime.core.RubyString)other);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class CaseEqualNode
    extends CoreMethodNode {
        public CaseEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CaseEqualNode(CaseEqualNode prev) {
            super(prev);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString string2) {
            CaseEqualNode.notDesignedForCompilation();
            return regexp2.matchCommon(string2.getBytes(), true, false) != this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(org.jruby.truffle.runtime.core.RubyRegexp a, org.jruby.truffle.runtime.core.RubyRegexp b2) {
            EqualNode.notDesignedForCompilation();
            return ((RubyString)RubyRegexp.newRegexp(this.getContext().getRuntime(), a.getSource(), a.getRegex().getOptions()).to_s()).getByteList().equals((Object)((RubyString)RubyRegexp.newRegexp(this.getContext().getRuntime(), b2.getSource(), b2.getRegex().getOptions()).to_s()).getByteList());
        }
    }

    public static abstract class EscapingYieldingNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private EscapeNode escapeNode;

        public EscapingYieldingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EscapingYieldingNode(EscapingYieldingNode prev) {
            super(prev);
        }

        protected org.jruby.truffle.runtime.core.RubyString escape(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2) {
            if (this.escapeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.escapeNode = (EscapeNode)this.insert(RegexpNodesFactory.EscapeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
            }
            return this.escapeNode.executeEscape(frame, string2);
        }
    }

    public static abstract class EscapingNode
    extends CoreMethodNode {
        @Node.Child
        private EscapeNode escapeNode;

        public EscapingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EscapingNode(EscapingNode prev) {
            super(prev);
        }

        protected org.jruby.truffle.runtime.core.RubyString escape(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2) {
            if (this.escapeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.escapeNode = (EscapeNode)this.insert(RegexpNodesFactory.EscapeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
            }
            return this.escapeNode.executeEscape(frame, string2);
        }
    }
}

