/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Collection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.ObjectIDOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;

@CoreClass(name="ObjectSpace")
public abstract class ObjectSpaceNodes {

    @CoreMethod(names={"undefine_finalizer"}, isModuleFunction=true, required=1)
    public static abstract class UndefineFinalizerNode
    extends CoreMethodNode {
        public UndefineFinalizerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UndefineFinalizerNode(UndefineFinalizerNode prev) {
            super(prev);
        }

        @Specialization
        public Object undefineFinalizer(Object object) {
            UndefineFinalizerNode.notDesignedForCompilation();
            this.getContext().getObjectSpaceManager().undefineFinalizer((RubyBasicObject)object);
            return object;
        }
    }

    @CoreMethod(names={"define_finalizer"}, isModuleFunction=true, required=2)
    public static abstract class DefineFinalizerNode
    extends CoreMethodNode {
        public DefineFinalizerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DefineFinalizerNode(DefineFinalizerNode prev) {
            super(prev);
        }

        @Specialization
        public RubyProc defineFinalizer(Object object, RubyProc finalizer) {
            DefineFinalizerNode.notDesignedForCompilation();
            this.getContext().getObjectSpaceManager().defineFinalizer((RubyBasicObject)object, finalizer);
            return finalizer;
        }
    }

    @CoreMethod(names={"each_object"}, isModuleFunction=true, needsBlock=true, optional=1)
    public static abstract class EachObjectNode
    extends YieldingCoreMethodNode {
        public EachObjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachObjectNode(EachObjectNode prev) {
            super(prev);
        }

        @Specialization
        public int eachObject(VirtualFrame frame, UndefinedPlaceholder ofClass, RubyProc block) {
            EachObjectNode.notDesignedForCompilation();
            Collection<RubyBasicObject> liveObjects = this.getContext().getObjectSpaceManager().collectLiveObjects().values();
            for (RubyBasicObject object : liveObjects) {
                this.yield(frame, block, object);
            }
            return liveObjects.size();
        }

        @Specialization
        public int eachObject(VirtualFrame frame, RubyClass ofClass, RubyProc block) {
            EachObjectNode.notDesignedForCompilation();
            int count2 = 0;
            for (RubyBasicObject object : this.getContext().getObjectSpaceManager().collectLiveObjects().values()) {
                if (!ModuleOperations.assignableTo(object.getLogicalClass(), ofClass)) continue;
                this.yield(frame, block, object);
                ++count2;
            }
            return count2;
        }
    }

    @CoreMethod(names={"_id2ref"}, isModuleFunction=true, required=1)
    public static abstract class ID2RefNode
    extends CoreMethodNode {
        public ID2RefNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ID2RefNode(ID2RefNode prev) {
            super(prev);
        }

        @Specialization
        public Object id2Ref(int id2) {
            return this.id2Ref((long)id2);
        }

        @Specialization
        public Object id2Ref(long id2) {
            ID2RefNode.notDesignedForCompilation();
            if (id2 == 4L) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            if (id2 == 2L) {
                return true;
            }
            if (id2 == 0L) {
                return false;
            }
            if (ObjectIDOperations.isSmallFixnumID(id2)) {
                return ObjectIDOperations.toFixnum(id2);
            }
            RubyBasicObject object = this.getContext().getObjectSpaceManager().collectLiveObjects().get(id2);
            if (object == null) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return object;
        }

        @Specialization(guards={"isLargeFixnumID"})
        public Object id2RefLargeFixnum(RubyBignum id2) {
            return ObjectIDOperations.toFixnum(id2);
        }

        @Specialization(guards={"isFloatID"})
        public double id2RefFloat(RubyBignum id2) {
            return ObjectIDOperations.toFloat(id2);
        }

        protected boolean isLargeFixnumID(RubyBignum id2) {
            return ObjectIDOperations.isLargeFixnumID(id2);
        }

        protected boolean isFloatID(RubyBignum id2) {
            return ObjectIDOperations.isFloatID(id2);
        }
    }
}

