/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.control.WhileNode;
import org.jruby.truffle.nodes.core.ArrayBuilderNode;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.globals.WrapInThreadLocalNode;
import org.jruby.truffle.nodes.literal.BooleanLiteralNode;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeFactory;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.yield.YieldNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.backtrace.MRIBacktraceFormatter;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ThrowException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.core.StringFormatter;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.util.ByteList;
import org.jruby.util.cli.Options;

@CoreClass(name="Kernel")
public abstract class KernelNodes {

    @CoreMethod(names={"untaint"})
    public static abstract class UntaintNode
    extends CoreMethodNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeTaintNode;

        public UntaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.writeTaintNode = new WriteHeadObjectFieldNode(RubyBasicObject.TAINTED_IDENTIFIER);
        }

        public UntaintNode(UntaintNode prev) {
            super(prev);
            this.writeTaintNode = prev.writeTaintNode;
        }

        @Specialization
        public Object taint(boolean object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(int object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(long object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(double object) {
            return this.frozen(object);
        }

        private Object frozen(Object object) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getContext().getCoreLibrary().getLogicalClass(object).getName(), this));
        }

        @Specialization
        public Object taint(RubyBasicObject object) {
            this.writeTaintNode.execute(object, false);
            return object;
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        @Node.Child
        private ClassNode classNode;
        @Node.Child
        private BasicObjectNodes.IDNode idNode;
        @Node.Child
        private ToHexStringNode toHexStringNode;

        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = KernelNodesFactory.ClassNodeFactory.create(context, sourceSection, new RubyNode[]{null});
            this.idNode = BasicObjectNodesFactory.IDNodeFactory.create(context, sourceSection, new RubyNode[]{null});
            this.toHexStringNode = KernelNodesFactory.ToHexStringNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        public abstract RubyString executeToS(VirtualFrame var1, Object var2);

        @Specialization
        public RubyString toS(VirtualFrame frame, Object self2) {
            ToSNode.notDesignedForCompilation();
            String className = this.classNode.executeGetClass(frame, self2).getName();
            if (className == null) {
                className = "Class";
            }
            Object id2 = this.idNode.executeObjectID(frame, self2);
            String hexID = this.toHexStringNode.executeToHexString(frame, id2);
            return this.getContext().makeString("#<" + className + ":0x" + hexID + ">");
        }
    }

    public static abstract class ToHexStringNode
    extends CoreMethodNode {
        public ToHexStringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToHexStringNode(ToHexStringNode prev) {
            super(prev);
        }

        public abstract String executeToHexString(VirtualFrame var1, Object var2);

        @Specialization
        public String toHexString(int value2) {
            return this.toHexString((long)value2);
        }

        @Specialization
        public String toHexString(long value2) {
            return Long.toHexString(value2);
        }

        @Specialization
        public String toHexString(RubyBignum value2) {
            return value2.toHexString();
        }
    }

    @CoreMethod(names={"throw"}, isModuleFunction=true, required=1, optional=1)
    public static abstract class ThrowNode
    extends CoreMethodNode {
        public ThrowNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ThrowNode(ThrowNode prev) {
            super(prev);
        }

        @Specialization
        public Object doThrow(Object tag2, UndefinedPlaceholder value2) {
            return this.doThrow(tag2, (Object)value2);
        }

        @Specialization
        public Object doThrow(Object tag2, Object value2) {
            ThrowNode.notDesignedForCompilation();
            if (!this.getContext().getThrowTags().contains(tag2)) {
                throw new RaiseException(new RubyException(this.getContext().getCoreLibrary().getArgumentErrorClass(), this.getContext().makeString(String.format("uncaught throw \"%s\"", tag2)), RubyCallStack.getBacktrace(this)));
            }
            if (value2 instanceof UndefinedPlaceholder) {
                throw new ThrowException(tag2, this.getContext().getCoreLibrary().getNilObject());
            }
            throw new ThrowException(tag2, value2);
        }
    }

    @CoreMethod(names={"tainted?"})
    public static abstract class TaintedNode
    extends CoreMethodNode {
        @Node.Child
        private ReadHeadObjectFieldNode readTaintNode;

        public TaintedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readTaintNode = new ReadHeadObjectFieldNode(RubyBasicObject.TAINTED_IDENTIFIER);
        }

        public TaintedNode(TaintedNode prev) {
            super(prev);
            this.readTaintNode = prev.readTaintNode;
        }

        @Specialization
        public boolean tainted(boolean object) {
            return false;
        }

        @Specialization
        public boolean tainted(int object) {
            return false;
        }

        @Specialization
        public boolean tainted(long object) {
            return false;
        }

        @Specialization
        public boolean tainted(double object) {
            return false;
        }

        @Specialization
        public boolean tainted(RubyBasicObject object) {
            try {
                return this.readTaintNode.isSet(object) && this.readTaintNode.executeBoolean(object);
            }
            catch (UnexpectedResultException e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    @CoreMethod(names={"taint"})
    public static abstract class TaintNode
    extends CoreMethodNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeTaintNode;

        public TaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.writeTaintNode = new WriteHeadObjectFieldNode(RubyBasicObject.TAINTED_IDENTIFIER);
        }

        public TaintNode(TaintNode prev) {
            super(prev);
            this.writeTaintNode = prev.writeTaintNode;
        }

        @Specialization
        public Object taint(boolean object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(int object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(long object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(double object) {
            return this.frozen(object);
        }

        private Object frozen(Object object) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getContext().getCoreLibrary().getLogicalClass(object).getName(), this));
        }

        @Specialization
        public Object taint(RubyBasicObject object) {
            this.writeTaintNode.execute(object, true);
            return object;
        }
    }

    @CoreMethod(names={"system"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class SystemNode
    extends CoreMethodNode {
        public SystemNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SystemNode(SystemNode prev) {
            super(prev);
        }

        @Specialization
        public boolean system(RubyString command) {
            SystemNode.notDesignedForCompilation();
            RubyHash env = this.getContext().getCoreLibrary().getENV();
            ArrayList<String> envp = new ArrayList<String>();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(env)) {
                envp.add(keyValue.getKey().toString() + "=" + keyValue.getValue().toString());
            }
            try {
                Runtime.getRuntime().exec(new String[]{"bash", "-c", command.toString()}, envp.toArray(new String[envp.size()]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    @CoreMethod(names={"sprintf"}, isModuleFunction=true, argumentsAsArray=true)
    public static abstract class SPrintfNode
    extends CoreMethodNode {
        public SPrintfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SPrintfNode(SPrintfNode prev) {
            super(prev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public RubyString sprintf(Object[] args2) {
            PrintStream printStream;
            SPrintfNode.notDesignedForCompilation();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                printStream = new PrintStream((OutputStream)outputStream, true, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (args2.length > 0) {
                String format = args2[0].toString();
                List<Object> values2 = Arrays.asList(args2).subList(1, args2.length);
                RubyThread runningThread = this.getContext().getThreadManager().leaveGlobalLock();
                try {
                    StringFormatter.format(this.getContext(), printStream, format, values2);
                }
                finally {
                    this.getContext().getThreadManager().enterGlobalLock(runningThread);
                }
            }
            return this.getContext().makeString(new ByteList(outputStream.toByteArray()));
        }
    }

    @CoreMethod(names={"sleep"}, isModuleFunction=true, optional=1)
    public static abstract class SleepNode
    extends CoreMethodNode {
        public SleepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SleepNode(SleepNode prev) {
            super(prev);
        }

        @Specialization
        public double sleep(UndefinedPlaceholder duration) {
            return this.doSleep(0.0);
        }

        @Specialization
        public double sleep(int duration) {
            return this.doSleep(duration);
        }

        @Specialization
        public double sleep(long duration) {
            return this.doSleep(duration);
        }

        @Specialization
        public double sleep(double duration) {
            return this.doSleep(duration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private double doSleep(double duration) {
            long start2 = System.nanoTime();
            RubyThread runningThread = this.getContext().getThreadManager().leaveGlobalLock();
            try {
                try {
                    Thread.sleep((long)(duration * 1000.0));
                }
                finally {
                    this.getContext().getThreadManager().enterGlobalLock(runningThread);
                }
            }
            catch (InterruptedException e) {
                this.getContext().getSafepointManager().poll();
            }
            long end2 = System.nanoTime();
            return (double)(end2 - start2) / 1.0E9;
        }
    }

    @CoreMethod(names={"String"}, isModuleFunction=true, required=1)
    public static abstract class StringNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toS;

        public StringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toS = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public StringNode(StringNode prev) {
            super(prev);
            this.toS = prev.toS;
        }

        @Specialization
        public RubyString string(RubyString value2) {
            return value2;
        }

        @Specialization(guards={"!isRubyString"})
        public Object string(VirtualFrame frame, Object value2) {
            return this.toS.call(frame, value2, "to_s", null, new Object[0]);
        }
    }

    @CoreMethod(names={"singleton_methods"}, optional=1)
    public static abstract class SingletonMethodsNode
    extends CoreMethodNode {
        public SingletonMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SingletonMethodsNode(SingletonMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray singletonMethods(RubyBasicObject self2, boolean includeInherited) {
            SingletonMethodsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(self2.getContext().getCoreLibrary().getArrayClass());
            Collection<InternalMethod> methods2 = includeInherited ? ModuleOperations.getAllMethods(self2.getSingletonClass(this)).values() : self2.getSingletonClass(this).getMethods().values();
            for (InternalMethod method : methods2) {
                array.slowPush(RubySymbol.newSymbol(self2.getContext(), method.getName()));
            }
            return array;
        }

        @Specialization
        public RubyArray singletonMethods(RubyBasicObject self2, UndefinedPlaceholder includeInherited) {
            return this.singletonMethods(self2, false);
        }
    }

    @CoreMethod(names={"singleton_class"})
    public static abstract class SingletonClassMethodNode
    extends CoreMethodNode {
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public SingletonClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeFactory.create(context, sourceSection, null);
        }

        public SingletonClassMethodNode(SingletonClassMethodNode prev) {
            super(prev);
            this.singletonClassNode = prev.singletonClassNode;
        }

        @Specialization
        public RubyClass singletonClass(VirtualFrame frame, Object self2) {
            return this.singletonClassNode.executeSingletonClass(frame, self2);
        }
    }

    @CoreMethod(names={"set_trace_func"}, isModuleFunction=true, required=1)
    public static abstract class SetTraceFuncNode
    extends CoreMethodNode {
        public SetTraceFuncNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SetTraceFuncNode(SetTraceFuncNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass setTraceFunc(RubyNilClass nil) {
            SetTraceFuncNode.notDesignedForCompilation();
            this.getContext().getTraceManager().setTraceFunc(null);
            return nil;
        }

        @Specialization
        public RubyProc setTraceFunc(RubyProc traceFunc) {
            SetTraceFuncNode.notDesignedForCompilation();
            this.getContext().getTraceManager().setTraceFunc(traceFunc);
            return traceFunc;
        }
    }

    @CoreMethod(names={"send"}, needsBlock=true, required=1, argumentsAsArray=true)
    public static abstract class SendNode
    extends BasicObjectNodes.SendNode {
        public SendNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SendNode(SendNode prev) {
            super(prev);
        }
    }

    @CoreMethod(names={"respond_to_missing?"}, required=1, optional=1, visibility=Visibility.PRIVATE)
    public static abstract class RespondToMissingNode
    extends CoreMethodNode {
        public RespondToMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RespondToMissingNode(RespondToMissingNode prev) {
            super(prev);
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubyString name2, UndefinedPlaceholder includeAll) {
            return false;
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubySymbol name2, UndefinedPlaceholder includeAll) {
            return false;
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubySymbol name2, boolean includeAll) {
            return false;
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubyString name2, boolean includeAll) {
            return false;
        }
    }

    @CoreMethod(names={"respond_to?"}, required=1, optional=1)
    public static abstract class RespondToNode
    extends CoreMethodNode {
        @Node.Child
        private DoesRespondDispatchHeadNode dispatch;
        @Node.Child
        private DoesRespondDispatchHeadNode dispatchIgnoreVisibility;

        public RespondToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = new DoesRespondDispatchHeadNode(context, false, false, MissingBehavior.RETURN_MISSING, null);
            this.dispatchIgnoreVisibility = new DoesRespondDispatchHeadNode(context, true, false, MissingBehavior.RETURN_MISSING, null);
            if (((Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED.load()).booleanValue()) {
                this.dispatch.forceUncached();
                this.dispatchIgnoreVisibility.forceUncached();
            }
        }

        public RespondToNode(RespondToNode prev) {
            super(prev);
            this.dispatch = prev.dispatch;
            this.dispatchIgnoreVisibility = prev.dispatchIgnoreVisibility;
        }

        public abstract boolean executeDoesRespondTo(VirtualFrame var1, Object var2, Object var3, boolean var4);

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubyString name2, UndefinedPlaceholder checkVisibility) {
            return this.dispatch.doesRespondTo(frame, name2, object);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubyString name2, boolean ignoreVisibility) {
            if (ignoreVisibility) {
                return this.dispatchIgnoreVisibility.doesRespondTo(frame, name2, object);
            }
            return this.dispatch.doesRespondTo(frame, name2, object);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubySymbol name2, UndefinedPlaceholder checkVisibility) {
            return this.dispatch.doesRespondTo(frame, name2, object);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubySymbol name2, boolean ignoreVisibility) {
            if (ignoreVisibility) {
                return this.dispatchIgnoreVisibility.doesRespondTo(frame, name2, object);
            }
            return this.dispatch.doesRespondTo(frame, name2, object);
        }
    }

    @CoreMethod(names={"require_relative"}, isModuleFunction=true, required=1)
    public static abstract class RequireRelativeNode
    extends CoreMethodNode {
        public RequireRelativeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RequireRelativeNode(RequireRelativeNode prev) {
            super(prev);
        }

        @Specialization
        public boolean require(RubyString feature) {
            RequireRelativeNode.notDesignedForCompilation();
            String sourcePath = Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getSource().getPath();
            String directoryPath = new File(sourcePath).getParent();
            try {
                this.getContext().getFeatureManager().require(directoryPath, feature.toString(), this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    @CoreMethod(names={"require"}, isModuleFunction=true, required=1)
    public static abstract class RequireNode
    extends CoreMethodNode {
        public RequireNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RequireNode(RequireNode prev) {
            super(prev);
        }

        @Specialization
        public boolean require(RubyString feature) {
            RequireNode.notDesignedForCompilation();
            try {
                this.getContext().getFeatureManager().require(null, feature.toString(), this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    @CoreMethod(names={"rand"}, isModuleFunction=true, optional=1)
    public static abstract class RandNode
    extends CoreMethodNode {
        public RandNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RandNode(RandNode prev) {
            super(prev);
        }

        @Specialization
        public double rand(UndefinedPlaceholder undefined) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isZero"})
        public double randZero(int max2) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isNonZero"})
        public int randNonZero(int max2) {
            return this.getContext().getRandom().nextInt(max2);
        }

        protected boolean isZero(int max2) {
            return max2 == 0;
        }

        protected boolean isNonZero(int max2) {
            return max2 != 0;
        }
    }

    @CoreMethod(names={"raise"}, isModuleFunction=true, optional=3)
    public static abstract class RaiseNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode initialize;

        public RaiseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initialize = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public RaiseNode(RaiseNode prev) {
            super(prev);
            this.initialize = prev.initialize;
        }

        @Specialization
        public Object raise(VirtualFrame frame, UndefinedPlaceholder undefined1, UndefinedPlaceholder undefined2, Object undefined3) {
            RaiseNode.notDesignedForCompilation();
            return this.raise(frame, this.getContext().getCoreLibrary().getRuntimeErrorClass(), this.getContext().makeString("re-raised - don't have the current exception yet!"), (Object)undefined1);
        }

        @Specialization
        public Object raise(VirtualFrame frame, RubyString message2, UndefinedPlaceholder undefined1, Object undefined2) {
            RaiseNode.notDesignedForCompilation();
            return this.raise(frame, this.getContext().getCoreLibrary().getRuntimeErrorClass(), message2, (Object)undefined1);
        }

        @Specialization
        public Object raise(VirtualFrame frame, RubyClass exceptionClass, UndefinedPlaceholder undefined1, Object undefined2) {
            RaiseNode.notDesignedForCompilation();
            return this.raise(frame, exceptionClass, this.getContext().makeString(""), (Object)undefined1);
        }

        @Specialization
        public Object raise(VirtualFrame frame, RubyClass exceptionClass, RubyString message2, Object undefined1) {
            RaiseNode.notDesignedForCompilation();
            RubyBasicObject exception2 = exceptionClass.allocate(this);
            this.initialize.call(frame, exception2, "initialize", null, message2);
            if (!(exception2 instanceof RubyException)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("exception class/object expected", this));
            }
            throw new RaiseException((RubyException)exception2);
        }

        @Specialization
        public Object raise(RubyException exception2, UndefinedPlaceholder undefined1, Object undefined2) {
            throw new RaiseException(exception2);
        }
    }

    @CoreMethod(names={"public_methods"}, optional=1)
    public static abstract class PublicMethodsNode
    extends CoreMethodNode {
        public PublicMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicMethodsNode(PublicMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray methods(RubyBasicObject self2, boolean includeInherited) {
            PublicMethodsNode.notDesignedForCompilation();
            if (!includeInherited) {
                this.getContext().getRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getSource().getName(), Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getStartLine(), "Object#methods always returns inherited methods at the moment");
            }
            return this.methods(self2, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization
        public RubyArray methods(RubyBasicObject self2, UndefinedPlaceholder includeInherited) {
            PublicMethodsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(self2.getContext().getCoreLibrary().getArrayClass());
            Map<String, InternalMethod> methods2 = self2.getMetaClass().getMethods();
            for (InternalMethod method : methods2.values()) {
                if (method.getVisibility() != Visibility.PUBLIC) continue;
                array.slowPush(self2.getContext().newSymbol(method.getName()));
            }
            return array;
        }
    }

    @CoreMethod(names={"proc"}, isModuleFunction=true, needsBlock=true)
    public static abstract class ProcNode
    extends CoreMethodNode {
        public ProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ProcNode(ProcNode prev) {
            super(prev);
        }

        @Specialization
        public RubyProc proc(RubyProc block) {
            ProcNode.notDesignedForCompilation();
            return new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, block.getSharedMethodInfo(), block.getCallTargetForProcs(), block.getCallTargetForProcs(), block.getCallTargetForMethods(), block.getDeclarationFrame(), block.getDeclaringModule(), block.getMethod(), block.getSelfCapturedInScope(), block.getBlockCapturedInScope());
        }
    }

    @CoreMethod(names={"private_methods"}, optional=1)
    public static abstract class PrivateMethodsNode
    extends CoreMethodNode {
        public PrivateMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrivateMethodsNode(PrivateMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray private_methods(RubyBasicObject self2, UndefinedPlaceholder unused2) {
            return this.private_methods(self2, true);
        }

        @Specialization
        public RubyArray private_methods(RubyBasicObject self2, boolean includeInherited) {
            PrivateMethodsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(self2.getContext().getCoreLibrary().getArrayClass());
            Map<String, InternalMethod> methods2 = includeInherited ? ModuleOperations.getAllMethods(self2.getMetaClass()) : self2.getMetaClass().getMethods();
            for (InternalMethod method : methods2.values()) {
                if (method.getVisibility() != Visibility.PRIVATE) continue;
                array.slowPush(self2.getContext().newSymbol(method.getName()));
            }
            return array;
        }
    }

    @CoreMethod(names={"print"}, isModuleFunction=true, argumentsAsArray=true)
    public static abstract class PrintNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toS;

        public PrintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toS = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public PrintNode(PrintNode prev) {
            super(prev);
            this.toS = prev.toS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public RubyNilClass print(VirtualFrame frame, Object[] args2) {
            byte[][] bytes2 = new byte[args2.length][];
            for (int i2 = 0; i2 < args2.length; ++i2) {
                bytes2[i2] = ((RubyString)this.toS.call(frame, args2[i2], "to_s", null, new Object[0])).getBytes().bytes();
            }
            RubyThread runningThread = this.getContext().getThreadManager().leaveGlobalLock();
            try {
                for (byte[] string2 : bytes2) {
                    this.write(string2);
                }
            }
            finally {
                this.getContext().getThreadManager().enterGlobalLock(runningThread);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @CompilerDirectives.TruffleBoundary
        private void write(byte[] bytes2) {
            try {
                this.getContext().getRuntime().getInstanceConfig().getOutput().write(bytes2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CoreMethod(names={"object_id"})
    public static abstract class ObjectIDNode
    extends BasicObjectNodes.IDNode {
        public ObjectIDNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ObjectIDNode(ObjectIDNode prev) {
            super(prev);
        }
    }

    @CoreMethod(names={"nil?"}, needsSelf=false)
    public static abstract class NilNode
    extends CoreMethodNode {
        public NilNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NilNode(NilNode prev) {
            super(prev);
        }

        @Specialization
        public boolean nil() {
            return false;
        }
    }

    @CoreMethod(names={"methods"}, optional=1)
    public static abstract class MethodsNode
    extends CoreMethodNode {
        public MethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MethodsNode(MethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray methods(RubyBasicObject self2, UndefinedPlaceholder unused2) {
            return this.methods(self2, true);
        }

        @Specialization
        public RubyArray methods(RubyBasicObject self2, boolean includeInherited) {
            MethodsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(self2.getContext().getCoreLibrary().getArrayClass());
            Map<String, InternalMethod> methods2 = includeInherited ? ModuleOperations.getAllMethods(self2.getMetaClass()) : self2.getMetaClass().getMethods();
            for (InternalMethod method : methods2.values()) {
                if (method.getVisibility() != Visibility.PUBLIC && method.getVisibility() != Visibility.PROTECTED) continue;
                array.slowPush(self2.getContext().newSymbol(method.getName()));
            }
            return array;
        }
    }

    @CoreMethod(names={"method"}, required=1)
    public static abstract class MethodNode
    extends CoreMethodNode {
        public MethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MethodNode(MethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyMethod method(Object object, RubySymbol name2) {
            MethodNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(object), name2.toString());
            if (method == null) {
                throw new UnsupportedOperationException();
            }
            return new RubyMethod(this.getContext().getCoreLibrary().getMethodClass(), object, method);
        }
    }

    @CoreMethod(names={"loop"}, isModuleFunction=true)
    public static abstract class LoopNode
    extends CoreMethodNode {
        @Node.Child
        private WhileNode whileNode;

        public LoopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.whileNode = WhileNode.createWhile(context, sourceSection, BooleanCastNodeFactory.create(context, sourceSection, new BooleanLiteralNode(context, sourceSection, true)), new YieldNode(context, this.getSourceSection(), new RubyNode[0], false));
        }

        public LoopNode(LoopNode prev) {
            super(prev);
            this.whileNode = prev.whileNode;
        }

        @Specialization
        public Object loop(VirtualFrame frame) {
            return this.whileNode.execute(frame);
        }
    }

    @CoreMethod(names={"local_variables"}, needsSelf=false)
    public static abstract class LocalVariablesNode
    extends CoreMethodNode {
        public LocalVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LocalVariablesNode(LocalVariablesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray localVariables() {
            LocalVariablesNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            for (Object name2 : Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, false).getFrameDescriptor().getIdentifiers()) {
                if (!(name2 instanceof String)) continue;
                array.slowPush(this.getContext().newSymbol((String)name2));
            }
            return array;
        }
    }

    @CoreMethod(names={"load"}, isModuleFunction=true, required=1)
    public static abstract class LoadNode
    extends CoreMethodNode {
        public LoadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LoadNode(LoadNode prev) {
            super(prev);
        }

        @Specialization
        public boolean load(RubyString file2) {
            LoadNode.notDesignedForCompilation();
            this.getContext().loadFile(file2.toString(), this);
            return true;
        }
    }

    @CoreMethod(names={"lambda"}, isModuleFunction=true, needsBlock=true)
    public static abstract class LambdaNode
    extends CoreMethodNode {
        public LambdaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LambdaNode(LambdaNode prev) {
            super(prev);
        }

        @Specialization
        public RubyProc proc(RubyProc block) {
            LambdaNode.notDesignedForCompilation();
            return new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.LAMBDA, block.getSharedMethodInfo(), block.getCallTargetForMethods(), block.getCallTargetForMethods(), block.getCallTargetForMethods(), block.getDeclarationFrame(), block.getDeclaringModule(), block.getMethod(), block.getSelfCapturedInScope(), block.getBlockCapturedInScope());
        }
    }

    @CoreMethod(names={"is_a?", "kind_of?"}, required=1)
    public static abstract class IsANode
    extends CoreMethodNode {
        public IsANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IsANode(IsANode prev) {
            super(prev);
        }

        public abstract boolean executeIsA(VirtualFrame var1, Object var2, RubyClass var3);

        @Specialization
        public boolean isA(RubyBasicObject self2, RubyNilClass nil) {
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isA(Object self2, RubyClass rubyClass) {
            IsANode.notDesignedForCompilation();
            return ModuleOperations.assignableTo(this.getContext().getCoreLibrary().getMetaClass(self2), rubyClass);
        }
    }

    @CoreMethod(names={"Integer"}, isModuleFunction=true, required=1)
    public static abstract class IntegerNode
    extends CoreMethodNode {
        @Node.Child
        private DoesRespondDispatchHeadNode toIntRespondTo;
        @Node.Child
        private CallDispatchHeadNode toInt;

        public IntegerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toIntRespondTo = new DoesRespondDispatchHeadNode(context, false, false, MissingBehavior.CALL_METHOD_MISSING, null);
            this.toInt = new CallDispatchHeadNode(context, false, false, MissingBehavior.CALL_METHOD_MISSING, null);
        }

        public IntegerNode(IntegerNode prev) {
            super(prev);
            this.toIntRespondTo = prev.toIntRespondTo;
            this.toInt = prev.toInt;
        }

        @Specialization
        public int integer(int value2) {
            return value2;
        }

        @Specialization
        public long integer(long value2) {
            return value2;
        }

        @Specialization
        public RubyBignum integer(RubyBignum value2) {
            return value2;
        }

        @Specialization
        public int integer(double value2) {
            return (int)value2;
        }

        @Specialization
        public Object integer(RubyString value2) {
            IntegerNode.notDesignedForCompilation();
            if (value2.toString().length() == 0) {
                return 0;
            }
            try {
                return Integer.parseInt(value2.toString());
            }
            catch (NumberFormatException e) {
                return this.bignum(new BigInteger(value2.toString()));
            }
        }

        @Specialization
        public Object integer(VirtualFrame frame, Object value2) {
            if (this.toIntRespondTo.doesRespondTo(frame, "to_int", value2)) {
                return this.toInt.call(frame, value2, "to_int", null, new Object[0]);
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(value2, this.getContext().getCoreLibrary().getIntegerClass(), (Node)this));
        }
    }

    @CoreMethod(names={"instance_variables"})
    public static abstract class InstanceVariablesNode
    extends CoreMethodNode {
        public InstanceVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceVariablesNode(InstanceVariablesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray instanceVariables(RubyBasicObject self2) {
            InstanceVariablesNode.notDesignedForCompilation();
            Object[] instanceVariableNames = self2.getOperations().getFieldNames(self2);
            Arrays.sort(instanceVariableNames);
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            for (Object name2 : instanceVariableNames) {
                if (!(name2 instanceof String)) continue;
                array.slowPush(this.getContext().getSymbolTable().getSymbol((String)name2));
            }
            return array;
        }
    }

    @CoreMethod(names={"instance_variable_set"}, required=2)
    public static abstract class InstanceVariableSetNode
    extends CoreMethodNode {
        public InstanceVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceVariableSetNode(InstanceVariableSetNode prev) {
            super(prev);
        }

        @Specialization
        public Object isInstanceVariableSet(RubyBasicObject object, RubyString name2, Object value2) {
            InstanceVariableSetNode.notDesignedForCompilation();
            InstanceVariableSetNode.notDesignedForCompilation();
            object.getOperations().setInstanceVariable(object, RubyContext.checkInstanceVariableName(this.getContext(), name2.toString(), this), value2);
            return value2;
        }

        @Specialization
        public Object isInstanceVariableSet(RubyBasicObject object, RubySymbol name2, Object value2) {
            InstanceVariableSetNode.notDesignedForCompilation();
            InstanceVariableSetNode.notDesignedForCompilation();
            object.getOperations().setInstanceVariable(object, RubyContext.checkInstanceVariableName(this.getContext(), name2.toString(), this), value2);
            return value2;
        }
    }

    @CoreMethod(names={"instance_variable_get"}, required=1)
    public static abstract class InstanceVariableGetNode
    extends CoreMethodNode {
        public InstanceVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceVariableGetNode(InstanceVariableGetNode prev) {
            super(prev);
        }

        @Specialization
        public Object isInstanceVariableGet(RubyBasicObject object, RubyString name2) {
            InstanceVariableGetNode.notDesignedForCompilation();
            return object.getInstanceVariable(RubyContext.checkInstanceVariableName(this.getContext(), name2.toString(), this));
        }

        @Specialization
        public Object isInstanceVariableGet(RubyBasicObject object, RubySymbol name2) {
            InstanceVariableGetNode.notDesignedForCompilation();
            return object.getInstanceVariable(RubyContext.checkInstanceVariableName(this.getContext(), name2.toString(), this));
        }
    }

    @CoreMethod(names={"instance_variable_defined?"}, required=1)
    public static abstract class InstanceVariableDefinedNode
    extends CoreMethodNode {
        public InstanceVariableDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceVariableDefinedNode(InstanceVariableDefinedNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isInstanceVariableDefined(RubyBasicObject object, RubyString name2) {
            InstanceVariableDefinedNode.notDesignedForCompilation();
            return object.isFieldDefined(RubyContext.checkInstanceVariableName(this.getContext(), name2.toString(), this));
        }

        @Specialization
        public boolean isInstanceVariableDefined(RubyBasicObject object, RubySymbol name2) {
            InstanceVariableDefinedNode.notDesignedForCompilation();
            return object.isFieldDefined(RubyContext.checkInstanceVariableName(this.getContext(), name2.toString(), this));
        }
    }

    @CoreMethod(names={"instance_of?"}, required=1)
    public static abstract class InstanceOfNode
    extends CoreMethodNode {
        public InstanceOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceOfNode(InstanceOfNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean instanceOf(Object self2, RubyClass rubyClass) {
            return this.getContext().getCoreLibrary().getLogicalClass(self2) == rubyClass;
        }
    }

    @CoreMethod(names={"initialize_dup", "initialize_clone"}, visibility=Visibility.PRIVATE, required=1)
    public static abstract class InitializeDupCloneNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode initializeCopyNode;

        public InitializeDupCloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initializeCopyNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        public InitializeDupCloneNode(InitializeDupCloneNode prev) {
            super(prev);
            this.initializeCopyNode = prev.initializeCopyNode;
        }

        @Specialization
        public Object initializeDup(VirtualFrame frame, RubyBasicObject self2, RubyBasicObject from) {
            return this.initializeCopyNode.call(frame, self2, "initialize_copy", null, from);
        }
    }

    @CoreMethod(names={"initialize_copy"}, visibility=Visibility.PRIVATE, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization
        public Object initializeCopy(RubyBasicObject self2, RubyBasicObject from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self2.getLogicalClass() != from.getLogicalClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("initialize_copy should take same class object", this));
            }
            return self2;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public HashNode(HashNode prev) {
            super(prev);
        }

        @Specialization
        public int hash(int value2) {
            return value2;
        }

        @Specialization
        public int hash(long value2) {
            return Long.valueOf(value2).hashCode();
        }

        @Specialization
        public int hash(double value2) {
            return Double.valueOf(value2).hashCode();
        }

        @Specialization
        public int hash(boolean value2) {
            return Boolean.valueOf(value2).hashCode();
        }

        @Specialization
        public int hash(RubyBasicObject self2) {
            return self2.hashCode();
        }
    }

    @CoreMethod(names={"gets"}, isModuleFunction=true)
    public static abstract class GetsNode
    extends CoreMethodNode {
        public GetsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetsNode(GetsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString gets(VirtualFrame frame) {
            String line;
            GetsNode.notDesignedForCompilation();
            RubyContext context = this.getContext();
            Frame caller = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
            RubyThread runningThread = this.getContext().getThreadManager().leaveGlobalLock();
            try {
                line = GetsNode.gets(context);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.getContext().getThreadManager().enterGlobalLock(runningThread);
            }
            RubyString rubyLine = context.makeString(line);
            FrameSlot slot = caller.getFrameDescriptor().findFrameSlot((Object)"$_");
            if (slot != null) {
                caller.setObject(slot, WrapInThreadLocalNode.wrap(this.getContext(), rubyLine));
            }
            return rubyLine;
        }

        @CompilerDirectives.TruffleBoundary
        private static String gets(RubyContext context) throws IOException {
            int c;
            StringBuilder builder = new StringBuilder();
            while ((c = context.getRuntime().getInstanceConfig().getInput().read()) != -1 && c != 13 && c != 10) {
                builder.append((char)c);
            }
            return builder.toString();
        }
    }

    @CoreMethod(names={"frozen?"})
    public static abstract class FrozenNode
    extends CoreMethodNode {
        public FrozenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FrozenNode(FrozenNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isFrozen(RubyBasicObject self2) {
            FrozenNode.notDesignedForCompilation();
            return self2.isFrozen();
        }
    }

    @CoreMethod(names={"freeze"})
    public static abstract class FreezeNode
    extends CoreMethodNode {
        public FreezeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FreezeNode(FreezeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject freeze(RubyBasicObject self2) {
            FreezeNode.notDesignedForCompilation();
            self2.freeze();
            return self2;
        }
    }

    @CoreMethod(names={"fork"}, isModuleFunction=true, argumentsAsArray=true)
    public static abstract class ForkNode
    extends CoreMethodNode {
        public ForkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ForkNode(ForkNode prev) {
            super(prev);
        }

        @Specialization
        public Object fork(Object[] args2) {
            ForkNode.notDesignedForCompilation();
            this.getContext().getWarnings().warn("Kernel#fork not implemented - defined to satisfy some metaprogramming in RubySpec");
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"extend"}, argumentsAsArray=true, required=1)
    public static abstract class ExtendNode
    extends CoreMethodNode {
        public ExtendNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExtendNode(ExtendNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject extend(RubyBasicObject self2, Object[] args2) {
            ExtendNode.notDesignedForCompilation();
            for (int n = 0; n < args2.length; ++n) {
                self2.extend((RubyModule)args2[n], this);
            }
            return self2;
        }
    }

    @CoreMethod(names={"exit!"}, isModuleFunction=true, optional=1)
    public static abstract class ExitBangNode
    extends CoreMethodNode {
        public ExitBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExitBangNode(ExitBangNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass exit(UndefinedPlaceholder exitCode) {
            return this.exit(1);
        }

        @Specialization
        public RubyNilClass exit(int exitCode) {
            CompilerDirectives.transferToInterpreter();
            System.exit(exitCode);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"exit"}, isModuleFunction=true, optional=1, lowerFixnumParameters={0})
    public static abstract class ExitNode
    extends CoreMethodNode {
        public ExitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExitNode(ExitNode prev) {
            super(prev);
        }

        @Specialization
        public Object exit(UndefinedPlaceholder exitCode) {
            ExitNode.notDesignedForCompilation();
            this.getContext().shutdown();
            System.exit(0);
            return null;
        }

        @Specialization
        public Object exit(int exitCode) {
            ExitNode.notDesignedForCompilation();
            this.getContext().shutdown();
            System.exit(exitCode);
            return null;
        }
    }

    @CoreMethod(names={"exec"}, isModuleFunction=true, required=1, argumentsAsArray=true)
    public static abstract class ExecNode
    extends CoreMethodNode {
        public ExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExecNode(ExecNode prev) {
            super(prev);
        }

        @Specialization
        public Object require(Object[] args2) {
            ExecNode.notDesignedForCompilation();
            String[] commandLine = new String[args2.length];
            for (int n = 0; n < args2.length; ++n) {
                commandLine[n] = args2[n].toString();
            }
            ExecNode.exec(this.getContext(), commandLine);
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private static void exec(RubyContext context, String[] commandLine) {
            int exitCode;
            Process process;
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            builder.inheritIO();
            RubyHash env = context.getCoreLibrary().getENV();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(env)) {
                builder.environment().put(keyValue.getKey().toString(), keyValue.getValue().toString());
            }
            try {
                process = builder.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            while (true) {
                try {
                    exitCode = process.waitFor();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            System.exit(exitCode);
        }
    }

    @CoreMethod(names={"eval"}, isModuleFunction=true, required=1, optional=3)
    public static abstract class EvalNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toStr;
        @Node.Child
        private BindingNode bindingNode;

        public EvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toStr = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public EvalNode(EvalNode prev) {
            super(prev);
            this.toStr = prev.toStr;
        }

        protected RubyBinding getCallerBinding(VirtualFrame frame) {
            if (this.bindingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bindingNode = (BindingNode)this.insert(KernelNodesFactory.BindingNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            return this.bindingNode.executeRubyBinding(frame);
        }

        @Specialization
        public Object eval(VirtualFrame frame, RubyString source2, UndefinedPlaceholder binding2, UndefinedPlaceholder filename2, UndefinedPlaceholder lineNumber) {
            EvalNode.notDesignedForCompilation();
            return this.eval(source2, this.getCallerBinding(frame), filename2, lineNumber);
        }

        @Specialization
        public Object eval(RubyString source2, RubyBinding binding2, UndefinedPlaceholder filename2, UndefinedPlaceholder lineNumber) {
            EvalNode.notDesignedForCompilation();
            return this.getContext().eval(source2.getBytes(), binding2, (RubyNode)this);
        }

        @Specialization
        public Object eval(RubyString source2, RubyBinding binding2, RubyString filename2, UndefinedPlaceholder lineNumber) {
            EvalNode.notDesignedForCompilation();
            return this.getContext().eval(source2.getBytes(), binding2, (RubyNode)this);
        }

        @Specialization
        public Object eval(RubyString source2, RubyBinding binding2, RubyString filename2, int lineNumber) {
            EvalNode.notDesignedForCompilation();
            return this.getContext().eval(source2.getBytes(), binding2, (RubyNode)this);
        }

        @Specialization(guards={"!isRubyString(arguments[0])"})
        public Object eval(VirtualFrame frame, RubyBasicObject object, UndefinedPlaceholder binding2, UndefinedPlaceholder filename2, UndefinedPlaceholder lineNumber) {
            EvalNode.notDesignedForCompilation();
            return this.eval(frame, object, this.getCallerBinding(frame), filename2, lineNumber);
        }

        @Specialization(guards={"!isRubyString(arguments[0])"})
        public Object eval(VirtualFrame frame, RubyBasicObject object, RubyBinding binding2, UndefinedPlaceholder filename2, UndefinedPlaceholder lineNumber) {
            Object coerced;
            EvalNode.notDesignedForCompilation();
            try {
                coerced = this.toStr.call(frame, object, "to_str", null, new Object[0]);
            }
            catch (RaiseException e) {
                if (e.getRubyException().getLogicalClass() == this.getContext().getCoreLibrary().getNoMethodErrorClass()) {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeError(String.format("no implicit conversion of %s into String", object.getLogicalClass().getName()), this));
                }
                throw e;
            }
            if (coerced instanceof RubyString) {
                return this.getContext().eval(((RubyString)coerced).getBytes(), binding2, (RubyNode)this);
            }
            throw new RaiseException(this.getContext().getCoreLibrary().typeError(String.format("can't convert %s to String (%s#to_str gives %s)", object.getLogicalClass().getName(), object.getLogicalClass().getName(), this.getContext().getCoreLibrary().getLogicalClass(coerced).getName()), this));
        }

        @Specialization(guards={"!isRubyBinding(arguments[1])"})
        public Object eval(RubyBasicObject source2, RubyBasicObject badBinding, UndefinedPlaceholder filename2, UndefinedPlaceholder lineNumber) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeError(String.format("wrong argument type %s (expected binding)", badBinding.getLogicalClass().getName()), this));
        }
    }

    @CoreMethod(names={"eql?"}, required=1)
    public static abstract class EqlNode
    extends BasicObjectNodes.ReferenceEqualNode {
        public EqlNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqlNode(EqlNode prev) {
            super(prev);
        }
    }

    @CoreMethod(names={"dup"})
    public static abstract class DupNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode initializeDupNode;

        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initializeDupNode = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.CALL_METHOD_MISSING);
        }

        public DupNode(DupNode prev) {
            super(prev);
            this.initializeDupNode = prev.initializeDupNode;
        }

        @Specialization
        public Object dup(VirtualFrame frame, RubyBasicObject self2) {
            RubyBasicObject newObject2 = self2.getLogicalClass().allocate(this);
            newObject2.getOperations().setInstanceVariables(newObject2, self2.getOperations().getInstanceVariables(self2));
            this.initializeDupNode.call(frame, newObject2, "initialize_dup", null, self2);
            return newObject2;
        }
    }

    @CoreMethod(names={"clone"})
    public static abstract class CloneNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode initializeCloneNode;

        public CloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initializeCloneNode = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.CALL_METHOD_MISSING);
        }

        public CloneNode(CloneNode prev) {
            super(prev);
            this.initializeCloneNode = prev.initializeCloneNode;
        }

        @Specialization
        public Object clone(VirtualFrame frame, RubyBasicObject self2) {
            CloneNode.notDesignedForCompilation();
            RubyBasicObject newObject2 = self2.getLogicalClass().allocate(this);
            if (self2.getMetaClass().isSingleton()) {
                newObject2.getSingletonClass(this).initCopy(self2.getMetaClass());
            }
            newObject2.getOperations().setInstanceVariables(newObject2, self2.getOperations().getInstanceVariables(self2));
            this.initializeCloneNode.call(frame, newObject2, "initialize_clone", null, self2);
            return newObject2;
        }
    }

    @CoreMethod(names={"class"})
    public static abstract class ClassNode
    extends CoreMethodNode {
        public ClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClassNode(ClassNode prev) {
            super(prev);
        }

        public abstract RubyClass executeGetClass(VirtualFrame var1, Object var2);

        @Specialization
        public RubyClass getClass(boolean value2) {
            ClassNode.notDesignedForCompilation();
            if (value2) {
                return this.getContext().getCoreLibrary().getTrueClass();
            }
            return this.getContext().getCoreLibrary().getFalseClass();
        }

        @Specialization
        public RubyClass getClass(int value2) {
            return this.getContext().getCoreLibrary().getFixnumClass();
        }

        @Specialization
        public RubyClass getClass(long value2) {
            return this.getContext().getCoreLibrary().getFixnumClass();
        }

        @Specialization
        public RubyClass getClass(double value2) {
            return this.getContext().getCoreLibrary().getFloatClass();
        }

        @Specialization
        public RubyClass getClass(RubyBasicObject self2) {
            return self2.getLogicalClass();
        }
    }

    @CoreMethod(names={"catch"}, isModuleFunction=true, needsBlock=true, required=1)
    public static abstract class CatchNode
    extends YieldingCoreMethodNode {
        public CatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CatchNode(CatchNode prev) {
            super(prev);
        }

        @Specialization
        public Object doCatch(VirtualFrame frame, Object tag2, RubyProc block) {
            CatchNode.notDesignedForCompilation();
            try {
                this.getContext().getThrowTags().add(tag2);
                Object object = this.yield(frame, block, new Object[0]);
                return object;
            }
            catch (ThrowException e) {
                if (e.getTag().equals(tag2)) {
                    CatchNode.notDesignedForCompilation();
                    this.getContext().getCoreLibrary().getGlobalVariablesObject().getOperations().setInstanceVariable(this.getContext().getCoreLibrary().getGlobalVariablesObject(), "$!", this.getContext().getCoreLibrary().getNilObject());
                    Object object = e.getValue();
                    return object;
                }
                throw e;
            }
            finally {
                this.getContext().getThrowTags().remove();
            }
        }
    }

    @CoreMethod(names={"caller"}, isModuleFunction=true, optional=1)
    public static abstract class CallerNode
    extends CoreMethodNode {
        public CallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CallerNode(CallerNode prev) {
            super(prev);
        }

        @Specialization
        public Object caller(UndefinedPlaceholder omit) {
            return this.caller(1);
        }

        @Specialization
        public Object caller(int omit) {
            CallerNode.notDesignedForCompilation();
            Backtrace backtrace2 = RubyCallStack.getBacktrace(this);
            List<Activation> activations = backtrace2.getActivations();
            int size2 = activations.size() - ++omit;
            if (size2 < 0) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            Object[] callers = new Object[size2];
            for (int n = 0; n < size2; ++n) {
                callers[n] = this.getContext().makeString(MRIBacktraceFormatter.formatCallerLine(activations, n + omit));
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), callers, callers.length);
        }
    }

    @CoreMethod(names={"block_given?"}, isModuleFunction=true)
    public static abstract class BlockGivenNode
    extends CoreMethodNode {
        public BlockGivenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BlockGivenNode(BlockGivenNode prev) {
            super(prev);
        }

        @Specialization
        public boolean blockGiven() {
            return RubyArguments.getBlock(Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, false).getArguments()) != null;
        }
    }

    @CoreMethod(names={"binding"}, isModuleFunction=true)
    public static abstract class BindingNode
    extends CoreMethodNode {
        public BindingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public abstract RubyBinding executeRubyBinding(VirtualFrame var1);

        @Specialization
        public RubyBinding binding() {
            MaterializedFrame callerFrame = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, false).materialize();
            return new RubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(callerFrame.getArguments()), callerFrame);
        }
    }

    @CoreMethod(names={"at_exit"}, isModuleFunction=true, needsBlock=true)
    public static abstract class AtExitNode
    extends CoreMethodNode {
        public AtExitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AtExitNode(AtExitNode prev) {
            super(prev);
        }

        @Specialization
        public Object atExit(RubyProc block) {
            AtExitNode.notDesignedForCompilation();
            this.getContext().getAtExitManager().add(block);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"Array"}, isModuleFunction=true, argumentsAsArray=true)
    public static abstract class ArrayNode
    extends CoreMethodNode {
        @Node.Child
        ArrayBuilderNode arrayBuilderNode;

        public ArrayNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilderNode = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public ArrayNode(ArrayNode prev) {
            super(prev);
            this.arrayBuilderNode = prev.arrayBuilderNode;
        }

        @Specialization(guards={"isOneArrayElement"})
        public RubyArray arrayOneArrayElement(Object[] args2) {
            return (RubyArray)args2[0];
        }

        @Specialization(guards={"!isOneArrayElement"})
        public RubyArray array(Object[] args2) {
            int length2 = args2.length;
            Object store = this.arrayBuilderNode.start(length2);
            for (int n = 0; n < length2; ++n) {
                store = this.arrayBuilderNode.append(store, n, args2[n]);
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilderNode.finish(store, length2), length2);
        }

        protected boolean isOneArrayElement(Object[] args2) {
            return args2.length == 1 && args2[0] instanceof RubyArray;
        }
    }

    @CoreMethod(names={"abort"}, isModuleFunction=true)
    public static abstract class AbortNode
    extends CoreMethodNode {
        public AbortNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AbortNode(AbortNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass abort() {
            CompilerDirectives.transferToInterpreter();
            System.exit(1);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode equalNode;
        @Node.Child
        private BooleanCastNode booleanCast;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.booleanCast = BooleanCastNodeFactory.create(context, sourceSection, null);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
            this.equalNode = prev.equalNode;
            this.booleanCast = prev.booleanCast;
        }

        @Specialization
        public Object compare(VirtualFrame frame, RubyBasicObject self2, RubyBasicObject other) {
            CompareNode.notDesignedForCompilation();
            if (self2 == other || this.booleanCast.executeBoolean(frame, this.equalNode.call(frame, self2, "==", null, other))) {
                return 0;
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"!~"}, required=1)
    public static abstract class NotMatchNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode matchNode;

        public NotMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.matchNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public NotMatchNode(NotMatchNode prev) {
            super(prev);
            this.matchNode = prev.matchNode;
        }

        @Specialization
        public boolean notMatch(VirtualFrame frame, Object self2, Object other) {
            return !this.matchNode.callBoolean(frame, self2, "=~", null, other);
        }
    }

    @CoreMethod(names={"=~"}, required=1, needsSelf=false)
    public static abstract class MatchNode
    extends CoreMethodNode {
        public MatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MatchNode(MatchNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass equal(Object other) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class SameOrEqualNode
    extends CoreMethodNode {
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode referenceEqualNode;
        @Node.Child
        private CallDispatchHeadNode equalNode;

        public SameOrEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SameOrEqualNode(SameOrEqualNode prev) {
            super(prev);
        }

        protected boolean areSame(VirtualFrame frame, Object left2, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.referenceEqualNode = (BasicObjectNodes.ReferenceEqualNode)this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left2, right);
        }

        protected boolean areEqual(VirtualFrame frame, Object left2, Object right) {
            if (this.equalNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.equalNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), false, false, null));
            }
            return this.equalNode.callBoolean(frame, left2, "==", null, right);
        }

        public abstract boolean executeSameOrEqual(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public boolean sameOrEqual(VirtualFrame frame, Object a, Object b2) {
            if (this.areSame(frame, a, b2)) {
                return true;
            }
            return this.areEqual(frame, a, b2);
        }
    }

    @CoreMethod(names={"`"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class BacktickNode
    extends CoreMethodNode {
        public BacktickNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BacktickNode(BacktickNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString backtick(RubyString command) {
            Process process;
            BacktickNode.notDesignedForCompilation();
            RubyContext context = this.getContext();
            RubyHash env = context.getCoreLibrary().getENV();
            ArrayList<String> envp = new ArrayList<String>();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(env)) {
                envp.add(keyValue.getKey().toString() + "=" + keyValue.getValue().toString());
            }
            try {
                process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command.toString()}, envp.toArray(new String[envp.size()]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            InputStream stdout = process.getInputStream();
            InputStreamReader reader = new InputStreamReader(stdout, StandardCharsets.UTF_8);
            StringBuilder resultBuilder = new StringBuilder();
            try {
                int c;
                while ((c = reader.read()) != -1) {
                    resultBuilder.append((char)c);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return context.makeString(resultBuilder.toString());
        }
    }
}

