/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.math.BigInteger;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBignum;

public class GeneralDivModNode
extends RubyNode {
    @Node.Child
    private FixnumOrBignumNode fixnumOrBignumQuotient;
    @Node.Child
    private FixnumOrBignumNode fixnumOrBignumRemainder;
    private final BranchProfile bZeroProfile = BranchProfile.create();
    private final BranchProfile bMinusOneProfile = BranchProfile.create();
    private final BranchProfile nanProfile = BranchProfile.create();
    private final BranchProfile bigIntegerFixnumProfile = BranchProfile.create();
    private final BranchProfile useFixnumPairProfile = BranchProfile.create();
    private final BranchProfile useObjectPairProfile = BranchProfile.create();

    public GeneralDivModNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.fixnumOrBignumQuotient = new FixnumOrBignumNode(context, sourceSection);
        this.fixnumOrBignumRemainder = new FixnumOrBignumNode(context, sourceSection);
    }

    public RubyArray execute(int a, int b2) {
        return this.divMod(a, b2);
    }

    public RubyArray execute(int a, long b2) {
        return this.divMod(a, b2);
    }

    public RubyArray execute(int a, BigInteger b2) {
        return this.divMod(BigInteger.valueOf(a), b2);
    }

    public RubyArray execute(int a, double b2) {
        return this.divMod((double)a, b2);
    }

    public RubyArray execute(long a, int b2) {
        return this.divMod(a, b2);
    }

    public RubyArray execute(long a, long b2) {
        return this.divMod(a, b2);
    }

    public RubyArray execute(long a, RubyBignum b2) {
        return this.divMod(BigInteger.valueOf(a), b2.bigIntegerValue());
    }

    public RubyArray execute(long a, double b2) {
        return this.divMod((double)a, b2);
    }

    public RubyArray execute(RubyBignum a, int b2) {
        return this.divMod(a.bigIntegerValue(), BigInteger.valueOf(b2));
    }

    public RubyArray execute(RubyBignum a, long b2) {
        return this.divMod(a.bigIntegerValue(), BigInteger.valueOf(b2));
    }

    public RubyArray execute(RubyBignum a, RubyBignum b2) {
        return this.divMod(a.bigIntegerValue(), b2.bigIntegerValue());
    }

    @CompilerDirectives.TruffleBoundary
    private RubyArray divMod(long a, long b2) {
        long mod;
        Number integerDiv;
        if (b2 == 0L) {
            this.bZeroProfile.enter();
            throw new ArithmeticException("divide by zero");
        }
        if (b2 == -1L) {
            this.bMinusOneProfile.enter();
            integerDiv = a == Long.MIN_VALUE ? BigInteger.valueOf(a).negate() : Long.valueOf(-a);
            mod = 0L;
        } else {
            long div = a / b2;
            mod = a - b2 * div;
            if (mod < 0L && b2 > 0L || mod > 0L && b2 < 0L) {
                --div;
                mod += b2;
            }
            integerDiv = div;
        }
        if (integerDiv instanceof Long && (Long)integerDiv >= Integer.MIN_VALUE && (Long)integerDiv <= Integer.MAX_VALUE && mod >= Integer.MIN_VALUE && mod <= Integer.MAX_VALUE) {
            this.useFixnumPairProfile.enter();
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new int[]{(int)((Long)integerDiv).longValue(), (int)mod}, 2);
        }
        if (integerDiv instanceof Long) {
            this.useObjectPairProfile.enter();
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{integerDiv, mod}, 2);
        }
        this.useObjectPairProfile.enter();
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{this.fixnumOrBignumQuotient.fixnumOrBignum(this.create((BigInteger)integerDiv)), mod}, 2);
    }

    @CompilerDirectives.TruffleBoundary
    private RubyArray divMod(double a, double b2) {
        if (b2 == 0.0) {
            this.bZeroProfile.enter();
            throw new ArithmeticException("divide by zero");
        }
        double mod = Math.IEEEremainder(a, b2);
        if (Double.isNaN(mod)) {
            this.nanProfile.enter();
            throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("NaN", this));
        }
        double div = Math.floor(a / b2);
        if (b2 * mod < 0.0) {
            mod += b2;
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{div, mod}, 2);
    }

    @CompilerDirectives.TruffleBoundary
    private RubyArray divMod(BigInteger a, BigInteger b2) {
        if (b2.signum() == 0) {
            this.bZeroProfile.enter();
            throw new ArithmeticException("divide by zero");
        }
        BigInteger[] bigIntegerResults = a.divideAndRemainder(b2);
        if (a.signum() * b2.signum() == -1 && bigIntegerResults[1].signum() != 0) {
            this.bigIntegerFixnumProfile.enter();
            bigIntegerResults[0] = bigIntegerResults[0].subtract(BigInteger.ONE);
            bigIntegerResults[1] = b2.add(bigIntegerResults[1]);
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{this.fixnumOrBignumQuotient.fixnumOrBignum(this.create(bigIntegerResults[0])), this.fixnumOrBignumRemainder.fixnumOrBignum(this.create(bigIntegerResults[1]))}, 2);
    }

    public RubyBignum create(BigInteger value2) {
        return new RubyBignum(this.getContext().getCoreLibrary().getBignumClass(), value2);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }
}

