/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=FixnumNodes.class)
public final class FixnumNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(NegNodeFactory.getInstance(), AddNodeFactory.getInstance(), SubNodeFactory.getInstance(), MulNodeFactory.getInstance(), PowNodeFactory.getInstance(), DivNodeFactory.getInstance(), ModNodeFactory.getInstance(), DivModNodeFactory.getInstance(), LessNodeFactory.getInstance(), LessEqualNodeFactory.getInstance(), EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), GreaterEqualNodeFactory.getInstance(), GreaterNodeFactory.getInstance(), ComplementNodeFactory.getInstance(), BitAndNodeFactory.getInstance(), BitOrNodeFactory.getInstance(), BitXOrNodeFactory.getInstance(), LeftShiftNodeFactory.getInstance(), RightShiftNodeFactory.getInstance(), AbsNodeFactory.getInstance(), BitLengthNodeFactory.getInstance(), FloorNodeFactory.getInstance(), InspectNodeFactory.getInstance(), SizeNodeFactory.getInstance(), ToFNodeFactory.getInstance(), ToSNodeFactory.getInstance(), ZeroNodeFactory.getInstance());
    }

    @GeneratedBy(value=FixnumNodes.ZeroNode.class)
    public static final class ZeroNodeFactory
    extends NodeFactoryBase<FixnumNodes.ZeroNode> {
        private static ZeroNodeFactory zeroNodeFactoryInstance;

        private ZeroNodeFactory() {
            super(FixnumNodes.ZeroNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.ZeroNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ZeroNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.ZeroNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ZeroUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.ZeroNode> getInstance() {
            if (zeroNodeFactoryInstance == null) {
                zeroNodeFactoryInstance = new ZeroNodeFactory();
            }
            return zeroNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.ZeroNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ZeroPolymorphicNode
        extends ZeroBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ZeroPolymorphicNode(ZeroBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.ZeroNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ZeroLongNode
        extends ZeroBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZeroLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ZeroLongNode(ZeroBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.zero(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.zero(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.ZeroNode create0(FixnumNodes.ZeroNode current2) {
                return new ZeroLongNode((ZeroBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ZeroNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ZeroIntNode
        extends ZeroBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZeroIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ZeroIntNode(ZeroBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.zero(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.zero(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.ZeroNode create0(FixnumNodes.ZeroNode current2) {
                return new ZeroIntNode((ZeroBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ZeroNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ZeroUninitializedNode
        extends ZeroBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZeroUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ZeroUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ZeroUninitializedNode(ZeroBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ZeroBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ZeroBaseNode rootNode = (ZeroBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ZeroBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.ZeroNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ZeroUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.ZeroNode.class)
        private static abstract class ZeroBaseNode
        extends FixnumNodes.ZeroNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ZeroBaseNode next0;

            ZeroBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ZeroBaseNode(ZeroBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ZeroBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ZeroBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ZeroUninitializedNode(this);
                    ((ZeroUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ZeroBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ZeroBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ZeroBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ZeroUninitializedNode(this), (Node)new ZeroPolymorphicNode(this), (DSLNode)((ZeroBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ZeroBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ZeroBaseNode)ZeroIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ZeroBaseNode)ZeroLongNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ZeroBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ZeroBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<FixnumNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(FixnumNodes.ToSNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSPolymorphicNode
        extends ToSBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ToSPolymorphicNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSLongIntNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            ToSLongIntNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.toS(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.toS(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ToSNode create0(FixnumNodes.ToSNode current2) {
                return new ToSLongIntNode((ToSBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSIntNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            ToSIntNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.toS(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.toS(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ToSNode create0(FixnumNodes.ToSNode current2) {
                return new ToSIntNode((ToSBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSLongUndefinedPlaceholderNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSLongUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, UndefinedPlaceholder.class}, 0, 0);

            ToSLongUndefinedPlaceholderNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.toS(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.toS(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ToSNode create0(FixnumNodes.ToSNode current2) {
                return new ToSLongUndefinedPlaceholderNode((ToSBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSIntUndefinedPlaceholderNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            ToSIntUndefinedPlaceholderNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.toS(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.toS(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ToSNode create0(FixnumNodes.ToSNode current2) {
                return new ToSIntUndefinedPlaceholderNode((ToSBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSUninitializedNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSUninitializedNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ToSBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSBaseNode rootNode = (ToSBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends FixnumNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSBaseNode next0;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSBaseNode(ToSBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ToSBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ToSUninitializedNode(this);
                    ((ToSUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToSBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ToSBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSUninitializedNode(this), (Node)new ToSPolymorphicNode(this), (DSLNode)((ToSBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                        return (ToSBaseNode)ToSIntUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                        return (ToSBaseNode)ToSLongUndefinedPlaceholderNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                        return (ToSBaseNode)ToSIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                        return (ToSBaseNode)ToSLongIntNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ToSBaseNode otherCast = (ToSBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.ToFNode.class)
    public static final class ToFNodeFactory
    extends NodeFactoryBase<FixnumNodes.ToFNode> {
        private static ToFNodeFactory toFNodeFactoryInstance;

        private ToFNodeFactory() {
            super(FixnumNodes.ToFNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.ToFNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToFNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.ToFNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToFUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.ToFNode> getInstance() {
            if (toFNodeFactoryInstance == null) {
                toFNodeFactoryInstance = new ToFNodeFactory();
            }
            return toFNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToFPolymorphicNode
        extends ToFBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToFPolymorphicNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToFLongNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ToFLongNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.toF(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.toF(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.ToFNode create0(FixnumNodes.ToFNode current2) {
                return new ToFLongNode((ToFBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToFIntNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ToFIntNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.toF(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.toF(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.ToFNode create0(FixnumNodes.ToFNode current2) {
                return new ToFIntNode((ToFBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToFUninitializedNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToFUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToFUninitializedNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToFBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToFBaseNode rootNode = (ToFBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToFBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.ToFNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToFUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.ToFNode.class)
        private static abstract class ToFBaseNode
        extends FixnumNodes.ToFNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToFBaseNode next0;

            ToFBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToFBaseNode(ToFBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToFBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToFBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToFUninitializedNode(this);
                    ((ToFUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToFBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToFBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ToFBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToFUninitializedNode(this), (Node)new ToFPolymorphicNode(this), (DSLNode)((ToFBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToFBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ToFBaseNode)ToFIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ToFBaseNode)ToFLongNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToFBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToFBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<FixnumNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(FixnumNodes.SizeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SizeDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeDefaultNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            SizeDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.size();
            }

            static FixnumNodes.SizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SizeDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.SizeNode.class)
        private static abstract class SizeBaseNode
        extends FixnumNodes.SizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            SizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.InspectNode.class)
    public static final class InspectNodeFactory
    extends NodeFactoryBase<FixnumNodes.InspectNode> {
        private static InspectNodeFactory inspectNodeFactoryInstance;

        private InspectNodeFactory() {
            super(FixnumNodes.InspectNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.InspectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InspectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.InspectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InspectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.InspectNode> getInstance() {
            if (inspectNodeFactoryInstance == null) {
                inspectNodeFactoryInstance = new InspectNodeFactory();
            }
            return inspectNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InspectPolymorphicNode
        extends InspectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            InspectPolymorphicNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InspectLongNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            InspectLongNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.inspect(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.inspect(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.InspectNode create0(FixnumNodes.InspectNode current2) {
                return new InspectLongNode((InspectBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InspectIntNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            InspectIntNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.inspect(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.inspect(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.InspectNode create0(FixnumNodes.InspectNode current2) {
                return new InspectIntNode((InspectBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InspectUninitializedNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InspectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InspectUninitializedNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InspectBaseNode rootNode = (InspectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InspectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.InspectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InspectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.InspectNode.class)
        private static abstract class InspectBaseNode
        extends FixnumNodes.InspectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InspectBaseNode next0;

            InspectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InspectBaseNode(InspectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                InspectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new InspectUninitializedNode(this);
                    ((InspectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InspectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InspectBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (InspectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InspectUninitializedNode(this), (Node)new InspectPolymorphicNode(this), (DSLNode)((InspectBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InspectBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (InspectBaseNode)InspectIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (InspectBaseNode)InspectLongNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((InspectBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (InspectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.FloorNode.class)
    public static final class FloorNodeFactory
    extends NodeFactoryBase<FixnumNodes.FloorNode> {
        private static FloorNodeFactory floorNodeFactoryInstance;

        private FloorNodeFactory() {
            super(FixnumNodes.FloorNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.FloorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FloorNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.FloorNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FloorUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.FloorNode> getInstance() {
            if (floorNodeFactoryInstance == null) {
                floorNodeFactoryInstance = new FloorNodeFactory();
            }
            return floorNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FloorPolymorphicNode
        extends FloorBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            FloorPolymorphicNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FloorLongNode
        extends FloorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FloorLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            FloorLongNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long"));
                }
                return super.floor(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.floor(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.FloorNode create0(FixnumNodes.FloorNode current2) {
                return new FloorLongNode((FloorBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FloorIntNode
        extends FloorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FloorIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            FloorIntNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int"));
                }
                return super.floor(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.floor(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.FloorNode create0(FixnumNodes.FloorNode current2) {
                return new FloorIntNode((FloorBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FloorUninitializedNode
        extends FloorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FloorUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FloorUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FloorUninitializedNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                FloorBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FloorBaseNode rootNode = (FloorBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((FloorBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.FloorNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FloorUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.FloorNode.class)
        private static abstract class FloorBaseNode
        extends FixnumNodes.FloorNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FloorBaseNode next0;

            FloorBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FloorBaseNode(FloorBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                FloorBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FloorBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new FloorUninitializedNode(this);
                    ((FloorUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (FloorBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = FloorBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (FloorBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FloorUninitializedNode(this), (Node)new FloorPolymorphicNode(this), (DSLNode)((FloorBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FloorBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (FloorBaseNode)FloorIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (FloorBaseNode)FloorLongNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((FloorBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (FloorBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
    public static final class BitLengthNodeFactory
    extends NodeFactoryBase<FixnumNodes.BitLengthNode> {
        private static BitLengthNodeFactory bitLengthNodeFactoryInstance;

        private BitLengthNodeFactory() {
            super(FixnumNodes.BitLengthNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.BitLengthNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitLengthNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.BitLengthNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BitLengthUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.BitLengthNode> getInstance() {
            if (bitLengthNodeFactoryInstance == null) {
                bitLengthNodeFactoryInstance = new BitLengthNodeFactory();
            }
            return bitLengthNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BitLengthPolymorphicNode
        extends BitLengthBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            BitLengthPolymorphicNode(BitLengthBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitLengthLongNode
        extends BitLengthBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitLengthLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            BitLengthLongNode(BitLengthBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.bitLength(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.bitLength(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.BitLengthNode create0(FixnumNodes.BitLengthNode current2) {
                return new BitLengthLongNode((BitLengthBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitLengthIntNode
        extends BitLengthBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitLengthIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            BitLengthIntNode(BitLengthBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.bitLength(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.bitLength(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.BitLengthNode create0(FixnumNodes.BitLengthNode current2) {
                return new BitLengthIntNode((BitLengthBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BitLengthUninitializedNode
        extends BitLengthBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitLengthUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BitLengthUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BitLengthUninitializedNode(BitLengthBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                BitLengthBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BitLengthBaseNode rootNode = (BitLengthBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BitLengthBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.BitLengthNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BitLengthUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitLengthNode.class)
        private static abstract class BitLengthBaseNode
        extends FixnumNodes.BitLengthNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BitLengthBaseNode next0;

            BitLengthBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BitLengthBaseNode(BitLengthBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                BitLengthBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BitLengthBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new BitLengthUninitializedNode(this);
                    ((BitLengthUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BitLengthBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = BitLengthBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (BitLengthBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BitLengthUninitializedNode(this), (Node)new BitLengthPolymorphicNode(this), (DSLNode)((BitLengthBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BitLengthBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (BitLengthBaseNode)BitLengthIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (BitLengthBaseNode)BitLengthLongNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((BitLengthBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (BitLengthBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.AbsNode.class)
    public static final class AbsNodeFactory
    extends NodeFactoryBase<FixnumNodes.AbsNode> {
        private static AbsNodeFactory absNodeFactoryInstance;

        private AbsNodeFactory() {
            super(FixnumNodes.AbsNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.AbsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AbsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.AbsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AbsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.AbsNode> getInstance() {
            if (absNodeFactoryInstance == null) {
                absNodeFactoryInstance = new AbsNodeFactory();
            }
            return absNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.AbsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AbsPolymorphicNode
        extends AbsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            AbsPolymorphicNode(AbsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.AbsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AbsLongNode
        extends AbsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AbsLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            AbsLongNode(AbsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long"));
                }
                return super.abs(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.abs(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.AbsNode create0(FixnumNodes.AbsNode current2) {
                return new AbsLongNode((AbsBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AbsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AbsIntNode
        extends AbsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AbsIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            AbsIntNode(AbsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int"));
                }
                return super.abs(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.abs(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.AbsNode create0(FixnumNodes.AbsNode current2) {
                return new AbsIntNode((AbsBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AbsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AbsUninitializedNode
        extends AbsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AbsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AbsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AbsUninitializedNode(AbsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                AbsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AbsBaseNode rootNode = (AbsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AbsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.AbsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AbsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.AbsNode.class)
        private static abstract class AbsBaseNode
        extends FixnumNodes.AbsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AbsBaseNode next0;

            AbsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AbsBaseNode(AbsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                AbsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AbsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new AbsUninitializedNode(this);
                    ((AbsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AbsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = AbsBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (AbsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AbsUninitializedNode(this), (Node)new AbsPolymorphicNode(this), (DSLNode)((AbsBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AbsBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (AbsBaseNode)AbsIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (AbsBaseNode)AbsLongNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((AbsBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (AbsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
    public static final class RightShiftNodeFactory
    extends NodeFactoryBase<FixnumNodes.RightShiftNode> {
        private static RightShiftNodeFactory rightShiftNodeFactoryInstance;

        private RightShiftNodeFactory() {
            super(FixnumNodes.RightShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.RightShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RightShiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.RightShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RightShiftUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.RightShiftNode> getInstance() {
            if (rightShiftNodeFactoryInstance == null) {
                rightShiftNodeFactoryInstance = new RightShiftNodeFactory();
            }
            return rightShiftNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RightShiftPolymorphicNode
        extends RightShiftBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RightShiftPolymorphicNode(RightShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeRightShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(arguments0ValueEvaluated)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(arguments0ValueEvaluated)) : arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated)) : (this.arguments1PolymorphicType == RubyBignum.class ? RubyTypesGen.RUBYTYPES.expectRubyBignum(arguments1ValueEvaluated) : arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RightShiftObjectNode
        extends RightShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RightShiftObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            RightShiftObjectNode(RightShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isInteger(arguments1Value) && !super.isLong(arguments1Value)) {
                    return super.rightShiftFallback(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isInteger, !isLong] failed");
            }

            @Override
            protected Object executeRightShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                Object arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (!super.isInteger(arguments1Value) && !super.isLong(arguments1Value)) {
                    return super.rightShiftFallback(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isInteger, !isLong] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!super.isInteger(arguments1Value) && !super.isLong(arguments1Value)) {
                    return super.rightShiftFallback(frameValue, arguments0Value, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.RightShiftNode create0(FixnumNodes.RightShiftNode current2) {
                return new RightShiftObjectNode((RightShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RightShiftIntLongRubyBignumNode
        extends RightShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RightShiftIntLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            RightShiftIntLongRubyBignumNode(RightShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.rightShift(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeRightShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectLong(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectRubyBignum(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.rightShift(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.rightShift(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.RightShiftNode create0(FixnumNodes.RightShiftNode current2) {
                return new RightShiftIntLongRubyBignumNode((RightShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RightShiftIntIntRubyBignumNode
        extends RightShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RightShiftIntIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            RightShiftIntIntRubyBignumNode(RightShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.rightShift(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeRightShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectRubyBignum(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.rightShift(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.rightShift(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.RightShiftNode create0(FixnumNodes.RightShiftNode current2) {
                return new RightShiftIntIntRubyBignumNode((RightShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RightShiftObjectLongIntNode
        extends RightShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RightShiftObjectLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            RightShiftObjectLongIntNode(RightShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.rightShift(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeRightShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectLong(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.rightShift(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.rightShift(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.RightShiftNode create0(FixnumNodes.RightShiftNode current2) {
                return new RightShiftObjectLongIntNode((RightShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RightShiftObjectIntIntNode
        extends RightShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RightShiftObjectIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            RightShiftObjectIntIntNode(RightShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.rightShift(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeRightShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.rightShift(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.rightShift(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.RightShiftNode create0(FixnumNodes.RightShiftNode current2) {
                return new RightShiftObjectIntIntNode((RightShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RightShiftUninitializedNode
        extends RightShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RightShiftUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RightShiftUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RightShiftUninitializedNode(RightShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeRightShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RightShiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RightShiftBaseNode rootNode = (RightShiftBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RightShiftBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.RightShiftNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RightShiftUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.RightShiftNode.class)
        private static abstract class RightShiftBaseNode
        extends FixnumNodes.RightShiftNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RightShiftBaseNode next0;

            RightShiftBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RightShiftBaseNode(RightShiftBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                RightShiftBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RightShiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RightShiftUninitializedNode(this);
                    ((RightShiftUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RightShiftBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = RightShiftBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (RightShiftBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RightShiftUninitializedNode(this), (Node)new RightShiftPolymorphicNode(this), (DSLNode)((RightShiftBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RightShiftBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                        return (RightShiftBaseNode)RightShiftObjectIntIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                        return (RightShiftBaseNode)RightShiftObjectLongIntNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                        return (RightShiftBaseNode)RightShiftIntIntRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                        return (RightShiftBaseNode)RightShiftIntLongRubyBignumNode.create0(this);
                    }
                }
                if (!super.isInteger(arguments1Value) && !super.isLong(arguments1Value)) {
                    return (RightShiftBaseNode)RightShiftObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RightShiftBaseNode otherCast = (RightShiftBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RightShiftBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
    public static final class LeftShiftNodeFactory
    extends NodeFactoryBase<FixnumNodes.LeftShiftNode> {
        private static LeftShiftNodeFactory leftShiftNodeFactoryInstance;

        private LeftShiftNodeFactory() {
            super(FixnumNodes.LeftShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.LeftShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LeftShiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.LeftShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LeftShiftUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.LeftShiftNode> getInstance() {
            if (leftShiftNodeFactoryInstance == null) {
                leftShiftNodeFactoryInstance = new LeftShiftNodeFactory();
            }
            return leftShiftNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LeftShiftPolymorphicNode
        extends LeftShiftBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LeftShiftPolymorphicNode(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(arguments0ValueEvaluated)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(arguments0ValueEvaluated)) : arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated)) : arguments1ValueEvaluated;
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LeftShiftObjectNode
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            LeftShiftObjectNode(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isInteger(arguments1Value) && !super.isLong(arguments1Value)) {
                    return super.leftShiftFallback(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isInteger, !isLong] failed");
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                Object arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (!super.isInteger(arguments1Value) && !super.isLong(arguments1Value)) {
                    return super.leftShiftFallback(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isInteger, !isLong] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!super.isInteger(arguments1Value) && !super.isLong(arguments1Value)) {
                    return super.leftShiftFallback(frameValue, arguments0Value, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LeftShiftNode create0(FixnumNodes.LeftShiftNode current2) {
                return new LeftShiftObjectNode((LeftShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LeftShiftLongLongInt1Node
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftLongLongInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            LeftShiftLongLongInt1Node(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (LeftShiftBaseNode.isStrictlyNegative(arguments1Value)) {
                    return super.leftShiftNeg(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isStrictlyNegative] failed"));
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectLong(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (LeftShiftBaseNode.isStrictlyNegative(arguments1Value)) {
                    return super.leftShiftNeg(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isStrictlyNegative] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (LeftShiftBaseNode.isStrictlyNegative(arguments1ValueCast)) {
                        return super.leftShiftNeg(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LeftShiftNode create0(FixnumNodes.LeftShiftNode current2) {
                return new LeftShiftLongLongInt1Node((LeftShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LeftShiftObjectLongIntNode
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftObjectLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            LeftShiftObjectLongIntNode(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (LeftShiftBaseNode.isPositive(arguments1Value)) {
                    return super.leftShiftWithOverflow(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isPositive] failed");
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectLong(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (LeftShiftBaseNode.isPositive(arguments1Value)) {
                    return super.leftShiftWithOverflow(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isPositive] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (LeftShiftBaseNode.isPositive(arguments1ValueCast)) {
                        return super.leftShiftWithOverflow(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LeftShiftNode create0(FixnumNodes.LeftShiftNode current2) {
                return new LeftShiftObjectLongIntNode((LeftShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LeftShiftLongLongInt0Node
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftLongLongInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            LeftShiftLongLongInt0Node(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (LeftShiftBaseNode.isPositive(arguments1Value) && LeftShiftBaseNode.canShiftIntoLong(arguments0Value, arguments1Value)) {
                    return super.leftShiftToLong(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isPositive, canShiftIntoLong] failed"));
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectLong(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (LeftShiftBaseNode.isPositive(arguments1Value) && LeftShiftBaseNode.canShiftIntoLong(arguments0Value, arguments1Value)) {
                    return super.leftShiftToLong(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isPositive, canShiftIntoLong] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (LeftShiftBaseNode.isPositive(arguments1ValueCast) && LeftShiftBaseNode.canShiftIntoLong(arguments0ValueCast, arguments1ValueCast)) {
                        return super.leftShiftToLong(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LeftShiftNode create0(FixnumNodes.LeftShiftNode current2) {
                return new LeftShiftLongLongInt0Node((LeftShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LeftShiftInt1Node
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            LeftShiftInt1Node(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (LeftShiftBaseNode.isStrictlyNegative(arguments1Value)) {
                    return super.leftShiftNeg(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isStrictlyNegative] failed"));
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (LeftShiftBaseNode.isStrictlyNegative(arguments1Value)) {
                    return super.leftShiftNeg(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isStrictlyNegative] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (LeftShiftBaseNode.isStrictlyNegative(arguments1ValueCast)) {
                        return super.leftShiftNeg(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LeftShiftNode create0(FixnumNodes.LeftShiftNode current2) {
                return new LeftShiftInt1Node((LeftShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LeftShiftObjectIntIntNode
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftObjectIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            LeftShiftObjectIntIntNode(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (LeftShiftBaseNode.isPositive(arguments1Value)) {
                    return super.leftShiftWithOverflow(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isPositive] failed");
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (LeftShiftBaseNode.isPositive(arguments1Value)) {
                    return super.leftShiftWithOverflow(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isPositive] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (LeftShiftBaseNode.isPositive(arguments1ValueCast)) {
                        return super.leftShiftWithOverflow(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LeftShiftNode create0(FixnumNodes.LeftShiftNode current2) {
                return new LeftShiftObjectIntIntNode((LeftShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LeftShiftLongIntIntNode
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftLongIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            LeftShiftLongIntIntNode(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (LeftShiftBaseNode.isPositive(arguments1Value) && LeftShiftBaseNode.canShiftIntoLong(arguments0Value, arguments1Value)) {
                    return super.leftShiftToLong(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isPositive, canShiftIntoLong] failed"));
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (LeftShiftBaseNode.isPositive(arguments1Value) && LeftShiftBaseNode.canShiftIntoLong(arguments0Value, arguments1Value)) {
                    return super.leftShiftToLong(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isPositive, canShiftIntoLong] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (LeftShiftBaseNode.isPositive(arguments1ValueCast) && LeftShiftBaseNode.canShiftIntoLong(arguments0ValueCast, arguments1ValueCast)) {
                        return super.leftShiftToLong(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LeftShiftNode create0(FixnumNodes.LeftShiftNode current2) {
                return new LeftShiftLongIntIntNode((LeftShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LeftShiftInt0Node
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            LeftShiftInt0Node(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (LeftShiftBaseNode.isPositive(arguments1Value) && LeftShiftBaseNode.canShiftIntoInt(arguments0Value, arguments1Value)) {
                    return super.leftShift(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isPositive, canShiftIntoInt] failed"));
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (LeftShiftBaseNode.isPositive(arguments1Value) && LeftShiftBaseNode.canShiftIntoInt(arguments0Value, arguments1Value)) {
                    return super.leftShift(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isPositive, canShiftIntoInt] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (LeftShiftBaseNode.isPositive(arguments1ValueCast) && LeftShiftBaseNode.canShiftIntoInt(arguments0ValueCast, arguments1ValueCast)) {
                        return super.leftShift(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LeftShiftNode create0(FixnumNodes.LeftShiftNode current2) {
                return new LeftShiftInt0Node((LeftShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LeftShiftUninitializedNode
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LeftShiftUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LeftShiftUninitializedNode(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeLeftShift(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LeftShiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LeftShiftBaseNode rootNode = (LeftShiftBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LeftShiftBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LeftShiftNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LeftShiftUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.LeftShiftNode.class)
        private static abstract class LeftShiftBaseNode
        extends FixnumNodes.LeftShiftNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LeftShiftBaseNode next0;

            LeftShiftBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LeftShiftBaseNode(LeftShiftBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                LeftShiftBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LeftShiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LeftShiftUninitializedNode(this);
                    ((LeftShiftUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LeftShiftBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = LeftShiftBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (LeftShiftBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LeftShiftUninitializedNode(this), (Node)new LeftShiftPolymorphicNode(this), (DSLNode)((LeftShiftBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LeftShiftBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                        int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1ValueCast) && FixnumNodes.LeftShiftNode.canShiftIntoInt(arguments0ValueCast, arguments1ValueCast)) {
                            return (LeftShiftBaseNode)LeftShiftInt0Node.create0(this);
                        }
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1ValueCast) && FixnumNodes.LeftShiftNode.canShiftIntoLong(arguments0ValueCast, arguments1ValueCast)) {
                            return (LeftShiftBaseNode)LeftShiftLongIntIntNode.create0(this);
                        }
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1ValueCast)) {
                            return (LeftShiftBaseNode)LeftShiftObjectIntIntNode.create0(this);
                        }
                        if (FixnumNodes.LeftShiftNode.isStrictlyNegative(arguments1ValueCast)) {
                            return (LeftShiftBaseNode)LeftShiftInt1Node.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                        long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1ValueCast) && FixnumNodes.LeftShiftNode.canShiftIntoLong(arguments0ValueCast, arguments1ValueCast)) {
                            return (LeftShiftBaseNode)LeftShiftLongLongInt0Node.create0(this);
                        }
                        if (FixnumNodes.LeftShiftNode.isPositive(arguments1ValueCast)) {
                            return (LeftShiftBaseNode)LeftShiftObjectLongIntNode.create0(this);
                        }
                        if (FixnumNodes.LeftShiftNode.isStrictlyNegative(arguments1ValueCast)) {
                            return (LeftShiftBaseNode)LeftShiftLongLongInt1Node.create0(this);
                        }
                    }
                }
                if (!super.isInteger(arguments1Value) && !super.isLong(arguments1Value)) {
                    return (LeftShiftBaseNode)LeftShiftObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LeftShiftBaseNode otherCast = (LeftShiftBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LeftShiftBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
    public static final class BitXOrNodeFactory
    extends NodeFactoryBase<FixnumNodes.BitXOrNode> {
        private static BitXOrNodeFactory bitXOrNodeFactoryInstance;

        private BitXOrNodeFactory() {
            super(FixnumNodes.BitXOrNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.BitXOrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitXOrNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.BitXOrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BitXOrUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.BitXOrNode> getInstance() {
            if (bitXOrNodeFactoryInstance == null) {
                bitXOrNodeFactoryInstance = new BitXOrNodeFactory();
            }
            return bitXOrNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BitXOrPolymorphicNode
        extends BitXOrBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            BitXOrPolymorphicNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitXOrObjectLongRubyBignumNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrObjectLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            BitXOrObjectLongRubyBignumNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.bitXOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.bitXOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitXOrNode create0(FixnumNodes.BitXOrNode current2) {
                return new BitXOrObjectLongRubyBignumNode((BitXOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitXOrLongNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            BitXOrLongNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.bitXOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.bitXOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitXOrNode create0(FixnumNodes.BitXOrNode current2) {
                return new BitXOrLongNode((BitXOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitXOrLongLongIntNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrLongLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            BitXOrLongLongIntNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.bitXOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.bitXOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitXOrNode create0(FixnumNodes.BitXOrNode current2) {
                return new BitXOrLongLongIntNode((BitXOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitXOrObjectIntRubyBignumNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrObjectIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            BitXOrObjectIntRubyBignumNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.bitXOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.bitXOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitXOrNode create0(FixnumNodes.BitXOrNode current2) {
                return new BitXOrObjectIntRubyBignumNode((BitXOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitXOrLongIntLongNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrLongIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            BitXOrLongIntLongNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.bitXOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.bitXOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitXOrNode create0(FixnumNodes.BitXOrNode current2) {
                return new BitXOrLongIntLongNode((BitXOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitXOrIntNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            BitXOrIntNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.bitXOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.bitXOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitXOrNode create0(FixnumNodes.BitXOrNode current2) {
                return new BitXOrIntNode((BitXOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BitXOrUninitializedNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BitXOrUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BitXOrUninitializedNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                BitXOrBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BitXOrBaseNode rootNode = (BitXOrBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BitXOrBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitXOrNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BitXOrUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitXOrNode.class)
        private static abstract class BitXOrBaseNode
        extends FixnumNodes.BitXOrNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BitXOrBaseNode next0;

            BitXOrBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BitXOrBaseNode(BitXOrBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                BitXOrBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BitXOrBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new BitXOrUninitializedNode(this);
                    ((BitXOrUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BitXOrBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = BitXOrBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (BitXOrBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BitXOrUninitializedNode(this), (Node)new BitXOrPolymorphicNode(this), (DSLNode)((BitXOrBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BitXOrBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (BitXOrBaseNode)BitXOrIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (BitXOrBaseNode)BitXOrLongIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (BitXOrBaseNode)BitXOrObjectIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (BitXOrBaseNode)BitXOrLongLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (BitXOrBaseNode)BitXOrLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (BitXOrBaseNode)BitXOrObjectLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    BitXOrBaseNode otherCast = (BitXOrBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (BitXOrBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.BitOrNode.class)
    public static final class BitOrNodeFactory
    extends NodeFactoryBase<FixnumNodes.BitOrNode> {
        private static BitOrNodeFactory bitOrNodeFactoryInstance;

        private BitOrNodeFactory() {
            super(FixnumNodes.BitOrNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.BitOrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitOrNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.BitOrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BitOrUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.BitOrNode> getInstance() {
            if (bitOrNodeFactoryInstance == null) {
                bitOrNodeFactoryInstance = new BitOrNodeFactory();
            }
            return bitOrNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BitOrPolymorphicNode
        extends BitOrBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            BitOrPolymorphicNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitOrObjectLongRubyBignumNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrObjectLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            BitOrObjectLongRubyBignumNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.bitOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.bitOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitOrNode create0(FixnumNodes.BitOrNode current2) {
                return new BitOrObjectLongRubyBignumNode((BitOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitOrLongNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            BitOrLongNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.bitOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.bitOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitOrNode create0(FixnumNodes.BitOrNode current2) {
                return new BitOrLongNode((BitOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitOrLongLongIntNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrLongLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            BitOrLongLongIntNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.bitOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.bitOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitOrNode create0(FixnumNodes.BitOrNode current2) {
                return new BitOrLongLongIntNode((BitOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitOrObjectIntRubyBignumNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrObjectIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            BitOrObjectIntRubyBignumNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.bitOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.bitOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitOrNode create0(FixnumNodes.BitOrNode current2) {
                return new BitOrObjectIntRubyBignumNode((BitOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitOrLongIntLongNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrLongIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            BitOrLongIntLongNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.bitOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.bitOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitOrNode create0(FixnumNodes.BitOrNode current2) {
                return new BitOrLongIntLongNode((BitOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitOrIntNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            BitOrIntNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.bitOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.bitOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitOrNode create0(FixnumNodes.BitOrNode current2) {
                return new BitOrIntNode((BitOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BitOrUninitializedNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BitOrUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BitOrUninitializedNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                BitOrBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BitOrBaseNode rootNode = (BitOrBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BitOrBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitOrNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BitOrUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitOrNode.class)
        private static abstract class BitOrBaseNode
        extends FixnumNodes.BitOrNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BitOrBaseNode next0;

            BitOrBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BitOrBaseNode(BitOrBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                BitOrBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BitOrBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new BitOrUninitializedNode(this);
                    ((BitOrUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BitOrBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = BitOrBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (BitOrBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BitOrUninitializedNode(this), (Node)new BitOrPolymorphicNode(this), (DSLNode)((BitOrBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BitOrBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (BitOrBaseNode)BitOrIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (BitOrBaseNode)BitOrLongIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (BitOrBaseNode)BitOrObjectIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (BitOrBaseNode)BitOrLongLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (BitOrBaseNode)BitOrLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (BitOrBaseNode)BitOrObjectLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    BitOrBaseNode otherCast = (BitOrBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (BitOrBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.BitAndNode.class)
    public static final class BitAndNodeFactory
    extends NodeFactoryBase<FixnumNodes.BitAndNode> {
        private static BitAndNodeFactory bitAndNodeFactoryInstance;

        private BitAndNodeFactory() {
            super(FixnumNodes.BitAndNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.BitAndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitAndNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.BitAndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BitAndUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.BitAndNode> getInstance() {
            if (bitAndNodeFactoryInstance == null) {
                bitAndNodeFactoryInstance = new BitAndNodeFactory();
            }
            return bitAndNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BitAndPolymorphicNode
        extends BitAndBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            BitAndPolymorphicNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitAndObjectLongRubyBignumNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndObjectLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            BitAndObjectLongRubyBignumNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.bitAnd(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.bitAnd(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitAndNode create0(FixnumNodes.BitAndNode current2) {
                return new BitAndObjectLongRubyBignumNode((BitAndBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitAndLongNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            BitAndLongNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.bitAnd(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.bitAnd(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitAndNode create0(FixnumNodes.BitAndNode current2) {
                return new BitAndLongNode((BitAndBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitAndLongLongIntNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndLongLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            BitAndLongLongIntNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.bitAnd(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.bitAnd(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitAndNode create0(FixnumNodes.BitAndNode current2) {
                return new BitAndLongLongIntNode((BitAndBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitAndObjectIntRubyBignumNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndObjectIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            BitAndObjectIntRubyBignumNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.bitAnd(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.bitAnd(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitAndNode create0(FixnumNodes.BitAndNode current2) {
                return new BitAndObjectIntRubyBignumNode((BitAndBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitAndLongIntLongNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndLongIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            BitAndLongIntLongNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.bitAnd(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.bitAnd(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitAndNode create0(FixnumNodes.BitAndNode current2) {
                return new BitAndLongIntLongNode((BitAndBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitAndIntNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            BitAndIntNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.bitAnd(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.bitAnd(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitAndNode create0(FixnumNodes.BitAndNode current2) {
                return new BitAndIntNode((BitAndBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BitAndUninitializedNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BitAndUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BitAndUninitializedNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                BitAndBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BitAndBaseNode rootNode = (BitAndBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BitAndBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.BitAndNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BitAndUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.BitAndNode.class)
        private static abstract class BitAndBaseNode
        extends FixnumNodes.BitAndNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BitAndBaseNode next0;

            BitAndBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BitAndBaseNode(BitAndBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                BitAndBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BitAndBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new BitAndUninitializedNode(this);
                    ((BitAndUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BitAndBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = BitAndBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (BitAndBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BitAndUninitializedNode(this), (Node)new BitAndPolymorphicNode(this), (DSLNode)((BitAndBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BitAndBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (BitAndBaseNode)BitAndIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (BitAndBaseNode)BitAndLongIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (BitAndBaseNode)BitAndObjectIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (BitAndBaseNode)BitAndLongLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (BitAndBaseNode)BitAndLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (BitAndBaseNode)BitAndObjectLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    BitAndBaseNode otherCast = (BitAndBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (BitAndBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.ComplementNode.class)
    public static final class ComplementNodeFactory
    extends NodeFactoryBase<FixnumNodes.ComplementNode> {
        private static ComplementNodeFactory complementNodeFactoryInstance;

        private ComplementNodeFactory() {
            super(FixnumNodes.ComplementNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.ComplementNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ComplementNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.ComplementNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ComplementUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.ComplementNode> getInstance() {
            if (complementNodeFactoryInstance == null) {
                complementNodeFactoryInstance = new ComplementNodeFactory();
            }
            return complementNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.ComplementNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ComplementPolymorphicNode
        extends ComplementBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ComplementPolymorphicNode(ComplementBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.ComplementNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ComplementLongNode
        extends ComplementBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ComplementLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ComplementLongNode(ComplementBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long"));
                }
                return super.complement(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.complement(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.ComplementNode create0(FixnumNodes.ComplementNode current2) {
                return new ComplementLongNode((ComplementBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ComplementNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ComplementIntNode
        extends ComplementBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ComplementIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ComplementIntNode(ComplementBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int"));
                }
                return super.complement(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.complement(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.ComplementNode create0(FixnumNodes.ComplementNode current2) {
                return new ComplementIntNode((ComplementBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ComplementNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ComplementUninitializedNode
        extends ComplementBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ComplementUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ComplementUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ComplementUninitializedNode(ComplementBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ComplementBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ComplementBaseNode rootNode = (ComplementBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ComplementBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.ComplementNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ComplementUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.ComplementNode.class)
        private static abstract class ComplementBaseNode
        extends FixnumNodes.ComplementNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ComplementBaseNode next0;

            ComplementBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ComplementBaseNode(ComplementBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ComplementBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ComplementBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ComplementUninitializedNode(this);
                    ((ComplementUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ComplementBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ComplementBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ComplementBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ComplementUninitializedNode(this), (Node)new ComplementPolymorphicNode(this), (DSLNode)((ComplementBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ComplementBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ComplementBaseNode)ComplementIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ComplementBaseNode)ComplementLongNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ComplementBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ComplementBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.GreaterNode.class)
    public static final class GreaterNodeFactory
    extends NodeFactoryBase<FixnumNodes.GreaterNode> {
        private static GreaterNodeFactory greaterNodeFactoryInstance;

        private GreaterNodeFactory() {
            super(FixnumNodes.GreaterNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.GreaterNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GreaterNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.GreaterNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GreaterUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.GreaterNode> getInstance() {
            if (greaterNodeFactoryInstance == null) {
                greaterNodeFactoryInstance = new GreaterNodeFactory();
            }
            return greaterNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GreaterPolymorphicNode
        extends GreaterBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GreaterPolymorphicNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterLongRubyBignumNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            GreaterLongRubyBignumNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterNode create0(FixnumNodes.GreaterNode current2) {
                return new GreaterLongRubyBignumNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterLongDoubleNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            GreaterLongDoubleNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterNode create0(FixnumNodes.GreaterNode current2) {
                return new GreaterLongDoubleNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterLongNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            GreaterLongNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterNode create0(FixnumNodes.GreaterNode current2) {
                return new GreaterLongNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterLongIntNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            GreaterLongIntNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterNode create0(FixnumNodes.GreaterNode current2) {
                return new GreaterLongIntNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterIntRubyBignumNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            GreaterIntRubyBignumNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterNode create0(FixnumNodes.GreaterNode current2) {
                return new GreaterIntRubyBignumNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterIntDoubleNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            GreaterIntDoubleNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterNode create0(FixnumNodes.GreaterNode current2) {
                return new GreaterIntDoubleNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterIntLongNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            GreaterIntLongNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterNode create0(FixnumNodes.GreaterNode current2) {
                return new GreaterIntLongNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterIntNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            GreaterIntNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterNode create0(FixnumNodes.GreaterNode current2) {
                return new GreaterIntNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GreaterUninitializedNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GreaterUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GreaterUninitializedNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GreaterBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GreaterBaseNode rootNode = (GreaterBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GreaterBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GreaterUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterNode.class)
        private static abstract class GreaterBaseNode
        extends FixnumNodes.GreaterNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GreaterBaseNode next0;

            GreaterBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GreaterBaseNode(GreaterBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                GreaterBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GreaterBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GreaterUninitializedNode(this);
                    ((GreaterUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GreaterBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = GreaterBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GreaterBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GreaterUninitializedNode(this), (Node)new GreaterPolymorphicNode(this), (DSLNode)((GreaterBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GreaterBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (GreaterBaseNode)GreaterIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (GreaterBaseNode)GreaterIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (GreaterBaseNode)GreaterIntDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (GreaterBaseNode)GreaterIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (GreaterBaseNode)GreaterLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (GreaterBaseNode)GreaterLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (GreaterBaseNode)GreaterLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (GreaterBaseNode)GreaterLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GreaterBaseNode otherCast = (GreaterBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GreaterBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
    public static final class GreaterEqualNodeFactory
    extends NodeFactoryBase<FixnumNodes.GreaterEqualNode> {
        private static GreaterEqualNodeFactory greaterEqualNodeFactoryInstance;

        private GreaterEqualNodeFactory() {
            super(FixnumNodes.GreaterEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.GreaterEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GreaterEqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.GreaterEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GreaterEqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.GreaterEqualNode> getInstance() {
            if (greaterEqualNodeFactoryInstance == null) {
                greaterEqualNodeFactoryInstance = new GreaterEqualNodeFactory();
            }
            return greaterEqualNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GreaterEqualPolymorphicNode
        extends GreaterEqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GreaterEqualPolymorphicNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualLongRubyBignumNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            GreaterEqualLongRubyBignumNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterEqualNode create0(FixnumNodes.GreaterEqualNode current2) {
                return new GreaterEqualLongRubyBignumNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualLongDoubleNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            GreaterEqualLongDoubleNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterEqualNode create0(FixnumNodes.GreaterEqualNode current2) {
                return new GreaterEqualLongDoubleNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualLongNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            GreaterEqualLongNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterEqualNode create0(FixnumNodes.GreaterEqualNode current2) {
                return new GreaterEqualLongNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualLongIntNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            GreaterEqualLongIntNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterEqualNode create0(FixnumNodes.GreaterEqualNode current2) {
                return new GreaterEqualLongIntNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualIntRubyBignumNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            GreaterEqualIntRubyBignumNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterEqualNode create0(FixnumNodes.GreaterEqualNode current2) {
                return new GreaterEqualIntRubyBignumNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualIntDoubleNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            GreaterEqualIntDoubleNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterEqualNode create0(FixnumNodes.GreaterEqualNode current2) {
                return new GreaterEqualIntDoubleNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualIntLongNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            GreaterEqualIntLongNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterEqualNode create0(FixnumNodes.GreaterEqualNode current2) {
                return new GreaterEqualIntLongNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualIntNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            GreaterEqualIntNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterEqualNode create0(FixnumNodes.GreaterEqualNode current2) {
                return new GreaterEqualIntNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GreaterEqualUninitializedNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GreaterEqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GreaterEqualUninitializedNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GreaterEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GreaterEqualBaseNode rootNode = (GreaterEqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GreaterEqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.GreaterEqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GreaterEqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.GreaterEqualNode.class)
        private static abstract class GreaterEqualBaseNode
        extends FixnumNodes.GreaterEqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GreaterEqualBaseNode next0;

            GreaterEqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GreaterEqualBaseNode(GreaterEqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                GreaterEqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GreaterEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GreaterEqualUninitializedNode(this);
                    ((GreaterEqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GreaterEqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = GreaterEqualBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GreaterEqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GreaterEqualUninitializedNode(this), (Node)new GreaterEqualPolymorphicNode(this), (DSLNode)((GreaterEqualBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GreaterEqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualIntDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GreaterEqualBaseNode otherCast = (GreaterEqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GreaterEqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<FixnumNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(FixnumNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompareUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ComparePolymorphicNode
        extends CompareBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ComparePolymorphicNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyNilClassObjectObjectNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyNilClassObjectObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            CompareRubyNilClassObjectObjectNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isDouble(arguments1Value) || super.isRubyBignum(arguments1Value))) {
                    return super.compare(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isInteger, !isLong, !isDouble, !isRubyBignum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isDouble(arguments1Value) || super.isRubyBignum(arguments1Value))) {
                    return super.compare(arguments0Value, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.CompareNode create0(FixnumNodes.CompareNode current2) {
                return new CompareRubyNilClassObjectObjectNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntLongRubyBignumNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            CompareIntLongRubyBignumNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.CompareNode create0(FixnumNodes.CompareNode current2) {
                return new CompareIntLongRubyBignumNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntLongDoubleNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            CompareIntLongDoubleNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.CompareNode create0(FixnumNodes.CompareNode current2) {
                return new CompareIntLongDoubleNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntLongLongNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntLongLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            CompareIntLongLongNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.CompareNode create0(FixnumNodes.CompareNode current2) {
                return new CompareIntLongLongNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntLongIntNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            CompareIntLongIntNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.CompareNode create0(FixnumNodes.CompareNode current2) {
                return new CompareIntLongIntNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntIntRubyBignumNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            CompareIntIntRubyBignumNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.CompareNode create0(FixnumNodes.CompareNode current2) {
                return new CompareIntIntRubyBignumNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntIntDoubleNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            CompareIntIntDoubleNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.CompareNode create0(FixnumNodes.CompareNode current2) {
                return new CompareIntIntDoubleNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntIntLongNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            CompareIntIntLongNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.CompareNode create0(FixnumNodes.CompareNode current2) {
                return new CompareIntIntLongNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            CompareIntNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.CompareNode create0(FixnumNodes.CompareNode current2) {
                return new CompareIntNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompareUninitializedNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompareUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompareUninitializedNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompareBaseNode rootNode = (CompareBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CompareBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.CompareNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompareUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.CompareNode.class)
        private static abstract class CompareBaseNode
        extends FixnumNodes.CompareNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompareBaseNode next0;

            CompareBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompareBaseNode(CompareBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                CompareBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CompareUninitializedNode(this);
                    ((CompareUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CompareBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = CompareBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CompareBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CompareUninitializedNode(this), (Node)new ComparePolymorphicNode(this), (DSLNode)((CompareBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompareBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (CompareBaseNode)CompareIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (CompareBaseNode)CompareIntIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (CompareBaseNode)CompareIntIntDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (CompareBaseNode)CompareIntIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (CompareBaseNode)CompareIntLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (CompareBaseNode)CompareIntLongLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (CompareBaseNode)CompareIntLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (CompareBaseNode)CompareIntLongRubyBignumNode.create0(this);
                    }
                }
                if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isDouble(arguments1Value) || super.isRubyBignum(arguments1Value))) {
                    return (CompareBaseNode)CompareRubyNilClassObjectObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CompareBaseNode otherCast = (CompareBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CompareBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<FixnumNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(FixnumNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            EqualObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isRubyBignum(arguments1Value))) {
                    return super.equal(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isInteger, !isLong, !isRubyBignum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isRubyBignum(arguments1Value))) {
                    return super.equal(frameValue, arguments0Value, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.EqualNode create0(FixnumNodes.EqualNode current2) {
                return new EqualObjectNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanLongRubyBignumNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            EqualBooleanLongRubyBignumNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.EqualNode create0(FixnumNodes.EqualNode current2) {
                return new EqualBooleanLongRubyBignumNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanLongDoubleNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            EqualBooleanLongDoubleNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.EqualNode create0(FixnumNodes.EqualNode current2) {
                return new EqualBooleanLongDoubleNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanLongLongNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanLongLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            EqualBooleanLongLongNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.EqualNode create0(FixnumNodes.EqualNode current2) {
                return new EqualBooleanLongLongNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanLongIntNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            EqualBooleanLongIntNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.EqualNode create0(FixnumNodes.EqualNode current2) {
                return new EqualBooleanLongIntNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanIntRubyBignumNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            EqualBooleanIntRubyBignumNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.EqualNode create0(FixnumNodes.EqualNode current2) {
                return new EqualBooleanIntRubyBignumNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanIntDoubleNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            EqualBooleanIntDoubleNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.EqualNode create0(FixnumNodes.EqualNode current2) {
                return new EqualBooleanIntDoubleNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanIntLongNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            EqualBooleanIntLongNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.EqualNode create0(FixnumNodes.EqualNode current2) {
                return new EqualBooleanIntLongNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanIntIntNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            EqualBooleanIntIntNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.EqualNode create0(FixnumNodes.EqualNode current2) {
                return new EqualBooleanIntIntNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = (EqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends FixnumNodes.EqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EqualBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EqualUninitializedNode(this), (Node)new EqualPolymorphicNode(this), (DSLNode)((EqualBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanIntIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanIntDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanLongLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanLongRubyBignumNode.create0(this);
                    }
                }
                if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isRubyBignum(arguments1Value))) {
                    return (EqualBaseNode)EqualObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
    public static final class LessEqualNodeFactory
    extends NodeFactoryBase<FixnumNodes.LessEqualNode> {
        private static LessEqualNodeFactory lessEqualNodeFactoryInstance;

        private LessEqualNodeFactory() {
            super(FixnumNodes.LessEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.LessEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LessEqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.LessEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LessEqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.LessEqualNode> getInstance() {
            if (lessEqualNodeFactoryInstance == null) {
                lessEqualNodeFactoryInstance = new LessEqualNodeFactory();
            }
            return lessEqualNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LessEqualPolymorphicNode
        extends LessEqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LessEqualPolymorphicNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualLongRubyBignumNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            LessEqualLongRubyBignumNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessEqualNode create0(FixnumNodes.LessEqualNode current2) {
                return new LessEqualLongRubyBignumNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualLongDoubleNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            LessEqualLongDoubleNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessEqualNode create0(FixnumNodes.LessEqualNode current2) {
                return new LessEqualLongDoubleNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualLongNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            LessEqualLongNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessEqualNode create0(FixnumNodes.LessEqualNode current2) {
                return new LessEqualLongNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualLongIntNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            LessEqualLongIntNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessEqualNode create0(FixnumNodes.LessEqualNode current2) {
                return new LessEqualLongIntNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualIntRubyBignumNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            LessEqualIntRubyBignumNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessEqualNode create0(FixnumNodes.LessEqualNode current2) {
                return new LessEqualIntRubyBignumNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualIntDoubleNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            LessEqualIntDoubleNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessEqualNode create0(FixnumNodes.LessEqualNode current2) {
                return new LessEqualIntDoubleNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualIntLongNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            LessEqualIntLongNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessEqualNode create0(FixnumNodes.LessEqualNode current2) {
                return new LessEqualIntLongNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualIntNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            LessEqualIntNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessEqualNode create0(FixnumNodes.LessEqualNode current2) {
                return new LessEqualIntNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LessEqualUninitializedNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LessEqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LessEqualUninitializedNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LessEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LessEqualBaseNode rootNode = (LessEqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LessEqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessEqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LessEqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessEqualNode.class)
        private static abstract class LessEqualBaseNode
        extends FixnumNodes.LessEqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LessEqualBaseNode next0;

            LessEqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LessEqualBaseNode(LessEqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                LessEqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LessEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LessEqualUninitializedNode(this);
                    ((LessEqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LessEqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = LessEqualBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (LessEqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LessEqualUninitializedNode(this), (Node)new LessEqualPolymorphicNode(this), (DSLNode)((LessEqualBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LessEqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualIntDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LessEqualBaseNode otherCast = (LessEqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LessEqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.LessNode.class)
    public static final class LessNodeFactory
    extends NodeFactoryBase<FixnumNodes.LessNode> {
        private static LessNodeFactory lessNodeFactoryInstance;

        private LessNodeFactory() {
            super(FixnumNodes.LessNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.LessNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LessNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.LessNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LessUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.LessNode> getInstance() {
            if (lessNodeFactoryInstance == null) {
                lessNodeFactoryInstance = new LessNodeFactory();
            }
            return lessNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LessPolymorphicNode
        extends LessBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LessPolymorphicNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessLongRubyBignumNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            LessLongRubyBignumNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessNode create0(FixnumNodes.LessNode current2) {
                return new LessLongRubyBignumNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessLongDoubleNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            LessLongDoubleNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessNode create0(FixnumNodes.LessNode current2) {
                return new LessLongDoubleNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessLongNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            LessLongNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessNode create0(FixnumNodes.LessNode current2) {
                return new LessLongNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessLongIntNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            LessLongIntNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessNode create0(FixnumNodes.LessNode current2) {
                return new LessLongIntNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessIntRubyBignumNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            LessIntRubyBignumNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessNode create0(FixnumNodes.LessNode current2) {
                return new LessIntRubyBignumNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessIntDoubleNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            LessIntDoubleNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessNode create0(FixnumNodes.LessNode current2) {
                return new LessIntDoubleNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessIntLongNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            LessIntLongNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessNode create0(FixnumNodes.LessNode current2) {
                return new LessIntLongNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessIntNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            LessIntNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessNode create0(FixnumNodes.LessNode current2) {
                return new LessIntNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LessUninitializedNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LessUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LessUninitializedNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LessBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LessBaseNode rootNode = (LessBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LessBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.LessNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LessUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.LessNode.class)
        private static abstract class LessBaseNode
        extends FixnumNodes.LessNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LessBaseNode next0;

            LessBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LessBaseNode(LessBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                LessBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LessBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LessUninitializedNode(this);
                    ((LessUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LessBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = LessBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (LessBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LessUninitializedNode(this), (Node)new LessPolymorphicNode(this), (DSLNode)((LessBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LessBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LessBaseNode)LessIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LessBaseNode)LessIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LessBaseNode)LessIntDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LessBaseNode)LessIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LessBaseNode)LessLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LessBaseNode)LessLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LessBaseNode)LessLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LessBaseNode)LessLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LessBaseNode otherCast = (LessBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LessBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.DivModNode.class)
    public static final class DivModNodeFactory
    extends NodeFactoryBase<FixnumNodes.DivModNode> {
        private static DivModNodeFactory divModNodeFactoryInstance;

        private DivModNodeFactory() {
            super(FixnumNodes.DivModNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.DivModNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DivModNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.DivModNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DivModUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.DivModNode> getInstance() {
            if (divModNodeFactoryInstance == null) {
                divModNodeFactoryInstance = new DivModNodeFactory();
            }
            return divModNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DivModPolymorphicNode
        extends DivModBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DivModPolymorphicNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModLongDoubleNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            DivModLongDoubleNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivModNode create0(FixnumNodes.DivModNode current2) {
                return new DivModLongDoubleNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModLongRubyBignumNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            DivModLongRubyBignumNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivModNode create0(FixnumNodes.DivModNode current2) {
                return new DivModLongRubyBignumNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModLongNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            DivModLongNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivModNode create0(FixnumNodes.DivModNode current2) {
                return new DivModLongNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModLongIntNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            DivModLongIntNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivModNode create0(FixnumNodes.DivModNode current2) {
                return new DivModLongIntNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModIntDoubleNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            DivModIntDoubleNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivModNode create0(FixnumNodes.DivModNode current2) {
                return new DivModIntDoubleNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModIntRubyBignumNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            DivModIntRubyBignumNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivModNode create0(FixnumNodes.DivModNode current2) {
                return new DivModIntRubyBignumNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModIntLongNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            DivModIntLongNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivModNode create0(FixnumNodes.DivModNode current2) {
                return new DivModIntLongNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModIntNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            DivModIntNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivModNode create0(FixnumNodes.DivModNode current2) {
                return new DivModIntNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DivModUninitializedNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DivModUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DivModUninitializedNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DivModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DivModBaseNode rootNode = (DivModBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DivModBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivModNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DivModUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivModNode.class)
        private static abstract class DivModBaseNode
        extends FixnumNodes.DivModNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DivModBaseNode next0;

            DivModBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DivModBaseNode(DivModBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                DivModBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DivModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DivModUninitializedNode(this);
                    ((DivModUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DivModBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DivModBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DivModBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DivModUninitializedNode(this), (Node)new DivModPolymorphicNode(this), (DSLNode)((DivModBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DivModBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (DivModBaseNode)DivModIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (DivModBaseNode)DivModIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (DivModBaseNode)DivModIntRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (DivModBaseNode)DivModIntDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (DivModBaseNode)DivModLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (DivModBaseNode)DivModLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (DivModBaseNode)DivModLongRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (DivModBaseNode)DivModLongDoubleNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DivModBaseNode otherCast = (DivModBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DivModBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.ModNode.class)
    public static final class ModNodeFactory
    extends NodeFactoryBase<FixnumNodes.ModNode> {
        private static ModNodeFactory modNodeFactoryInstance;

        private ModNodeFactory() {
            super(FixnumNodes.ModNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.ModNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ModNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.ModNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ModUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.ModNode> getInstance() {
            if (modNodeFactoryInstance == null) {
                modNodeFactoryInstance = new ModNodeFactory();
            }
            return modNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ModPolymorphicNode
        extends ModBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ModPolymorphicNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModObjectLongRubyBignumNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModObjectLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            ModObjectLongRubyBignumNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ModNode create0(FixnumNodes.ModNode current2) {
                return new ModObjectLongRubyBignumNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModObjectIntRubyBignumNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModObjectIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            ModObjectIntRubyBignumNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ModNode create0(FixnumNodes.ModNode current2) {
                return new ModObjectIntRubyBignumNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModLongNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            ModLongNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ModNode create0(FixnumNodes.ModNode current2) {
                return new ModLongNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModLongLongIntNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModLongLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            ModLongLongIntNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ModNode create0(FixnumNodes.ModNode current2) {
                return new ModLongLongIntNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModDoubleLongDoubleNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModDoubleLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            ModDoubleLongDoubleNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ModNode create0(FixnumNodes.ModNode current2) {
                return new ModDoubleLongDoubleNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModDoubleIntDoubleNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModDoubleIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            ModDoubleIntDoubleNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ModNode create0(FixnumNodes.ModNode current2) {
                return new ModDoubleIntDoubleNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModLongIntLongNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModLongIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            ModLongIntLongNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ModNode create0(FixnumNodes.ModNode current2) {
                return new ModLongIntLongNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModIntNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            ModIntNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ModNode create0(FixnumNodes.ModNode current2) {
                return new ModIntNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ModUninitializedNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ModUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ModUninitializedNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ModBaseNode rootNode = (ModBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ModBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.ModNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ModUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.ModNode.class)
        private static abstract class ModBaseNode
        extends FixnumNodes.ModNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ModBaseNode next0;

            ModBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ModBaseNode(ModBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ModBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ModUninitializedNode(this);
                    ((ModUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ModBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ModBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ModBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ModUninitializedNode(this), (Node)new ModPolymorphicNode(this), (DSLNode)((ModBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ModBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (ModBaseNode)ModIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (ModBaseNode)ModLongIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (ModBaseNode)ModDoubleIntDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (ModBaseNode)ModDoubleLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (ModBaseNode)ModLongLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (ModBaseNode)ModLongNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                        return (ModBaseNode)ModObjectIntRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                        return (ModBaseNode)ModObjectLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ModBaseNode otherCast = (ModBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ModBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.DivNode.class)
    public static final class DivNodeFactory
    extends NodeFactoryBase<FixnumNodes.DivNode> {
        private static DivNodeFactory divNodeFactoryInstance;

        private DivNodeFactory() {
            super(FixnumNodes.DivNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.DivNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DivNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.DivNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DivUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.DivNode> getInstance() {
            if (divNodeFactoryInstance == null) {
                divNodeFactoryInstance = new DivNodeFactory();
            }
            return divNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DivPolymorphicNode
        extends DivBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DivPolymorphicNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivIntLongRubyBignumNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivIntLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            DivIntLongRubyBignumNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivIntLongRubyBignumNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivDoubleLongDoubleNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivDoubleLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            DivDoubleLongDoubleNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivDoubleLongDoubleNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivObjectLongLongNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivObjectLongLongNode.class, new Class[]{DivLongNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            DivObjectLongLongNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.divEdgeCase(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.divEdgeCase(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivObjectLongLongNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivLongNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{DivObjectLongLongNode.class}, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            DivLongNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                try {
                    return super.div(arguments0Value, arguments1Value);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    try {
                        return super.div(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivLongNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivObjectLongIntNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivObjectLongIntNode.class, new Class[]{DivLongLongIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            DivObjectLongIntNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.divEdgeCase(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.divEdgeCase(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivObjectLongIntNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivLongLongIntNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivLongLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{DivObjectLongIntNode.class}, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            DivLongLongIntNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                try {
                    return super.div(arguments0Value, arguments1Value);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    try {
                        return super.div(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivLongLongIntNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivIntIntRubyBignumNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivIntIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            DivIntIntRubyBignumNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivIntIntRubyBignumNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivDoubleIntDoubleNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivDoubleIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            DivDoubleIntDoubleNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivDoubleIntDoubleNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivObjectIntLongNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivObjectIntLongNode.class, new Class[]{DivLongIntLongNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            DivObjectIntLongNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.divEdgeCase(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.divEdgeCase(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivObjectIntLongNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivLongIntLongNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivLongIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{DivObjectIntLongNode.class}, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            DivLongIntLongNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                try {
                    return super.div(arguments0Value, arguments1Value);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    try {
                        return super.div(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivLongIntLongNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivObjectIntIntNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivObjectIntIntNode.class, new Class[]{DivIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            DivObjectIntIntNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.divEdgeCase(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.divEdgeCase(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivObjectIntIntNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivIntNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{DivObjectIntIntNode.class}, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            DivIntNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                try {
                    return super.div(arguments0Value, arguments1Value);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    try {
                        return super.div(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(FixnumNodes.DivNode current2) {
                return new DivIntNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DivUninitializedNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DivUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DivUninitializedNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DivBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DivBaseNode rootNode = (DivBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DivBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.DivNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DivUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.DivNode.class)
        private static abstract class DivBaseNode
        extends FixnumNodes.DivNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DivBaseNode next0;

            DivBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DivBaseNode(DivBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                DivBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DivBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DivUninitializedNode(this);
                    ((DivUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DivBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DivBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DivBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DivUninitializedNode(this), (Node)new DivPolymorphicNode(this), (DSLNode)((DivBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DivBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)DivIntNode.METADATA)) {
                            return (DivBaseNode)DivIntNode.create0(this);
                        }
                        return (DivBaseNode)DivObjectIntIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)DivLongIntLongNode.METADATA)) {
                            return (DivBaseNode)DivLongIntLongNode.create0(this);
                        }
                        return (DivBaseNode)DivObjectIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (DivBaseNode)DivDoubleIntDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (DivBaseNode)DivIntIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)DivLongLongIntNode.METADATA)) {
                            return (DivBaseNode)DivLongLongIntNode.create0(this);
                        }
                        return (DivBaseNode)DivObjectLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)DivLongNode.METADATA)) {
                            return (DivBaseNode)DivLongNode.create0(this);
                        }
                        return (DivBaseNode)DivObjectLongLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (DivBaseNode)DivDoubleLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (DivBaseNode)DivIntLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DivBaseNode otherCast = (DivBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DivBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.PowNode.class)
    public static final class PowNodeFactory
    extends NodeFactoryBase<FixnumNodes.PowNode> {
        private static PowNodeFactory powNodeFactoryInstance;

        private PowNodeFactory() {
            super(FixnumNodes.PowNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.PowNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PowNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.PowNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PowUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.PowNode> getInstance() {
            if (powNodeFactoryInstance == null) {
                powNodeFactoryInstance = new PowNodeFactory();
            }
            return powNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PowPolymorphicNode
        extends PowBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PowPolymorphicNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectObjectRubyBasicObjectNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectObjectRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyBasicObject.class}, 0, 0);

            PowObjectObjectRubyBasicObjectNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (super.isRational(arguments1Value)) {
                    return super.pow(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isRational] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyBasicObject arguments1ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && super.isRational(arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value))) {
                    return super.pow(frameValue, arguments0Value, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowObjectObjectRubyBasicObjectNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectLongRubyBignumNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            PowObjectLongRubyBignumNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowObjectLongRubyBignumNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectLongDoubleNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            PowObjectLongDoubleNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.pow(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.pow(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowObjectLongDoubleNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectLongLongNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectLongLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            PowObjectLongLongNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowObjectLongLongNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectLongIntNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            PowObjectLongIntNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowObjectLongIntNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowLongNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            PowLongNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                if (PowBaseNode.canShiftIntoLong(arguments0Value, arguments1Value)) {
                    return super.powTwo(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [canShiftIntoLong] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                long arguments1ValueCast;
                long arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && PowBaseNode.canShiftIntoLong(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value))) {
                    return super.powTwo(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowLongNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowLongLongIntNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowLongLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            PowLongLongIntNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (PowBaseNode.canShiftIntoLong(arguments0Value, arguments1Value)) {
                    return super.powTwo(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [canShiftIntoLong] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                int arguments1ValueCast;
                long arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && PowBaseNode.canShiftIntoLong(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value))) {
                    return super.powTwo(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowLongLongIntNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectIntRubyBignumNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            PowObjectIntRubyBignumNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowObjectIntRubyBignumNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectIntDoubleNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            PowObjectIntDoubleNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.pow(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.pow(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowObjectIntDoubleNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectIntLongNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            PowObjectIntLongNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowObjectIntLongNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectIntIntNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            PowObjectIntIntNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowObjectIntIntNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowIntIntLongNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowIntIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            PowIntIntLongNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                if (PowBaseNode.canShiftIntoInt(arguments0Value, arguments1Value)) {
                    return super.powTwo(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [canShiftIntoInt] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                long arguments1ValueCast;
                int arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && PowBaseNode.canShiftIntoInt(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value))) {
                    return super.powTwo(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowIntIntLongNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowIntNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            PowIntNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (PowBaseNode.canShiftIntoInt(arguments0Value, arguments1Value)) {
                    return super.powTwo(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [canShiftIntoInt] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                int arguments1ValueCast;
                int arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && PowBaseNode.canShiftIntoInt(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value))) {
                    return super.powTwo(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(FixnumNodes.PowNode current2) {
                return new PowIntNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PowUninitializedNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PowUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PowUninitializedNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PowBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PowBaseNode rootNode = (PowBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PowBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.PowNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PowUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.PowNode.class)
        private static abstract class PowBaseNode
        extends FixnumNodes.PowNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PowBaseNode next0;

            PowBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PowBaseNode(PowBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PowBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PowBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PowUninitializedNode(this);
                    ((PowUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PowBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PowBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PowBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PowUninitializedNode(this), (Node)new PowPolymorphicNode(this), (DSLNode)((PowBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PowBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                RubyBasicObject arguments1ValueCast;
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments1ValueCast2;
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && FixnumNodes.PowNode.canShiftIntoInt(arguments0ValueCast, arguments1ValueCast2 = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value))) {
                        return (PowBaseNode)PowIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && FixnumNodes.PowNode.canShiftIntoInt(arguments0ValueCast, arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value))) {
                        return (PowBaseNode)PowIntIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (PowBaseNode)PowObjectIntIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (PowBaseNode)PowObjectIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (PowBaseNode)PowObjectIntDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (PowBaseNode)PowObjectIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    int arguments1ValueCast3;
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && FixnumNodes.PowNode.canShiftIntoLong(arguments0ValueCast, arguments1ValueCast3 = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value))) {
                        return (PowBaseNode)PowLongLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && FixnumNodes.PowNode.canShiftIntoLong(arguments0ValueCast, arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value))) {
                        return (PowBaseNode)PowLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (PowBaseNode)PowObjectLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (PowBaseNode)PowObjectLongLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (PowBaseNode)PowObjectLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (PowBaseNode)PowObjectLongRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && super.isRational(arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value))) {
                    return (PowBaseNode)PowObjectObjectRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PowBaseNode otherCast = (PowBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PowBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<FixnumNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(FixnumNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MulUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MulPolymorphicNode
        extends MulBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MulPolymorphicNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulObjectLongRubyBignumNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulObjectLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            MulObjectLongRubyBignumNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulObjectLongRubyBignumNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulDoubleLongDoubleNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulDoubleLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            MulDoubleLongDoubleNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulDoubleLongDoubleNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulObjectLongLongNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulObjectLongLongNode.class, new Class[]{MulLongNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            MulObjectLongLongNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.mulWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.mulWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulObjectLongLongNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulLongNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{MulObjectLongLongNode.class}, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            MulLongNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                try {
                    return super.mul(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    try {
                        return super.mul(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulLongNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulObjectLongIntNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulObjectLongIntNode.class, new Class[]{MulLongLongIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            MulObjectLongIntNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.mulWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.mulWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulObjectLongIntNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulLongLongIntNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulLongLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{MulObjectLongIntNode.class}, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            MulLongLongIntNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                try {
                    return super.mul(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    try {
                        return super.mul(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulLongLongIntNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulObjectIntRubyBignumNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulObjectIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            MulObjectIntRubyBignumNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulObjectIntRubyBignumNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulDoubleIntDoubleNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulDoubleIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            MulDoubleIntDoubleNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulDoubleIntDoubleNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulObjectIntLong1Node
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulObjectIntLong1Node.class, new Class[]{MulObjectIntLong0Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            MulObjectIntLong1Node(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.mulWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.mulWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulObjectIntLong1Node((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulObjectIntLong0Node
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulObjectIntLong0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{MulObjectIntLong1Node.class}, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            MulObjectIntLong0Node(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                try {
                    return super.mul(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    try {
                        return super.mul(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulObjectIntLong0Node((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulLongIntIntNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulLongIntIntNode.class, new Class[]{MulIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            MulLongIntIntNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.mulWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.mulWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulLongIntIntNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulIntNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{MulLongIntIntNode.class}, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            MulIntNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                try {
                    return super.mul(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    try {
                        return super.mul(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(FixnumNodes.MulNode current2) {
                return new MulIntNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MulUninitializedNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MulUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MulUninitializedNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MulBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MulBaseNode rootNode = (MulBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MulBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.MulNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MulUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.MulNode.class)
        private static abstract class MulBaseNode
        extends FixnumNodes.MulNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MulBaseNode next0;

            MulBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MulBaseNode(MulBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                MulBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MulBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MulUninitializedNode(this);
                    ((MulUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MulBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MulBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MulBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MulUninitializedNode(this), (Node)new MulPolymorphicNode(this), (DSLNode)((MulBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MulBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)MulIntNode.METADATA)) {
                            return (MulBaseNode)MulIntNode.create0(this);
                        }
                        return (MulBaseNode)MulLongIntIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)MulObjectIntLong0Node.METADATA)) {
                            return (MulBaseNode)MulObjectIntLong0Node.create0(this);
                        }
                        return (MulBaseNode)MulObjectIntLong1Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (MulBaseNode)MulDoubleIntDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (MulBaseNode)MulObjectIntRubyBignumNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)MulLongLongIntNode.METADATA)) {
                            return (MulBaseNode)MulLongLongIntNode.create0(this);
                        }
                        return (MulBaseNode)MulObjectLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)MulLongNode.METADATA)) {
                            return (MulBaseNode)MulLongNode.create0(this);
                        }
                        return (MulBaseNode)MulObjectLongLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (MulBaseNode)MulDoubleLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (MulBaseNode)MulObjectLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MulBaseNode otherCast = (MulBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MulBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.SubNode.class)
    public static final class SubNodeFactory
    extends NodeFactoryBase<FixnumNodes.SubNode> {
        private static SubNodeFactory subNodeFactoryInstance;

        private SubNodeFactory() {
            super(FixnumNodes.SubNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.SubNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SubNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.SubNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SubUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.SubNode> getInstance() {
            if (subNodeFactoryInstance == null) {
                subNodeFactoryInstance = new SubNodeFactory();
            }
            return subNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SubPolymorphicNode
        extends SubBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SubPolymorphicNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubObjectLongRubyBignumNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubObjectLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            SubObjectLongRubyBignumNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubObjectLongRubyBignumNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubDoubleLongDoubleNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubDoubleLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            SubDoubleLongDoubleNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubDoubleLongDoubleNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubObjectLongLongNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubObjectLongLongNode.class, new Class[]{SubLongNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            SubObjectLongLongNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.subWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.subWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubObjectLongLongNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubLongNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{SubObjectLongLongNode.class}, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            SubLongNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                try {
                    return super.sub(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    try {
                        return super.sub(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubLongNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubObjectLongIntNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubObjectLongIntNode.class, new Class[]{SubLongLongIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            SubObjectLongIntNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.subWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.subWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubObjectLongIntNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubLongLongIntNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubLongLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{SubObjectLongIntNode.class}, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            SubLongLongIntNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                try {
                    return super.sub(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    try {
                        return super.sub(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubLongLongIntNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubDoubleIntDoubleNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubDoubleIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            SubDoubleIntDoubleNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubDoubleIntDoubleNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubObjectIntRubyBignumNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubObjectIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            SubObjectIntRubyBignumNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubObjectIntRubyBignumNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubObjectIntLongNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubObjectIntLongNode.class, new Class[]{SubLongIntLongNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            SubObjectIntLongNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.subWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.subWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubObjectIntLongNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubLongIntLongNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubLongIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{SubObjectIntLongNode.class}, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            SubLongIntLongNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                try {
                    return super.sub(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    try {
                        return super.sub(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubLongIntLongNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubLongIntIntNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubLongIntIntNode.class, new Class[]{SubIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            SubLongIntIntNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.subWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.subWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubLongIntIntNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubIntNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{SubLongIntIntNode.class}, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            SubIntNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                try {
                    return super.sub(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    try {
                        return super.sub(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(FixnumNodes.SubNode current2) {
                return new SubIntNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SubUninitializedNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SubUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SubUninitializedNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SubBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SubBaseNode rootNode = (SubBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SubBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.SubNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SubUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.SubNode.class)
        private static abstract class SubBaseNode
        extends FixnumNodes.SubNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SubBaseNode next0;

            SubBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SubBaseNode(SubBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                SubBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SubBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SubUninitializedNode(this);
                    ((SubUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SubBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SubBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SubBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SubUninitializedNode(this), (Node)new SubPolymorphicNode(this), (DSLNode)((SubBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SubBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)SubIntNode.METADATA)) {
                            return (SubBaseNode)SubIntNode.create0(this);
                        }
                        return (SubBaseNode)SubLongIntIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)SubLongIntLongNode.METADATA)) {
                            return (SubBaseNode)SubLongIntLongNode.create0(this);
                        }
                        return (SubBaseNode)SubObjectIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (SubBaseNode)SubObjectIntRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (SubBaseNode)SubDoubleIntDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)SubLongLongIntNode.METADATA)) {
                            return (SubBaseNode)SubLongLongIntNode.create0(this);
                        }
                        return (SubBaseNode)SubObjectLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)SubLongNode.METADATA)) {
                            return (SubBaseNode)SubLongNode.create0(this);
                        }
                        return (SubBaseNode)SubObjectLongLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (SubBaseNode)SubDoubleLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (SubBaseNode)SubObjectLongRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SubBaseNode otherCast = (SubBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SubBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<FixnumNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(FixnumNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AddNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AddUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AddPolymorphicNode
        extends AddBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AddPolymorphicNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddObjectLongRubyBasicObjectNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddObjectLongRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBasicObject.class}, 0, 0);

            AddObjectLongRubyBasicObjectNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (super.isRational(arguments1Value)) {
                    return super.add(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isRational] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (super.isRational(arguments1ValueCast)) {
                        return super.add(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddObjectLongRubyBasicObjectNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddObjectLongRubyBignumNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddObjectLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            AddObjectLongRubyBignumNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddObjectLongRubyBignumNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddDoubleLongDoubleNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddDoubleLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            AddDoubleLongDoubleNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddDoubleLongDoubleNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddObjectLongLongNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddObjectLongLongNode.class, new Class[]{AddLongNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            AddObjectLongLongNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.addWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.addWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddObjectLongLongNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddLongNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{AddObjectLongLongNode.class}, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            AddLongNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                try {
                    return super.add(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    try {
                        return super.add(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddLongNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddObjectLongIntNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddObjectLongIntNode.class, new Class[]{AddLongLongIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            AddObjectLongIntNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.addWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.addWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddObjectLongIntNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddLongLongIntNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddLongLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{AddObjectLongIntNode.class}, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            AddLongLongIntNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                try {
                    return super.add(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    try {
                        return super.add(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddLongLongIntNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddObjectIntRubyBasicObjectNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddObjectIntRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBasicObject.class}, 0, 0);

            AddObjectIntRubyBasicObjectNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (super.isRational(arguments1Value)) {
                    return super.add(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isRational] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (super.isRational(arguments1ValueCast)) {
                        return super.add(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddObjectIntRubyBasicObjectNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddObjectIntRubyBignumNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddObjectIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            AddObjectIntRubyBignumNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddObjectIntRubyBignumNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddObjectIntLongNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddObjectIntLongNode.class, new Class[]{AddLongIntLongNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            AddObjectIntLongNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.addWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.addWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddObjectIntLongNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddLongIntLongNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddLongIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{AddObjectIntLongNode.class}, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            AddLongIntLongNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                try {
                    return super.add(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    try {
                        return super.add(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddLongIntLongNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddDoubleIntDoubleNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddDoubleIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            AddDoubleIntDoubleNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddDoubleIntDoubleNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddLongIntIntNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddLongIntIntNode.class, new Class[]{AddIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            AddLongIntIntNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.addWithOverflow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.addWithOverflow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddLongIntIntNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddIntNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{AddLongIntIntNode.class}, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            AddIntNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                try {
                    return super.add(arguments0Value, arguments1Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    try {
                        return super.add(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(FixnumNodes.AddNode current2) {
                return new AddIntNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AddUninitializedNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AddUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AddUninitializedNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AddBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AddBaseNode rootNode = (AddBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AddBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FixnumNodes.AddNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AddUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.AddNode.class)
        private static abstract class AddBaseNode
        extends FixnumNodes.AddNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AddBaseNode next0;

            AddBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AddBaseNode(AddBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                AddBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AddBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AddUninitializedNode(this);
                    ((AddUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AddBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = AddBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (AddBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AddUninitializedNode(this), (Node)new AddPolymorphicNode(this), (DSLNode)((AddBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AddBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                RubyBasicObject arguments1ValueCast;
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)AddIntNode.METADATA)) {
                            return (AddBaseNode)AddIntNode.create0(this);
                        }
                        return (AddBaseNode)AddLongIntIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (AddBaseNode)AddDoubleIntDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)AddLongIntLongNode.METADATA)) {
                            return (AddBaseNode)AddLongIntLongNode.create0(this);
                        }
                        return (AddBaseNode)AddObjectIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (AddBaseNode)AddObjectIntRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && super.isRational(arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value))) {
                        return (AddBaseNode)AddObjectIntRubyBasicObjectNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)AddLongLongIntNode.METADATA)) {
                            return (AddBaseNode)AddLongLongIntNode.create0(this);
                        }
                        return (AddBaseNode)AddObjectLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)AddLongNode.METADATA)) {
                            return (AddBaseNode)AddLongNode.create0(this);
                        }
                        return (AddBaseNode)AddObjectLongLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (AddBaseNode)AddDoubleLongDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (AddBaseNode)AddObjectLongRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && super.isRational(arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value))) {
                        return (AddBaseNode)AddObjectLongRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AddBaseNode otherCast = (AddBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AddBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FixnumNodes.NegNode.class)
    public static final class NegNodeFactory
    extends NodeFactoryBase<FixnumNodes.NegNode> {
        private static NegNodeFactory negNodeFactoryInstance;

        private NegNodeFactory() {
            super(FixnumNodes.NegNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FixnumNodes.NegNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NegNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FixnumNodes.NegNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NegUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FixnumNodes.NegNode> getInstance() {
            if (negNodeFactoryInstance == null) {
                negNodeFactoryInstance = new NegNodeFactory();
            }
            return negNodeFactoryInstance;
        }

        @GeneratedBy(value=FixnumNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NegPolymorphicNode
        extends NegBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            NegPolymorphicNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FixnumNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NegRubyBignumLongNode
        extends NegBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NegRubyBignumLongNode.class, new Class[]{NegLongNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            NegRubyBignumLongNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long"));
                }
                return super.negWithOverflow(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.negWithOverflow(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.NegNode create0(FixnumNodes.NegNode current2) {
                return new NegRubyBignumLongNode((NegBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NegLongNode
        extends NegBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NegLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{NegRubyBignumLongNode.class}, new Class[]{Long.TYPE}, 0, 0);

            NegLongNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long"));
                }
                try {
                    return super.neg(arguments0Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    try {
                        return super.neg(arguments0ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.NegNode create0(FixnumNodes.NegNode current2) {
                return new NegLongNode((NegBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NegLongIntNode
        extends NegBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NegLongIntNode.class, new Class[]{NegIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            NegLongIntNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int"));
                }
                return super.negWithOverflow(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.negWithOverflow(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.NegNode create0(FixnumNodes.NegNode current2) {
                return new NegLongIntNode((NegBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NegIntNode
        extends NegBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NegIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{NegLongIntNode.class}, new Class[]{Integer.TYPE}, 0, 0);

            NegIntNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int"));
                }
                try {
                    return super.neg(arguments0Value);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, "Thrown ArithmeticException"));
                }
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    try {
                        return super.neg(arguments0ValueCast);
                    }
                    catch (ArithmeticException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, "Thrown ArithmeticException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.NegNode create0(FixnumNodes.NegNode current2) {
                return new NegIntNode((NegBaseNode)current2);
            }
        }

        @GeneratedBy(value=FixnumNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NegUninitializedNode
        extends NegBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NegUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NegUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            NegUninitializedNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                NegBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NegBaseNode rootNode = (NegBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((NegBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FixnumNodes.NegNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NegUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FixnumNodes.NegNode.class)
        private static abstract class NegBaseNode
        extends FixnumNodes.NegNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected NegBaseNode next0;

            NegBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            NegBaseNode(NegBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                NegBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NegBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new NegUninitializedNode(this);
                    ((NegUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (NegBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = NegBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (NegBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NegUninitializedNode(this), (Node)new NegPolymorphicNode(this), (DSLNode)((NegBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NegBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (!DSLShare.isExcluded((Node)this, (DSLMetadata)NegIntNode.METADATA)) {
                        return (NegBaseNode)NegIntNode.create0(this);
                    }
                    return (NegBaseNode)NegLongIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (!DSLShare.isExcluded((Node)this, (DSLMetadata)NegLongNode.METADATA)) {
                        return (NegBaseNode)NegLongNode.create0(this);
                    }
                    return (NegBaseNode)NegRubyBignumLongNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((NegBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (NegBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

