/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=EncodingNodes.class)
public final class EncodingNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(CompatibleQueryNodeFactory.getInstance(), DefaultExternalNodeFactory.getInstance(), DefaultInternalNodeFactory.getInstance(), SetDefaultExternalNodeFactory.getInstance(), SetDefaultInternalNodeFactory.getInstance(), FindNodeFactory.getInstance(), NameListNodeFactory.getInstance(), ListNodeFactory.getInstance(), DummyNodeFactory.getInstance(), ToSNodeFactory.getInstance(), InspectNodeFactory.getInstance());
    }

    @GeneratedBy(value=EncodingNodes.InspectNode.class)
    public static final class InspectNodeFactory
    extends NodeFactoryBase<EncodingNodes.InspectNode> {
        private static InspectNodeFactory inspectNodeFactoryInstance;

        private InspectNodeFactory() {
            super(EncodingNodes.InspectNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.InspectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InspectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.InspectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InspectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.InspectNode> getInstance() {
            if (inspectNodeFactoryInstance == null) {
                inspectNodeFactoryInstance = new InspectNodeFactory();
            }
            return inspectNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InspectPolymorphicNode
        extends InspectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            InspectPolymorphicNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=EncodingNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InspectRubyEncodingNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectRubyEncodingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyEncoding.class}, 0, 0);

            InspectRubyEncodingNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyEncoding");
                }
                return super.toS(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value)) {
                    RubyEncoding arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments0Value);
                    return super.toS(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.InspectNode create0(EncodingNodes.InspectNode current2) {
                return new InspectRubyEncodingNode((InspectBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InspectUninitializedNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InspectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InspectUninitializedNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InspectBaseNode rootNode = (InspectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InspectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.InspectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InspectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.InspectNode.class)
        private static abstract class InspectBaseNode
        extends EncodingNodes.InspectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InspectBaseNode next0;

            InspectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InspectBaseNode(InspectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                InspectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new InspectUninitializedNode(this);
                    ((InspectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InspectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InspectBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (InspectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InspectUninitializedNode(this), (Node)new InspectPolymorphicNode(this), (DSLNode)((InspectBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InspectBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value)) {
                    return (InspectBaseNode)InspectRubyEncodingNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((InspectBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (InspectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<EncodingNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(EncodingNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSPolymorphicNode
        extends ToSBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSPolymorphicNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=EncodingNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSRubyEncodingNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSRubyEncodingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyEncoding.class}, 0, 0);

            ToSRubyEncodingNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyEncoding");
                }
                return super.toS(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value)) {
                    RubyEncoding arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments0Value);
                    return super.toS(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.ToSNode create0(EncodingNodes.ToSNode current2) {
                return new ToSRubyEncodingNode((ToSBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSUninitializedNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSUninitializedNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSBaseNode rootNode = (ToSBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends EncodingNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSBaseNode next0;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSBaseNode(ToSBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToSBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSUninitializedNode(this);
                    ((ToSUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToSBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ToSBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSUninitializedNode(this), (Node)new ToSPolymorphicNode(this), (DSLNode)((ToSBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value)) {
                    return (ToSBaseNode)ToSRubyEncodingNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DummyNode.class)
    public static final class DummyNodeFactory
    extends NodeFactoryBase<EncodingNodes.DummyNode> {
        private static DummyNodeFactory dummyNodeFactoryInstance;

        private DummyNodeFactory() {
            super(EncodingNodes.DummyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.DummyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DummyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.DummyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DummyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.DummyNode> getInstance() {
            if (dummyNodeFactoryInstance == null) {
                dummyNodeFactoryInstance = new DummyNodeFactory();
            }
            return dummyNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.DummyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DummyPolymorphicNode
        extends DummyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DummyPolymorphicNode(DummyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=EncodingNodes.DummyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DummyRubyEncodingNode
        extends DummyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DummyRubyEncodingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyEncoding.class}, 0, 0);

            DummyRubyEncodingNode(DummyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyEncoding");
                }
                return super.isDummy(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value)) {
                    RubyEncoding arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments0Value);
                    return super.isDummy(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.DummyNode create0(EncodingNodes.DummyNode current2) {
                return new DummyRubyEncodingNode((DummyBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingNodes.DummyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DummyUninitializedNode
        extends DummyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DummyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DummyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DummyUninitializedNode(DummyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DummyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DummyBaseNode rootNode = (DummyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DummyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.DummyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DummyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.DummyNode.class)
        private static abstract class DummyBaseNode
        extends EncodingNodes.DummyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DummyBaseNode next0;

            DummyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DummyBaseNode(DummyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                DummyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DummyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DummyUninitializedNode(this);
                    ((DummyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DummyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DummyBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (DummyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DummyUninitializedNode(this), (Node)new DummyPolymorphicNode(this), (DSLNode)((DummyBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DummyBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value)) {
                    return (DummyBaseNode)DummyRubyEncodingNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DummyBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DummyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ListNode.class)
    public static final class ListNodeFactory
    extends NodeFactoryBase<EncodingNodes.ListNode> {
        private static ListNodeFactory listNodeFactoryInstance;

        private ListNodeFactory() {
            super(EncodingNodes.ListNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.ListNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ListNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.ListNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ListDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.ListNode> getInstance() {
            if (listNodeFactoryInstance == null) {
                listNodeFactoryInstance = new ListNodeFactory();
            }
            return listNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.ListNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ListDefaultNode
        extends ListBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ListDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            ListDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.list();
            }

            static EncodingNodes.ListNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ListDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.ListNode.class)
        private static abstract class ListBaseNode
        extends EncodingNodes.ListNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            ListBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.NameListNode.class)
    public static final class NameListNodeFactory
    extends NodeFactoryBase<EncodingNodes.NameListNode> {
        private static NameListNodeFactory nameListNodeFactoryInstance;

        private NameListNodeFactory() {
            super(EncodingNodes.NameListNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.NameListNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NameListNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.NameListNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NameListDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.NameListNode> getInstance() {
            if (nameListNodeFactoryInstance == null) {
                nameListNodeFactoryInstance = new NameListNodeFactory();
            }
            return nameListNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.NameListNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NameListDefaultNode
        extends NameListBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameListDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            NameListDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.find();
            }

            static EncodingNodes.NameListNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NameListDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.NameListNode.class)
        private static abstract class NameListBaseNode
        extends EncodingNodes.NameListNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            NameListBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.FindNode.class)
    public static final class FindNodeFactory
    extends NodeFactoryBase<EncodingNodes.FindNode> {
        private static FindNodeFactory findNodeFactoryInstance;

        private FindNodeFactory() {
            super(EncodingNodes.FindNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.FindNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FindNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.FindNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FindUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.FindNode> getInstance() {
            if (findNodeFactoryInstance == null) {
                findNodeFactoryInstance = new FindNodeFactory();
            }
            return findNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.FindNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FindPolymorphicNode
        extends FindBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            FindPolymorphicNode(FindBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=EncodingNodes.FindNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FindRubyStringNode
        extends FindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FindRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            FindRubyStringNode(FindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.find(arguments0Value);
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.find(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.FindNode create0(EncodingNodes.FindNode current2) {
                return new FindRubyStringNode((FindBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingNodes.FindNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FindUninitializedNode
        extends FindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FindUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FindUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FindUninitializedNode(FindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyEncoding executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                FindBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FindBaseNode rootNode = (FindBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((FindBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.FindNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FindUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.FindNode.class)
        private static abstract class FindBaseNode
        extends EncodingNodes.FindNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FindBaseNode next0;

            FindBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FindBaseNode(FindBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyEncoding executeChained0(VirtualFrame var1, Object var2);

            protected final RubyEncoding rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                FindBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FindBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new FindUninitializedNode(this);
                    ((FindUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (FindBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = FindBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (FindBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FindUninitializedNode(this), (Node)new FindPolymorphicNode(this), (DSLNode)((FindBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FindBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (FindBaseNode)FindRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((FindBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (FindBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
    public static final class SetDefaultInternalNodeFactory
    extends NodeFactoryBase<EncodingNodes.SetDefaultInternalNode> {
        private static SetDefaultInternalNodeFactory setDefaultInternalNodeFactoryInstance;

        private SetDefaultInternalNodeFactory() {
            super(EncodingNodes.SetDefaultInternalNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.SetDefaultInternalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetDefaultInternalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.SetDefaultInternalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SetDefaultInternalUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.SetDefaultInternalNode> getInstance() {
            if (setDefaultInternalNodeFactoryInstance == null) {
                setDefaultInternalNodeFactoryInstance = new SetDefaultInternalNodeFactory();
            }
            return setDefaultInternalNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetDefaultInternalPolymorphicNode
        extends SetDefaultInternalBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SetDefaultInternalPolymorphicNode(SetDefaultInternalBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyNilClass.class ? this.arguments[0].executeRubyNilClass(frameValue) : (this.arguments0PolymorphicType == RubyEncoding.class ? this.arguments[0].executeRubyEncoding(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetDefaultInternalRubyNilClassNode
        extends SetDefaultInternalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultInternalRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyNilClass.class}, 0, 0);

            SetDefaultInternalRubyNilClassNode(SetDefaultInternalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyNilClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyNilClass"));
                }
                return super.defaultExternal(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyNilClass(arguments0Value)) {
                    RubyNilClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(arguments0Value);
                    return super.defaultExternal(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.SetDefaultInternalNode create0(EncodingNodes.SetDefaultInternalNode current2) {
                return new SetDefaultInternalRubyNilClassNode((SetDefaultInternalBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetDefaultInternalRubyEncodingNode
        extends SetDefaultInternalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultInternalRubyEncodingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyEncoding.class}, 0, 0);

            SetDefaultInternalRubyEncodingNode(SetDefaultInternalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyEncoding(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyEncoding"));
                }
                return super.defaultExternal(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value)) {
                    RubyEncoding arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments0Value);
                    return super.defaultExternal(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.SetDefaultInternalNode create0(EncodingNodes.SetDefaultInternalNode current2) {
                return new SetDefaultInternalRubyEncodingNode((SetDefaultInternalBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetDefaultInternalUninitializedNode
        extends SetDefaultInternalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultInternalUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetDefaultInternalUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SetDefaultInternalUninitializedNode(SetDefaultInternalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SetDefaultInternalBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetDefaultInternalBaseNode rootNode = (SetDefaultInternalBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetDefaultInternalBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.SetDefaultInternalNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SetDefaultInternalUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
        private static abstract class SetDefaultInternalBaseNode
        extends EncodingNodes.SetDefaultInternalNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SetDefaultInternalBaseNode next0;

            SetDefaultInternalBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SetDefaultInternalBaseNode(SetDefaultInternalBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SetDefaultInternalBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetDefaultInternalBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SetDefaultInternalUninitializedNode(this);
                    ((SetDefaultInternalUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetDefaultInternalBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SetDefaultInternalBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SetDefaultInternalBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetDefaultInternalUninitializedNode(this), (Node)new SetDefaultInternalPolymorphicNode(this), (DSLNode)((SetDefaultInternalBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetDefaultInternalBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value)) {
                    return (SetDefaultInternalBaseNode)SetDefaultInternalRubyEncodingNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyNilClass(arguments0Value)) {
                    return (SetDefaultInternalBaseNode)SetDefaultInternalRubyNilClassNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SetDefaultInternalBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SetDefaultInternalBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
    public static final class SetDefaultExternalNodeFactory
    extends NodeFactoryBase<EncodingNodes.SetDefaultExternalNode> {
        private static SetDefaultExternalNodeFactory setDefaultExternalNodeFactoryInstance;

        private SetDefaultExternalNodeFactory() {
            super(EncodingNodes.SetDefaultExternalNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.SetDefaultExternalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetDefaultExternalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.SetDefaultExternalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SetDefaultExternalUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.SetDefaultExternalNode> getInstance() {
            if (setDefaultExternalNodeFactoryInstance == null) {
                setDefaultExternalNodeFactoryInstance = new SetDefaultExternalNodeFactory();
            }
            return setDefaultExternalNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetDefaultExternalPolymorphicNode
        extends SetDefaultExternalBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SetDefaultExternalPolymorphicNode(SetDefaultExternalBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetDefaultExternalRubyEncodingNode
        extends SetDefaultExternalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultExternalRubyEncodingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyEncoding.class}, 0, 0);

            SetDefaultExternalRubyEncodingNode(SetDefaultExternalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyEncoding arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyEncoding");
                }
                return super.defaultExternal(arguments0Value);
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value)) {
                    RubyEncoding arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments0Value);
                    return super.defaultExternal(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.SetDefaultExternalNode create0(EncodingNodes.SetDefaultExternalNode current2) {
                return new SetDefaultExternalRubyEncodingNode((SetDefaultExternalBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetDefaultExternalUninitializedNode
        extends SetDefaultExternalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetDefaultExternalUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetDefaultExternalUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SetDefaultExternalUninitializedNode(SetDefaultExternalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyEncoding executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyEncoding executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SetDefaultExternalBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetDefaultExternalBaseNode rootNode = (SetDefaultExternalBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetDefaultExternalBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static EncodingNodes.SetDefaultExternalNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SetDefaultExternalUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
        private static abstract class SetDefaultExternalBaseNode
        extends EncodingNodes.SetDefaultExternalNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SetDefaultExternalBaseNode next0;

            SetDefaultExternalBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SetDefaultExternalBaseNode(SetDefaultExternalBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyEncoding executeChained0(VirtualFrame var1, Object var2);

            protected final RubyEncoding rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SetDefaultExternalBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetDefaultExternalBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SetDefaultExternalUninitializedNode(this);
                    ((SetDefaultExternalUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetDefaultExternalBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SetDefaultExternalBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SetDefaultExternalBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetDefaultExternalUninitializedNode(this), (Node)new SetDefaultExternalPolymorphicNode(this), (DSLNode)((SetDefaultExternalBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetDefaultExternalBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value)) {
                    return (SetDefaultExternalBaseNode)SetDefaultExternalRubyEncodingNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SetDefaultExternalBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SetDefaultExternalBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DefaultInternalNode.class)
    public static final class DefaultInternalNodeFactory
    extends NodeFactoryBase<EncodingNodes.DefaultInternalNode> {
        private static DefaultInternalNodeFactory defaultInternalNodeFactoryInstance;

        private DefaultInternalNodeFactory() {
            super(EncodingNodes.DefaultInternalNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.DefaultInternalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DefaultInternalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.DefaultInternalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DefaultInternalDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.DefaultInternalNode> getInstance() {
            if (defaultInternalNodeFactoryInstance == null) {
                defaultInternalNodeFactoryInstance = new DefaultInternalNodeFactory();
            }
            return defaultInternalNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.DefaultInternalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefaultInternalDefaultNode
        extends DefaultInternalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefaultInternalDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            DefaultInternalDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.defaultInternal();
            }

            static EncodingNodes.DefaultInternalNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DefaultInternalDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.DefaultInternalNode.class)
        private static abstract class DefaultInternalBaseNode
        extends EncodingNodes.DefaultInternalNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            DefaultInternalBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DefaultExternalNode.class)
    public static final class DefaultExternalNodeFactory
    extends NodeFactoryBase<EncodingNodes.DefaultExternalNode> {
        private static DefaultExternalNodeFactory defaultExternalNodeFactoryInstance;

        private DefaultExternalNodeFactory() {
            super(EncodingNodes.DefaultExternalNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.DefaultExternalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DefaultExternalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.DefaultExternalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DefaultExternalDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.DefaultExternalNode> getInstance() {
            if (defaultExternalNodeFactoryInstance == null) {
                defaultExternalNodeFactoryInstance = new DefaultExternalNodeFactory();
            }
            return defaultExternalNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.DefaultExternalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefaultExternalDefaultNode
        extends DefaultExternalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefaultExternalDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            DefaultExternalDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding value2;
                try {
                    value2 = this.executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyEncoding executeRubyEncoding(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.defaultExternal();
            }

            static EncodingNodes.DefaultExternalNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DefaultExternalDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.DefaultExternalNode.class)
        private static abstract class DefaultExternalBaseNode
        extends EncodingNodes.DefaultExternalNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            DefaultExternalBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
    public static final class CompatibleQueryNodeFactory
    extends NodeFactoryBase<EncodingNodes.CompatibleQueryNode> {
        private static CompatibleQueryNodeFactory compatibleQueryNodeFactoryInstance;

        private CompatibleQueryNodeFactory() {
            super(EncodingNodes.CompatibleQueryNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public EncodingNodes.CompatibleQueryNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompatibleQueryNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static EncodingNodes.CompatibleQueryNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompatibleQueryUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<EncodingNodes.CompatibleQueryNode> getInstance() {
            if (compatibleQueryNodeFactoryInstance == null) {
                compatibleQueryNodeFactoryInstance = new CompatibleQueryNodeFactory();
            }
            return compatibleQueryNodeFactoryInstance;
        }

        @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CompatibleQueryPolymorphicNode
        extends CompatibleQueryBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            CompatibleQueryPolymorphicNode(CompatibleQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyString.class ? this.arguments[0].executeRubyString(frameValue) : (this.arguments0PolymorphicType == RubyEncoding.class ? this.arguments[0].executeRubyEncoding(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubyEncoding.class ? this.arguments[1].executeRubyEncoding(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompatibleQueryRubyEncodingNode
        extends CompatibleQueryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompatibleQueryRubyEncodingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyEncoding.class, RubyEncoding.class}, 0, 0);

            CompatibleQueryRubyEncodingNode(CompatibleQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyEncoding arguments1Value;
                RubyEncoding arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyEncoding");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyEncoding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyEncoding");
                }
                return super.isCompatible(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value)) {
                    RubyEncoding arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments0Value);
                    RubyEncoding arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyEncoding(arguments1Value);
                    return super.isCompatible(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static EncodingNodes.CompatibleQueryNode create0(EncodingNodes.CompatibleQueryNode current2) {
                return new CompatibleQueryRubyEncodingNode((CompatibleQueryBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompatibleQueryRubyStringNode
        extends CompatibleQueryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompatibleQueryRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            CompatibleQueryRubyStringNode(CompatibleQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.isCompatible(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.isCompatible(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static EncodingNodes.CompatibleQueryNode create0(EncodingNodes.CompatibleQueryNode current2) {
                return new CompatibleQueryRubyStringNode((CompatibleQueryBaseNode)current2);
            }
        }

        @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompatibleQueryUninitializedNode
        extends CompatibleQueryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompatibleQueryUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompatibleQueryUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompatibleQueryUninitializedNode(CompatibleQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CompatibleQueryBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompatibleQueryBaseNode rootNode = (CompatibleQueryBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CompatibleQueryBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static EncodingNodes.CompatibleQueryNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompatibleQueryUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
        private static abstract class CompatibleQueryBaseNode
        extends EncodingNodes.CompatibleQueryNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompatibleQueryBaseNode next0;

            CompatibleQueryBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompatibleQueryBaseNode(CompatibleQueryBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                CompatibleQueryBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompatibleQueryBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CompatibleQueryUninitializedNode(this);
                    ((CompatibleQueryUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CompatibleQueryBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = CompatibleQueryBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CompatibleQueryBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CompatibleQueryUninitializedNode(this), (Node)new CompatibleQueryPolymorphicNode(this), (DSLNode)((CompatibleQueryBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompatibleQueryBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (CompatibleQueryBaseNode)CompatibleQueryRubyStringNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyEncoding(arguments1Value)) {
                    return (CompatibleQueryBaseNode)CompatibleQueryRubyEncodingNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CompatibleQueryBaseNode otherCast = (CompatibleQueryBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CompatibleQueryBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

