/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscoderDB;
import org.jruby.Ruby;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyEncodingConverter;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;

@CoreClass(name="Encoding::Converter")
public abstract class EncodingConverterNodes {

    @CoreMethod(names={"search_convpath"}, isModuleFunction=true, needsSelf=false, required=2)
    public static abstract class SearchConvPathNode
    extends CoreMethodNode {
        public SearchConvPathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SearchConvPathNode(SearchConvPathNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray searchConvpath(RubyString source2, RubyString destination) {
            SearchConvPathNode.notDesignedForCompilation();
            final Ruby runtime = this.getContext().getRuntime();
            final RubyNilClass nil = this.getContext().getCoreLibrary().getNilObject();
            ThreadContext context = runtime.getCurrentContext();
            final byte[][] encNames = new byte[][]{null, null};
            Encoding[] encs = new Encoding[]{null, null};
            int[] ecflags_p = new int[]{0};
            IRubyObject[] ecopts_p = new IRubyObject[]{context.nil};
            final Object[] convpath2 = new Object[]{this.getContext().getCoreLibrary().getNilObject()};
            EncodingUtils.econvArgs(context, new IRubyObject[]{this.getContext().toJRuby(source2), this.getContext().toJRuby(destination)}, encNames, encs, ecflags_p, ecopts_p);
            TranscoderDB.searchPath((byte[])encNames[0], (byte[])encNames[1], (TranscoderDB.SearchPathCallback)new TranscoderDB.SearchPathCallback(){

                public void call(byte[] source2, byte[] destination, int depth) {
                    RubyBasicObject v;
                    if (convpath2[0] == nil) {
                        convpath2[0] = new RubyArray(SearchConvPathNode.this.getContext().getCoreLibrary().getArrayClass(), null, 0);
                    }
                    if (EncodingUtils.DECORATOR_P(encNames[0], encNames[1])) {
                        v = new RubyString(SearchConvPathNode.this.getContext().getCoreLibrary().getStringClass(), new ByteList(encNames[2]));
                    } else {
                        Encoding sourceEncoding = runtime.getEncodingService().findEncodingOrAliasEntry(source2).getEncoding();
                        Encoding destinationEncoding = runtime.getEncodingService().findEncodingOrAliasEntry(destination).getEncoding();
                        v = new RubyArray(SearchConvPathNode.this.getContext().getCoreLibrary().getArrayClass(), new Object[]{RubyEncoding.getEncoding(destinationEncoding), RubyEncoding.getEncoding(sourceEncoding)}, 2);
                    }
                    ((RubyArray)convpath2[0]).slowPush(v);
                }
            });
            if (convpath2[0] == nil) {
                throw new UnsupportedOperationException();
            }
            return (RubyArray)convpath2[0];
        }
    }

    @CoreMethod(names={"initialize"}, required=2)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize(RubyEncodingConverter self2, RubyString source2, RubyString destination) {
            InitializeNode.notDesignedForCompilation();
            Ruby runtime = this.getContext().getRuntime();
            Encoding[] encs = new Encoding[]{null, null};
            byte[][] encNames = new byte[][]{null, null};
            int[] ecflags = new int[]{0};
            IRubyObject[] ecopts = new IRubyObject[]{runtime.getNil()};
            EncodingUtils.econvArgs(runtime.getCurrentContext(), new IRubyObject[]{this.getContext().toJRuby(source2), this.getContext().toJRuby(destination)}, encNames, encs, ecflags, ecopts);
            EConv econv = EncodingUtils.econvOpenOpts(runtime.getCurrentContext(), encNames[0], encNames[1], ecflags[0], ecopts[0]);
            if (econv == null) {
                throw new UnsupportedOperationException();
            }
            self2.setEConv(econv);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"convpath"})
    public static abstract class ConvPathNode
    extends CoreMethodNode {
        public ConvPathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConvPathNode(ConvPathNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray convpath(RubyEncodingConverter converter) {
            ConvPathNode.notDesignedForCompilation();
            Ruby runtime = this.getContext().getRuntime();
            EConv ec = converter.getEConv();
            Object[] result2 = new Object[ec.numTranscoders];
            int r = 0;
            for (int i2 = 0; i2 < ec.numTranscoders; ++i2) {
                RubyBasicObject v;
                Transcoder tr = ec.elements[i2].transcoding.transcoder;
                if (EncodingUtils.DECORATOR_P(tr.getSource(), tr.getDestination())) {
                    v = new RubyString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(tr.getDestination()));
                } else {
                    Encoding source2 = runtime.getEncodingService().findEncodingOrAliasEntry(tr.getSource()).getEncoding();
                    Encoding destination = runtime.getEncodingService().findEncodingOrAliasEntry(tr.getDestination()).getEncoding();
                    v = new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{RubyEncoding.getEncoding(source2), RubyEncoding.getEncoding(destination)}, 2);
                }
                result2[r++] = v;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), result2, result2.length);
        }
    }
}

