/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=BignumNodes.class)
public final class BignumNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(NegNodeFactory.getInstance(), AddNodeFactory.getInstance(), SubNodeFactory.getInstance(), MulNodeFactory.getInstance(), PowNodeFactory.getInstance(), DivNodeFactory.getInstance(), ModNodeFactory.getInstance(), LessNodeFactory.getInstance(), LessEqualNodeFactory.getInstance(), EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), GreaterEqualNodeFactory.getInstance(), GreaterNodeFactory.getInstance(), BitAndNodeFactory.getInstance(), BitOrNodeFactory.getInstance(), BitXOrNodeFactory.getInstance(), LeftShiftNodeFactory.getInstance(), RightShiftNodeFactory.getInstance(), AbsNodeFactory.getInstance(), DivModNodeFactory.getInstance(), EvenNodeFactory.getInstance(), HashNodeFactory.getInstance(), ToFNodeFactory.getInstance(), ToSNodeFactory.getInstance());
    }

    @GeneratedBy(value=BignumNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<BignumNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(BignumNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSPolymorphicNode
        extends ToSBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSPolymorphicNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=BignumNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSRubyBignumNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ToSRubyBignumNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.toS(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.toS(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.ToSNode create0(BignumNodes.ToSNode current2) {
                return new ToSRubyBignumNode((ToSBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSUninitializedNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSUninitializedNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSBaseNode rootNode = (ToSBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends BignumNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSBaseNode next0;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSBaseNode(ToSBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToSBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSUninitializedNode(this);
                    ((ToSUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToSBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ToSBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSUninitializedNode(this), (Node)new ToSPolymorphicNode(this), (DSLNode)((ToSBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ToSBaseNode)ToSRubyBignumNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.ToFNode.class)
    public static final class ToFNodeFactory
    extends NodeFactoryBase<BignumNodes.ToFNode> {
        private static ToFNodeFactory toFNodeFactoryInstance;

        private ToFNodeFactory() {
            super(BignumNodes.ToFNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.ToFNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToFNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.ToFNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToFUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.ToFNode> getInstance() {
            if (toFNodeFactoryInstance == null) {
                toFNodeFactoryInstance = new ToFNodeFactory();
            }
            return toFNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToFPolymorphicNode
        extends ToFBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToFPolymorphicNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=BignumNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToFRubyBignumNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ToFRubyBignumNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.toF(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.toF(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.ToFNode create0(BignumNodes.ToFNode current2) {
                return new ToFRubyBignumNode((ToFBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToFUninitializedNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToFUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToFUninitializedNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToFBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToFBaseNode rootNode = (ToFBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToFBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.ToFNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToFUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.ToFNode.class)
        private static abstract class ToFBaseNode
        extends BignumNodes.ToFNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToFBaseNode next0;

            ToFBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToFBaseNode(ToFBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToFBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToFBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToFUninitializedNode(this);
                    ((ToFUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToFBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToFBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ToFBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToFUninitializedNode(this), (Node)new ToFPolymorphicNode(this), (DSLNode)((ToFBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToFBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ToFBaseNode)ToFRubyBignumNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToFBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToFBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<BignumNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(BignumNodes.HashNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.HashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HashNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.HashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return HashUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class HashPolymorphicNode
        extends HashBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            HashPolymorphicNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=BignumNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HashRubyBignumNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            HashRubyBignumNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.hash(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.hash(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.HashNode create0(BignumNodes.HashNode current2) {
                return new HashRubyBignumNode((HashBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class HashUninitializedNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            HashUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            HashUninitializedNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                HashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    HashBaseNode rootNode = (HashBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((HashBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.HashNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new HashUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.HashNode.class)
        private static abstract class HashBaseNode
        extends BignumNodes.HashNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected HashBaseNode next0;

            HashBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            HashBaseNode(HashBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                HashBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                HashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new HashUninitializedNode(this);
                    ((HashUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (HashBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = HashBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (HashBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new HashUninitializedNode(this), (Node)new HashPolymorphicNode(this), (DSLNode)((HashBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final HashBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (HashBaseNode)HashRubyBignumNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((HashBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (HashBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.EvenNode.class)
    public static final class EvenNodeFactory
    extends NodeFactoryBase<BignumNodes.EvenNode> {
        private static EvenNodeFactory evenNodeFactoryInstance;

        private EvenNodeFactory() {
            super(BignumNodes.EvenNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.EvenNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EvenNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.EvenNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EvenUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.EvenNode> getInstance() {
            if (evenNodeFactoryInstance == null) {
                evenNodeFactoryInstance = new EvenNodeFactory();
            }
            return evenNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.EvenNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EvenPolymorphicNode
        extends EvenBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EvenPolymorphicNode(EvenBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=BignumNodes.EvenNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EvenRubyBignumNode
        extends EvenBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EvenRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            EvenRubyBignumNode(EvenBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.even(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.even(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.EvenNode create0(BignumNodes.EvenNode current2) {
                return new EvenRubyBignumNode((EvenBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.EvenNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EvenUninitializedNode
        extends EvenBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EvenUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EvenUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EvenUninitializedNode(EvenBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EvenBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EvenBaseNode rootNode = (EvenBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EvenBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.EvenNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EvenUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.EvenNode.class)
        private static abstract class EvenBaseNode
        extends BignumNodes.EvenNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EvenBaseNode next0;

            EvenBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EvenBaseNode(EvenBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                EvenBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EvenBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EvenUninitializedNode(this);
                    ((EvenUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EvenBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EvenBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (EvenBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EvenUninitializedNode(this), (Node)new EvenPolymorphicNode(this), (DSLNode)((EvenBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EvenBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (EvenBaseNode)EvenRubyBignumNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EvenBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EvenBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.DivModNode.class)
    public static final class DivModNodeFactory
    extends NodeFactoryBase<BignumNodes.DivModNode> {
        private static DivModNodeFactory divModNodeFactoryInstance;

        private DivModNodeFactory() {
            super(BignumNodes.DivModNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.DivModNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DivModNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.DivModNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DivModUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.DivModNode> getInstance() {
            if (divModNodeFactoryInstance == null) {
                divModNodeFactoryInstance = new DivModNodeFactory();
            }
            return divModNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DivModPolymorphicNode
        extends DivModBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DivModPolymorphicNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModRubyBignumNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            DivModRubyBignumNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.DivModNode create0(BignumNodes.DivModNode current2) {
                return new DivModRubyBignumNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModRubyBignumLongNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            DivModRubyBignumLongNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.DivModNode create0(BignumNodes.DivModNode current2) {
                return new DivModRubyBignumLongNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModRubyBignumIntNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            DivModRubyBignumIntNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.DivModNode create0(BignumNodes.DivModNode current2) {
                return new DivModRubyBignumIntNode((DivModBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DivModUninitializedNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DivModUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DivModUninitializedNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DivModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DivModBaseNode rootNode = (DivModBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DivModBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.DivModNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DivModUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.DivModNode.class)
        private static abstract class DivModBaseNode
        extends BignumNodes.DivModNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DivModBaseNode next0;

            DivModBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DivModBaseNode(DivModBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                DivModBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DivModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DivModUninitializedNode(this);
                    ((DivModUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DivModBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DivModBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DivModBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DivModUninitializedNode(this), (Node)new DivModPolymorphicNode(this), (DSLNode)((DivModBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DivModBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (DivModBaseNode)DivModRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (DivModBaseNode)DivModRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (DivModBaseNode)DivModRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DivModBaseNode otherCast = (DivModBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DivModBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.AbsNode.class)
    public static final class AbsNodeFactory
    extends NodeFactoryBase<BignumNodes.AbsNode> {
        private static AbsNodeFactory absNodeFactoryInstance;

        private AbsNodeFactory() {
            super(BignumNodes.AbsNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.AbsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AbsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.AbsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AbsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.AbsNode> getInstance() {
            if (absNodeFactoryInstance == null) {
                absNodeFactoryInstance = new AbsNodeFactory();
            }
            return absNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.AbsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AbsPolymorphicNode
        extends AbsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            AbsPolymorphicNode(AbsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyBignum executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=BignumNodes.AbsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AbsRubyBignumNode
        extends AbsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AbsRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            AbsRubyBignumNode(AbsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.abs(arguments0Value);
            }

            @Override
            protected RubyBignum executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.abs(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.AbsNode create0(BignumNodes.AbsNode current2) {
                return new AbsRubyBignumNode((AbsBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.AbsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AbsUninitializedNode
        extends AbsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AbsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AbsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AbsUninitializedNode(AbsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyBignum executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyBignum executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                AbsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AbsBaseNode rootNode = (AbsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AbsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.AbsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AbsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.AbsNode.class)
        private static abstract class AbsBaseNode
        extends BignumNodes.AbsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AbsBaseNode next0;

            AbsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AbsBaseNode(AbsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBignum executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBignum rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                AbsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AbsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new AbsUninitializedNode(this);
                    ((AbsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AbsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = AbsBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (AbsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AbsUninitializedNode(this), (Node)new AbsPolymorphicNode(this), (DSLNode)((AbsBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AbsBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (AbsBaseNode)AbsRubyBignumNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((AbsBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (AbsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.RightShiftNode.class)
    public static final class RightShiftNodeFactory
    extends NodeFactoryBase<BignumNodes.RightShiftNode> {
        private static RightShiftNodeFactory rightShiftNodeFactoryInstance;

        private RightShiftNodeFactory() {
            super(BignumNodes.RightShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.RightShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RightShiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.RightShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RightShiftUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.RightShiftNode> getInstance() {
            if (rightShiftNodeFactoryInstance == null) {
                rightShiftNodeFactoryInstance = new RightShiftNodeFactory();
            }
            return rightShiftNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.RightShiftNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RightShiftPolymorphicNode
        extends RightShiftBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RightShiftPolymorphicNode(RightShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.RightShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RightShiftRubyBignumNode
        extends RightShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RightShiftRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            RightShiftRubyBignumNode(RightShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.leftShift(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.leftShift(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.RightShiftNode create0(BignumNodes.RightShiftNode current2) {
                return new RightShiftRubyBignumNode((RightShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.RightShiftNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RightShiftUninitializedNode
        extends RightShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RightShiftUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RightShiftUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RightShiftUninitializedNode(RightShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RightShiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RightShiftBaseNode rootNode = (RightShiftBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RightShiftBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.RightShiftNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RightShiftUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.RightShiftNode.class)
        private static abstract class RightShiftBaseNode
        extends BignumNodes.RightShiftNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RightShiftBaseNode next0;

            RightShiftBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RightShiftBaseNode(RightShiftBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                RightShiftBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RightShiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RightShiftUninitializedNode(this);
                    ((RightShiftUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RightShiftBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = RightShiftBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (RightShiftBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RightShiftUninitializedNode(this), (Node)new RightShiftPolymorphicNode(this), (DSLNode)((RightShiftBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RightShiftBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (RightShiftBaseNode)RightShiftRubyBignumNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RightShiftBaseNode otherCast = (RightShiftBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RightShiftBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.LeftShiftNode.class)
    public static final class LeftShiftNodeFactory
    extends NodeFactoryBase<BignumNodes.LeftShiftNode> {
        private static LeftShiftNodeFactory leftShiftNodeFactoryInstance;

        private LeftShiftNodeFactory() {
            super(BignumNodes.LeftShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.LeftShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LeftShiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.LeftShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LeftShiftUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.LeftShiftNode> getInstance() {
            if (leftShiftNodeFactoryInstance == null) {
                leftShiftNodeFactoryInstance = new LeftShiftNodeFactory();
            }
            return leftShiftNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LeftShiftPolymorphicNode
        extends LeftShiftBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LeftShiftPolymorphicNode(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LeftShiftRubyBignumNode
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            LeftShiftRubyBignumNode(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.leftShift(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.leftShift(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LeftShiftNode create0(BignumNodes.LeftShiftNode current2) {
                return new LeftShiftRubyBignumNode((LeftShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.LeftShiftNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LeftShiftUninitializedNode
        extends LeftShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LeftShiftUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LeftShiftUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LeftShiftUninitializedNode(LeftShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LeftShiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LeftShiftBaseNode rootNode = (LeftShiftBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LeftShiftBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LeftShiftNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LeftShiftUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.LeftShiftNode.class)
        private static abstract class LeftShiftBaseNode
        extends BignumNodes.LeftShiftNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LeftShiftBaseNode next0;

            LeftShiftBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LeftShiftBaseNode(LeftShiftBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                LeftShiftBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LeftShiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LeftShiftUninitializedNode(this);
                    ((LeftShiftUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LeftShiftBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = LeftShiftBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (LeftShiftBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LeftShiftUninitializedNode(this), (Node)new LeftShiftPolymorphicNode(this), (DSLNode)((LeftShiftBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LeftShiftBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (LeftShiftBaseNode)LeftShiftRubyBignumNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LeftShiftBaseNode otherCast = (LeftShiftBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LeftShiftBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.BitXOrNode.class)
    public static final class BitXOrNodeFactory
    extends NodeFactoryBase<BignumNodes.BitXOrNode> {
        private static BitXOrNodeFactory bitXOrNodeFactoryInstance;

        private BitXOrNodeFactory() {
            super(BignumNodes.BitXOrNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.BitXOrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitXOrNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.BitXOrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BitXOrUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.BitXOrNode> getInstance() {
            if (bitXOrNodeFactoryInstance == null) {
                bitXOrNodeFactoryInstance = new BitXOrNodeFactory();
            }
            return bitXOrNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BitXOrPolymorphicNode
        extends BitXOrBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            BitXOrPolymorphicNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitXOrRubyBignumNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            BitXOrRubyBignumNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.bitXOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.bitXOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitXOrNode create0(BignumNodes.BitXOrNode current2) {
                return new BitXOrRubyBignumNode((BitXOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitXOrRubyBignumLongNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            BitXOrRubyBignumLongNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.bitXOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.bitXOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitXOrNode create0(BignumNodes.BitXOrNode current2) {
                return new BitXOrRubyBignumLongNode((BitXOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitXOrRubyBignumIntNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            BitXOrRubyBignumIntNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.bitXOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.bitXOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitXOrNode create0(BignumNodes.BitXOrNode current2) {
                return new BitXOrRubyBignumIntNode((BitXOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.BitXOrNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BitXOrUninitializedNode
        extends BitXOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitXOrUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BitXOrUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BitXOrUninitializedNode(BitXOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                BitXOrBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BitXOrBaseNode rootNode = (BitXOrBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BitXOrBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitXOrNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BitXOrUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.BitXOrNode.class)
        private static abstract class BitXOrBaseNode
        extends BignumNodes.BitXOrNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BitXOrBaseNode next0;

            BitXOrBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BitXOrBaseNode(BitXOrBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                BitXOrBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BitXOrBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new BitXOrUninitializedNode(this);
                    ((BitXOrUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BitXOrBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = BitXOrBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (BitXOrBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BitXOrUninitializedNode(this), (Node)new BitXOrPolymorphicNode(this), (DSLNode)((BitXOrBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BitXOrBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (BitXOrBaseNode)BitXOrRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (BitXOrBaseNode)BitXOrRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (BitXOrBaseNode)BitXOrRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    BitXOrBaseNode otherCast = (BitXOrBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (BitXOrBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.BitOrNode.class)
    public static final class BitOrNodeFactory
    extends NodeFactoryBase<BignumNodes.BitOrNode> {
        private static BitOrNodeFactory bitOrNodeFactoryInstance;

        private BitOrNodeFactory() {
            super(BignumNodes.BitOrNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.BitOrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitOrNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.BitOrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BitOrUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.BitOrNode> getInstance() {
            if (bitOrNodeFactoryInstance == null) {
                bitOrNodeFactoryInstance = new BitOrNodeFactory();
            }
            return bitOrNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BitOrPolymorphicNode
        extends BitOrBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            BitOrPolymorphicNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitOrRubyBignumNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            BitOrRubyBignumNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.bitOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.bitOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitOrNode create0(BignumNodes.BitOrNode current2) {
                return new BitOrRubyBignumNode((BitOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitOrRubyBignumLongNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            BitOrRubyBignumLongNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.bitOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.bitOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitOrNode create0(BignumNodes.BitOrNode current2) {
                return new BitOrRubyBignumLongNode((BitOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitOrRubyBignumIntNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            BitOrRubyBignumIntNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.bitOr(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.bitOr(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitOrNode create0(BignumNodes.BitOrNode current2) {
                return new BitOrRubyBignumIntNode((BitOrBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.BitOrNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BitOrUninitializedNode
        extends BitOrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitOrUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BitOrUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BitOrUninitializedNode(BitOrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                BitOrBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BitOrBaseNode rootNode = (BitOrBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BitOrBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitOrNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BitOrUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.BitOrNode.class)
        private static abstract class BitOrBaseNode
        extends BignumNodes.BitOrNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BitOrBaseNode next0;

            BitOrBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BitOrBaseNode(BitOrBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                BitOrBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BitOrBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new BitOrUninitializedNode(this);
                    ((BitOrUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BitOrBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = BitOrBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (BitOrBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BitOrUninitializedNode(this), (Node)new BitOrPolymorphicNode(this), (DSLNode)((BitOrBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BitOrBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (BitOrBaseNode)BitOrRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (BitOrBaseNode)BitOrRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (BitOrBaseNode)BitOrRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    BitOrBaseNode otherCast = (BitOrBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (BitOrBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.BitAndNode.class)
    public static final class BitAndNodeFactory
    extends NodeFactoryBase<BignumNodes.BitAndNode> {
        private static BitAndNodeFactory bitAndNodeFactoryInstance;

        private BitAndNodeFactory() {
            super(BignumNodes.BitAndNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.BitAndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BitAndNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.BitAndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BitAndUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.BitAndNode> getInstance() {
            if (bitAndNodeFactoryInstance == null) {
                bitAndNodeFactoryInstance = new BitAndNodeFactory();
            }
            return bitAndNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BitAndPolymorphicNode
        extends BitAndBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            BitAndPolymorphicNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitAndRubyBignumNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            BitAndRubyBignumNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.bitAnd(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.bitAnd(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitAndNode create0(BignumNodes.BitAndNode current2) {
                return new BitAndRubyBignumNode((BitAndBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitAndRubyBignumLongNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            BitAndRubyBignumLongNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.bitAnd(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.bitAnd(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitAndNode create0(BignumNodes.BitAndNode current2) {
                return new BitAndRubyBignumLongNode((BitAndBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BitAndRubyBignumIntNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            BitAndRubyBignumIntNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.bitAnd(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.bitAnd(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitAndNode create0(BignumNodes.BitAndNode current2) {
                return new BitAndRubyBignumIntNode((BitAndBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.BitAndNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BitAndUninitializedNode
        extends BitAndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BitAndUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BitAndUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BitAndUninitializedNode(BitAndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                BitAndBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BitAndBaseNode rootNode = (BitAndBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BitAndBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.BitAndNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BitAndUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.BitAndNode.class)
        private static abstract class BitAndBaseNode
        extends BignumNodes.BitAndNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BitAndBaseNode next0;

            BitAndBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BitAndBaseNode(BitAndBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                BitAndBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BitAndBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new BitAndUninitializedNode(this);
                    ((BitAndUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BitAndBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = BitAndBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (BitAndBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BitAndUninitializedNode(this), (Node)new BitAndPolymorphicNode(this), (DSLNode)((BitAndBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BitAndBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (BitAndBaseNode)BitAndRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (BitAndBaseNode)BitAndRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (BitAndBaseNode)BitAndRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    BitAndBaseNode otherCast = (BitAndBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (BitAndBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.GreaterNode.class)
    public static final class GreaterNodeFactory
    extends NodeFactoryBase<BignumNodes.GreaterNode> {
        private static GreaterNodeFactory greaterNodeFactoryInstance;

        private GreaterNodeFactory() {
            super(BignumNodes.GreaterNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.GreaterNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GreaterNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.GreaterNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GreaterUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.GreaterNode> getInstance() {
            if (greaterNodeFactoryInstance == null) {
                greaterNodeFactoryInstance = new GreaterNodeFactory();
            }
            return greaterNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GreaterPolymorphicNode
        extends GreaterBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GreaterPolymorphicNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterRubyBignumNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            GreaterRubyBignumNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.GreaterNode create0(BignumNodes.GreaterNode current2) {
                return new GreaterRubyBignumNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterRubyBignumDoubleNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterRubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            GreaterRubyBignumDoubleNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.GreaterNode create0(BignumNodes.GreaterNode current2) {
                return new GreaterRubyBignumDoubleNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterRubyBignumLongNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            GreaterRubyBignumLongNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.GreaterNode create0(BignumNodes.GreaterNode current2) {
                return new GreaterRubyBignumLongNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterRubyBignumIntNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            GreaterRubyBignumIntNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.greater(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.greater(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.GreaterNode create0(BignumNodes.GreaterNode current2) {
                return new GreaterRubyBignumIntNode((GreaterBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GreaterUninitializedNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GreaterUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GreaterUninitializedNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GreaterBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GreaterBaseNode rootNode = (GreaterBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GreaterBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.GreaterNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GreaterUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterNode.class)
        private static abstract class GreaterBaseNode
        extends BignumNodes.GreaterNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GreaterBaseNode next0;

            GreaterBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GreaterBaseNode(GreaterBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                GreaterBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GreaterBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GreaterUninitializedNode(this);
                    ((GreaterUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GreaterBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = GreaterBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GreaterBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GreaterUninitializedNode(this), (Node)new GreaterPolymorphicNode(this), (DSLNode)((GreaterBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GreaterBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (GreaterBaseNode)GreaterRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (GreaterBaseNode)GreaterRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (GreaterBaseNode)GreaterRubyBignumDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (GreaterBaseNode)GreaterRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GreaterBaseNode otherCast = (GreaterBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GreaterBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
    public static final class GreaterEqualNodeFactory
    extends NodeFactoryBase<BignumNodes.GreaterEqualNode> {
        private static GreaterEqualNodeFactory greaterEqualNodeFactoryInstance;

        private GreaterEqualNodeFactory() {
            super(BignumNodes.GreaterEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.GreaterEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GreaterEqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.GreaterEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GreaterEqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.GreaterEqualNode> getInstance() {
            if (greaterEqualNodeFactoryInstance == null) {
                greaterEqualNodeFactoryInstance = new GreaterEqualNodeFactory();
            }
            return greaterEqualNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GreaterEqualPolymorphicNode
        extends GreaterEqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GreaterEqualPolymorphicNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualRubyBignumNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            GreaterEqualRubyBignumNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.GreaterEqualNode create0(BignumNodes.GreaterEqualNode current2) {
                return new GreaterEqualRubyBignumNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualRubyBignumDoubleNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualRubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            GreaterEqualRubyBignumDoubleNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.GreaterEqualNode create0(BignumNodes.GreaterEqualNode current2) {
                return new GreaterEqualRubyBignumDoubleNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualRubyBignumLongNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            GreaterEqualRubyBignumLongNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.GreaterEqualNode create0(BignumNodes.GreaterEqualNode current2) {
                return new GreaterEqualRubyBignumLongNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualRubyBignumIntNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            GreaterEqualRubyBignumIntNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.GreaterEqualNode create0(BignumNodes.GreaterEqualNode current2) {
                return new GreaterEqualRubyBignumIntNode((GreaterEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GreaterEqualUninitializedNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GreaterEqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GreaterEqualUninitializedNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GreaterEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GreaterEqualBaseNode rootNode = (GreaterEqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GreaterEqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.GreaterEqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GreaterEqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.GreaterEqualNode.class)
        private static abstract class GreaterEqualBaseNode
        extends BignumNodes.GreaterEqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GreaterEqualBaseNode next0;

            GreaterEqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GreaterEqualBaseNode(GreaterEqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                GreaterEqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GreaterEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GreaterEqualUninitializedNode(this);
                    ((GreaterEqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GreaterEqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = GreaterEqualBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GreaterEqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GreaterEqualUninitializedNode(this), (Node)new GreaterEqualPolymorphicNode(this), (DSLNode)((GreaterEqualBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GreaterEqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualRubyBignumDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GreaterEqualBaseNode otherCast = (GreaterEqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GreaterEqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<BignumNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(BignumNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompareUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ComparePolymorphicNode
        extends CompareBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ComparePolymorphicNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyBignumNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            CompareRubyBignumNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.CompareNode create0(BignumNodes.CompareNode current2) {
                return new CompareRubyBignumNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyBignumDoubleNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            CompareRubyBignumDoubleNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.CompareNode create0(BignumNodes.CompareNode current2) {
                return new CompareRubyBignumDoubleNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyBignumLongNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            CompareRubyBignumLongNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.CompareNode create0(BignumNodes.CompareNode current2) {
                return new CompareRubyBignumLongNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyBignumIntNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            CompareRubyBignumIntNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.compare(arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.compare(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.CompareNode create0(BignumNodes.CompareNode current2) {
                return new CompareRubyBignumIntNode((CompareBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompareUninitializedNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompareUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompareUninitializedNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompareBaseNode rootNode = (CompareBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CompareBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.CompareNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompareUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.CompareNode.class)
        private static abstract class CompareBaseNode
        extends BignumNodes.CompareNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompareBaseNode next0;

            CompareBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompareBaseNode(CompareBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                CompareBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CompareUninitializedNode(this);
                    ((CompareUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CompareBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = CompareBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CompareBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CompareUninitializedNode(this), (Node)new ComparePolymorphicNode(this), (DSLNode)((CompareBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompareBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (CompareBaseNode)CompareRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (CompareBaseNode)CompareRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (CompareBaseNode)CompareRubyBignumDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (CompareBaseNode)CompareRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CompareBaseNode otherCast = (CompareBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CompareBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<BignumNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(BignumNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyBignumNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            EqualRubyBignumNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.EqualNode create0(BignumNodes.EqualNode current2) {
                return new EqualRubyBignumNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyBignumDoubleNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            EqualRubyBignumDoubleNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.EqualNode create0(BignumNodes.EqualNode current2) {
                return new EqualRubyBignumDoubleNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyBignumLongNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            EqualRubyBignumLongNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.EqualNode create0(BignumNodes.EqualNode current2) {
                return new EqualRubyBignumLongNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyBignumIntNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            EqualRubyBignumIntNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.EqualNode create0(BignumNodes.EqualNode current2) {
                return new EqualRubyBignumIntNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = (EqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends BignumNodes.EqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EqualBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EqualUninitializedNode(this), (Node)new EqualPolymorphicNode(this), (DSLNode)((EqualBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyBignumDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.LessEqualNode.class)
    public static final class LessEqualNodeFactory
    extends NodeFactoryBase<BignumNodes.LessEqualNode> {
        private static LessEqualNodeFactory lessEqualNodeFactoryInstance;

        private LessEqualNodeFactory() {
            super(BignumNodes.LessEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.LessEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LessEqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.LessEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LessEqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.LessEqualNode> getInstance() {
            if (lessEqualNodeFactoryInstance == null) {
                lessEqualNodeFactoryInstance = new LessEqualNodeFactory();
            }
            return lessEqualNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LessEqualPolymorphicNode
        extends LessEqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LessEqualPolymorphicNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualRubyBignumNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            LessEqualRubyBignumNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LessEqualNode create0(BignumNodes.LessEqualNode current2) {
                return new LessEqualRubyBignumNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualRubyBignumDoubleNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualRubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            LessEqualRubyBignumDoubleNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LessEqualNode create0(BignumNodes.LessEqualNode current2) {
                return new LessEqualRubyBignumDoubleNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualRubyBignumLongNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            LessEqualRubyBignumLongNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LessEqualNode create0(BignumNodes.LessEqualNode current2) {
                return new LessEqualRubyBignumLongNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualRubyBignumIntNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            LessEqualRubyBignumIntNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LessEqualNode create0(BignumNodes.LessEqualNode current2) {
                return new LessEqualRubyBignumIntNode((LessEqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LessEqualUninitializedNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LessEqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LessEqualUninitializedNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LessEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LessEqualBaseNode rootNode = (LessEqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LessEqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LessEqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LessEqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.LessEqualNode.class)
        private static abstract class LessEqualBaseNode
        extends BignumNodes.LessEqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LessEqualBaseNode next0;

            LessEqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LessEqualBaseNode(LessEqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                LessEqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LessEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LessEqualUninitializedNode(this);
                    ((LessEqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LessEqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = LessEqualBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (LessEqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LessEqualUninitializedNode(this), (Node)new LessEqualPolymorphicNode(this), (DSLNode)((LessEqualBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LessEqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualRubyBignumDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LessEqualBaseNode otherCast = (LessEqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LessEqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.LessNode.class)
    public static final class LessNodeFactory
    extends NodeFactoryBase<BignumNodes.LessNode> {
        private static LessNodeFactory lessNodeFactoryInstance;

        private LessNodeFactory() {
            super(BignumNodes.LessNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.LessNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LessNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.LessNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LessUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.LessNode> getInstance() {
            if (lessNodeFactoryInstance == null) {
                lessNodeFactoryInstance = new LessNodeFactory();
            }
            return lessNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LessPolymorphicNode
        extends LessBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LessPolymorphicNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessRubyBignumNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            LessRubyBignumNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LessNode create0(BignumNodes.LessNode current2) {
                return new LessRubyBignumNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessRubyBignumDoubleNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessRubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            LessRubyBignumDoubleNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LessNode create0(BignumNodes.LessNode current2) {
                return new LessRubyBignumDoubleNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessRubyBignumLongNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            LessRubyBignumLongNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LessNode create0(BignumNodes.LessNode current2) {
                return new LessRubyBignumLongNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessRubyBignumIntNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            LessRubyBignumIntNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LessNode create0(BignumNodes.LessNode current2) {
                return new LessRubyBignumIntNode((LessBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LessUninitializedNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LessUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LessUninitializedNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LessBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LessBaseNode rootNode = (LessBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LessBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.LessNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LessUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.LessNode.class)
        private static abstract class LessBaseNode
        extends BignumNodes.LessNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LessBaseNode next0;

            LessBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LessBaseNode(LessBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                LessBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LessBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LessUninitializedNode(this);
                    ((LessUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LessBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = LessBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (LessBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LessUninitializedNode(this), (Node)new LessPolymorphicNode(this), (DSLNode)((LessBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LessBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LessBaseNode)LessRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LessBaseNode)LessRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LessBaseNode)LessRubyBignumDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LessBaseNode)LessRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LessBaseNode otherCast = (LessBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LessBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.ModNode.class)
    public static final class ModNodeFactory
    extends NodeFactoryBase<BignumNodes.ModNode> {
        private static ModNodeFactory modNodeFactoryInstance;

        private ModNodeFactory() {
            super(BignumNodes.ModNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.ModNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ModNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.ModNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ModUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.ModNode> getInstance() {
            if (modNodeFactoryInstance == null) {
                modNodeFactoryInstance = new ModNodeFactory();
            }
            return modNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ModPolymorphicNode
        extends ModBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ModPolymorphicNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModRubyBignumNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            ModRubyBignumNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.ModNode create0(BignumNodes.ModNode current2) {
                return new ModRubyBignumNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModRubyBignumLongNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            ModRubyBignumLongNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.ModNode create0(BignumNodes.ModNode current2) {
                return new ModRubyBignumLongNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModRubyBignumIntNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            ModRubyBignumIntNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.ModNode create0(BignumNodes.ModNode current2) {
                return new ModRubyBignumIntNode((ModBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ModUninitializedNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ModUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ModUninitializedNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ModBaseNode rootNode = (ModBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ModBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.ModNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ModUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.ModNode.class)
        private static abstract class ModBaseNode
        extends BignumNodes.ModNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ModBaseNode next0;

            ModBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ModBaseNode(ModBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ModBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ModUninitializedNode(this);
                    ((ModUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ModBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ModBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ModBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ModUninitializedNode(this), (Node)new ModPolymorphicNode(this), (DSLNode)((ModBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ModBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (ModBaseNode)ModRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (ModBaseNode)ModRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (ModBaseNode)ModRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ModBaseNode otherCast = (ModBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ModBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.DivNode.class)
    public static final class DivNodeFactory
    extends NodeFactoryBase<BignumNodes.DivNode> {
        private static DivNodeFactory divNodeFactoryInstance;

        private DivNodeFactory() {
            super(BignumNodes.DivNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.DivNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DivNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.DivNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DivUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.DivNode> getInstance() {
            if (divNodeFactoryInstance == null) {
                divNodeFactoryInstance = new DivNodeFactory();
            }
            return divNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DivPolymorphicNode
        extends DivBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DivPolymorphicNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivObjectRubyBignumNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivObjectRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            DivObjectRubyBignumNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.DivNode create0(BignumNodes.DivNode current2) {
                return new DivObjectRubyBignumNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivDoubleNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            DivDoubleNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.DivNode create0(BignumNodes.DivNode current2) {
                return new DivDoubleNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivRubyBignumLongNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            DivRubyBignumLongNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.DivNode create0(BignumNodes.DivNode current2) {
                return new DivRubyBignumLongNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivObjectIntNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivObjectIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            DivObjectIntNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.DivNode create0(BignumNodes.DivNode current2) {
                return new DivObjectIntNode((DivBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DivUninitializedNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DivUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DivUninitializedNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DivBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DivBaseNode rootNode = (DivBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DivBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.DivNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DivUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.DivNode.class)
        private static abstract class DivBaseNode
        extends BignumNodes.DivNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DivBaseNode next0;

            DivBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DivBaseNode(DivBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                DivBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DivBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DivUninitializedNode(this);
                    ((DivUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DivBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DivBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DivBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DivUninitializedNode(this), (Node)new DivPolymorphicNode(this), (DSLNode)((DivBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DivBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (DivBaseNode)DivObjectIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (DivBaseNode)DivRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (DivBaseNode)DivDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (DivBaseNode)DivObjectRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DivBaseNode otherCast = (DivBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DivBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.PowNode.class)
    public static final class PowNodeFactory
    extends NodeFactoryBase<BignumNodes.PowNode> {
        private static PowNodeFactory powNodeFactoryInstance;

        private PowNodeFactory() {
            super(BignumNodes.PowNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.PowNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PowNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.PowNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PowUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.PowNode> getInstance() {
            if (powNodeFactoryInstance == null) {
                powNodeFactoryInstance = new PowNodeFactory();
            }
            return powNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PowPolymorphicNode
        extends PowBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PowPolymorphicNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowRubyBignumNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            PowRubyBignumNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.PowNode create0(BignumNodes.PowNode current2) {
                return new PowRubyBignumNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowDoubleNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            PowDoubleNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.PowNode create0(BignumNodes.PowNode current2) {
                return new PowDoubleNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowRubyBignumLongNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            PowRubyBignumLongNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.PowNode create0(BignumNodes.PowNode current2) {
                return new PowRubyBignumLongNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowRubyBignumIntNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            PowRubyBignumIntNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.PowNode create0(BignumNodes.PowNode current2) {
                return new PowRubyBignumIntNode((PowBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PowUninitializedNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PowUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PowUninitializedNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PowBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PowBaseNode rootNode = (PowBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PowBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.PowNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PowUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.PowNode.class)
        private static abstract class PowBaseNode
        extends BignumNodes.PowNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PowBaseNode next0;

            PowBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PowBaseNode(PowBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PowBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PowBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PowUninitializedNode(this);
                    ((PowUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PowBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PowBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PowBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PowUninitializedNode(this), (Node)new PowPolymorphicNode(this), (DSLNode)((PowBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PowBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (PowBaseNode)PowRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (PowBaseNode)PowRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (PowBaseNode)PowDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (PowBaseNode)PowRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PowBaseNode otherCast = (PowBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PowBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<BignumNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(BignumNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MulUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MulPolymorphicNode
        extends MulBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MulPolymorphicNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulRubyBignumNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            MulRubyBignumNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.MulNode create0(BignumNodes.MulNode current2) {
                return new MulRubyBignumNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulDoubleNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            MulDoubleNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.MulNode create0(BignumNodes.MulNode current2) {
                return new MulDoubleNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulRubyBignumLongNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            MulRubyBignumLongNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.MulNode create0(BignumNodes.MulNode current2) {
                return new MulRubyBignumLongNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulRubyBignumIntNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            MulRubyBignumIntNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.MulNode create0(BignumNodes.MulNode current2) {
                return new MulRubyBignumIntNode((MulBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MulUninitializedNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MulUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MulUninitializedNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MulBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MulBaseNode rootNode = (MulBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MulBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.MulNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MulUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.MulNode.class)
        private static abstract class MulBaseNode
        extends BignumNodes.MulNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MulBaseNode next0;

            MulBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MulBaseNode(MulBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                MulBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MulBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MulUninitializedNode(this);
                    ((MulUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MulBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MulBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MulBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MulUninitializedNode(this), (Node)new MulPolymorphicNode(this), (DSLNode)((MulBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MulBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (MulBaseNode)MulRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (MulBaseNode)MulRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (MulBaseNode)MulDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (MulBaseNode)MulRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MulBaseNode otherCast = (MulBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MulBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.SubNode.class)
    public static final class SubNodeFactory
    extends NodeFactoryBase<BignumNodes.SubNode> {
        private static SubNodeFactory subNodeFactoryInstance;

        private SubNodeFactory() {
            super(BignumNodes.SubNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.SubNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SubNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.SubNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SubUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.SubNode> getInstance() {
            if (subNodeFactoryInstance == null) {
                subNodeFactoryInstance = new SubNodeFactory();
            }
            return subNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SubPolymorphicNode
        extends SubBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SubPolymorphicNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubObjectRubyBignumNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubObjectRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            SubObjectRubyBignumNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.SubNode create0(BignumNodes.SubNode current2) {
                return new SubObjectRubyBignumNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubDoubleNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            SubDoubleNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.SubNode create0(BignumNodes.SubNode current2) {
                return new SubDoubleNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubObjectLongNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubObjectLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            SubObjectLongNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.SubNode create0(BignumNodes.SubNode current2) {
                return new SubObjectLongNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubObjectIntNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubObjectIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            SubObjectIntNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.SubNode create0(BignumNodes.SubNode current2) {
                return new SubObjectIntNode((SubBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SubUninitializedNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SubUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SubUninitializedNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SubBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SubBaseNode rootNode = (SubBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SubBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.SubNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SubUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.SubNode.class)
        private static abstract class SubBaseNode
        extends BignumNodes.SubNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SubBaseNode next0;

            SubBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SubBaseNode(SubBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                SubBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SubBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SubUninitializedNode(this);
                    ((SubUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SubBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SubBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SubBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SubUninitializedNode(this), (Node)new SubPolymorphicNode(this), (DSLNode)((SubBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SubBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (SubBaseNode)SubObjectIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (SubBaseNode)SubObjectLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (SubBaseNode)SubDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (SubBaseNode)SubObjectRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SubBaseNode otherCast = (SubBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SubBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<BignumNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(BignumNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AddNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AddUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AddPolymorphicNode
        extends AddBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AddPolymorphicNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BignumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddObjectRubyBignumNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddObjectRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            AddObjectRubyBignumNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.AddNode create0(BignumNodes.AddNode current2) {
                return new AddObjectRubyBignumNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddDoubleNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            AddDoubleNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.AddNode create0(BignumNodes.AddNode current2) {
                return new AddDoubleNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddRubyBignumLongNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            AddRubyBignumLongNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.AddNode create0(BignumNodes.AddNode current2) {
                return new AddRubyBignumLongNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddRubyBignumIntNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            AddRubyBignumIntNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.AddNode create0(BignumNodes.AddNode current2) {
                return new AddRubyBignumIntNode((AddBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AddUninitializedNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AddUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AddUninitializedNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AddBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AddBaseNode rootNode = (AddBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AddBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BignumNodes.AddNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AddUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.AddNode.class)
        private static abstract class AddBaseNode
        extends BignumNodes.AddNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AddBaseNode next0;

            AddBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AddBaseNode(AddBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                AddBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AddBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AddUninitializedNode(this);
                    ((AddUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AddBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = AddBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (AddBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AddUninitializedNode(this), (Node)new AddPolymorphicNode(this), (DSLNode)((AddBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AddBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (AddBaseNode)AddRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (AddBaseNode)AddRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (AddBaseNode)AddDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (AddBaseNode)AddObjectRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AddBaseNode otherCast = (AddBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AddBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=BignumNodes.NegNode.class)
    public static final class NegNodeFactory
    extends NodeFactoryBase<BignumNodes.NegNode> {
        private static NegNodeFactory negNodeFactoryInstance;

        private NegNodeFactory() {
            super(BignumNodes.NegNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BignumNodes.NegNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NegNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BignumNodes.NegNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NegUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BignumNodes.NegNode> getInstance() {
            if (negNodeFactoryInstance == null) {
                negNodeFactoryInstance = new NegNodeFactory();
            }
            return negNodeFactoryInstance;
        }

        @GeneratedBy(value=BignumNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NegPolymorphicNode
        extends NegBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            NegPolymorphicNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyBignum executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=BignumNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NegRubyBignumNode
        extends NegBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NegRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            NegRubyBignumNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.neg(arguments0Value);
            }

            @Override
            protected RubyBignum executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.neg(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.NegNode create0(BignumNodes.NegNode current2) {
                return new NegRubyBignumNode((NegBaseNode)current2);
            }
        }

        @GeneratedBy(value=BignumNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NegUninitializedNode
        extends NegBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NegUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NegUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            NegUninitializedNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyBignum executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyBignum executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                NegBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NegBaseNode rootNode = (NegBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((NegBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static BignumNodes.NegNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NegUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BignumNodes.NegNode.class)
        private static abstract class NegBaseNode
        extends BignumNodes.NegNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected NegBaseNode next0;

            NegBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            NegBaseNode(NegBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBignum executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBignum rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                NegBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NegBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new NegUninitializedNode(this);
                    ((NegUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (NegBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = NegBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (NegBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NegUninitializedNode(this), (Node)new NegPolymorphicNode(this), (DSLNode)((NegBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NegBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (NegBaseNode)NegRubyBignumNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((NegBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (NegBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

