/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;

@ImportGuards(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayIndexNode
extends RubyNode {
    final int index;

    public ArrayIndexNode(RubyContext context, SourceSection sourceSection, int index2) {
        super(context, sourceSection);
        this.index = index2;
    }

    public ArrayIndexNode(ArrayIndexNode prev) {
        super(prev);
        this.index = prev.index;
    }

    @Specialization(guards={"isNull"})
    public RubyNilClass getNull(RubyArray array) {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Specialization(guards={"isIntegerFixnum"}, rewriteOn={UnexpectedResultException.class})
    public int getIntegerFixnumInBounds(RubyArray array) throws UnexpectedResultException {
        int normalisedIndex = array.normaliseIndex(this.index);
        if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
            throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
        }
        return ((int[])array.getStore())[normalisedIndex];
    }

    @Specialization(guards={"isIntegerFixnum"})
    public Object getIntegerFixnum(RubyArray array) {
        int normalisedIndex = array.normaliseIndex(this.index);
        if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return ((int[])array.getStore())[normalisedIndex];
    }

    @Specialization(guards={"isLongFixnum"}, rewriteOn={UnexpectedResultException.class})
    public long getLongFixnumInBounds(RubyArray array) throws UnexpectedResultException {
        int normalisedIndex = array.normaliseIndex(this.index);
        if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
            throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
        }
        return ((long[])array.getStore())[normalisedIndex];
    }

    @Specialization(guards={"isLongFixnum"})
    public Object getLongFixnum(RubyArray array) {
        int normalisedIndex = array.normaliseIndex(this.index);
        if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return ((long[])array.getStore())[normalisedIndex];
    }

    @Specialization(guards={"isFloat"}, rewriteOn={UnexpectedResultException.class})
    public double getFloatInBounds(RubyArray array) throws UnexpectedResultException {
        int normalisedIndex = array.normaliseIndex(this.index);
        if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
            throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
        }
        return ((double[])array.getStore())[normalisedIndex];
    }

    @Specialization(guards={"isFloat"})
    public Object getFloat(RubyArray array) {
        int normalisedIndex = array.normaliseIndex(this.index);
        if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return ((double[])array.getStore())[normalisedIndex];
    }

    @Specialization(guards={"isObject"})
    public Object getObject(RubyArray array) {
        int normalisedIndex = array.normaliseIndex(this.index);
        if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return ((Object[])array.getStore())[normalisedIndex];
    }
}

