/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.util.ArrayUtils;

@ImportGuards(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayDropTailNode
extends RubyNode {
    final int index;

    public ArrayDropTailNode(RubyContext context, SourceSection sourceSection, int index2) {
        super(context, sourceSection);
        this.index = index2;
    }

    public ArrayDropTailNode(ArrayDropTailNode prev) {
        super(prev);
        this.index = prev.index;
    }

    @Specialization(guards={"isNull"})
    public RubyArray getHeadNull(RubyArray array) {
        ArrayDropTailNode.notDesignedForCompilation();
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
    }

    @Specialization(guards={"isIntegerFixnum"})
    public RubyArray getHeadIntegerFixnum(RubyArray array) {
        ArrayDropTailNode.notDesignedForCompilation();
        if (this.index >= array.getSize()) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((int[])array.getStore(), 0, array.getSize() - this.index), array.getSize() - this.index);
    }

    @Specialization(guards={"isLongFixnum"})
    public RubyArray geHeadLongFixnum(RubyArray array) {
        ArrayDropTailNode.notDesignedForCompilation();
        if (this.index >= array.getSize()) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        int size2 = array.getSize() - this.index;
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((long[])array.getStore(), 0, size2), size2);
    }

    @Specialization(guards={"isFloat"})
    public RubyArray getHeadFloat(RubyArray array) {
        ArrayDropTailNode.notDesignedForCompilation();
        if (this.index >= array.getSize()) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        int size2 = array.getSize() - this.index;
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((double[])array.getStore(), 0, size2), size2);
    }

    @Specialization(guards={"isObject"})
    public RubyArray getHeadObject(RubyArray array) {
        ArrayDropTailNode.notDesignedForCompilation();
        if (this.index >= array.getSize()) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        int size2 = array.getSize() - this.index;
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((Object[])array.getStore(), 0, size2), size2);
    }
}

