/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.runtime.RubyContext;

public class IfNode
extends RubyNode {
    @Node.Child
    private BooleanCastNode condition;
    @Node.Child
    private RubyNode thenBody;
    @Node.Child
    private RubyNode elseBody;
    private final ConditionProfile conditionProfile = ConditionProfile.createCountingProfile();

    public IfNode(RubyContext context, SourceSection sourceSection, BooleanCastNode condition, RubyNode thenBody, RubyNode elseBody) {
        super(context, sourceSection);
        assert (condition != null);
        assert (thenBody != null);
        assert (elseBody != null);
        this.condition = condition;
        this.thenBody = thenBody;
        this.elseBody = elseBody;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.conditionProfile.profile(this.condition.executeBoolean(frame))) {
            return this.thenBody.execute(frame);
        }
        return this.elseBody.execute(frame);
    }
}

