/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.SplatCastNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;

@GeneratedBy(value=SplatCastNode.class)
public final class SplatCastNodeFactory
extends NodeFactoryBase<SplatCastNode> {
    private static SplatCastNodeFactory instance;

    private SplatCastNodeFactory() {
        super(SplatCastNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, SplatCastNode.NilBehavior.class, Boolean.TYPE, RubyNode.class}});
    }

    public SplatCastNode createNode(Object ... arguments) {
        if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof SplatCastNode.NilBehavior) || !(arguments[3] instanceof Boolean) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
            return SplatCastNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (SplatCastNode.NilBehavior)((Object)arguments[2]), (Boolean)arguments[3], (RubyNode)((Object)arguments[4]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static SplatCastNode create(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior, boolean useToAry, RubyNode child) {
        return SplatCastUninitializedNode.create0(context, sourceSection, nilBehavior, useToAry, child);
    }

    public static NodeFactory<SplatCastNode> getInstance() {
        if (instance == null) {
            instance = new SplatCastNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=SplatCastNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class SplatCastPolymorphicNode
    extends SplatCastBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        SplatCastPolymorphicNode(SplatCastBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == RubyArray.class ? this.child.executeArray(frameValue) : (this.childPolymorphicType == RubyNilClass.class ? this.child.executeRubyNilClass(frameValue) : this.child.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=SplatCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SplatCastObjectNode
    extends SplatCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SplatCastObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

        SplatCastObjectNode(SplatCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue = this.child.execute(frameValue);
            if (!super.isRubyNilClass(childValue) && !super.isRubyArray(childValue)) {
                return super.splat(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubyNilClass, !isRubyArray] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!super.isRubyNilClass(childValue) && !super.isRubyArray(childValue)) {
                return super.splat(frameValue, childValue);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static SplatCastNode create0(SplatCastNode current2) {
            return new SplatCastObjectNode((SplatCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=SplatCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SplatCastRubyArrayNode
    extends SplatCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SplatCastRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        SplatCastRubyArrayNode(SplatCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray childValue;
            try {
                childValue = this.child.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyArray");
            }
            return super.splat(frameValue, childValue);
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(childValue)) {
                RubyArray childValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(childValue);
                return super.splat(frameValue, childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static SplatCastNode create0(SplatCastNode current2) {
            return new SplatCastRubyArrayNode((SplatCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=SplatCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SplatCastRubyNilClassNode
    extends SplatCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SplatCastRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyNilClass.class}, 0, 0);

        SplatCastRubyNilClassNode(SplatCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyNilClass childValue;
            try {
                childValue = this.child.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyNilClass");
            }
            return super.splat(childValue);
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                RubyNilClass childValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(childValue);
                return super.splat(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static SplatCastNode create0(SplatCastNode current2) {
            return new SplatCastRubyNilClassNode((SplatCastBaseNode)current2);
        }
    }

    @GeneratedBy(value=SplatCastNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class SplatCastUninitializedNode
    extends SplatCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SplatCastUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        SplatCastUninitializedNode(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior, boolean useToAry, RubyNode child) {
            super(context, sourceSection, nilBehavior, useToAry, child);
        }

        SplatCastUninitializedNode(SplatCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            SplatCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                SplatCastBaseNode rootNode = (SplatCastBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((SplatCastBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, childValue);
        }

        static SplatCastNode create0(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior, boolean useToAry, RubyNode child) {
            return new SplatCastUninitializedNode(context, sourceSection, nilBehavior, useToAry, child);
        }
    }

    @GeneratedBy(value=SplatCastNode.class)
    private static abstract class SplatCastBaseNode
    extends SplatCastNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected SplatCastBaseNode next0;

        SplatCastBaseNode(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior, boolean useToAry, RubyNode child) {
            super(context, sourceSection, nilBehavior, useToAry);
            this.child = child;
        }

        SplatCastBaseNode(SplatCastBaseNode copy) {
            super(copy);
        }

        @Override
        protected RubyNode getChild() {
            return this.child;
        }

        protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

        protected final RubyArray rewrite0(VirtualFrame frameValue, Object childValue, String reason2) {
            String message2;
            SplatCastBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            SplatCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new SplatCastUninitializedNode(this);
                ((SplatCastUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (SplatCastBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SplatCastBaseNode.createInfo0(reason2, childValue)))) == null) {
                returnNode = (SplatCastBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SplatCastUninitializedNode(this), (Node)new SplatCastPolymorphicNode(this), (DSLNode)((SplatCastBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final SplatCastBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                return (SplatCastBaseNode)SplatCastRubyNilClassNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyArray(childValue)) {
                return (SplatCastBaseNode)SplatCastRubyArrayNode.create0(this);
            }
            if (!super.isRubyNilClass(childValue) && !super.isRubyArray(childValue)) {
                return (SplatCastBaseNode)SplatCastObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((SplatCastBaseNode)other).child;
            this.next0 = newNext == null ? null : (SplatCastBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

