/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.ProcOrNullNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;

@GeneratedBy(value=ProcOrNullNode.class)
public final class ProcOrNullNodeFactory
extends NodeFactoryBase<ProcOrNullNode> {
    private static ProcOrNullNodeFactory instance;

    private ProcOrNullNodeFactory() {
        super(ProcOrNullNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public ProcOrNullNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ProcOrNullNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ProcOrNullNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return ProcOrNullUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<ProcOrNullNode> getInstance() {
        if (instance == null) {
            instance = new ProcOrNullNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ProcOrNullNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ProcOrNullPolymorphicNode
    extends ProcOrNullBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        ProcOrNullPolymorphicNode(ProcOrNullBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == RubyNilClass.class ? this.child.executeRubyNilClass(frameValue) : (this.childPolymorphicType == RubyProc.class ? this.child.executeRubyProc(frameValue) : this.child.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=ProcOrNullNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ProcOrNullRubyProcNode
    extends ProcOrNullBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ProcOrNullRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyProc.class}, 0, 0);

        ProcOrNullRubyProcNode(ProcOrNullBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyProc childValue;
            try {
                childValue = this.child.executeRubyProc(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyProc");
            }
            return super.doProc(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyProc(childValue)) {
                RubyProc childValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(childValue);
                return super.doProc(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ProcOrNullNode create0(ProcOrNullNode current2) {
            return new ProcOrNullRubyProcNode((ProcOrNullBaseNode)current2);
        }
    }

    @GeneratedBy(value=ProcOrNullNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ProcOrNullRubyNilClassNode
    extends ProcOrNullBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ProcOrNullRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyNilClass.class}, 0, 0);

        ProcOrNullRubyNilClassNode(ProcOrNullBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass childValue;
            try {
                childValue = this.child.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyNilClass");
            }
            return super.doNil(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                RubyNilClass childValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(childValue);
                return super.doNil(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ProcOrNullNode create0(ProcOrNullNode current2) {
            return new ProcOrNullRubyNilClassNode((ProcOrNullBaseNode)current2);
        }
    }

    @GeneratedBy(value=ProcOrNullNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ProcOrNullUninitializedNode
    extends ProcOrNullBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ProcOrNullUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ProcOrNullUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        ProcOrNullUninitializedNode(ProcOrNullBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            ProcOrNullBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ProcOrNullBaseNode rootNode = (ProcOrNullBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ProcOrNullBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, childValue);
        }

        static ProcOrNullNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new ProcOrNullUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=ProcOrNullNode.class)
    private static abstract class ProcOrNullBaseNode
    extends ProcOrNullNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected ProcOrNullBaseNode next0;

        ProcOrNullBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        ProcOrNullBaseNode(ProcOrNullBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object childValue, String reason2) {
            String message2;
            ProcOrNullBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ProcOrNullBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new ProcOrNullUninitializedNode(this);
                ((ProcOrNullUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ProcOrNullBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ProcOrNullBaseNode.createInfo0(reason2, childValue)))) == null) {
                returnNode = (ProcOrNullBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ProcOrNullUninitializedNode(this), (Node)new ProcOrNullPolymorphicNode(this), (DSLNode)((ProcOrNullBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ProcOrNullBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                return (ProcOrNullBaseNode)ProcOrNullRubyNilClassNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyProc(childValue)) {
                return (ProcOrNullBaseNode)ProcOrNullRubyProcNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((ProcOrNullBaseNode)other).child;
            this.next0 = newNext == null ? null : (ProcOrNullBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

