/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.cast.ProcOrNullNode;
import org.jruby.truffle.nodes.cast.ProcOrNullNodeFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.util.ArrayUtils;

public class RubyCallNode
extends RubyNode {
    private final String methodName;
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private ProcOrNullNode block;
    @Node.Children
    private final RubyNode[] arguments;
    private final boolean isSplatted;
    private final boolean isVCall;
    @Node.Child
    private CallDispatchHeadNode dispatchHead;
    private final BranchProfile splatNotArrayProfile = BranchProfile.create();
    @CompilerDirectives.CompilationFinal
    private boolean seenNullInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenIntegerFixnumInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenLongFixnumInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenObjectInUnsplat = false;
    @Node.Child
    private CallDispatchHeadNode respondToMissing;
    @Node.Child
    private BooleanCastNode respondToMissingCast;
    private final boolean ignoreVisibility;

    public RubyCallNode(RubyContext context, SourceSection section, String methodName, RubyNode receiver2, RubyNode block, boolean isSplatted, RubyNode ... arguments) {
        this(context, section, methodName, receiver2, block, isSplatted, false, false, arguments);
    }

    public RubyCallNode(RubyContext context, SourceSection section, String methodName, RubyNode receiver2, RubyNode block, boolean isSplatted, boolean ignoreVisibility, boolean rubiniusPrimitive, RubyNode ... arguments) {
        this(context, section, methodName, receiver2, block, isSplatted, false, ignoreVisibility, rubiniusPrimitive, arguments);
    }

    public RubyCallNode(RubyContext context, SourceSection section, String methodName, RubyNode receiver2, RubyNode block, boolean isSplatted, boolean isVCall, boolean ignoreVisibility, boolean rubiniusPrimitive, RubyNode ... arguments) {
        super(context, section);
        this.methodName = methodName;
        this.receiver = receiver2;
        this.block = block == null ? null : ProcOrNullNodeFactory.create(context, section, block);
        this.arguments = arguments;
        this.isSplatted = isSplatted;
        this.isVCall = isVCall;
        this.dispatchHead = DispatchHeadNodeFactory.createMethodCall(context, ignoreVisibility, false, MissingBehavior.CALL_METHOD_MISSING);
        this.respondToMissing = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.RETURN_MISSING);
        this.respondToMissingCast = BooleanCastNodeFactory.create(context, section, null);
        this.ignoreVisibility = ignoreVisibility;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        Object[] argumentsObjects = this.executeArguments(frame);
        RubyProc blockObject = this.executeBlock(frame);
        return this.dispatchHead.call(frame, receiverObject, this.methodName, blockObject, argumentsObjects);
    }

    private RubyProc executeBlock(VirtualFrame frame) {
        if (this.block != null) {
            return this.block.executeRubyProc(frame);
        }
        return null;
    }

    @ExplodeLoop
    private Object[] executeArguments(VirtualFrame frame) {
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            argumentsObjects[i2] = this.arguments[i2].execute(frame);
        }
        if (this.isSplatted) {
            return this.splat(argumentsObjects[0]);
        }
        return argumentsObjects;
    }

    private Object[] splat(Object argument) {
        if (!(argument instanceof RubyArray)) {
            this.splatNotArrayProfile.enter();
            RubyCallNode.notDesignedForCompilation();
            throw new UnsupportedOperationException();
        }
        RubyArray array = (RubyArray)argument;
        int size2 = array.getSize();
        Object store = array.getStore();
        if (this.seenNullInUnsplat && store == null) {
            return new Object[0];
        }
        if (this.seenIntegerFixnumInUnsplat && store instanceof int[]) {
            return ArrayUtils.boxUntil((int[])store, size2);
        }
        if (this.seenLongFixnumInUnsplat && store instanceof long[]) {
            return ArrayUtils.boxUntil((long[])store, size2);
        }
        if (this.seenObjectInUnsplat && store instanceof Object[]) {
            return ArrayUtils.extractRange((Object[])store, 0, size2);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (store == null) {
            this.seenNullInUnsplat = true;
            return new Object[0];
        }
        if (store instanceof int[]) {
            this.seenIntegerFixnumInUnsplat = true;
            return ArrayUtils.boxUntil((int[])store, size2);
        }
        if (store instanceof long[]) {
            this.seenLongFixnumInUnsplat = true;
            return ArrayUtils.boxUntil((long[])store, size2);
        }
        if (store instanceof Object[]) {
            this.seenObjectInUnsplat = true;
            return ArrayUtils.extractRange((Object[])store, 0, size2);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object receiverObject;
        RubyCallNode.notDesignedForCompilation();
        if (this.receiver.isDefined(frame) == this.getContext().getCoreLibrary().getNilObject()) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        for (RubyNode argument : this.arguments) {
            if (argument.isDefined(frame) != this.getContext().getCoreLibrary().getNilObject()) continue;
            return this.getContext().getCoreLibrary().getNilObject();
        }
        RubyContext context = this.getContext();
        try {
            CompilerAsserts.neverPartOfCompilation();
            receiverObject = this.receiver.execute(frame);
        }
        catch (Exception e) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        InternalMethod method = ModuleOperations.lookupMethod(context.getCoreLibrary().getMetaClass(receiverObject), this.methodName);
        Object self2 = RubyArguments.getSelf(frame.getArguments());
        if (method == null) {
            Object r = this.respondToMissing.call(frame, receiverObject, "respond_to_missing?", null, context.makeString(this.methodName));
            if (r != DispatchNode.MISSING && !this.respondToMissingCast.executeBoolean(frame, r)) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
        } else {
            if (method.isUndefined()) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            if (!this.ignoreVisibility && !method.isVisibleTo(this, context.getCoreLibrary().getMetaClass(self2))) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
        }
        return context.makeString("method");
    }

    public String getName() {
        return this.methodName;
    }

    public boolean isVCall() {
        return this.isVCall;
    }
}

