/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.net.URL;
import org.jruby.Ruby;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.Library;

public class ClassExtensionLibrary
implements Library {
    private final Class theClass;
    private final String name;

    static ClassExtensionLibrary tryFind(Ruby runtime, String searchName) {
        String[] all = searchName.split("/");
        StringBuilder finName = new StringBuilder();
        int j = all.length - 1;
        for (int i2 = 0; i2 < j; ++i2) {
            finName.append(all[i2].toLowerCase()).append(".");
        }
        try {
            String[] last2 = all[all.length - 1].split("_");
            int j2 = last2.length;
            for (int i3 = 0; i3 < j2 && !"".equals(last2[i3]); ++i3) {
                finName.append(Character.toUpperCase(last2[i3].charAt(0))).append(last2[i3].substring(1));
            }
            finName.append("Service");
            String className = finName.toString().replaceAll("^\\.*", "");
            String classFile = className.replaceAll("\\.", "/") + ".class";
            URL resource2 = runtime.getJRubyClassLoader().getResource(classFile);
            if (resource2 != null) {
                Class theClass = runtime.getJavaSupport().loadJavaClass(className);
                return new ClassExtensionLibrary(className + ".java", theClass);
            }
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            if (runtime.isDebug()) {
                cnfe.printStackTrace();
            }
            return null;
        }
        catch (UnsupportedClassVersionError ucve) {
            if (runtime.isDebug()) {
                ucve.printStackTrace();
            }
            throw runtime.newLoadError("JRuby ext built for wrong Java version in `" + finName + "': " + ucve, finName.toString());
        }
    }

    public ClassExtensionLibrary(String name2, Class extension) {
        this.theClass = extension;
        this.name = name2;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void load(Ruby runtime, boolean wrap2) {
        if (BasicLibraryService.class.isAssignableFrom(this.theClass)) {
            try {
                runtime.loadExtension(this.name, (BasicLibraryService)this.theClass.newInstance(), wrap2);
            }
            catch (Exception ee) {
                throw new RuntimeException(ee.getMessage(), ee);
            }
        }
    }
}

