/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jruby.RubyClass;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ClassSuperInvokeSite;
import org.jruby.ir.targets.InstanceSuperInvokeSite;
import org.jruby.ir.targets.InvokeSite;
import org.jruby.ir.targets.SelfInvokeSite;
import org.jruby.ir.targets.UnresolvedSuperInvokeSite;
import org.jruby.ir.targets.ZSuperInvokeSite;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.objectweb.asm.Handle;

public abstract class SuperInvokeSite
extends SelfInvokeSite {
    protected final String superName;
    protected final boolean[] splatMap;
    public static final Handle BOOTSTRAP = new Handle(6, CodegenUtils.p(SuperInvokeSite.class), "bootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class));

    public SuperInvokeSite(MethodType type2, String superName, String splatmapString) {
        super(type2, superName, CallType.SUPER);
        this.superName = superName;
        this.splatMap = IRRuntimeHelpers.decodeSplatmap(splatmapString);
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String splatmapString) {
        SelfInvokeSite site;
        String[] targetAndMethod = name2.split(":");
        String superName = JavaNameMangler.demangleMethodName(targetAndMethod[1]);
        switch (targetAndMethod[0]) {
            case "invokeInstanceSuper": {
                site = new InstanceSuperInvokeSite(type2, superName, splatmapString);
                break;
            }
            case "invokeClassSuper": {
                site = new ClassSuperInvokeSite(type2, superName, splatmapString);
                break;
            }
            case "invokeUnresolvedSuper": {
                site = new UnresolvedSuperInvokeSite(type2, superName, splatmapString);
                break;
            }
            case "invokeZSuper": {
                site = new ZSuperInvokeSite(type2, superName, splatmapString);
                break;
            }
            default: {
                throw new RuntimeException("invalid super call: " + name2);
            }
        }
        return InvokeSite.bootstrap(site, lookup);
    }

    public abstract IRubyObject invoke(ThreadContext var1, IRubyObject var2, IRubyObject var3, RubyClass var4, IRubyObject[] var5, Block var6) throws Throwable;

    public abstract IRubyObject fail(ThreadContext var1, IRubyObject var2, IRubyObject var3, RubyClass var4, IRubyObject[] var5, Block var6) throws Throwable;
}

