/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyHash;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.BignumObjectSite;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.DRegexpObjectSite;
import org.jruby.ir.targets.FixnumObjectSite;
import org.jruby.ir.targets.FloatObjectSite;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.NormalInvokeSite;
import org.jruby.ir.targets.RegexpObjectSite;
import org.jruby.ir.targets.SelfInvokeSite;
import org.jruby.ir.targets.SymbolObjectSite;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.RegexpOptions;
import org.objectweb.asm.Label;

public class IRBytecodeAdapter7
extends IRBytecodeAdapter {
    public IRBytecodeAdapter7(SkinnyMethodAdapter adapter, Signature signature, ClassData classData) {
        super(adapter, signature, classData);
    }

    @Override
    public void pushFixnum(long l) {
        this.loadContext();
        this.adapter.invokedynamic("fixnum", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), FixnumObjectSite.BOOTSTRAP, l);
    }

    @Override
    public void pushFloat(double d) {
        this.loadContext();
        this.adapter.invokedynamic("flote", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), FloatObjectSite.BOOTSTRAP, d);
    }

    @Override
    public void pushString(ByteList bl) {
        this.loadContext();
        this.adapter.invokedynamic("string", CodegenUtils.sig(RubyString.class, ThreadContext.class), Bootstrap.string(), new String(bl.bytes(), RubyEncoding.ISO), bl.getEncoding().toString());
    }

    @Override
    public void pushFrozenString(ByteList bl) {
        this.loadContext();
        this.adapter.invokedynamic("frozen", CodegenUtils.sig(RubyString.class, ThreadContext.class), Bootstrap.string(), new String(bl.bytes(), RubyEncoding.ISO), bl.getEncoding().toString());
    }

    @Override
    public void pushByteList(ByteList bl) {
        this.adapter.invokedynamic("bytelist", CodegenUtils.sig(ByteList.class, new Class[0]), Bootstrap.bytelist(), new String(bl.bytes(), RubyEncoding.ISO), bl.getEncoding().toString());
    }

    @Override
    public void pushRegexp(int options2) {
        this.adapter.invokedynamic("regexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class, RubyString.class), RegexpObjectSite.BOOTSTRAP, options2);
    }

    @Override
    public void pushDRegexp(Runnable callback, RegexpOptions options2, int arity2) {
        if (arity2 > 250) {
            throw new NotCompilableException("dynamic regexp has more than 250 elements");
        }
        String cacheField = null;
        Label done = null;
        if (options2.isOnce()) {
            cacheField = "dregexp" + this.getClassData().callSiteCount.getAndIncrement();
            done = new Label();
            this.adapter.getClassVisitor().visitField(10, cacheField, CodegenUtils.ci(RubyRegexp.class), null, null).visitEnd();
            this.adapter.getstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(RubyRegexp.class));
            this.adapter.dup();
            this.adapter.ifnonnull(done);
            this.adapter.pop();
        }
        callback.run();
        this.adapter.invokedynamic("dregexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(ThreadContext.class, RubyString.class, arity2)), DRegexpObjectSite.BOOTSTRAP, options2.toEmbeddedOptions());
        if (done != null) {
            this.adapter.dup();
            this.adapter.putstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(RubyRegexp.class));
            this.adapter.label(done);
        }
    }

    @Override
    public void pushSymbol(String sym, Encoding encoding2) {
        this.loadContext();
        this.adapter.invokedynamic("symbol", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), SymbolObjectSite.BOOTSTRAP, sym, new String(encoding2.getName()));
    }

    @Override
    public void loadRuntime() {
        this.loadContext();
        this.adapter.invokedynamic("runtime", CodegenUtils.sig(Ruby.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushEncoding(Encoding encoding2) {
        this.loadContext();
        this.adapter.invokedynamic("encoding", CodegenUtils.sig(RubyEncoding.class, ThreadContext.class), Bootstrap.contextValueString(), new String(encoding2.getName()));
    }

    @Override
    public void invokeOther(String name2, int arity2, boolean hasClosure) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + name2 + "' has more than " + 250 + " arguments");
        }
        if (hasClosure) {
            if (arity2 == -1) {
                this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class)), NormalInvokeSite.BOOTSTRAP, new Object[0]);
            } else {
                this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, arity2 + 2, Block.class)), NormalInvokeSite.BOOTSTRAP, new Object[0]);
            }
        } else if (arity2 == -1) {
            this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY)), NormalInvokeSite.BOOTSTRAP, new Object[0]);
        } else {
            this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2)), NormalInvokeSite.BOOTSTRAP, new Object[0]);
        }
    }

    @Override
    public void invokeOtherOneFixnum(String name2, long fixnum) {
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.adapter.invokedynamic("fixnumOperator:" + JavaNameMangler.mangleMethodName(name2), signature, InvokeDynamicSupport.getFixnumOperatorHandle(), fixnum, "", 0);
    }

    @Override
    public void invokeOtherOneFloat(String name2, double flote) {
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.adapter.invokedynamic("floatOperator:" + JavaNameMangler.mangleMethodName(name2), signature, InvokeDynamicSupport.getFloatOperatorHandle(), flote, "", 0);
    }

    @Override
    public void invokeSelf(String name2, int arity2, boolean hasClosure) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + name2 + "' has more than " + 250 + " arguments");
        }
        if (hasClosure) {
            if (arity2 == -1) {
                this.adapter.invokedynamic("invokeSelf:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class)), SelfInvokeSite.BOOTSTRAP, new Object[0]);
            } else {
                this.adapter.invokedynamic("invokeSelf:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, arity2 + 2, Block.class)), SelfInvokeSite.BOOTSTRAP, new Object[0]);
            }
        } else if (arity2 == -1) {
            this.adapter.invokedynamic("invokeSelf:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY)), SelfInvokeSite.BOOTSTRAP, new Object[0]);
        } else {
            this.adapter.invokedynamic("invokeSelf:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2)), SelfInvokeSite.BOOTSTRAP, new Object[0]);
        }
    }

    @Override
    public void invokeInstanceSuper(String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to instance super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeInstanceSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString);
        } else {
            this.adapter.invokedynamic("invokeInstanceSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString);
        }
    }

    @Override
    public void invokeClassSuper(String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to class super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeClassSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString);
        } else {
            this.adapter.invokedynamic("invokeClassSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString);
        }
    }

    @Override
    public void invokeUnresolvedSuper(String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to unresolved super has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString);
        } else {
            this.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString);
        }
    }

    @Override
    public void invokeZSuper(String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to zsuper has more than 250 arguments");
        }
        String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
        if (hasClosure) {
            this.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)), Bootstrap.invokeSuper(), splatmapString);
        } else {
            this.adapter.invokedynamic("invokeUnresolvedSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2)), Bootstrap.invokeSuper(), splatmapString);
        }
    }

    @Override
    public void searchConst(String name2, boolean noPrivateConsts) {
        this.adapter.invokedynamic("searchConst:" + name2, CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, StaticScope.class)), Bootstrap.searchConst(), noPrivateConsts ? 1 : 0);
    }

    @Override
    public void inheritanceSearchConst(String name2, boolean noPrivateConsts) {
        this.adapter.invokedynamic("inheritanceSearchConst:" + name2, CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class)), Bootstrap.searchConst(), noPrivateConsts ? 1 : 0);
    }

    @Override
    public void lexicalSearchConst(String name2) {
        this.adapter.invokedynamic("lexicalSearchConst:" + name2, CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, StaticScope.class)), Bootstrap.searchConst(), 0);
    }

    @Override
    public void pushNil() {
        this.loadContext();
        this.adapter.invokedynamic("nil", CodegenUtils.sig(IRubyObject.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushBoolean(boolean b2) {
        this.loadContext();
        this.adapter.invokedynamic(b2 ? "True" : "False", CodegenUtils.sig(IRubyObject.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushBignum(BigInteger bigint) {
        String bigintStr = bigint.toString();
        this.loadContext();
        this.adapter.invokedynamic("bignum", CodegenUtils.sig(RubyBignum.class, ThreadContext.class), BignumObjectSite.BOOTSTRAP, bigintStr);
    }

    @Override
    public void putField(String name2) {
        this.adapter.invokedynamic("ivarSet:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(Void.TYPE, IRubyObject.class, IRubyObject.class), Bootstrap.ivar(), new Object[0]);
    }

    @Override
    public void getField(String name2) {
        this.adapter.invokedynamic("ivarGet:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, IRubyObject.class), Bootstrap.ivar(), new Object[0]);
    }

    @Override
    public void array(int length2) {
        if (length2 > 250) {
            throw new NotCompilableException("literal array has more than 250 elements");
        }
        this.adapter.invokedynamic("array", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2)), Bootstrap.array(), new Object[0]);
    }

    @Override
    public void hash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("literal hash has more than 125 pairs");
        }
        this.adapter.invokedynamic("hash", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2 * 2)), Bootstrap.hash(), new Object[0]);
    }

    @Override
    public void kwargsHash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("kwargs hash has more than 125 pairs");
        }
        this.adapter.invokedynamic("kwargsHash", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, RubyHash.class, JVM.OBJECT, length2 * 2)), Bootstrap.kwargsHash(), new Object[0]);
    }

    @Override
    public void checkpoint() {
        this.loadContext();
        this.adapter.invokedynamic("checkpoint", CodegenUtils.sig(Void.TYPE, ThreadContext.class), InvokeDynamicSupport.checkpointHandle(), new Object[0]);
    }
}

