/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.NormalCachingCallSite;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.RegexpOptions;
import org.objectweb.asm.Label;

public class IRBytecodeAdapter6
extends IRBytecodeAdapter {
    public IRBytecodeAdapter6(SkinnyMethodAdapter adapter, Signature signature, ClassData classData) {
        super(adapter, signature, classData);
    }

    @Override
    public void pushFixnum(long l) {
        this.loadRuntime();
        this.adapter.ldc(l);
        this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "newFixnum", CodegenUtils.sig(RubyFixnum.class, Long.TYPE));
    }

    @Override
    public void pushFloat(double d) {
        this.loadRuntime();
        this.adapter.ldc(d);
        this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "newFloat", CodegenUtils.sig(RubyFloat.class, Double.TYPE));
    }

    @Override
    public void pushString(ByteList bl) {
        this.loadRuntime();
        this.pushByteList(bl);
        this.adapter.invokestatic(CodegenUtils.p(RubyString.class), "newStringShared", CodegenUtils.sig(RubyString.class, Ruby.class, ByteList.class));
    }

    @Override
    public void pushFrozenString(ByteList bl) {
        String cacheField = "frozenString" + this.getClassData().callSiteCount.getAndIncrement();
        Label done = new Label();
        this.adapter.getClassVisitor().visitField(10, cacheField, CodegenUtils.ci(RubyString.class), null, null).visitEnd();
        this.adapter.getstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(RubyString.class));
        this.adapter.dup();
        this.adapter.ifnonnull(done);
        this.adapter.pop();
        this.loadRuntime();
        this.adapter.ldc(bl.toString());
        this.adapter.ldc(bl.getEncoding().toString());
        this.invokeIRHelper("newFrozenStringFromRaw", CodegenUtils.sig(RubyString.class, Ruby.class, String.class, String.class));
        this.adapter.dup();
        this.adapter.putstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(RubyString.class));
        this.adapter.label(done);
    }

    @Override
    public void pushByteList(ByteList bl) {
        String cacheField = "byteList" + this.getClassData().callSiteCount.getAndIncrement();
        Label done = new Label();
        this.adapter.getClassVisitor().visitField(10, cacheField, CodegenUtils.ci(ByteList.class), null, null).visitEnd();
        this.adapter.getstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(ByteList.class));
        this.adapter.dup();
        this.adapter.ifnonnull(done);
        this.adapter.pop();
        this.loadRuntime();
        this.adapter.ldc(bl.toString());
        this.adapter.ldc(bl.getEncoding().toString());
        this.invokeIRHelper("newByteListFromRaw", CodegenUtils.sig(ByteList.class, Ruby.class, String.class, String.class));
        this.adapter.dup();
        this.adapter.putstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(ByteList.class));
        this.adapter.label(done);
    }

    @Override
    public void pushRegexp(int options2) {
        this.adapter.pushInt(options2);
        this.invokeIRHelper("constructRubyRegexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class, RubyString.class, Integer.TYPE));
    }

    @Override
    public void pushDRegexp(Runnable callback, RegexpOptions options2, int arity2) {
        if (arity2 > 250) {
            throw new NotCompilableException("dynamic regexp has more than 250 elements");
        }
        String incomingSig = CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(ThreadContext.class, RubyString.class, arity2, Integer.TYPE));
        if (!this.getClassData().dregexpMethodsDefined.contains(arity2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, "dregexp:" + arity2, incomingSig, null, null);
            adapter2.aload(0);
            IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 1, arity2);
            adapter2.iload(1 + arity2);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "newDynamicRegexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE));
            adapter2.areturn();
            adapter2.end();
            this.getClassData().dregexpMethodsDefined.add(arity2);
        }
        String cacheField = null;
        Label done = null;
        if (options2.isOnce()) {
            cacheField = "dregexp" + this.getClassData().callSiteCount.getAndIncrement();
            done = new Label();
            this.adapter.getClassVisitor().visitField(10, cacheField, CodegenUtils.ci(RubyRegexp.class), null, null).visitEnd();
            this.adapter.getstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(RubyRegexp.class));
            this.adapter.dup();
            this.adapter.ifnonnull(done);
            this.adapter.pop();
        }
        callback.run();
        this.adapter.ldc(options2.toEmbeddedOptions());
        this.adapter.invokestatic(this.getClassData().clsName, "dregexp:" + arity2, incomingSig);
        if (done != null) {
            this.adapter.dup();
            this.adapter.putstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(RubyRegexp.class));
            this.adapter.label(done);
        }
    }

    @Override
    public void pushSymbol(String sym, Encoding encoding2) {
        this.loadRuntime();
        this.adapter.ldc(sym);
        this.loadContext();
        this.adapter.ldc(encoding2.toString());
        this.invokeIRHelper("retrieveJCodingsEncoding", CodegenUtils.sig(Encoding.class, ThreadContext.class, String.class));
        this.adapter.invokestatic(CodegenUtils.p(RubySymbol.class), "newSymbol", CodegenUtils.sig(RubySymbol.class, Ruby.class, String.class, Encoding.class));
    }

    @Override
    public void loadRuntime() {
        this.loadContext();
        this.adapter.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
    }

    @Override
    public void pushEncoding(Encoding encoding2) {
        this.loadContext();
        this.adapter.ldc(encoding2.toString());
        this.invokeIRHelper("retrieveEncoding", CodegenUtils.sig(RubyEncoding.class, ThreadContext.class, String.class));
    }

    @Override
    public void invokeOther(String name2, int arity2, boolean hasClosure) {
        this.invoke(name2, arity2, hasClosure, CallType.NORMAL);
    }

    public void invoke(String name2, int arity2, boolean hasClosure, CallType callType) {
        String outgoingSig;
        String incomingSig;
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + name2 + "' has more than " + 250 + " arguments");
        }
        if (hasClosure) {
            switch (arity2) {
                case -1: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    break;
                }
                default: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    break;
                }
            }
        } else {
            switch (arity2) {
                case -1: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    break;
                }
                default: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                }
            }
        }
        String methodName = "invokeOther" + this.getClassData().callSiteCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(name2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        this.adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(CachingCallSite.class), null, null).visitEnd();
        adapter2.getstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CachingCallSite.class));
        adapter2.dup();
        Label doCall = new Label();
        adapter2.ifnonnull(doCall);
        adapter2.pop();
        adapter2.ldc(name2);
        Class siteClass = callType == CallType.NORMAL ? NormalCachingCallSite.class : FunctionalCachingCallSite.class;
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "new" + siteClass.getSimpleName(), CodegenUtils.sig(siteClass, String.class));
        adapter2.dup();
        adapter2.putstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CachingCallSite.class));
        adapter2.label(doCall);
        adapter2.aload(0);
        adapter2.aload(1);
        adapter2.aload(2);
        switch (arity2) {
            case -1: 
            case 1: {
                adapter2.aload(3);
                if (!hasClosure) break;
                adapter2.aload(4);
                break;
            }
            case 0: {
                if (!hasClosure) break;
                adapter2.aload(3);
                break;
            }
            case 2: {
                adapter2.aload(3);
                adapter2.aload(4);
                if (!hasClosure) break;
                adapter2.aload(5);
                break;
            }
            case 3: {
                adapter2.aload(3);
                adapter2.aload(4);
                adapter2.aload(5);
                if (!hasClosure) break;
                adapter2.aload(6);
                break;
            }
            default: {
                IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 3, arity2);
                if (!hasClosure) break;
                adapter2.aload(3 + arity2);
            }
        }
        adapter2.invokevirtual(CodegenUtils.p(CachingCallSite.class), "call", outgoingSig);
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    public static void buildArrayFromLocals(SkinnyMethodAdapter adapter2, int base, int arity2) {
        int j;
        if (arity2 == 0) {
            adapter2.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            return;
        }
        adapter2.pushInt(arity2);
        adapter2.invokestatic(CodegenUtils.p(Helpers.class), "anewarrayIRubyObjects", CodegenUtils.sig(IRubyObject[].class, Integer.TYPE));
        for (int i2 = 0; i2 < arity2; i2 += j) {
            for (j = 0; i2 + j < arity2 && j < 10; ++j) {
                adapter2.aload(base + i2 + j);
            }
            adapter2.pushInt(i2);
            adapter2.invokestatic(CodegenUtils.p(Helpers.class), "aastoreIRubyObjects", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject.class, j, Integer.TYPE)));
        }
    }

    @Override
    public void invokeOtherOneFixnum(String name2, long fixnum) {
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT));
        String outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, Long.TYPE));
        String methodName = "invokeOtherOneFixnum" + this.getClassData().callSiteCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(name2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        this.adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(CachingCallSite.class), null, null).visitEnd();
        adapter2.getstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CachingCallSite.class));
        adapter2.dup();
        Label doCall = new Label();
        adapter2.ifnonnull(doCall);
        adapter2.pop();
        adapter2.ldc(name2);
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "newNormalCachingCallSite", CodegenUtils.sig(NormalCachingCallSite.class, String.class));
        adapter2.dup();
        adapter2.putstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CachingCallSite.class));
        adapter2.label(doCall);
        adapter2.aload(0);
        adapter2.aload(1);
        adapter2.aload(2);
        adapter2.ldc(fixnum);
        adapter2.invokevirtual(CodegenUtils.p(CachingCallSite.class), "call", outgoingSig);
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeOtherOneFloat(String name2, double flote) {
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT));
        String outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, Double.TYPE));
        String methodName = "invokeOtherOneFloat" + this.getClassData().callSiteCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(name2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        this.adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(CachingCallSite.class), null, null).visitEnd();
        adapter2.getstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CachingCallSite.class));
        adapter2.dup();
        Label doCall = new Label();
        adapter2.ifnonnull(doCall);
        adapter2.pop();
        adapter2.ldc(name2);
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "newNormalCachingCallSite", CodegenUtils.sig(NormalCachingCallSite.class, String.class));
        adapter2.dup();
        adapter2.putstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CachingCallSite.class));
        adapter2.label(doCall);
        adapter2.aload(0);
        adapter2.aload(1);
        adapter2.aload(2);
        adapter2.ldc(flote);
        adapter2.invokevirtual(CodegenUtils.p(CachingCallSite.class), "call", outgoingSig);
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeSelf(String name2, int arity2, boolean hasClosure) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + name2 + "' has more than " + 250 + " arguments");
        }
        this.invoke(name2, arity2, hasClosure, CallType.FUNCTIONAL);
    }

    @Override
    public void invokeInstanceSuper(String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to instance super has more than 250 arguments");
        }
        this.performSuper(name2, arity2, hasClosure, splatmap, "instanceSuperSplatArgs", false);
    }

    @Override
    public void invokeClassSuper(String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to class super has more than 250 arguments");
        }
        this.performSuper(name2, arity2, hasClosure, splatmap, "classSuperSplatArgs", false);
    }

    @Override
    public void invokeUnresolvedSuper(String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to unresolved super has more than 250 arguments");
        }
        this.performSuper(name2, arity2, hasClosure, splatmap, "unresolvedSuperSplatArgs", true);
    }

    @Override
    public void invokeZSuper(String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to zsuper has more than 250 arguments");
        }
        this.performSuper(name2, arity2, hasClosure, splatmap, "zSuperSplatArgs", true);
    }

    private void performSuper(String name2, int arity2, boolean hasClosure, boolean[] splatmap, String helperName, boolean unresolved) {
        String outgoingSig;
        String incomingSig;
        if (hasClosure) {
            incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class));
            outgoingSig = unresolved ? CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, JVM.OBJECT_ARRAY, Block.class, boolean[].class)) : CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, RubyModule.class, JVM.OBJECT_ARRAY, Block.class, boolean[].class));
        } else {
            incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2));
            outgoingSig = unresolved ? CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, JVM.OBJECT_ARRAY, Block.class, boolean[].class)) : CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, RubyModule.class, JVM.OBJECT_ARRAY, Block.class, boolean[].class));
        }
        String methodName = "invokeSuper" + this.getClassData().callSiteCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(name2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.aload(0);
        adapter2.aload(2);
        if (!unresolved) {
            adapter2.ldc(name2);
        }
        if (!unresolved) {
            adapter2.aload(3);
        }
        IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 4, arity2);
        if (hasClosure) {
            adapter2.aload(4 + arity2);
        } else {
            adapter2.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        }
        if (splatmap != null || splatmap.length > 0 || IRBytecodeAdapter6.anyTrue(splatmap)) {
            String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
            adapter2.ldc(splatmapString);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "decodeSplatmap", CodegenUtils.sig(boolean[].class, String.class));
        } else {
            adapter2.getstatic(CodegenUtils.p(IRRuntimeHelpers.class), "EMPTY_BOOLEAN_ARRAY", CodegenUtils.ci(boolean[].class));
        }
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), helperName, outgoingSig);
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    private static boolean anyTrue(boolean[] booleans) {
        for (boolean b2 : booleans) {
            if (!b2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void searchConst(String name2, boolean noPrivateConsts) {
        this.adapter.ldc(name2);
        this.adapter.ldc(noPrivateConsts);
        this.invokeIRHelper("searchConst", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, StaticScope.class, String.class, Boolean.TYPE));
    }

    @Override
    public void inheritanceSearchConst(String name2, boolean noPrivateConsts) {
        this.adapter.ldc(name2);
        this.adapter.ldc(noPrivateConsts);
        this.invokeIRHelper("inheritedSearchConst", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class, Boolean.TYPE));
    }

    @Override
    public void lexicalSearchConst(String name2) {
        this.adapter.ldc(name2);
        this.invokeIRHelper("lexicalSearchConst", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, StaticScope.class, String.class));
    }

    @Override
    public void pushNil() {
        this.loadContext();
        this.adapter.getfield(CodegenUtils.p(ThreadContext.class), "nil", CodegenUtils.ci(IRubyObject.class));
    }

    @Override
    public void pushBoolean(boolean b2) {
        this.loadRuntime();
        this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), b2 ? "getTrue" : "getFalse", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
    }

    @Override
    public void pushBignum(BigInteger bigint) {
        String bigintStr = bigint.toString();
        this.loadRuntime();
        this.adapter.ldc(bigintStr);
        this.adapter.invokestatic(CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(RubyBignum.class, Ruby.class, String.class));
    }

    @Override
    public void putField(String name2) {
        this.adapter.ldc(name2);
        this.invokeIRHelper("setInstanceVariable", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, String.class));
        this.adapter.pop();
    }

    @Override
    public void getField(String name2) {
        this.loadRuntime();
        this.adapter.ldc(name2);
        this.invokeHelper("getInstanceVariable", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class, String.class));
    }

    @Override
    public void array(int length2) {
        if (length2 > 250) {
            throw new NotCompilableException("literal array has more than 250 elements");
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2));
        if (!this.getClassData().arrayMethodsDefined.contains(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, "array:" + length2, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
            IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 1, length2);
            adapter2.invokevirtual(CodegenUtils.p(Ruby.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            this.getClassData().arrayMethodsDefined.add(length2);
        }
        this.adapter.invokestatic(this.getClassData().clsName, "array:" + length2, incomingSig);
    }

    @Override
    public void hash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("literal hash has more than 125 pairs");
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2 * 2));
        if (!this.getClassData().hashMethodsDefined.contains(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, "hash:" + length2, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
            IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 1, length2 * 2);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "constructHashFromArray", CodegenUtils.sig(RubyHash.class, Ruby.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            this.getClassData().hashMethodsDefined.add(length2);
        }
        this.adapter.invokestatic(this.getClassData().clsName, "hash:" + length2, incomingSig);
    }

    @Override
    public void kwargsHash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("kwargs hash has more than 125 pairs");
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, RubyHash.class, IRubyObject.class, length2 * 2));
        if (!this.getClassData().kwargsHashMethodsDefined.contains(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, "kwargsHash:" + length2, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.aload(1);
            IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 2, length2 * 2);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "dupKwargsHashAndPopulateFromArray", CodegenUtils.sig(RubyHash.class, ThreadContext.class, RubyHash.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            this.getClassData().hashMethodsDefined.add(length2);
        }
        this.adapter.invokestatic(this.getClassData().clsName, "kwargsHash:" + length2, incomingSig);
    }

    @Override
    public void checkpoint() {
        this.loadContext();
        this.adapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "callThreadPoll", CodegenUtils.sig(Void.TYPE, new Class[0]));
    }
}

