/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import org.jcodings.Encoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.BuildLambdaInstr;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.ConstMissingInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetEncodingInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.Match2Instr;
import org.jruby.ir.instructions.Match3Instr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.PopBindingInstr;
import org.jruby.ir.instructions.PopFrameInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PushBindingInstr;
import org.jruby.ir.instructions.PushFrameInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseArgumentErrorInstr;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRPersistenceValues;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.lexer.yacc.SimpleSourcePosition;
import org.jruby.runtime.CallType;

class InstrDecoderMap
implements IRPersistenceValues {
    private final IRReaderDecoder d;
    private final IRManager manager;

    public InstrDecoderMap(IRManager manager, IRReaderDecoder decoder) {
        this.manager = manager;
        this.d = decoder;
    }

    public Instr decode(Operation operation) {
        Instr instr = null;
        try {
            instr = this.decodeInner(operation);
        }
        catch (Exception e) {
            System.out.println("Got: " + instr + ", :" + this.d.getCurrentScope().getClass().getName());
            e.printStackTrace();
        }
        return instr;
    }

    public Instr decodeInner(Operation operation) {
        switch (operation) {
            case ALIAS: {
                return new AliasInstr(this.d.decodeOperand(), this.d.decodeOperand());
            }
            case ATTR_ASSIGN: {
                return this.decodeAttrAssignInstr();
            }
            case BEQ: {
                return BEQInstr.create(this.d.decodeOperand(), this.d.decodeOperand(), (Label)this.d.decodeOperand());
            }
            case BINDING_LOAD: {
                return new LoadLocalVarInstr(this.d.decodeScope(), (TemporaryLocalVariable)this.d.decodeOperand(), (LocalVariable)this.d.decodeOperand());
            }
            case BINDING_STORE: {
                return new StoreLocalVarInstr(this.d.decodeOperand(), this.d.decodeScope(), (LocalVariable)this.d.decodeOperand());
            }
            case BLOCK_GIVEN: {
                return new BlockGivenInstr(this.d.decodeVariable(), this.d.decodeOperand());
            }
            case BNE: {
                return new BNEInstr(this.d.decodeOperand(), this.d.decodeOperand(), (Label)this.d.decodeOperand());
            }
            case BREAK: {
                return new BreakInstr(this.d.decodeOperand(), this.d.decodeString());
            }
            case B_FALSE: {
                return this.createBFalse();
            }
            case B_NIL: {
                return this.createBNil();
            }
            case B_TRUE: {
                return this.createBTrue();
            }
            case B_UNDEF: {
                return this.createBUndef();
            }
            case CALL: {
                return this.decodeCall();
            }
            case CHECK_ARGS_ARRAY_ARITY: {
                return new CheckArgsArrayArityInstr(this.d.decodeOperand(), this.d.decodeInt(), this.d.decodeInt(), this.d.decodeInt());
            }
            case CHECK_ARITY: {
                return new CheckArityInstr(this.d.decodeInt(), this.d.decodeInt(), this.d.decodeInt(), this.d.decodeBoolean(), this.d.decodeInt());
            }
            case CLASS_VAR_MODULE: {
                return new GetClassVarContainerModuleInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeVariable());
            }
            case CONST_MISSING: {
                return this.decodeConstMissingInstr();
            }
            case COPY: {
                return this.decodeCopy();
            }
            case DEF_CLASS: {
                return new DefineClassInstr(this.d.decodeVariable(), (IRClassBody)this.d.decodeScope(), this.d.decodeOperand(), this.d.decodeOperand());
            }
            case DEF_CLASS_METH: {
                return new DefineClassMethodInstr(this.d.decodeOperand(), (IRMethod)this.d.decodeScope());
            }
            case DEF_INST_METH: {
                return new DefineInstanceMethodInstr((IRMethod)this.d.decodeScope());
            }
            case DEF_META_CLASS: {
                return new DefineMetaClassInstr(this.d.decodeVariable(), this.d.decodeOperand(), (IRModuleBody)this.d.decodeScope());
            }
            case DEF_MODULE: {
                return new DefineModuleInstr(this.d.decodeVariable(), (IRModuleBody)this.d.decodeScope(), this.d.decodeOperand());
            }
            case EQQ: {
                return new EQQInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeOperand());
            }
            case EXC_REGION_END: {
                return new ExceptionRegionEndMarkerInstr();
            }
            case EXC_REGION_START: {
                return new ExceptionRegionStartMarkerInstr((Label)this.d.decodeOperand());
            }
            case GET_CVAR: {
                return new GetClassVariableInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeString());
            }
            case GET_ENCODING: {
                return new GetEncodingInstr(this.d.decodeVariable(), Encoding.load((String)this.d.decodeString()));
            }
            case GET_ERROR_INFO: {
                return new GetErrorInfoInstr(this.d.decodeVariable());
            }
            case GET_FIELD: {
                return new GetFieldInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeString());
            }
            case GET_GLOBAL_VAR: {
                return new GetGlobalVariableInstr(this.d.decodeVariable(), this.d.decodeString());
            }
            case GVAR_ALIAS: {
                return new GVarAliasInstr(this.d.decodeOperand(), this.d.decodeOperand());
            }
            case INHERITANCE_SEARCH_CONST: {
                return new InheritanceSearchConstInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeString(), this.d.decodeBoolean());
            }
            case JUMP: {
                return new JumpInstr((Label)this.d.decodeOperand());
            }
            case LABEL: {
                return new LabelInstr((Label)this.d.decodeOperand());
            }
            case LAMBDA: {
                return this.decodeLambda();
            }
            case LEXICAL_SEARCH_CONST: {
                return new LexicalSearchConstInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeString());
            }
            case LINE_NUM: {
                return this.decodeLineNumber();
            }
            case MASGN_OPT: {
                return new OptArgMultipleAsgnInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeInt(), this.d.decodeInt());
            }
            case MASGN_REQD: {
                return new ReqdArgMultipleAsgnInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeInt(), this.d.decodeInt(), this.d.decodeInt());
            }
            case MASGN_REST: {
                return new RestArgMultipleAsgnInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeInt(), this.d.decodeInt(), this.d.decodeInt());
            }
            case MATCH: {
                return new MatchInstr(this.d.decodeVariable(), this.d.decodeOperand());
            }
            case MATCH2: {
                return new Match2Instr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeOperand());
            }
            case MATCH3: {
                return new Match3Instr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeOperand());
            }
            case NONLOCAL_RETURN: {
                return new NonlocalReturnInstr(this.d.decodeOperand(), this.d.decodeString());
            }
            case NOP: {
                return NopInstr.NOP;
            }
            case NORESULT_CALL: {
                return this.decodeNoResultCall();
            }
            case POP_BINDING: {
                return new PopBindingInstr();
            }
            case POP_FRAME: {
                return new PopFrameInstr();
            }
            case PROCESS_MODULE_BODY: {
                return new ProcessModuleBodyInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeOperand());
            }
            case PUSH_BINDING: {
                return new PushBindingInstr();
            }
            case PUSH_FRAME: {
                return this.decodeFrame();
            }
            case PUT_CONST: {
                return new PutConstInstr(this.d.decodeOperand(), this.d.decodeString(), this.d.decodeOperand());
            }
            case PUT_CVAR: {
                return new PutClassVariableInstr(this.d.decodeOperand(), this.d.decodeString(), this.d.decodeOperand());
            }
            case PUT_FIELD: {
                return new PutFieldInstr(this.d.decodeOperand(), this.d.decodeString(), this.d.decodeOperand());
            }
            case PUT_GLOBAL_VAR: {
                return new PutGlobalVarInstr(this.d.decodeString(), this.d.decodeOperand());
            }
            case RAISE_ARGUMENT_ERROR: {
                return new RaiseArgumentErrorInstr(this.d.decodeInt(), this.d.decodeInt(), this.d.decodeInt(), this.d.decodeInt());
            }
            case RECORD_END_BLOCK: {
                return new RecordEndBlockInstr(this.d.decodeScope(), (WrappedIRClosure)this.d.decodeOperand());
            }
            case REIFY_CLOSURE: {
                return new ReifyClosureInstr(this.d.decodeVariable(), this.d.decodeVariable());
            }
            case RECV_RUBY_EXC: {
                return this.decodeReceiveRubyException();
            }
            case RECV_JRUBY_EXC: {
                return this.decodeReceiveJRubyException();
            }
            case RECV_KW_ARG: {
                return new ReceiveKeywordArgInstr(this.d.decodeVariable(), this.d.decodeString(), this.d.decodeInt());
            }
            case RECV_KW_REST_ARG: {
                return new ReceiveKeywordRestArgInstr(this.d.decodeVariable(), this.d.decodeInt());
            }
            case RECV_OPT_ARG: {
                return new ReceiveOptArgInstr(this.d.decodeVariable(), this.d.decodeInt(), this.d.decodeInt(), this.d.decodeInt());
            }
            case RECV_POST_REQD_ARG: {
                return new ReceivePostReqdArgInstr(this.d.decodeVariable(), this.d.decodeInt(), this.d.decodeInt(), this.d.decodeInt());
            }
            case RECV_PRE_REQD_ARG: {
                return new ReceivePreReqdArgInstr(this.d.decodeVariable(), this.d.decodeInt());
            }
            case RECV_REST_ARG: {
                return this.decodeReceiveRestArgInstr();
            }
            case RECV_SELF: {
                return new ReceiveSelfInstr(this.d.decodeVariable());
            }
            case RESCUE_EQQ: {
                return new RescueEQQInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeOperand());
            }
            case RESTORE_ERROR_INFO: {
                return new RestoreErrorInfoInstr(this.d.decodeOperand());
            }
            case RETURN: {
                return new ReturnInstr(this.d.decodeOperand());
            }
            case RUNTIME_HELPER: {
                return this.decodeRuntimeHelperCall();
            }
            case SEARCH_CONST: {
                return this.decodeSearchConst();
            }
            case CLASS_SUPER: {
                return this.decodeSuperInstr(operation);
            }
            case INSTANCE_SUPER: {
                return this.decodeSuperInstr(operation);
            }
            case UNRESOLVED_SUPER: {
                return this.decodeUnresolvedSuperInstr();
            }
            case THREAD_POLL: {
                return new ThreadPollInstr(this.d.decodeBoolean());
            }
            case THROW: {
                return new ThrowExceptionInstr(this.d.decodeOperand());
            }
            case TO_ARY: {
                return new ToAryInstr(this.d.decodeVariable(), this.d.decodeOperand());
            }
            case UNDEF_METHOD: {
                return new UndefMethodInstr(this.d.decodeVariable(), this.d.decodeOperand());
            }
            case YIELD: {
                return new YieldInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeOperand(), this.d.decodeBoolean());
            }
            case ZSUPER: {
                return this.decodeZSuperInstr();
            }
        }
        throw new IllegalArgumentException("Whoa bro: " + (Object)((Object)operation));
    }

    private Instr decodeAttrAssignInstr() {
        Operand op = this.d.decodeOperand();
        String methAddr = this.d.decodeString();
        int length2 = this.d.decodeInt();
        Operand[] args2 = new Operand[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            args2[i2] = this.d.decodeOperand();
        }
        return AttrAssignInstr.create(op, methAddr, args2);
    }

    private Instr decodeCall() {
        int argsLength;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call");
        }
        Variable result2 = this.d.decodeVariable();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, result:  " + result2);
        }
        int callTypeOrdinal = this.d.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, calltype(ord):  " + callTypeOrdinal);
        }
        String methAddr = this.d.decodeString();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, methaddr:  " + methAddr);
        }
        Operand receiver2 = this.d.decodeOperand();
        int argsCount = this.d.decodeInt();
        boolean hasClosureArg = argsCount < 0;
        int n = argsLength = hasClosureArg ? -1 * (argsCount + 1) : argsCount;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("ARGS: " + argsLength + ", CLOSURE: " + hasClosureArg);
        }
        Operand[] args2 = new Operand[argsLength];
        for (int i2 = 0; i2 < argsLength; ++i2) {
            args2[i2] = this.d.decodeOperand();
        }
        Operand closure = hasClosureArg ? this.d.decodeOperand() : null;
        return CallInstr.create(CallType.fromOrdinal(callTypeOrdinal), result2, methAddr, receiver2, args2, closure);
    }

    private Instr decodeFrame() {
        String methAddr = this.d.decodeString();
        return new PushFrameInstr(methAddr);
    }

    private Instr decodeConstMissingInstr() {
        return new ConstMissingInstr(this.d.decodeVariable(), this.d.decodeOperand(), this.d.decodeString());
    }

    private Instr decodeLambda() {
        Variable v = this.d.decodeVariable();
        WrappedIRClosure c = (WrappedIRClosure)this.d.decodeOperand();
        return new BuildLambdaInstr(v, c, new SimpleSourcePosition(this.d.decodeString(), this.d.decodeInt()));
    }

    private Instr decodeNoResultCall() {
        int argsLength;
        int callTypeOrdinal = this.d.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, ordinal:  " + callTypeOrdinal);
        }
        String methAddr = this.d.decodeString();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, methaddr:  " + methAddr);
        }
        Operand receiver2 = this.d.decodeOperand();
        int argsCount = this.d.decodeInt();
        boolean hasClosureArg = argsCount < 0;
        int n = argsLength = hasClosureArg ? -1 * (argsCount + 1) : argsCount;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("ARGS: " + argsLength + ", CLOSURE: " + hasClosureArg);
        }
        Operand[] args2 = new Operand[argsLength];
        for (int i2 = 0; i2 < argsLength; ++i2) {
            args2[i2] = this.d.decodeOperand();
        }
        Operand closure = hasClosureArg ? this.d.decodeOperand() : null;
        return NoResultCallInstr.create(CallType.fromOrdinal(callTypeOrdinal), methAddr, receiver2, args2, closure);
    }

    private Instr decodeCopy() {
        return new CopyInstr(this.d.decodeVariable(), this.d.decodeOperand());
    }

    private Instr decodeLineNumber() {
        return new LineNumberInstr(this.d.decodeInt());
    }

    private Instr decodeReceiveRestArgInstr() {
        return new ReceiveRestArgInstr(this.d.decodeVariable(), this.d.decodeInt(), this.d.decodeInt());
    }

    private Instr decodeRuntimeHelperCall() {
        Variable result2 = this.d.decodeVariable();
        String name2 = "";
        int size2 = this.d.decodeInt();
        Operand[] args2 = new Operand[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            args2[i2] = this.d.decodeOperand();
        }
        return new RuntimeHelperCall(result2, null, args2);
    }

    private Instr decodeSearchConst() {
        Variable result2 = this.d.decodeVariable();
        String constName = this.d.decodeString();
        Operand startScope = this.d.decodeOperand();
        boolean noPrivateConst = this.d.decodeBoolean();
        return new SearchConstInstr(result2, constName, startScope, noPrivateConst);
    }

    private Instr createBFalse() {
        return new BFalseInstr(this.d.decodeOperand(), (Label)this.d.decodeOperand());
    }

    private Instr createBTrue() {
        return new BTrueInstr(this.d.decodeOperand(), (Label)this.d.decodeOperand());
    }

    private Instr createBNil() {
        return new BNilInstr(this.d.decodeOperand(), (Label)this.d.decodeOperand());
    }

    private Instr createBUndef() {
        return new BUndefInstr(this.d.decodeOperand(), (Label)this.d.decodeOperand());
    }

    private Instr decodeReceiveRubyException() {
        return new ReceiveRubyExceptionInstr(this.d.decodeVariable());
    }

    private Instr decodeReceiveJRubyException() {
        return new ReceiveJRubyExceptionInstr(this.d.decodeVariable());
    }

    private Instr decodeSuperInstr(Operation operation) {
        Operand closure;
        int argsLength;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding super");
        }
        Variable result2 = this.d.decodeVariable();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding super, result:  " + result2);
        }
        int callTypeOrdinal = this.d.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding super, calltype(ord):  " + callTypeOrdinal);
        }
        String methAddr = this.d.decodeString();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding super, methaddr:  " + methAddr);
        }
        Operand receiver2 = this.d.decodeOperand();
        int argsCount = this.d.decodeInt();
        boolean hasClosureArg = argsCount < 0;
        int n = argsLength = hasClosureArg ? -1 * (argsCount + 1) : argsCount;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("ARGS: " + argsLength + ", CLOSURE: " + hasClosureArg);
        }
        Operand[] args2 = new Operand[argsLength];
        for (int i2 = 0; i2 < argsLength; ++i2) {
            args2[i2] = this.d.decodeOperand();
        }
        Operand operand = closure = hasClosureArg ? this.d.decodeOperand() : null;
        if (operation == Operation.CLASS_SUPER) {
            return new ClassSuperInstr(result2, receiver2, methAddr, args2, closure);
        }
        return new InstanceSuperInstr(result2, receiver2, methAddr, args2, closure);
    }

    public Instr decodeUnresolvedSuperInstr() {
        int argsLength;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding un. super");
        }
        Variable result2 = this.d.decodeVariable();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding un. super, result:  " + result2);
        }
        int callTypeOrdinal = this.d.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding un. super, calltype(ord):  " + callTypeOrdinal);
        }
        Operand receiver2 = this.d.decodeOperand();
        int argsCount = this.d.decodeInt();
        boolean hasClosureArg = argsCount < 0;
        int n = argsLength = hasClosureArg ? -1 * (argsCount + 1) : argsCount;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("ARGS: " + argsLength + ", CLOSURE: " + hasClosureArg);
        }
        Operand[] args2 = new Operand[argsLength];
        for (int i2 = 0; i2 < argsLength; ++i2) {
            args2[i2] = this.d.decodeOperand();
        }
        Operand closure = hasClosureArg ? this.d.decodeOperand() : null;
        return new UnresolvedSuperInstr(result2, receiver2, args2, closure);
    }

    public Instr decodeZSuperInstr() {
        Variable result2 = this.d.decodeVariable();
        Operand receiver2 = this.d.decodeOperand();
        boolean hasClosure = this.d.decodeBoolean();
        Operand closure = hasClosure ? this.d.decodeOperand() : null;
        int argsLength = this.d.decodeInt();
        Operand[] args2 = new Operand[argsLength];
        for (int i2 = 0; i2 < argsLength; ++i2) {
            args2[i2] = this.d.decodeOperand();
        }
        return new ZSuperInstr(result2, receiver2, args2, closure);
    }
}

