/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CFGBuilder;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

public class LocalOptimizationPass
extends CompilerPass {
    public static List<Class<? extends CompilerPass>> DEPENDENCIES = Arrays.asList(CFGBuilder.class);

    @Override
    public String getLabel() {
        return "Local Optimizations";
    }

    @Override
    public List<Class<? extends CompilerPass>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public Object execute(IRScope s2, Object ... data2) {
        for (IRClosure c : s2.getClosures()) {
            this.run(c, false, true);
        }
        for (BasicBlock b2 : ((CFG)data2[0]).getBasicBlocks()) {
            LocalOptimizationPass.runLocalOptsOnInstrList(s2, b2.getInstrs().listIterator(), false);
        }
        s2.computeScopeFlags();
        new LiveVariableAnalysis().invalidate(s2);
        return null;
    }

    private static void recordSimplification(Variable res, Operand val, Map<Operand, Operand> valueMap, Map<Variable, List<Variable>> simplificationMap) {
        valueMap.put(res, val);
        ArrayList<Variable> valVars = new ArrayList<Variable>();
        val.addUsedVariables(valVars);
        for (Variable v : valVars) {
            List<Variable> x = simplificationMap.get(v);
            if (x == null) {
                x = new ArrayList<Variable>();
                simplificationMap.put(v, x);
            }
            x.add(res);
        }
    }

    public static void runLocalOptsOnInstrList(IRScope s2, ListIterator<Instr> instrs, boolean preCFG) {
        HashMap<Operand, Operand> valueMap = new HashMap<Operand, Operand>();
        HashMap<Variable, List<Variable>> simplificationMap = new HashMap<Variable, List<Variable>>();
        while (instrs.hasNext()) {
            List simplifiedVars;
            Variable res;
            Instr i2 = instrs.next();
            Operation iop = i2.getOperation();
            if (preCFG && iop.startsBasicBlock()) {
                valueMap = new HashMap();
                simplificationMap = new HashMap();
            }
            Operand val = i2.simplifyAndGetResult(s2, valueMap);
            Variable variable = res = i2 instanceof ResultInstr ? ((ResultInstr)((Object)i2)).getResult() : null;
            if (res != null && val != null) {
                if (!res.equals(val)) {
                    LocalOptimizationPass.recordSimplification(res, val, valueMap, simplificationMap);
                }
                if (!i2.hasSideEffects()) {
                    if (i2 instanceof CopyInstr) {
                        if (res.equals(val) && i2.canBeDeleted(s2)) {
                            i2.markDead();
                            instrs.remove();
                        }
                    } else {
                        instrs.set(new CopyInstr(res, val));
                    }
                }
            } else if (res != null && val == null) {
                valueMap.remove(res);
            }
            if (res != null && !res.equals(val) && (simplifiedVars = (List)simplificationMap.get(res)) != null) {
                for (Variable v : simplifiedVars) {
                    valueMap.remove(v);
                }
                simplificationMap.remove(res);
            }
            if ((!preCFG || !iop.endsBasicBlock()) && (!iop.isCall() || i2.isDead())) continue;
            valueMap = new HashMap();
            simplificationMap = new HashMap();
        }
    }
}

