/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.List;
import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.RootNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRTranslator;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.TraceInstr;
import org.jruby.ir.instructions.boxing.AluInstr;
import org.jruby.ir.instructions.boxing.BoxBooleanInstr;
import org.jruby.ir.instructions.boxing.BoxFixnumInstr;
import org.jruby.ir.instructions.boxing.BoxFloatInstr;
import org.jruby.ir.instructions.boxing.BoxInstr;
import org.jruby.ir.instructions.boxing.UnboxInstr;
import org.jruby.ir.instructions.specialized.OneFixnumArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneFloatArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockNoResultCallInstr;
import org.jruby.ir.instructions.specialized.ZeroOperandArgNoBlockCallInstr;
import org.jruby.ir.interpreter.BeginEndInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.interpreter.Profiler;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UnboxedBoolean;
import org.jruby.ir.operands.UnboxedFixnum;
import org.jruby.ir.operands.UnboxedFloat;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class Interpreter
extends IRTranslator<IRubyObject, IRubyObject> {
    private static final Logger LOG = LoggerFactory.getLogger("Interpreter");
    private static final IRubyObject[] EMPTY_ARGS = new IRubyObject[0];
    private static int interpInstrsCount = 0;

    private Interpreter() {
    }

    public static Interpreter getInstance() {
        return InterpreterHolder.instance;
    }

    public static void dumpStats() {
        if ((IRRuntimeHelpers.isDebug() || IRRuntimeHelpers.inProfileMode()) && interpInstrsCount > 10000) {
            LOG.info("-- Interpreted instructions: {}", interpInstrsCount);
        }
    }

    public static void runBeginBlocks(List<IRClosure> beBlocks, ThreadContext context, IRubyObject self2, StaticScope currScope, Object[] temp) {
        if (beBlocks == null) {
            return;
        }
        for (IRClosure b2 : beBlocks) {
            b2.prepareForInterpretation();
            Block blk = (Block)new WrappedIRClosure(b2.getSelf(), b2).retrieve(context, self2, currScope, context.getCurrentScope(), temp);
            blk.yield(context, null);
        }
    }

    @Override
    protected IRubyObject execute(Ruby runtime, IRScriptBody irScope, IRubyObject self2) {
        StaticScope scope;
        RubyModule currModule;
        BeginEndInterpreterContext ic = (BeginEndInterpreterContext)irScope.prepareForInterpretation();
        ThreadContext context = runtime.getCurrentContext();
        String name2 = "(root)";
        if (IRRuntimeHelpers.isDebug()) {
            LOG.info("Executing " + ic, new Object[0]);
        }
        if ((currModule = (scope = ic.getStaticScope()).getModule()) == null) {
            currModule = context.getRuntime().getObject();
        }
        scope.setModule(currModule);
        DynamicScope tlbScope = irScope.getToplevelScope();
        if (tlbScope == null) {
            context.preMethodScopeOnly(scope);
        } else {
            context.preScopedBody(tlbScope);
            tlbScope.growIfNeeded();
        }
        context.setCurrentVisibility(Visibility.PRIVATE);
        try {
            Interpreter.runBeginBlocks(ic.getBeginBlocks(), context, self2, scope, null);
            IRubyObject iRubyObject = Interpreter.INTERPRET_ROOT(context, self2, ic, currModule, name2);
            return iRubyObject;
        }
        catch (IRBreakJump bj) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
        finally {
            Interpreter.dumpStats();
            context.popScope();
        }
    }

    private static void setResult(Object[] temp, DynamicScope currDynScope, Variable resultVar, Object result2) {
        if (resultVar instanceof TemporaryVariable) {
            temp[((TemporaryLocalVariable)resultVar).offset] = result2;
        } else {
            LocalVariable lv = (LocalVariable)resultVar;
            currDynScope.setValue((IRubyObject)result2, lv.getLocation(), lv.getScopeDepth());
        }
    }

    private static void setResult(Object[] temp, DynamicScope currDynScope, Instr instr, Object result2) {
        if (instr instanceof ResultInstr) {
            Interpreter.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), result2);
        }
    }

    private static Object retrieveOp(Operand r, ThreadContext context, IRubyObject self2, DynamicScope currDynScope, StaticScope currScope, Object[] temp) {
        if (r instanceof Self) {
            return self2;
        }
        if (r instanceof TemporaryLocalVariable) {
            Object res = temp[((TemporaryLocalVariable)r).offset];
            return res == null ? context.nil : res;
        }
        if (r instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)r;
            IRubyObject res = currDynScope.getValue(lv.getLocation(), lv.getScopeDepth());
            return res == null ? context.nil : res;
        }
        return r.retrieve(context, self2, currScope, currDynScope, temp);
    }

    private static double getFloatArg(double[] floats, Operand arg2) {
        if (arg2 instanceof Float) {
            return ((Float)arg2).value;
        }
        if (arg2 instanceof UnboxedFloat) {
            return ((UnboxedFloat)arg2).value;
        }
        if (arg2 instanceof Fixnum) {
            return ((Fixnum)arg2).value;
        }
        if (arg2 instanceof UnboxedFixnum) {
            return ((UnboxedFixnum)arg2).value;
        }
        if (arg2 instanceof Bignum) {
            return ((Bignum)arg2).value.doubleValue();
        }
        if (arg2 instanceof TemporaryLocalVariable) {
            return floats[((TemporaryLocalVariable)arg2).offset];
        }
        throw new RuntimeException("invalid float operand: " + arg2);
    }

    private static long getFixnumArg(long[] fixnums, Operand arg2) {
        if (arg2 instanceof Float) {
            return (long)((Float)arg2).value;
        }
        if (arg2 instanceof UnboxedFixnum) {
            return ((UnboxedFixnum)arg2).value;
        }
        if (arg2 instanceof Fixnum) {
            return ((Fixnum)arg2).value;
        }
        if (arg2 instanceof Bignum) {
            return ((Bignum)arg2).value.longValue();
        }
        if (arg2 instanceof TemporaryLocalVariable) {
            return fixnums[((TemporaryLocalVariable)arg2).offset];
        }
        throw new RuntimeException("invalid fixnum operand: " + arg2);
    }

    private static boolean getBooleanArg(boolean[] booleans, Operand arg2) {
        if (arg2 instanceof UnboxedBoolean) {
            return ((UnboxedBoolean)arg2).isTrue();
        }
        if (arg2 instanceof TemporaryLocalVariable) {
            return booleans[((TemporaryLocalVariable)arg2).offset];
        }
        throw new RuntimeException("invalid fixnum operand: " + arg2);
    }

    private static void setFloatVar(double[] floats, TemporaryLocalVariable var, double val) {
        floats[var.offset] = val;
    }

    private static void setFixnumVar(long[] fixnums, TemporaryLocalVariable var, long val) {
        fixnums[var.offset] = val;
    }

    private static void setBooleanVar(boolean[] booleans, TemporaryLocalVariable var, boolean val) {
        booleans[var.offset] = val;
    }

    private static void interpretIntOp(AluInstr instr, Operation op, long[] fixnums, boolean[] booleans) {
        TemporaryLocalVariable dst = (TemporaryLocalVariable)instr.getResult();
        long i1 = Interpreter.getFixnumArg(fixnums, instr.getArg1());
        long i2 = Interpreter.getFixnumArg(fixnums, instr.getArg2());
        switch (op) {
            case IADD: {
                Interpreter.setFixnumVar(fixnums, dst, i1 + i2);
                break;
            }
            case ISUB: {
                Interpreter.setFixnumVar(fixnums, dst, i1 - i2);
                break;
            }
            case IMUL: {
                Interpreter.setFixnumVar(fixnums, dst, i1 * i2);
                break;
            }
            case IDIV: {
                Interpreter.setFixnumVar(fixnums, dst, i1 / i2);
                break;
            }
            case IOR: {
                Interpreter.setFixnumVar(fixnums, dst, i1 | i2);
                break;
            }
            case IAND: {
                Interpreter.setFixnumVar(fixnums, dst, i1 & i2);
                break;
            }
            case IXOR: {
                Interpreter.setFixnumVar(fixnums, dst, i1 ^ i2);
                break;
            }
            case ISHL: {
                Interpreter.setFixnumVar(fixnums, dst, i1 << (int)i2);
                break;
            }
            case ISHR: {
                Interpreter.setFixnumVar(fixnums, dst, i1 >> (int)i2);
                break;
            }
            case ILT: {
                Interpreter.setBooleanVar(booleans, dst, i1 < i2);
                break;
            }
            case IGT: {
                Interpreter.setBooleanVar(booleans, dst, i1 > i2);
                break;
            }
            case IEQ: {
                Interpreter.setBooleanVar(booleans, dst, i1 == i2);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled int op: " + (Object)((Object)op) + " for instr " + instr);
            }
        }
    }

    private static void interpretFloatOp(AluInstr instr, Operation op, double[] floats, boolean[] booleans) {
        TemporaryLocalVariable dst = (TemporaryLocalVariable)instr.getResult();
        double a1 = Interpreter.getFloatArg(floats, instr.getArg1());
        double a2 = Interpreter.getFloatArg(floats, instr.getArg2());
        switch (op) {
            case FADD: {
                Interpreter.setFloatVar(floats, dst, a1 + a2);
                break;
            }
            case FSUB: {
                Interpreter.setFloatVar(floats, dst, a1 - a2);
                break;
            }
            case FMUL: {
                Interpreter.setFloatVar(floats, dst, a1 * a2);
                break;
            }
            case FDIV: {
                Interpreter.setFloatVar(floats, dst, a1 / a2);
                break;
            }
            case FLT: {
                Interpreter.setBooleanVar(booleans, dst, a1 < a2);
                break;
            }
            case FGT: {
                Interpreter.setBooleanVar(booleans, dst, a1 > a2);
                break;
            }
            case FEQ: {
                Interpreter.setBooleanVar(booleans, dst, a1 == a2);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled float op: " + (Object)((Object)op) + " for instr " + instr);
            }
        }
    }

    private static void receiveArg(ThreadContext context, Instr i2, Operation operation, IRubyObject[] args2, boolean acceptsKeywordArgument, DynamicScope currDynScope, Object[] temp, Object exception2, Block block) {
        ResultInstr instr = (ResultInstr)((Object)i2);
        switch (operation) {
            case RECV_PRE_REQD_ARG: {
                int argIndex = ((ReceivePreReqdArgInstr)instr).getArgIndex();
                IRubyObject result2 = IRRuntimeHelpers.getPreArgSafe(context, args2, argIndex);
                Interpreter.setResult(temp, currDynScope, instr.getResult(), (Object)result2);
                return;
            }
            case RECV_POST_REQD_ARG: {
                IRubyObject result2 = ((ReceivePostReqdArgInstr)instr).receivePostReqdArg(args2, acceptsKeywordArgument);
                Interpreter.setResult(temp, currDynScope, instr.getResult(), (Object)(result2 == null ? context.nil : result2));
                return;
            }
            case RECV_RUBY_EXC: {
                Interpreter.setResult(temp, currDynScope, instr.getResult(), IRRuntimeHelpers.unwrapRubyException(exception2));
                return;
            }
            case RECV_JRUBY_EXC: {
                Interpreter.setResult(temp, currDynScope, instr.getResult(), exception2);
                return;
            }
            case LOAD_IMPLICIT_CLOSURE: {
                Interpreter.setResult(temp, currDynScope, instr.getResult(), (Object)block);
                return;
            }
        }
        IRubyObject result2 = ((ReceiveArgBase)instr).receiveArg(context, args2, acceptsKeywordArgument);
        Interpreter.setResult(temp, currDynScope, instr.getResult(), (Object)result2);
    }

    private static void processCall(ThreadContext context, Instr instr, Operation operation, DynamicScope currDynScope, StaticScope currScope, Object[] temp, IRubyObject self2) {
        switch (operation) {
            case CALL_1F: {
                OneFixnumArgNoBlockCallInstr call2 = (OneFixnumArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)Interpreter.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject result2 = call2.getCallSite().call(context, self2, r, call2.getFixnumArg());
                Interpreter.setResult(temp, currDynScope, call2.getResult(), (Object)result2);
                break;
            }
            case CALL_1D: {
                OneFloatArgNoBlockCallInstr call3 = (OneFloatArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)Interpreter.retrieveOp(call3.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject result2 = call3.getCallSite().call(context, self2, r, call3.getFloatArg());
                Interpreter.setResult(temp, currDynScope, call3.getResult(), (Object)result2);
                break;
            }
            case CALL_1O: {
                OneOperandArgNoBlockCallInstr call4 = (OneOperandArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)Interpreter.retrieveOp(call4.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject o = (IRubyObject)call4.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                IRubyObject result2 = call4.getCallSite().call(context, self2, r, o);
                Interpreter.setResult(temp, currDynScope, call4.getResult(), (Object)result2);
                break;
            }
            case CALL_1OB: {
                OneOperandArgBlockCallInstr call5 = (OneOperandArgBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)Interpreter.retrieveOp(call5.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject o = (IRubyObject)call5.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                Block preparedBlock = call5.prepareBlock(context, self2, currScope, currDynScope, temp);
                IRubyObject result2 = call5.getCallSite().call(context, self2, r, o, preparedBlock);
                Interpreter.setResult(temp, currDynScope, call5.getResult(), (Object)result2);
                break;
            }
            case CALL_0O: {
                ZeroOperandArgNoBlockCallInstr call6 = (ZeroOperandArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)Interpreter.retrieveOp(call6.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject result2 = call6.getCallSite().call(context, self2, r);
                Interpreter.setResult(temp, currDynScope, call6.getResult(), (Object)result2);
                break;
            }
            case NORESULT_CALL_1O: {
                OneOperandArgNoBlockNoResultCallInstr call7 = (OneOperandArgNoBlockNoResultCallInstr)instr;
                IRubyObject r = (IRubyObject)Interpreter.retrieveOp(call7.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject o = (IRubyObject)call7.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                call7.getCallSite().call(context, self2, r, o);
                break;
            }
            case NORESULT_CALL: {
                instr.interpret(context, currScope, currDynScope, self2, temp);
                break;
            }
            default: {
                Object result2 = instr.interpret(context, currScope, currDynScope, self2, temp);
                Interpreter.setResult(temp, currDynScope, instr, result2);
            }
        }
    }

    private static void processBookKeepingOp(ThreadContext context, Instr instr, Operation operation, String name2, IRubyObject[] args2, IRubyObject self2, Block block, RubyModule implClass) {
        switch (operation) {
            case PUSH_FRAME: {
                context.preMethodFrameOnly(implClass, name2, self2, block);
                context.setCurrentVisibility(Visibility.PUBLIC);
                break;
            }
            case POP_FRAME: {
                context.popFrame();
                break;
            }
            case POP_BINDING: {
                context.popScope();
                break;
            }
            case THREAD_POLL: {
                if (IRRuntimeHelpers.inProfileMode()) {
                    Profiler.clockTick();
                }
                context.callThreadPoll();
                break;
            }
            case CHECK_ARITY: {
                ((CheckArityInstr)instr).checkArity(context, args2);
                break;
            }
            case LINE_NUM: {
                context.setLine(((LineNumberInstr)instr).lineNumber);
                break;
            }
            case TRACE: {
                if (!context.runtime.hasEventHooks()) break;
                TraceInstr trace = (TraceInstr)instr;
                int linenumber = trace.getLinenumber() == -1 ? context.getLine() + 1 : trace.getLinenumber();
                context.trace(trace.getEvent(), trace.getName(), context.getFrameKlazz(), trace.getFilename(), linenumber);
            }
        }
    }

    private static IRubyObject processReturnOp(ThreadContext context, Instr instr, Operation operation, DynamicScope currDynScope, Object[] temp, IRubyObject self2, Block.Type blockType, StaticScope currScope) {
        switch (operation) {
            case RETURN: {
                return (IRubyObject)Interpreter.retrieveOp(((ReturnBase)instr).getReturnValue(), context, self2, currDynScope, currScope, temp);
            }
            case BREAK: {
                BreakInstr bi = (BreakInstr)instr;
                IRubyObject rv = (IRubyObject)bi.getReturnValue().retrieve(context, self2, currScope, currDynScope, temp);
                return IRRuntimeHelpers.initiateBreak(context, currDynScope, rv, blockType);
            }
            case NONLOCAL_RETURN: {
                NonlocalReturnInstr ri = (NonlocalReturnInstr)instr;
                IRubyObject rv = (IRubyObject)Interpreter.retrieveOp(ri.getReturnValue(), context, self2, currDynScope, currScope, temp);
                return IRRuntimeHelpers.initiateNonLocalReturn(context, currDynScope, blockType, rv);
            }
        }
        return null;
    }

    private static void processOtherOp(ThreadContext context, Instr instr, Operation operation, DynamicScope currDynScope, StaticScope currScope, Object[] temp, IRubyObject self2, Block.Type blockType, double[] floats, long[] fixnums, boolean[] booleans) {
        switch (operation) {
            case COPY: {
                CopyInstr c = (CopyInstr)instr;
                Operand src = c.getSource();
                Variable res = c.getResult();
                if (res instanceof TemporaryFloatVariable) {
                    Interpreter.setFloatVar(floats, (TemporaryFloatVariable)res, Interpreter.getFloatArg(floats, src));
                    break;
                }
                if (res instanceof TemporaryFixnumVariable) {
                    Interpreter.setFixnumVar(fixnums, (TemporaryFixnumVariable)res, Interpreter.getFixnumArg(fixnums, src));
                    break;
                }
                Interpreter.setResult(temp, currDynScope, res, Interpreter.retrieveOp(src, context, self2, currDynScope, currScope, temp));
                break;
            }
            case GET_FIELD: {
                IRubyObject result2;
                GetFieldInstr gfi = (GetFieldInstr)instr;
                IRubyObject object = (IRubyObject)gfi.getSource().retrieve(context, self2, currScope, currDynScope, temp);
                VariableAccessor a = gfi.getAccessor(object);
                IRubyObject iRubyObject = result2 = a == null ? null : (IRubyObject)a.get(object);
                if (result2 == null) {
                    if (context.runtime.isVerbose()) {
                        context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + gfi.getRef() + " not initialized");
                    }
                    result2 = context.nil;
                }
                Interpreter.setResult(temp, currDynScope, gfi.getResult(), (Object)result2);
                break;
            }
            case SEARCH_CONST: {
                SearchConstInstr sci = (SearchConstInstr)instr;
                ConstantCache cache = sci.getConstantCache();
                Object result3 = !ConstantCache.isCached(cache) ? sci.cache(context, currScope, currDynScope, self2, temp) : cache.value;
                Interpreter.setResult(temp, currDynScope, sci.getResult(), result3);
                break;
            }
            case RUNTIME_HELPER: {
                RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                IRubyObject result3 = rhc.callHelper(context, currScope, currDynScope, self2, temp, blockType);
                if (rhc.getResult() == null) break;
                Interpreter.setResult(temp, currDynScope, rhc.getResult(), (Object)result3);
                break;
            }
            case BOX_FLOAT: {
                RubyFloat f = context.runtime.newFloat(Interpreter.getFloatArg(floats, ((BoxFloatInstr)instr).getValue()));
                Interpreter.setResult(temp, currDynScope, ((BoxInstr)instr).getResult(), (Object)f);
                break;
            }
            case BOX_FIXNUM: {
                RubyFixnum f = context.runtime.newFixnum(Interpreter.getFixnumArg(fixnums, ((BoxFixnumInstr)instr).getValue()));
                Interpreter.setResult(temp, currDynScope, ((BoxInstr)instr).getResult(), (Object)f);
                break;
            }
            case BOX_BOOLEAN: {
                RubyBoolean f = context.runtime.newBoolean(Interpreter.getBooleanArg(booleans, ((BoxBooleanInstr)instr).getValue()));
                Interpreter.setResult(temp, currDynScope, ((BoxInstr)instr).getResult(), (Object)f);
                break;
            }
            case UNBOX_FLOAT: {
                UnboxInstr ui = (UnboxInstr)instr;
                Object val = Interpreter.retrieveOp(ui.getValue(), context, self2, currDynScope, currScope, temp);
                if (val instanceof RubyFloat) {
                    floats[((TemporaryLocalVariable)ui.getResult()).offset] = ((RubyFloat)val).getValue();
                    break;
                }
                floats[((TemporaryLocalVariable)ui.getResult()).offset] = ((RubyFixnum)val).getDoubleValue();
                break;
            }
            case UNBOX_FIXNUM: {
                UnboxInstr ui = (UnboxInstr)instr;
                Object val = Interpreter.retrieveOp(ui.getValue(), context, self2, currDynScope, currScope, temp);
                if (val instanceof RubyFloat) {
                    fixnums[((TemporaryLocalVariable)ui.getResult()).offset] = ((RubyFloat)val).getLongValue();
                    break;
                }
                fixnums[((TemporaryLocalVariable)ui.getResult()).offset] = ((RubyFixnum)val).getLongValue();
                break;
            }
            case LOAD_FRAME_CLOSURE: {
                Interpreter.setResult(temp, currDynScope, instr, (Object)context.getFrameBlock());
                return;
            }
            default: {
                Object result3 = instr.interpret(context, currScope, currDynScope, self2, temp);
                Interpreter.setResult(temp, currDynScope, instr, result3);
            }
        }
    }

    private static IRubyObject interpret(ThreadContext context, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject[] args2, Block block, Block.Type blockType) {
        Instr[] instrs = interpreterContext.getInstructions();
        Object[] temp = interpreterContext.allocateTemporaryVariables();
        double[] floats = interpreterContext.allocateTemporaryFloatVariables();
        long[] fixnums = interpreterContext.allocateTemporaryFixnumVariables();
        boolean[] booleans = interpreterContext.allocateTemporaryBooleanVariables();
        int n = instrs.length;
        int ipc = 0;
        Throwable exception2 = null;
        StaticScope currScope = interpreterContext.getStaticScope();
        DynamicScope currDynScope = context.getCurrentScope();
        IRScope scope = currScope.getIRScope();
        boolean acceptsKeywordArgument = interpreterContext.receivesKeywordArguments();
        boolean debug = IRRuntimeHelpers.isDebug();
        boolean profile = IRRuntimeHelpers.inProfileMode();
        Integer scopeVersion = profile ? Profiler.initProfiling(scope) : 0;
        while (ipc < n) {
            Instr instr = instrs[ipc];
            ++ipc;
            Operation operation = instr.getOperation();
            if (debug) {
                LOG.info("I: {}", instr);
                ++interpInstrsCount;
            } else if (profile) {
                Profiler.instrTick(operation);
                ++interpInstrsCount;
            }
            try {
                block1 : switch (operation.opClass) {
                    case INT_OP: {
                        Interpreter.interpretIntOp((AluInstr)instr, operation, fixnums, booleans);
                        break;
                    }
                    case FLOAT_OP: {
                        Interpreter.interpretFloatOp((AluInstr)instr, operation, floats, booleans);
                        break;
                    }
                    case ARG_OP: {
                        Interpreter.receiveArg(context, instr, operation, args2, acceptsKeywordArgument, currDynScope, temp, exception2, block);
                        break;
                    }
                    case CALL_OP: {
                        if (profile) {
                            Profiler.updateCallSite(instr, scope, scopeVersion);
                        }
                        Interpreter.processCall(context, instr, operation, currDynScope, currScope, temp, self2);
                        break;
                    }
                    case RET_OP: {
                        return Interpreter.processReturnOp(context, instr, operation, currDynScope, temp, self2, blockType, currScope);
                    }
                    case BRANCH_OP: {
                        switch (operation) {
                            case JUMP: {
                                ipc = ((JumpInstr)instr).getJumpTarget().getTargetPC();
                                break block1;
                            }
                        }
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case BOOK_KEEPING_OP: {
                        if (operation == Operation.PUSH_BINDING) {
                            currDynScope = interpreterContext.newDynamicScope(context);
                            context.pushScope(currDynScope);
                            break;
                        }
                        Interpreter.processBookKeepingOp(context, instr, operation, name2, args2, self2, block, implClass);
                        break;
                    }
                    case OTHER_OP: {
                        Interpreter.processOtherOp(context, instr, operation, currDynScope, currScope, temp, self2, blockType, floats, fixnums, booleans);
                    }
                }
            }
            catch (Throwable t) {
                Interpreter.extractToMethodToAvoidC2Crash(context, instr, t);
                ipc = instr.getRPC();
                if (debug) {
                    LOG.info("in : " + interpreterContext.getStaticScope().getIRScope() + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                    LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        throw context.runtime.newRuntimeError("BUG: interpreter fell through to end unexpectedly");
    }

    private static void extractToMethodToAvoidC2Crash(ThreadContext context, Instr instr, Throwable t) {
        if (!(t instanceof Unrescuable)) {
            if (!instr.canRaiseException()) {
                System.err.println("BUG: Got exception " + t + " but instr " + instr + " is not supposed to be raising exceptions!");
            }
            if (t instanceof RaiseException && context.runtime.getGlobalVariables().get("$!") != IRRuntimeHelpers.unwrapRubyException(t)) {
                System.err.println("BUG: $! and exception are not matching up.");
                System.err.println("$!: " + context.runtime.getGlobalVariables().get("$!"));
                System.err.println("t : " + t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_ROOT(ThreadContext context, IRubyObject self2, InterpreterContext ic, RubyModule clazz, String name2) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            IRubyObject iRubyObject = Interpreter.interpret(context, self2, ic, clazz, name2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK, null);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(ThreadContext context, IRubyObject self2, InterpreterContext ic, RubyModule clazz, IRubyObject[] args2, String name2, Block block, Block.Type blockType) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            IRubyObject iRubyObject = Interpreter.interpret(context, self2, ic, clazz, name2, args2, block, blockType);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_BLOCK(ThreadContext context, IRubyObject self2, InterpreterContext ic, IRubyObject[] args2, String name2, Block block, Block.Type blockType) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            IRubyObject iRubyObject = Interpreter.interpret(context, self2, ic, null, name2, args2, block, blockType);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_METHOD(ThreadContext context, InterpretedIRMethod method, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        InterpreterContext ic = method.ensureInstrsReady();
        boolean isSynthetic = method.isSynthetic();
        try {
            if (!isSynthetic) {
                ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            }
            IRubyObject iRubyObject = Interpreter.interpret(context, self2, ic, method.getImplementationClass().getMethodLocation(), name2, args2, block, null);
            return iRubyObject;
        }
        finally {
            if (!isSynthetic) {
                ThreadContext.popBacktrace(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalSimple(ThreadContext context, RubyModule under, IRubyObject self2, RubyString src, String file2, int lineNumber, EvalType evalType) {
        Ruby runtime = context.runtime;
        if (runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.TRUFFLE) {
            throw new UnsupportedOperationException();
        }
        DynamicScope parentScope = context.getCurrentScope();
        ManyVarsDynamicScope evalScope = new ManyVarsDynamicScope(runtime.getStaticScopeFactory().newEvalScope(parentScope.getStaticScope()), parentScope);
        evalScope.getStaticScope().setModule(under);
        context.pushEvalSimpleFrame(self2);
        try {
            IRubyObject iRubyObject = Interpreter.evalCommon(context, evalScope, self2, src, file2, lineNumber, "(eval)", Block.NULL_BLOCK, evalType);
            return iRubyObject;
        }
        finally {
            context.popFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject evalCommon(ThreadContext context, DynamicScope evalScope, IRubyObject self2, IRubyObject src, String file2, int lineNumber, String name2, Block block, EvalType evalType) {
        StaticScope ss = evalScope.getStaticScope();
        BeginEndInterpreterContext ic = Interpreter.prepareIC(context, evalScope, src, file2, lineNumber, evalType);
        evalScope.setEvalType(evalType);
        context.pushScope(evalScope);
        try {
            evalScope.growIfNeeded();
            Interpreter.runBeginBlocks(ic.getBeginBlocks(), context, self2, ss, null);
            IRubyObject iRubyObject = Interpreter.INTERPRET_EVAL(context, self2, ic, ic.getStaticScope().getModule(), EMPTY_ARGS, name2, block, null);
            return iRubyObject;
        }
        finally {
            evalScope.clearEvalType();
            context.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject self2, IRubyObject src, Binding binding2) {
        Ruby runtime = context.runtime;
        if (runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.TRUFFLE) {
            throw new UnsupportedOperationException();
        }
        DynamicScope evalScope = binding2.getEvalScope(runtime);
        evalScope.getStaticScope().determineModule();
        Frame lastFrame = context.preEvalWithBinding(binding2);
        try {
            IRubyObject iRubyObject = Interpreter.evalCommon(context, evalScope, self2, src, binding2.getFile(), binding2.getLine(), binding2.getMethod(), binding2.getFrame().getBlock(), EvalType.BINDING_EVAL);
            return iRubyObject;
        }
        finally {
            context.postEvalWithBinding(binding2, lastFrame);
        }
    }

    private static BeginEndInterpreterContext prepareIC(ThreadContext context, DynamicScope evalScope, IRubyObject src, String file2, int lineNumber, EvalType evalType) {
        Ruby runtime = context.runtime;
        IRScope containingIRScope = evalScope.getStaticScope().getEnclosingScope().getIRScope();
        RootNode rootNode = (RootNode)runtime.parseEval(src.convertToString().getByteList(), file2, evalScope, lineNumber);
        IREvalScript evalScript = IRBuilder.createIRBuilder(runtime, runtime.getIRManager()).buildEvalRoot(evalScope.getStaticScope(), containingIRScope, file2, lineNumber, rootNode, evalType);
        BeginEndInterpreterContext ic = (BeginEndInterpreterContext)evalScript.prepareForInterpretation();
        if (IRRuntimeHelpers.isDebug()) {
            LOG.info("Graph:\n" + evalScript.cfg().toStringGraph(), new Object[0]);
            LOG.info("CFG:\n" + evalScript.cfg().toStringInstrs(), new Object[0]);
        }
        return ic;
    }

    private static class InterpreterHolder {
        public static final Interpreter instance = new Interpreter();

        private InterpreterHolder() {
        }
    }
}

