/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.RaiseArgumentErrorInstr;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.runtime.ThreadContext;

public class CheckArityInstr
extends Instr
implements FixedArityInstr {
    public final int required;
    public final int opt;
    public final int rest;
    public final boolean receivesKeywords;
    public final int restKey;

    public CheckArityInstr(int required, int opt, int rest2, boolean receivesKeywords, int restKey) {
        super(Operation.CHECK_ARITY, EMPTY_OPERANDS);
        this.required = required;
        this.opt = opt;
        this.rest = rest2;
        this.receivesKeywords = receivesKeywords;
        this.restKey = restKey;
    }

    @Override
    public String toString() {
        return super.toString() + " req: " + this.required + ", opt: " + this.opt + ", *r: " + this.rest + ", kw: " + this.receivesKeywords + ", **r: " + this.restKey;
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new CheckArityInstr(this.required, this.opt, this.rest, this.receivesKeywords, this.restKey);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.canMapArgsStatically()) {
            int numArgs = ii.getArgsCount();
            if (numArgs < this.required || this.rest == -1 && numArgs > this.required + this.opt) {
                return new RaiseArgumentErrorInstr(this.required, this.opt, this.rest, this.rest);
            }
            return null;
        }
        return new CheckArgsArrayArityInstr(ii.getArgs(), this.required, this.opt, this.rest);
    }

    public void checkArity(ThreadContext context, Object[] args2) {
        IRRuntimeHelpers.checkArity(context, args2, this.required, this.opt, this.rest, this.receivesKeywords, this.restKey);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CheckArityInstr(this);
    }
}

