/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandBranchInstr;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BNEInstr
extends TwoOperandBranchInstr
implements FixedArityInstr {
    public static BranchInstr create(Operand v1, Operand v2, Label jmpTarget) {
        if (v2 instanceof Boolean) {
            return ((Boolean)v2).isFalse() ? new BTrueInstr(v1, jmpTarget) : new BFalseInstr(v1, jmpTarget);
        }
        return new BNEInstr(v1, v2, jmpTarget);
    }

    public BNEInstr(Operand v1, Operand v2, Label jmpTarget) {
        super(Operation.BNE, v1, v2, jmpTarget);
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BNEInstr(this.getArg1().cloneForInlining(ii), this.getArg2().cloneForInlining(ii), ii.getRenamedLabel(this.getJumpTarget()));
    }

    @Override
    public int interpretAndGetNewIPC(ThreadContext context, DynamicScope currDynScope, StaticScope currScope, IRubyObject self2, Object[] temp, int ipc) {
        Object value1 = this.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
        Object value2 = this.getArg2().retrieve(context, self2, currScope, currDynScope, temp);
        boolean eql2 = this.getArg2() == context.getRuntime().getIRManager().getNil() || this.getArg2() == UndefinedValue.UNDEFINED ? value1 == value2 : ((IRubyObject)value1).op_equal(context, (IRubyObject)value2).isTrue();
        return !eql2 ? this.getJumpTarget().getTargetPC() : ipc;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BNEInstr(this);
    }
}

