/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.util.ArrayList;
import org.jruby.AbstractRubyMethod;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.Node;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ext.jruby.JRubyExecutionContextLocal;
import org.jruby.ext.jruby.JRubyFiberLocal;
import org.jruby.ext.jruby.JRubyThreadLocal;
import org.jruby.ext.jruby.JRubyUtilLibrary;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.internal.runtime.methods.MethodArgs2;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

@JRubyModule(name={"JRuby"})
public class JRubyLibrary
implements Library {
    @Override
    public void load(Ruby runtime, boolean wrap2) {
        ThreadContext context = runtime.getCurrentContext();
        runtime.getLoadService().require("java");
        runtime.getLoadService().loadFromClassLoader(runtime.getJRubyClassLoader(), "jruby/jruby.rb", false);
        RubyModule jrubyModule = runtime.getOrCreateModule("JRuby");
        jrubyModule.defineAnnotatedMethods(JRubyLibrary.class);
        jrubyModule.defineAnnotatedMethods(JRubyUtilLibrary.class);
        RubyClass threadLocalClass = jrubyModule.defineClassUnder("ThreadLocal", runtime.getObject(), JRubyThreadLocal.ALLOCATOR);
        threadLocalClass.defineAnnotatedMethods(JRubyExecutionContextLocal.class);
        RubyClass fiberLocalClass = jrubyModule.defineClassUnder("FiberLocal", runtime.getObject(), JRubyFiberLocal.ALLOCATOR);
        fiberLocalClass.defineAnnotatedMethods(JRubyExecutionContextLocal.class);
        RubyModule config = jrubyModule.defineModuleUnder("CONFIG");
        config.getSingletonClass().defineAnnotatedMethods(JRubyConfig.class);
    }

    @JRubyMethod(module=true)
    public static IRubyObject reference(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        Ruby runtime = context.runtime;
        return Java.getInstance(runtime, obj, false);
    }

    @JRubyMethod(module=true)
    public static IRubyObject reference0(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        Ruby runtime = context.runtime;
        return Java.getInstance(runtime, obj);
    }

    @JRubyMethod(module=true)
    public static IRubyObject dereference(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        Object unwrapped;
        if (obj instanceof JavaProxy) {
            unwrapped = ((JavaProxy)obj).getObject();
        } else if (obj.dataGetStruct() instanceof JavaObject) {
            unwrapped = JavaUtil.unwrapJavaObject(obj);
        } else {
            throw context.runtime.newTypeError("got " + obj + ", expected wrapped Java object");
        }
        if (!(unwrapped instanceof IRubyObject)) {
            throw context.runtime.newTypeError("got " + obj + ", expected Java-wrapped Ruby object");
        }
        return (IRubyObject)unwrapped;
    }

    @JRubyMethod(module=true)
    public static IRubyObject identity_hash(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return context.runtime.newFixnum(System.identityHashCode(obj));
    }

    private static IRubyObject getNameFrom(Ruby runtime, INameNode node) {
        return node == null ? runtime.getNil() : RubySymbol.newSymbol(runtime, node.getName());
    }

    public static class MethodExtensions {
        @JRubyMethod(name={"args"})
        public static IRubyObject methodArgs(IRubyObject recv2) {
            Ruby runtime = recv2.getRuntime();
            AbstractRubyMethod rubyMethod = (AbstractRubyMethod)recv2;
            RubyArray argsArray = RubyArray.newArray(runtime);
            DynamicMethod method = rubyMethod.getMethod().getRealMethod();
            RubySymbol req = runtime.newSymbol("req");
            RubySymbol opt = runtime.newSymbol("opt");
            RubySymbol rest2 = runtime.newSymbol("rest");
            RubySymbol block = runtime.newSymbol("block");
            if (method instanceof MethodArgs2) {
                return Helpers.parameterListToParameters(runtime, ((MethodArgs2)((Object)method)).getParameterList(), true);
            }
            if (method instanceof MethodArgs) {
                MethodArgs interpMethod = (MethodArgs)((Object)method);
                ArgsNode args2 = interpMethod.getArgsNode();
                ListNode requiredArgs = args2.getPre();
                for (int i2 = 0; requiredArgs != null && i2 < requiredArgs.size(); ++i2) {
                    Node argNode = requiredArgs.get(i2);
                    if (argNode instanceof MultipleAsgn19Node) {
                        argsArray.append(RubyArray.newArray(runtime, req));
                        continue;
                    }
                    argsArray.append(RubyArray.newArray(runtime, req, JRubyLibrary.getNameFrom(runtime, (INameNode)((Object)argNode))));
                }
                ListNode optArgs = args2.getOptArgs();
                for (int i3 = 0; optArgs != null && i3 < optArgs.size(); ++i3) {
                    argsArray.append(RubyArray.newArray(runtime, opt, JRubyLibrary.getNameFrom(runtime, (INameNode)((Object)optArgs.get(i3)))));
                }
                if (args2.getRestArg() >= 0) {
                    RestArgNode restArg = (RestArgNode)args2.getRestArgNode();
                    if (restArg instanceof UnnamedRestArgNode) {
                        if (((UnnamedRestArgNode)restArg).isStar()) {
                            argsArray.append(RubyArray.newArray(runtime, rest2));
                        }
                    } else {
                        argsArray.append(RubyArray.newArray(runtime, rest2, JRubyLibrary.getNameFrom(runtime, args2.getRestArgNode())));
                    }
                }
                ListNode requiredArgsPost = args2.getPost();
                for (int i4 = 0; requiredArgsPost != null && i4 < requiredArgsPost.size(); ++i4) {
                    Node argNode = requiredArgsPost.get(i4);
                    if (argNode instanceof MultipleAsgn19Node) {
                        argsArray.append(RubyArray.newArray(runtime, req));
                        continue;
                    }
                    argsArray.append(RubyArray.newArray(runtime, req, JRubyLibrary.getNameFrom(runtime, (INameNode)((Object)requiredArgsPost.get(i4)))));
                }
                if (args2.getBlock() != null) {
                    argsArray.append(RubyArray.newArray(runtime, block, JRubyLibrary.getNameFrom(runtime, args2.getBlock())));
                }
            } else if (method instanceof IRMethodArgs) {
                for (String[] argParam : ((IRMethodArgs)((Object)method)).getParameterList()) {
                    RubySymbol argType = runtime.newSymbol(argParam[0]);
                    if (argParam[1] == "") {
                        argsArray.append(RubyArray.newArray(runtime, argType));
                        continue;
                    }
                    argsArray.append(RubyArray.newArray(runtime, argType, runtime.newSymbol(argParam[1])));
                }
            } else if (method.getArity() == Arity.OPTIONAL) {
                argsArray.append(RubyArray.newArray(runtime, rest2));
            }
            return argsArray;
        }

        public static String[] methodParameters(Ruby runtime, DynamicMethod method) {
            ArrayList<String> argsArray = new ArrayList<String>();
            if ((method = method.getRealMethod()) instanceof MethodArgs2) {
                return ((MethodArgs2)((Object)method)).getParameterList();
            }
            if (method instanceof MethodArgs) {
                MethodArgs interpMethod = (MethodArgs)((Object)method);
                ArgsNode args2 = interpMethod.getArgsNode();
                ListNode requiredArgs = args2.getPre();
                for (int i2 = 0; requiredArgs != null && i2 < requiredArgs.size(); ++i2) {
                    Node argNode = requiredArgs.get(i2);
                    if (argNode instanceof MultipleAsgn19Node) {
                        argsArray.add("q");
                        continue;
                    }
                    argsArray.add("q" + JRubyLibrary.getNameFrom(runtime, (INameNode)((Object)argNode)));
                }
                ListNode optArgs = args2.getOptArgs();
                for (int i3 = 0; optArgs != null && i3 < optArgs.size(); ++i3) {
                    argsArray.add("o" + JRubyLibrary.getNameFrom(runtime, (INameNode)((Object)optArgs.get(i3))));
                }
                if (args2.getRestArg() >= 0) {
                    RestArgNode restArg = (RestArgNode)args2.getRestArgNode();
                    if (restArg instanceof UnnamedRestArgNode) {
                        if (((UnnamedRestArgNode)restArg).isStar()) {
                            argsArray.add("r");
                        }
                    } else {
                        argsArray.add("r" + JRubyLibrary.getNameFrom(runtime, args2.getRestArgNode()));
                    }
                }
                ListNode requiredArgsPost = args2.getPost();
                for (int i4 = 0; requiredArgsPost != null && i4 < requiredArgsPost.size(); ++i4) {
                    Node argNode = requiredArgsPost.get(i4);
                    if (argNode instanceof MultipleAsgn19Node) {
                        argsArray.add("q");
                        continue;
                    }
                    argsArray.add("q" + JRubyLibrary.getNameFrom(runtime, (INameNode)((Object)requiredArgsPost.get(i4))));
                }
                if (args2.getBlock() != null) {
                    argsArray.add("b" + JRubyLibrary.getNameFrom(runtime, args2.getBlock()));
                }
            } else if (method instanceof IRMethodArgs) {
                for (String[] argParam : ((IRMethodArgs)((Object)method)).getParameterList()) {
                    RubySymbol argType = runtime.newSymbol(argParam[0]);
                    if (argParam[1] == "") {
                        argsArray.add(argParam[0]);
                        continue;
                    }
                    argsArray.add(argParam[0] + argParam[1]);
                }
            } else if (method.getArity() == Arity.OPTIONAL) {
                argsArray.add("r");
            }
            return argsArray.toArray(new String[argsArray.size()]);
        }
    }

    public static class JRubyConfig {
        @JRubyMethod(name={"rubygems_disabled?"})
        public static IRubyObject rubygems_disabled_p(ThreadContext context, IRubyObject self2) {
            return context.runtime.newBoolean(context.runtime.getInstanceConfig().isDisableGems());
        }
    }
}

