/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class EnsureNode
extends Node {
    private final Node bodyNode;
    private final Node ensureNode;

    public EnsureNode(ISourcePosition position, Node bodyNode, Node ensureNode) {
        super(position);
        assert (bodyNode != null) : "bodyNode is not null";
        this.bodyNode = bodyNode;
        this.ensureNode = ensureNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ENSURENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitEnsureNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getEnsureNode() {
        return this.ensureNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.bodyNode, this.ensureNode);
    }
}

