/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.Ptr;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvResult;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscoderDB;
import org.jcodings.transcode.Transcoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyConverter;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyMethod;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeSupport;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

public class EncodingUtils {
    public static final int ECONV_DEFAULT_NEWLINE_DECORATOR = Platform.IS_WINDOWS ? 4096 : 0;
    public static final int DEFAULT_TEXTMODE = Platform.IS_WINDOWS ? 4096 : 0;
    public static final int TEXTMODE_NEWLINE_DECORATOR_ON_WRITE = Platform.IS_WINDOWS ? 4096 : 0;
    private static final byte[] NULL_BYTE_ARRAY = new byte[0];
    static final int VMODE = 0;
    static final int PERM = 1;
    public static final ResizeFunction strTranscodingResize = new ResizeFunction(){

        @Override
        public int resize(ByteList destination, int len, int new_len) {
            destination.setRealSize(len);
            destination.ensure(new_len);
            return destination.getBegin();
        }
    };
    private static final TranscodeFallback HASH_FALLBACK = new TranscodeFallback(){

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject fallback, IRubyObject c) {
            return ((RubyHash)fallback).op_aref(context, c);
        }
    };
    private static final TranscodeFallback PROC_FALLBACK = new TranscodeFallback(){

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject fallback, IRubyObject c) {
            return ((RubyProc)fallback).call(context, new IRubyObject[]{c});
        }
    };
    private static final TranscodeFallback METHOD_FALLBACK = new TranscodeFallback(){

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject fallback, IRubyObject c) {
            return fallback.callMethod(context, "call", c);
        }
    };
    private static final TranscodeFallback AREF_FALLBACK = new TranscodeFallback(){

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject fallback, IRubyObject c) {
            return fallback.callMethod(context, "[]", c);
        }
    };

    public static Encoding rbToEncoding(ThreadContext context, IRubyObject enc) {
        if (enc instanceof RubyEncoding) {
            return ((RubyEncoding)enc).getEncoding();
        }
        return EncodingUtils.toEncoding(context, enc);
    }

    public static Encoding toEncoding(ThreadContext context, IRubyObject enc) {
        RubyString encStr = enc.convertToString();
        if (!encStr.getEncoding().isAsciiCompatible()) {
            throw context.runtime.newArgumentError("invalid name encoding (non ASCII)");
        }
        Encoding idx = context.runtime.getEncodingService().getEncodingFromObject(enc);
        return idx;
    }

    public static IRubyObject[] openArgsToArgs(Ruby runtime, IRubyObject firstElement, RubyHash options2) {
        IRubyObject value2 = EncodingUtils.hashARef(runtime, options2, "open_args");
        if (value2.isNil()) {
            return new IRubyObject[]{firstElement, options2};
        }
        RubyArray array = value2.convertToArray();
        Object[] openArgs = new IRubyObject[array.size()];
        value2.convertToArray().toArray(openArgs);
        IRubyObject[] args2 = new IRubyObject[openArgs.length + 1];
        args2[0] = firstElement;
        System.arraycopy(openArgs, 0, args2, 1, openArgs.length);
        return args2;
    }

    public static void extractBinmode(Ruby runtime, IRubyObject optionsArg, int[] fmode_p) {
        int fmodeMask = 0;
        IRubyObject v = EncodingUtils.hashARef(runtime, optionsArg, "textmode");
        if (!v.isNil() && v.isTrue()) {
            fmodeMask |= 0x1000;
        }
        if (!(v = EncodingUtils.hashARef(runtime, optionsArg, "binmode")).isNil() && v.isTrue()) {
            fmodeMask |= 4;
        }
        if ((fmodeMask & 4) != 0 && (fmodeMask & 0x1000) != 0) {
            throw runtime.newArgumentError("both textmode and binmode specified");
        }
        fmode_p[0] = fmode_p[0] | fmodeMask;
    }

    private static IRubyObject hashARef(Ruby runtime, IRubyObject hash2, String symbol) {
        if (hash2 == null || !(hash2 instanceof RubyHash)) {
            return runtime.getNil();
        }
        IRubyObject value2 = ((RubyHash)hash2).fastARef(runtime.newSymbol(symbol));
        return value2 == null ? runtime.getNil() : value2;
    }

    public static Encoding ascii8bitEncoding(Ruby runtime) {
        return runtime.getEncodingService().getAscii8bitEncoding();
    }

    public static Object vmodeVperm(IRubyObject vmode, IRubyObject vperm) {
        return new IRubyObject[]{vmode, vperm};
    }

    public static IRubyObject vmode(Object vmodeVperm) {
        return ((IRubyObject[])vmodeVperm)[0];
    }

    public static void vmode(Object vmodeVperm, IRubyObject vmode) {
        ((IRubyObject[])vmodeVperm)[0] = vmode;
    }

    public static IRubyObject vperm(Object vmodeVperm) {
        return ((IRubyObject[])vmodeVperm)[1];
    }

    public static void vperm(Object vmodeVperm, IRubyObject vperm) {
        ((IRubyObject[])vmodeVperm)[1] = vperm;
    }

    public static final int MODE_BTMODE(int fmode, int a, int b2, int c) {
        if ((fmode & 4) != 0) {
            return b2;
        }
        if ((fmode & 0x1000) != 0) {
            return c;
        }
        return a;
    }

    public static int SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(Encoding enc2, int ecflags) {
        if (enc2 != null && (ecflags & ECONV_DEFAULT_NEWLINE_DECORATOR) != 0) {
            return ecflags | 0x100;
        }
        return ecflags;
    }

    public static void extractModeEncoding(ThreadContext context, IOEncodable ioEncodable, Object vmodeAndVperm_p, IRubyObject options2, int[] oflags_p, int[] fmode_p) {
        int ecflags;
        IRubyObject[] ecopts_p;
        block18: {
            IRubyObject v;
            Ruby runtime = context.runtime;
            ecopts_p = new IRubyObject[]{context.nil};
            boolean hasEnc = false;
            boolean hasVmode = false;
            EncodingUtils.ioExtIntToEncs(context, ioEncodable, null, null, 0);
            while (true) {
                if (EncodingUtils.vmode(vmodeAndVperm_p) == null || EncodingUtils.vmode(vmodeAndVperm_p).isNil()) {
                    fmode_p[0] = 1;
                    oflags_p[0] = ModeFlags.RDONLY;
                } else {
                    IRubyObject intmode = TypeConverter.checkIntegerType(context.runtime, EncodingUtils.vmode(vmodeAndVperm_p), "to_int");
                    if (!intmode.isNil()) {
                        EncodingUtils.vmode(vmodeAndVperm_p, intmode);
                        oflags_p[0] = RubyNumeric.num2int(intmode);
                        fmode_p[0] = ModeFlags.getOpenFileFlagsFor(oflags_p[0]);
                    } else {
                        String p2 = EncodingUtils.vmode(vmodeAndVperm_p).convertToString().asJavaString();
                        fmode_p[0] = OpenFile.ioModestrFmode(runtime, p2);
                        oflags_p[0] = OpenFile.ioFmodeOflags(fmode_p[0]);
                        int colonSplit = p2.indexOf(":");
                        if (colonSplit != -1) {
                            hasEnc = true;
                            EncodingUtils.parseModeEncoding(context, ioEncodable, p2.substring(colonSplit + 1), fmode_p);
                        } else {
                            Encoding e = (fmode_p[0] & 4) != 0 ? EncodingUtils.ascii8bitEncoding(context.runtime) : null;
                            EncodingUtils.ioExtIntToEncs(context, ioEncodable, e, null, fmode_p[0]);
                        }
                    }
                }
                if (options2 == null || options2.isNil()) {
                    int n = ecflags = (fmode_p[0] & 1) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], ECONV_DEFAULT_NEWLINE_DECORATOR, 0, 256) : 0;
                    if (TEXTMODE_NEWLINE_DECORATOR_ON_WRITE != 0) {
                        ecflags |= (fmode_p[0] & 2) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], TEXTMODE_NEWLINE_DECORATOR_ON_WRITE, 0, TEXTMODE_NEWLINE_DECORATOR_ON_WRITE) : 0;
                    }
                    ecflags = EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(ioEncodable.getEnc2(), ecflags);
                    ecopts_p[0] = context.nil;
                    break block18;
                }
                EncodingUtils.extractBinmode(context.runtime, options2, fmode_p);
                if ((fmode_p[0] & 4) != 0) {
                    oflags_p[0] = oflags_p[0] | ModeFlags.BINARY;
                    if (!hasEnc) {
                        EncodingUtils.ioExtIntToEncs(context, ioEncodable, EncodingUtils.ascii8bitEncoding(context.runtime), null, fmode_p[0]);
                    }
                } else if (DEFAULT_TEXTMODE != 0 && (EncodingUtils.vmode(vmodeAndVperm_p) == null || EncodingUtils.vmode(vmodeAndVperm_p).isNil())) {
                    fmode_p[0] = fmode_p[0] | DEFAULT_TEXTMODE;
                }
                if (hasVmode || (v = EncodingUtils.hashARef(context.runtime, options2, "mode")).isNil()) break;
                if (EncodingUtils.vmode(vmodeAndVperm_p) != null && !EncodingUtils.vmode(vmodeAndVperm_p).isNil()) {
                    throw context.runtime.newArgumentError("mode specified twice");
                }
                hasVmode = true;
                EncodingUtils.vmode(vmodeAndVperm_p, v);
            }
            v = EncodingUtils.hashARef(context.runtime, options2, "perm");
            if (!v.isNil() && EncodingUtils.vperm(vmodeAndVperm_p) != null) {
                if (!EncodingUtils.vperm(vmodeAndVperm_p).isNil()) {
                    throw context.runtime.newArgumentError("perm specified twice");
                }
                EncodingUtils.vperm(vmodeAndVperm_p, v);
            }
            int n = ecflags = (fmode_p[0] & 1) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], ECONV_DEFAULT_NEWLINE_DECORATOR, 0, 256) : 0;
            if (TEXTMODE_NEWLINE_DECORATOR_ON_WRITE != -1) {
                ecflags |= (fmode_p[0] & 2) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], TEXTMODE_NEWLINE_DECORATOR_ON_WRITE, 0, TEXTMODE_NEWLINE_DECORATOR_ON_WRITE) : 0;
            }
            if (EncodingUtils.ioExtractEncodingOption(context, ioEncodable, options2, fmode_p) && hasEnc) {
                throw context.runtime.newArgumentError("encoding specified twice");
            }
            ecflags = EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(ioEncodable.getEnc2(), ecflags);
            ecflags = EncodingUtils.econvPrepareOptions(context, options2, ecopts_p, ecflags);
        }
        EncodingUtils.validateEncodingBinmode(context, fmode_p, ecflags, ioEncodable);
        ioEncodable.setEcflags(ecflags);
        ioEncodable.setEcopts(ecopts_p[0]);
    }

    public static boolean ioExtractEncodingOption(ThreadContext context, IOEncodable ioEncodable, IRubyObject options2, int[] fmode_p) {
        IRubyObject tmp;
        Ruby runtime = context.runtime;
        IRubyObject encoding2 = context.nil;
        IRubyObject extenc = null;
        IRubyObject intenc = null;
        boolean extracted = false;
        Encoding extencoding = null;
        Object intencoding = null;
        if (options2 != null || !options2.isNil()) {
            IRubyObject internalOpt;
            IRubyObject externalOpt;
            RubyHash opts = (RubyHash)options2;
            IRubyObject encodingOpt = opts.op_aref(context, runtime.newSymbol("encoding"));
            if (!encodingOpt.isNil()) {
                encoding2 = encodingOpt;
            }
            if (!(externalOpt = opts.op_aref(context, runtime.newSymbol("external_encoding"))).isNil()) {
                extenc = externalOpt;
            }
            if (!(internalOpt = opts.op_aref(context, runtime.newSymbol("internal_encoding"))).isNil()) {
                intenc = internalOpt;
            }
        }
        if (!(extenc == null && intenc == null || encoding2.isNil())) {
            if (runtime.isVerbose()) {
                runtime.getWarnings().warn("Ignoring encoding parameter '" + encoding2 + "': " + (extenc == null ? "internal" : "external") + "_encoding is used");
            }
            encoding2 = context.nil;
        }
        if (extenc != null && !extenc.isNil()) {
            extencoding = EncodingUtils.rbToEncoding(context, extenc);
        }
        if (intenc != null) {
            String p2;
            intencoding = intenc.isNil() ? null : (!(tmp = intenc.checkStringType19()).isNil() ? ((p2 = tmp.toString()).equals("-") ? null : EncodingUtils.rbToEncoding(context, intenc)) : EncodingUtils.rbToEncoding(context, intenc));
            if (extencoding == intencoding) {
                intencoding = null;
            }
        }
        if (!encoding2.isNil()) {
            extracted = true;
            tmp = encoding2.checkStringType19();
            if (!tmp.isNil()) {
                EncodingUtils.parseModeEncoding(context, ioEncodable, tmp.asJavaString(), fmode_p);
            } else {
                EncodingUtils.ioExtIntToEncs(context, ioEncodable, EncodingUtils.rbToEncoding(context, encoding2), null, 0);
            }
        } else if (extenc != null || intenc != null) {
            extracted = true;
            EncodingUtils.ioExtIntToEncs(context, ioEncodable, extencoding, intencoding, 0);
        }
        return extracted;
    }

    public static void ioExtIntToEncs(ThreadContext context, IOEncodable encodable, Encoding external, Encoding internal, int fmode) {
        boolean defaultExternal = false;
        if (external == null) {
            external = context.runtime.getDefaultExternalEncoding();
            defaultExternal = true;
        }
        if (external == EncodingUtils.ascii8bitEncoding(context.runtime)) {
            internal = null;
        } else if (internal == null) {
            internal = context.runtime.getDefaultInternalEncoding();
        }
        if (internal == null || (fmode & 0x100000) == 0 && internal == external) {
            encodable.setEnc((Encoding)(defaultExternal && internal != external ? null : external));
            encodable.setEnc2(null);
        } else {
            encodable.setEnc(internal);
            encodable.setEnc2(external);
        }
    }

    public static void parseModeEncoding(ThreadContext context, IOEncodable ioEncodable, String option, int[] fmode_p) {
        Encoding idx;
        String[] encs;
        Ruby runtime = context.runtime;
        EncodingService service = runtime.getEncodingService();
        Encoding idx2 = null;
        if (fmode_p == null) {
            fmode_p = new int[]{0};
        }
        if ((encs = option.split(":", 2)).length == 2) {
            String estr = encs[0];
            if (estr.toLowerCase().startsWith("bom|utf-")) {
                fmode_p[0] = fmode_p[0] | 0x100000;
                ioEncodable.setBOM(true);
                estr = estr.substring(4);
            }
            idx = service.getEncodingFromString(estr);
        } else {
            String estr = option;
            if (estr.toLowerCase().startsWith("bom|utf-")) {
                fmode_p[0] = fmode_p[0] | 0x100000;
                ioEncodable.setBOM(true);
                estr = estr.substring(4);
            }
            idx = service.getEncodingFromString(estr);
        }
        Encoding extEnc = idx;
        Encoding intEnc = null;
        if (encs.length == 2) {
            if (encs[1].equals("-")) {
                intEnc = null;
            } else {
                idx2 = service.getEncodingFromString(encs[1]);
                if (idx2 == null) {
                    context.runtime.getWarnings().warn("ignoring internal encoding " + idx2 + ": it is identical to external encoding " + idx);
                    intEnc = null;
                } else {
                    intEnc = idx2;
                }
            }
        }
        EncodingUtils.ioExtIntToEncs(context, ioEncodable, extEnc, intEnc, fmode_p[0]);
    }

    public static ByteList econvStrConvert(ThreadContext context, EConv ec, ByteList src, int flags2) {
        return EncodingUtils.econvSubstrAppend(context, ec, src, null, flags2);
    }

    public static ByteList econvSubstrAppend(ThreadContext context, EConv ec, ByteList src, ByteList dst, int flags2) {
        return EncodingUtils.econvAppend(context, ec, src, dst, flags2);
    }

    public static ByteList econvAppend(ThreadContext context, EConv ec, ByteList sByteList, ByteList dst, int flags2) {
        EConvResult res;
        int len = sByteList.getRealSize();
        Ptr sp = new Ptr(0);
        int se = 0;
        int ds = 0;
        int ss = sByteList.getBegin();
        Ptr dp = new Ptr(0);
        int de = 0;
        if (dst == null) {
            dst = new ByteList(len);
            if (ec.destinationEncoding != null) {
                dst.setEncoding(ec.destinationEncoding);
            }
        }
        int maxOutput = ec.lastTranscoding != null ? ec.lastTranscoding.transcoder.maxOutput : 1;
        do {
            int dlen = dst.getRealSize();
            if (dst.getUnsafeBytes().length - dst.getBegin() - dlen < len + maxOutput) {
                long newCapa = dlen + len + maxOutput;
                if (Integer.MAX_VALUE < newCapa) {
                    throw context.runtime.newArgumentError("too long string");
                }
                dst.ensure((int)newCapa);
                dst.setRealSize(dlen);
            }
            sp.p = ss;
            se = sp.p + len;
            byte[] dBytes = dst.getUnsafeBytes();
            ds = dst.getBegin();
            de = dBytes.length;
            dp.p = ds += dlen;
            res = ec.convert(sByteList.getUnsafeBytes(), sp, se, dBytes, dp, de, flags2);
            len -= sp.p - ss;
            ss = sp.p;
            dst.setRealSize(dlen + (dp.p - ds));
            EncodingUtils.econvCheckError(context, ec);
        } while (res == EConvResult.DestinationBufferFull);
        return dst;
    }

    public static void econvCheckError(ThreadContext context, EConv ec) {
        RaiseException re = EncodingUtils.makeEconvException(context.runtime, ec);
        if (re != null) {
            throw re;
        }
    }

    public static int econvPrepareOpts(ThreadContext context, IRubyObject opthash, IRubyObject[] opts) {
        return EncodingUtils.econvPrepareOptions(context, opthash, opts, 0);
    }

    public static int econvPrepareOptions(ThreadContext context, IRubyObject opthash, IRubyObject[] opts, int ecflags) {
        IRubyObject newhash = context.nil;
        if (opthash.isNil()) {
            opts[0] = context.nil;
            return ecflags;
        }
        RubyHash optHash2 = (RubyHash)opthash;
        ecflags = EncodingUtils.econvOpts(context, opthash, ecflags);
        IRubyObject v = optHash2.op_aref(context, context.runtime.newSymbol("replace"));
        if (!v.isNil()) {
            RubyString v_str = v.convertToString();
            if (v_str.scanForCodeRange() == 48) {
                throw context.runtime.newArgumentError("replacement string is broken: " + v_str);
            }
            v = v_str.freeze(context);
            newhash = RubyHash.newHash(context.runtime);
            ((RubyHash)newhash).op_aset(context, context.runtime.newSymbol("replace"), v);
        }
        if (!(v = optHash2.op_aref(context, context.runtime.newSymbol("fallback"))).isNil()) {
            boolean condition;
            IRubyObject h = TypeConverter.checkHashType(context.runtime, v);
            if (h.isNil()) {
                condition = v instanceof RubyProc || v instanceof RubyMethod || v.respondsTo("[]");
            } else {
                v = h;
                condition = true;
            }
            if (condition) {
                if (newhash.isNil()) {
                    newhash = RubyHash.newHash(context.runtime);
                }
                ((RubyHash)newhash).op_aset(context, context.runtime.newSymbol("fallback"), v);
            }
        }
        if (!newhash.isNil()) {
            newhash.setFrozen(true);
        }
        opts[0] = newhash;
        return ecflags;
    }

    public static int econvOpts(ThreadContext context, IRubyObject opt, int ecflags) {
        Ruby runtime = context.runtime;
        IRubyObject v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("invalid"));
        if (!v.isNil()) {
            if (v.toString().equals("replace")) {
                ecflags |= 2;
            } else {
                throw runtime.newArgumentError("unknown value for invalid character option");
            }
        }
        if (!(v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("undef"))).isNil()) {
            if (v.toString().equals("replace")) {
                ecflags |= 0x20;
            } else {
                throw runtime.newArgumentError("unknown value for undefined character option");
            }
        }
        if (!(v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("replace"))).isNil() && (ecflags & 2) != 0) {
            ecflags |= 0x20;
        }
        if (!(v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("xml"))).isNil()) {
            if (v.toString().equals("text")) {
                ecflags |= 0x4030;
            } else if (v.toString().equals("attr")) {
                ecflags |= 0x108030;
            } else {
                throw runtime.newArgumentError("unexpected value for xml option: " + v);
            }
        }
        if (!(v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("newline"))).isNil()) {
            ecflags &= 0xFFFFC0FF;
            if (v.toString().equals("universal")) {
                ecflags |= 0x100;
            } else if (v.toString().equals("crlf")) {
                ecflags |= 0x1000;
            } else if (v.toString().equals("cr")) {
                ecflags |= 0x2000;
            } else if (!v.toString().equals("lf")) {
                if (v instanceof RubySymbol) {
                    throw runtime.newArgumentError("unexpected value for newline option: " + ((RubySymbol)v).to_s(context).toString());
                }
                throw runtime.newArgumentError("unexpected value for newline option");
            }
        }
        int setflags = 0;
        boolean newlineflag = false;
        v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("universal_newline"));
        if (v.isTrue()) {
            setflags |= 0x100;
        }
        newlineflag |= !v.isNil();
        v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("crlf_newline"));
        if (v.isTrue()) {
            setflags |= 0x1000;
        }
        newlineflag |= !v.isNil();
        v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("cr_newline"));
        if (v.isTrue()) {
            setflags |= 0x2000;
        }
        if (newlineflag |= !v.isNil()) {
            ecflags &= 0xFFFFC0FF;
            ecflags |= setflags;
        }
        return ecflags;
    }

    public static EConv econvOpenOpts(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags, IRubyObject opthash) {
        IRubyObject replacement2;
        Ruby runtime = context.runtime;
        if (opthash == null || opthash.isNil()) {
            replacement2 = context.nil;
        } else {
            if (!(opthash instanceof RubyHash) || !opthash.isFrozen()) {
                throw runtime.newRuntimeError("bug: EncodingUtils.econvOpenOpts called with invalid opthash");
            }
            replacement2 = ((RubyHash)opthash).op_aref(context, runtime.newSymbol("replace"));
        }
        EConv ec = TranscoderDB.open((byte[])sourceEncoding, (byte[])destinationEncoding, (int)ecflags);
        if (ec == null) {
            return ec;
        }
        if (!replacement2.isNil()) {
            RubyString replStr = (RubyString)replacement2;
            ByteList replBL = replStr.getByteList();
            ec.makeReplacement();
            int ret = ec.setReplacement(replBL.getUnsafeBytes(), replBL.getBegin(), replBL.getRealSize(), replBL.getEncoding().getName());
            if (ret == -1) {
                ec.close();
                return null;
            }
        }
        return ec;
    }

    public static RaiseException econvOpenExc(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags) {
        String message2 = EncodingUtils.econvDescription(context, sourceEncoding, destinationEncoding, ecflags, "code converter not found (") + ")";
        return context.runtime.newConverterNotFoundError(message2);
    }

    public static String econvDescription(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags, String message2) {
        return message2 + new String(sourceEncoding) + " to " + new String(destinationEncoding);
    }

    public static Encoding econvAsciicompatEncoding(Encoding enc) {
        return RubyConverter.NONASCII_TO_ASCII.get(enc);
    }

    public static boolean encAsciicompat(Encoding enc) {
        return EncodingUtils.encMbminlen(enc) == 1 && !EncodingUtils.encDummy(enc);
    }

    public static int encAscget(byte[] pBytes, int p2, int e, int[] len, Encoding enc) {
        if (EncodingUtils.encAsciicompat(enc)) {
            int c = pBytes[p2] & 0xFF;
            if (!Encoding.isAscii((byte)((byte)c))) {
                return -1;
            }
            if (len != null) {
                len[0] = 1;
            }
            return c;
        }
        int l = StringSupport.preciseLength(enc, pBytes, p2, e);
        if (!StringSupport.MBCLEN_CHARFOUND_P(l)) {
            return -1;
        }
        int c = enc.mbcToCode(pBytes, p2, e);
        if (!Encoding.isAscii((int)c)) {
            return -1;
        }
        if (len != null) {
            len[0] = l;
        }
        return c;
    }

    public static int encMbminlen(Encoding encoding2) {
        return encoding2.minLength();
    }

    public static boolean encDummy(Encoding enc) {
        return enc.isDummy();
    }

    public static Encoding encGet(ThreadContext context, IRubyObject obj) {
        if (obj instanceof EncodingCapable) {
            return ((EncodingCapable)((Object)obj)).getEncoding();
        }
        return context.runtime.getDefaultInternalEncoding();
    }

    public static boolean encodingEqual(byte[] enc1, byte[] enc2) {
        return new String(enc1).equalsIgnoreCase(new String(enc2));
    }

    public static Encoding encArg(ThreadContext context, IRubyObject encval, byte[][] name_p, Encoding[] enc_p) {
        Encoding enc = EncodingUtils.toEncodingIndex(context, encval);
        name_p[0] = enc == null ? encval.convertToString().getBytes() : enc.getName();
        enc_p[0] = enc;
        return enc_p[0];
    }

    public static Encoding toEncodingIndex(ThreadContext context, IRubyObject enc) {
        if (enc instanceof RubyEncoding) {
            return ((RubyEncoding)enc).getEncoding();
        }
        if ((enc = enc.checkStringType19()).isNil()) {
            return null;
        }
        if (!((RubyString)enc).getEncoding().isAsciiCompatible()) {
            return null;
        }
        return context.runtime.getEncodingService().getEncodingFromObjectNoError(enc);
    }

    public static IRubyObject encodedDup(ThreadContext context, IRubyObject newstr, IRubyObject str, Encoding encindex) {
        if (encindex == null) {
            return str.dup();
        }
        if (newstr == str) {
            newstr = str.dup();
        } else {
            ((RubyBasicObject)newstr).setMetaClass(str.getMetaClass());
        }
        ((RubyString)newstr).modify19();
        return EncodingUtils.strEncodeAssociate(context, newstr, encindex);
    }

    public static IRubyObject strEncodeAssociate(ThreadContext context, IRubyObject str, Encoding encidx) {
        EncodingUtils.encAssociateIndex(str, encidx);
        if (EncodingUtils.encAsciicompat(encidx)) {
            ((RubyString)str).scanForCodeRange();
        } else {
            ((RubyString)str).setCodeRange(32);
        }
        return str;
    }

    public static IRubyObject encAssociateIndex(IRubyObject obj, Encoding encidx) {
        ((RubyBasicObject)obj).checkFrozen();
        if (encidx == null) {
            encidx = ASCIIEncoding.INSTANCE;
        }
        if (((EncodingCapable)((Object)obj)).getEncoding() == encidx) {
            return obj;
        }
        if (obj instanceof RubyString && !CodeRangeSupport.isCodeRangeAsciiOnly((RubyString)obj) || EncodingUtils.encAsciicompat(encidx)) {
            ((RubyString)obj).clearCodeRange();
        }
        ((EncodingCapable)((Object)obj)).setEncoding(encidx);
        return obj;
    }

    public static IRubyObject strEncode(ThreadContext context, IRubyObject str, IRubyObject ... args2) {
        IRubyObject[] newstr_p = new IRubyObject[]{str};
        Encoding dencindex = EncodingUtils.strTranscode(context, args2, newstr_p);
        return EncodingUtils.encodedDup(context, newstr_p[0], str, dencindex);
    }

    public static IRubyObject rbStrEncode(ThreadContext context, IRubyObject str, IRubyObject to, int ecflags, IRubyObject ecopt) {
        IRubyObject[] newstr_p = new IRubyObject[]{str};
        Encoding dencindex = EncodingUtils.strTranscode0(context, 1, new IRubyObject[]{to}, newstr_p, ecflags, ecopt);
        return EncodingUtils.encodedDup(context, newstr_p[0], str, dencindex);
    }

    public static Encoding strTranscode(ThreadContext context, IRubyObject[] args2, IRubyObject[] self_p) {
        IRubyObject tmp;
        int ecflags = 0;
        int argc = args2.length;
        IRubyObject[] ecopts_p = new IRubyObject[]{context.nil};
        if (args2.length >= 1 && !(tmp = TypeConverter.checkHashType(context.runtime, args2[args2.length - 1])).isNil()) {
            --argc;
            ecflags = EncodingUtils.econvPrepareOpts(context, tmp, ecopts_p);
        }
        return EncodingUtils.strTranscode0(context, argc, args2, self_p, ecflags, ecopts_p[0]);
    }

    public static Encoding strTranscode0(ThreadContext context, int argc, IRubyObject[] args2, IRubyObject[] self_p, int ecflags, IRubyObject ecopts) {
        ByteList sp;
        IRubyObject arg1;
        Ruby runtime = context.runtime;
        IRubyObject str = self_p[0];
        Encoding[] senc_p = new Encoding[]{null};
        Encoding[] denc_p = new Encoding[]{null};
        byte[][] sname_p = new byte[][]{null};
        byte[][] dname_p = new byte[][]{null};
        boolean explicitlyInvalidReplace = true;
        if (argc > 2) {
            throw context.runtime.newArgumentError(args2.length, 2);
        }
        if (argc == 0) {
            arg1 = runtime.getEncodingService().getDefaultInternal();
            if (arg1 == null || arg1.isNil()) {
                if (ecflags == 0) {
                    return null;
                }
                arg1 = EncodingUtils.objEncoding(context, str);
            }
            if ((ecflags & 0xF) == 0) {
                explicitlyInvalidReplace = false;
            }
            ecflags |= 0x22;
        } else {
            arg1 = args2[0];
        }
        IRubyObject arg2 = argc <= 1 ? context.nil : args2[1];
        Encoding dencindex = EncodingUtils.strTranscodeEncArgs(context, str, arg1, arg2, sname_p, senc_p, dname_p, denc_p);
        if ((ecflags & 0x10FF00) == 0) {
            if (senc_p[0] != null && senc_p[0] == denc_p[0]) {
                if ((ecflags & 0xF) != 0 && explicitlyInvalidReplace) {
                    IRubyObject dest;
                    IRubyObject rep = context.nil;
                    if (!ecopts.isNil()) {
                        rep = ((RubyHash)ecopts).op_aref(context, runtime.newString("replace"));
                    }
                    if ((dest = ((RubyString)str).scrub(context, rep, Block.NULL_BLOCK)).isNil()) {
                        dest = str;
                    }
                    self_p[0] = dest;
                    return dencindex;
                }
                return arg2.isNil() ? null : dencindex;
            }
            if (senc_p[0] != null && denc_p[0] != null && senc_p[0].isAsciiCompatible() && denc_p[0].isAsciiCompatible() && ((RubyString)str).scanForCodeRange() == 16) {
                return dencindex;
            }
            if (EncodingUtils.encodingEqual(sname_p[0], dname_p[0])) {
                return arg2.isNil() ? null : dencindex;
            }
        } else if (EncodingUtils.encodingEqual(sname_p[0], dname_p[0])) {
            sname_p[0] = NULL_BYTE_ARRAY;
            dname_p[0] = NULL_BYTE_ARRAY;
        }
        ByteList fromp = sp = ((RubyString)str).getByteList();
        int slen = ((RubyString)str).size();
        int blen = slen + 30;
        RubyString dest = RubyString.newStringLight(runtime, blen);
        ByteList destp = dest.getByteList();
        byte[] frompBytes = fromp.unsafeBytes();
        byte[] destpBytes = destp.unsafeBytes();
        Ptr frompPos = new Ptr(fromp.getBegin());
        Ptr destpPos = new Ptr(destp.getBegin());
        EncodingUtils.transcodeLoop(context, frompBytes, frompPos, destpBytes, destpPos, frompPos.p + slen, destpPos.p + blen, destp, strTranscodingResize, sname_p[0], dname_p[0], ecflags, ecopts);
        if (frompPos.p != sp.begin() + slen) {
            throw runtime.newArgumentError("not fully converted, " + (slen - frompPos.p) + " bytes left");
        }
        destp.setRealSize(destpPos.p);
        if (denc_p[0] == null) {
            dencindex = EncodingUtils.defineDummyEncoding(context, dname_p[0]);
        }
        self_p[0] = dest;
        return dencindex;
    }

    public static IRubyObject objEncoding(ThreadContext context, IRubyObject obj) {
        Encoding enc = EncodingUtils.encGet(context, obj);
        if (enc == null) {
            throw context.runtime.newTypeError("unknown encoding");
        }
        return context.runtime.getEncodingService().convertEncodingToRubyEncoding(enc);
    }

    public static Encoding strTranscodeEncArgs(ThreadContext context, IRubyObject str, IRubyObject arg1, IRubyObject arg2, byte[][] sname_p, Encoding[] senc_p, byte[][] dname_p, Encoding[] denc_p) {
        Encoding dencindex = EncodingUtils.encArg(context, arg1, dname_p, denc_p);
        if (arg2.isNil()) {
            senc_p[0] = EncodingUtils.encGet(context, str);
            sname_p[0] = senc_p[0].getName();
        } else {
            EncodingUtils.encArg(context, arg2, sname_p, senc_p);
        }
        return dencindex;
    }

    public static boolean encRegistered(byte[] name2) {
        return EncodingDB.getEncodings().get(name2) != null;
    }

    public static void encCheckDuplication(ThreadContext context, byte[] name2) {
        if (EncodingUtils.encRegistered(name2)) {
            throw context.runtime.newArgumentError("encoding " + new String(name2) + " is already registered");
        }
    }

    public static Encoding encReplicate(ThreadContext context, byte[] name2, Encoding encoding2) {
        EncodingUtils.encCheckDuplication(context, name2);
        EncodingDB.replicate((String)new String(name2), (String)new String(encoding2.getName()));
        return ((EncodingDB.Entry)EncodingDB.getEncodings().get(name2)).getEncoding();
    }

    public static Encoding defineDummyEncoding(ThreadContext context, byte[] name2) {
        Encoding dummy = EncodingUtils.encReplicate(context, name2, EncodingUtils.ascii8bitEncoding(context.runtime));
        return dummy;
    }

    public static boolean DECORATOR_P(byte[] sname, byte[] dname) {
        return sname == null || sname.length == 0 || sname[0] == 0;
    }

    public static ByteList strConvEncOpts(ThreadContext context, ByteList str, Encoding fromEncoding, Encoding toEncoding, int ecflags, IRubyObject ecopts) {
        return EncodingUtils.strConvEncOpts(context, RubyString.newString(context.runtime, str), fromEncoding, toEncoding, ecflags, ecopts).getByteList();
    }

    public static RubyString strConvEncOpts(ThreadContext context, RubyString str, Encoding fromEncoding, Encoding toEncoding, int ecflags, IRubyObject ecopts) {
        if (toEncoding == null) {
            return str;
        }
        if (fromEncoding == null) {
            fromEncoding = str.getEncoding();
        }
        if (fromEncoding == toEncoding) {
            return str;
        }
        if (toEncoding.isAsciiCompatible() && str.isAsciiOnly() || toEncoding == ASCIIEncoding.INSTANCE) {
            if (str.getEncoding() != toEncoding) {
                str = (RubyString)str.dup();
                str.setEncoding(toEncoding);
            }
            return str;
        }
        ByteList strByteList = str.getByteList();
        int len = strByteList.getRealSize();
        ByteList newStr = new ByteList(len);
        int olen = len;
        EConv ec = EncodingUtils.econvOpenOpts(context, fromEncoding.getName(), toEncoding.getName(), ecflags, ecopts);
        if (ec == null) {
            return str;
        }
        byte[] sbytes = strByteList.getUnsafeBytes();
        Ptr sp = new Ptr(strByteList.getBegin());
        int start2 = sp.p;
        Ptr dp = new Ptr(0);
        int convertedOutput = 0;
        byte[] destbytes = newStr.getUnsafeBytes();
        int dest = newStr.begin();
        dp.p = dest + convertedOutput;
        EConvResult ret = ec.convert(sbytes, sp, start2 + len, destbytes, dp, dest + olen, 0);
        while (ret == EConvResult.DestinationBufferFull) {
            int convertedInput = sp.p - start2;
            int rest2 = len - convertedInput;
            convertedOutput = dp.p - dest;
            newStr.setRealSize(convertedOutput);
            rest2 = convertedInput != 0 && convertedOutput != 0 && rest2 < Integer.MAX_VALUE / convertedOutput ? rest2 * convertedOutput / convertedInput : olen;
            newStr.ensure(olen += rest2 < 2 ? 2 : rest2);
        }
        ec.close();
        switch (ret) {
            case Finished: {
                len = dp.p;
                newStr.setRealSize(len);
                newStr.setEncoding(toEncoding);
                return RubyString.newString(context.runtime, newStr);
            }
        }
        return str;
    }

    public static RubyString strConvEnc(ThreadContext context, RubyString value2, Encoding fromEncoding, Encoding toEncoding) {
        return EncodingUtils.strConvEncOpts(context, value2, fromEncoding, toEncoding, 0, context.nil);
    }

    public static ByteList strConvEnc(ThreadContext context, ByteList value2, Encoding fromEncoding, Encoding toEncoding) {
        return EncodingUtils.strConvEncOpts(context, value2, fromEncoding, toEncoding, 0, context.nil);
    }

    public static IRubyObject setStrBuf(Ruby runtime, IRubyObject str, int len) {
        if (str == null || str.isNil()) {
            str = RubyString.newStringLight(runtime, len);
        } else {
            RubyString s2 = str.convertToString();
            int clen = s2.size();
            if (clen >= len) {
                s2.modify();
                return s2;
            }
            str = s2;
            len -= clen;
        }
        ((RubyString)str).modifyExpand(((RubyString)str).size() + len);
        return str;
    }

    public static void transcodeLoop(ThreadContext context, byte[] inBytes, Ptr inPos, byte[] outBytes, Ptr outPos, int inStop, int _outStop, ByteList destination, ResizeFunction resizeFunction, byte[] sname, byte[] dname, int ecflags, IRubyObject ecopts) {
        Transcoding lastTC;
        Ruby runtime = context.runtime;
        Ptr outStop = new Ptr(_outStop);
        IRubyObject fallback = context.nil;
        TranscodeFallback fallbackFunc = null;
        EConv ec = EncodingUtils.econvOpenOpts(context, sname, dname, ecflags, ecopts);
        if (ec == null) {
            throw EncodingUtils.econvOpenExc(context, sname, dname, ecflags);
        }
        if (!ecopts.isNil() && ecopts instanceof RubyHash) {
            fallback = ((RubyHash)ecopts).op_aref(context, runtime.newSymbol("fallback"));
            fallbackFunc = fallback instanceof RubyHash ? HASH_FALLBACK : (fallback instanceof RubyProc ? PROC_FALLBACK : (fallback instanceof RubyMethod ? METHOD_FALLBACK : AREF_FALLBACK));
        }
        int maxOutput = (lastTC = ec.lastTranscoding) != null ? lastTC.transcoder.maxOutput : 1;
        Ptr outStart = new Ptr(outPos.p);
        while (true) {
            EConvResult ret = ec.convert(inBytes, inPos, inStop, outBytes, outPos, outStop.p, 0);
            if (!fallback.isNil() && ret == EConvResult.UndefinedConversion) {
                IRubyObject rep = RubyString.newStringNoCopy(runtime, new ByteList(ec.lastError.getErrorBytes(), ec.lastError.getErrorBytesP(), ec.lastError.getErrorBytesLength(), runtime.getEncodingService().findEncodingOrAliasEntry(ec.lastError.getSource()).getEncoding(), false));
                if (!(rep = fallbackFunc.call(context, fallback, rep)).isNil()) {
                    rep = rep.convertToString();
                    Encoding repEnc = ((RubyString)rep).getEncoding();
                    ByteList repByteList = ((RubyString)rep).getByteList();
                    ec.insertOutput(repByteList.getUnsafeBytes(), repByteList.begin(), repByteList.getRealSize(), repEnc.getName());
                    continue;
                }
            }
            if (ret == EConvResult.InvalidByteSequence || ret == EConvResult.IncompleteInput || ret == EConvResult.UndefinedConversion) {
                RaiseException re = EncodingUtils.makeEconvException(runtime, ec);
                ec.close();
                throw re;
            }
            if (ret != EConvResult.DestinationBufferFull) break;
            EncodingUtils.moreOutputBuffer(destination, resizeFunction, maxOutput, outStart, outPos, outStop);
            outBytes = destination.getUnsafeBytes();
        }
        ec.close();
    }

    public static RaiseException makeEconvException(Ruby runtime, EConv ec) {
        if (ec.lastError.getResult() == EConvResult.InvalidByteSequence || ec.lastError.getResult() == EConvResult.IncompleteInput) {
            String mesg;
            byte[] errBytes = ec.lastError.getErrorBytes();
            int errBytesP = ec.lastError.getErrorBytesP();
            int errorLen = ec.lastError.getErrorBytesLength();
            ByteList _bytes = new ByteList(errBytes, errBytesP, errorLen - errBytesP);
            RubyString bytes2 = RubyString.newString(runtime, _bytes);
            RubyString dumped = (RubyString)bytes2.dump();
            int readagainLen = ec.lastError.getReadAgainLength();
            IRubyObject bytes22 = runtime.getNil();
            if (ec.lastError.getResult() == EConvResult.IncompleteInput) {
                mesg = "incomplete " + dumped + " on " + new String(ec.lastError.getSource());
            } else if (readagainLen != 0) {
                bytes22 = RubyString.newString(runtime, new ByteList(errBytes, errorLen + errBytesP, ec.lastError.getReadAgainLength()));
                IRubyObject dumped2 = ((RubyString)bytes22).dump();
                mesg = dumped + " followed by " + dumped2 + " on " + new String(ec.lastError.getSource());
            } else {
                mesg = dumped + " on " + new String(ec.lastError.getSource());
            }
            RaiseException exc = runtime.newInvalidByteSequenceError(mesg);
            exc.getException().setInternalVariable("error_bytes", bytes2);
            exc.getException().setInternalVariable("readagain_bytes", bytes22);
            exc.getException().setInternalVariable("incomplete_input", ec.lastError.getResult() == EConvResult.IncompleteInput ? runtime.getTrue() : runtime.getFalse());
            return EncodingUtils.makeEConvExceptionSetEncs(exc, runtime, ec);
        }
        if (ec.lastError.getResult() == EConvResult.UndefinedConversion) {
            String mesg;
            byte[] errBytes = ec.lastError.getErrorBytes();
            int errBytesP = ec.lastError.getErrorBytesP();
            int errorLen = ec.lastError.getErrorBytesLength();
            ByteList _bytes = new ByteList(errBytes, errBytesP, errorLen - errBytesP);
            RubyString bytes3 = RubyString.newString(runtime, _bytes);
            if (Arrays.equals(ec.lastError.getSource(), "UTF-8".getBytes())) {
                // empty if block
            }
            RubyString dumped = (RubyString)bytes3.dump();
            if (Arrays.equals(ec.lastError.getSource(), ec.source) && Arrays.equals(ec.lastError.getDestination(), ec.destination)) {
                mesg = dumped + " from " + new String(ec.lastError.getSource()) + " to " + new String(ec.lastError.getDestination());
            } else {
                mesg = dumped + " to " + new String(ec.lastError.getDestination()) + " in conversion from " + new String(ec.source);
                for (int i2 = 0; i2 < ec.numTranscoders; ++i2) {
                    mesg = mesg + " to " + new String(ec.elements[i2].transcoding.transcoder.getDestination());
                }
            }
            RaiseException exc = runtime.newUndefinedConversionError(mesg);
            EncodingDB.Entry entry = runtime.getEncodingService().findEncodingOrAliasEntry(ec.lastError.getSource());
            if (entry != null) {
                bytes3.setEncoding(entry.getEncoding());
                exc.getException().setInternalVariable("error_char", bytes3);
            }
            return EncodingUtils.makeEConvExceptionSetEncs(exc, runtime, ec);
        }
        return null;
    }

    private static RaiseException makeEConvExceptionSetEncs(RaiseException exc, Ruby runtime, EConv ec) {
        exc.getException().setInternalVariable("source_encoding_name", RubyString.newString(runtime, ec.lastError.getSource()));
        exc.getException().setInternalVariable("destination_encoding_name", RubyString.newString(runtime, ec.lastError.getDestination()));
        EncodingDB.Entry entry = runtime.getEncodingService().findEncodingOrAliasEntry(ec.lastError.getSource());
        if (entry != null) {
            exc.getException().setInternalVariable("source_encoding", runtime.getEncodingService().convertEncodingToRubyEncoding(entry.getEncoding()));
        }
        if ((entry = runtime.getEncodingService().findEncodingOrAliasEntry(ec.lastError.getDestination())) != null) {
            exc.getException().setInternalVariable("destination_encoding", runtime.getEncodingService().convertEncodingToRubyEncoding(entry.getEncoding()));
        }
        return exc;
    }

    static void moreOutputBuffer(ByteList destination, ResizeFunction resizeDestination, int maxOutput, Ptr outStart, Ptr outPos, Ptr outStop) {
        int len = outPos.p - outStart.p;
        int newLen = (len + maxOutput) * 2;
        outStart.p = resizeDestination.resize(destination, len, newLen);
        outPos.p = outStart.p + len;
        outStop.p = outStart.p + newLen;
    }

    public static void ioSetEncodingByBOM(ThreadContext context, RubyIO io2) {
        Ruby runtime = context.runtime;
        Encoding bomEncoding = EncodingUtils.ioStripBOM(io2);
        if (bomEncoding != null) {
            RubyEncoding theBom = runtime.getEncodingService().getEncoding(bomEncoding);
            IRubyObject theInternal = io2.internal_encoding(context);
            io2.setEncoding(runtime.getCurrentContext(), theBom, theInternal, context.nil);
        }
    }

    @Deprecated
    public static Encoding ioStripBOM(RubyIO io2) {
        return EncodingUtils.ioStripBOM(io2.getRuntime().getCurrentContext(), io2);
    }

    public static Encoding ioStripBOM(ThreadContext context, RubyIO io2) {
        IRubyObject b1 = io2.getbyte(context);
        if (b1.isNil()) {
            return null;
        }
        switch ((int)((RubyFixnum)b1).getLongValue()) {
            case 239: {
                IRubyObject b3;
                IRubyObject b2 = io2.getbyte(context);
                if (b2.isNil()) break;
                if (((RubyFixnum)b2).getLongValue() == 187L && !(b3 = io2.getbyte(context)).isNil()) {
                    if (((RubyFixnum)b3).getLongValue() == 191L) {
                        return UTF8Encoding.INSTANCE;
                    }
                    io2.ungetbyte(context, b3);
                }
                io2.ungetbyte(context, b2);
                break;
            }
            case 254: {
                IRubyObject b2 = io2.getbyte(context);
                if (b2.isNil()) break;
                if (((RubyFixnum)b2).getLongValue() == 255L) {
                    return UTF16BEEncoding.INSTANCE;
                }
                io2.ungetbyte(context, b2);
                break;
            }
            case 255: {
                IRubyObject b2 = io2.getbyte(context);
                if (b2.isNil()) break;
                if (((RubyFixnum)b2).getLongValue() == 254L) {
                    IRubyObject b4;
                    IRubyObject b3 = io2.getbyte(context);
                    if (((RubyFixnum)b3).getLongValue() == 0L && !(b4 = io2.getbyte(context)).isNil()) {
                        if (((RubyFixnum)b4).getLongValue() == 0L) {
                            return UTF32LEEncoding.INSTANCE;
                        }
                    } else {
                        io2.ungetbyte(context, b3);
                        return UTF16LEEncoding.INSTANCE;
                    }
                    io2.ungetbyte(context, b4);
                    io2.ungetbyte(context, b3);
                }
                io2.ungetbyte(context, b2);
                break;
            }
            case 0: {
                IRubyObject b3;
                IRubyObject b2 = io2.getbyte(context);
                if (b2.isNil()) break;
                if (((RubyFixnum)b2).getLongValue() == 0L && !(b3 = io2.getbyte(context)).isNil()) {
                    IRubyObject b4;
                    if (((RubyFixnum)b3).getLongValue() == 254L && !(b4 = io2.getbyte(context)).isNil()) {
                        if (((RubyFixnum)b4).getLongValue() == 255L) {
                            return UTF32BEEncoding.INSTANCE;
                        }
                        io2.ungetbyte(context, b4);
                    }
                    io2.ungetbyte(context, b3);
                }
                io2.ungetbyte(context, b2);
            }
        }
        io2.ungetbyte(context, b1);
        return null;
    }

    public static void validateEncodingBinmode(ThreadContext context, int[] fmode_p, int ecflags, IOEncodable ioEncodable) {
        Ruby runtime = context.runtime;
        int fmode = fmode_p[0];
        if ((fmode & 1) != 0 && ioEncodable.getEnc2() == null && (fmode & 4) == 0 && !(ioEncodable.getEnc() != null ? ioEncodable.getEnc() : runtime.getDefaultExternalEncoding()).isAsciiCompatible()) {
            throw runtime.newArgumentError("ASCII incompatible encoding needs binmode");
        }
        if ((fmode & 4) == 0 && (DEFAULT_TEXTMODE != 0 || (ecflags & 0x3F00) != 0)) {
            fmode_p[0] = fmode |= DEFAULT_TEXTMODE;
        } else if (DEFAULT_TEXTMODE == 0 && (ecflags & 0x3F00) == 0) {
            fmode_p[0] = fmode &= 0xFFFFEFFF;
        }
    }

    public static void rbEncSetDefaultExternal(ThreadContext context, IRubyObject encoding2) {
        if (encoding2.isNil()) {
            throw context.runtime.newArgumentError("default external can not be nil");
        }
        Encoding[] enc_p = new Encoding[]{context.runtime.getDefaultExternalEncoding()};
        EncodingUtils.encSetDefaultEncoding(context, enc_p, encoding2, "external");
        context.runtime.setDefaultExternalEncoding(enc_p[0]);
    }

    public static void rbEncSetDefaultInternal(ThreadContext context, IRubyObject encoding2) {
        Encoding[] enc_p = new Encoding[]{context.runtime.getDefaultInternalEncoding()};
        EncodingUtils.encSetDefaultEncoding(context, enc_p, encoding2, "internal");
        context.runtime.setDefaultInternalEncoding(enc_p[0]);
    }

    public static boolean encSetDefaultEncoding(ThreadContext context, Encoding[] def_p, IRubyObject encoding2, String name2) {
        boolean overridden = false;
        if (def_p != null) {
            overridden = true;
        }
        def_p[0] = encoding2.isNil() ? null : EncodingUtils.rbToEncoding(context, encoding2);
        if (name2.equals("external")) {
            // empty if block
        }
        return overridden;
    }

    public static Encoding defaultExternalEncoding(Ruby runtime) {
        if (runtime.getDefaultExternalEncoding() != null) {
            return runtime.getDefaultExternalEncoding();
        }
        return runtime.getEncodingService().getLocaleEncoding();
    }

    public static void rbStrBufCat(Ruby runtime, RubyString str, ByteList ptr) {
        if (ptr.length() == 0) {
            return;
        }
        EncodingUtils.strBufCat(runtime, str, ptr);
    }

    public static void rbStrBufCat(Ruby runtime, RubyString str, byte[] ptrBytes, int ptr, int len) {
        if (len == 0) {
            return;
        }
        EncodingUtils.strBufCat(runtime, str, ptrBytes, ptr, len);
    }

    public static void rbStrBufCat(Ruby runtime, ByteList str, byte[] ptrBytes, int ptr, int len) {
        if (len == 0) {
            return;
        }
        EncodingUtils.strBufCat(str, ptrBytes, ptr, len);
    }

    public static void strBufCat(Ruby runtime, RubyString str, ByteList ptr) {
        EncodingUtils.strBufCat(runtime, str, ptr.getUnsafeBytes(), ptr.getBegin(), ptr.getRealSize());
    }

    public static void strBufCat(Ruby runtime, RubyString str, byte[] ptrBytes, int ptr, int len) {
        str.modify();
        EncodingUtils.strBufCat(str.getByteList(), ptrBytes, ptr, len);
    }

    public static void strBufCat(ByteList str, byte[] ptrBytes, int ptr, int len) {
        int off = -1;
        if (len == 0) {
            return;
        }
        int total2 = str.getRealSize() + len;
        str.ensure(total2);
        str.append(ptrBytes, ptr, len);
    }

    public static void encStrBufCat(Ruby runtime, RubyString str, ByteList ptr, Encoding enc) {
        EncodingUtils.encCrStrBufCat(runtime, str, ptr.getUnsafeBytes(), ptr.getBegin(), ptr.getRealSize(), enc, 0, null);
    }

    public static void encStrBufCat(Ruby runtime, RubyString str, byte[] ptrBytes, int ptr, int len, Encoding enc) {
        EncodingUtils.encCrStrBufCat(runtime, str, ptrBytes, ptr, len, enc, 0, null);
    }

    public static void encCrStrBufCat(Ruby runtime, RubyString str, ByteList ptr, Encoding ptrEnc, int ptr_cr, int[] ptr_cr_ret) {
        EncodingUtils.encCrStrBufCat(runtime, str, ptr.getUnsafeBytes(), ptr.getBegin(), ptr.getRealSize(), ptrEnc, ptr_cr, ptr_cr_ret);
    }

    public static void encCrStrBufCat(Ruby runtime, RubyString str, byte[] ptrBytes, int ptr, int len, Encoding ptrEnc, int ptr_cr, int[] ptr_cr_ret) {
        int res_cr;
        Encoding resEnc;
        int str_cr;
        Encoding strEnc = str.getEncoding();
        boolean incompatible = false;
        int n = str_cr = str.size() > 0 ? str.getCodeRange() : 16;
        if (strEnc == ptrEnc) {
            if (str_cr == 0) {
                ptr_cr = 0;
            } else if (ptr_cr == 0) {
                ptr_cr = StringSupport.codeRangeScan(ptrEnc, ptrBytes, ptr, len);
            }
        } else {
            if (!EncodingUtils.encAsciicompat(strEnc) || !EncodingUtils.encAsciicompat(ptrEnc)) {
                if (len == 0) {
                    return;
                }
                if (str.size() == 0) {
                    EncodingUtils.rbStrBufCat(runtime, str, ptrBytes, ptr, len);
                    str.setEncodingAndCodeRange(ptrEnc, ptr_cr);
                    return;
                }
                incompatible = true;
            }
            if (!incompatible) {
                if (ptr_cr == 0) {
                    ptr_cr = StringSupport.codeRangeScan(ptrEnc, ptrBytes, ptr, len);
                }
                if (str_cr == 0 && (strEnc == ASCIIEncoding.INSTANCE || ptr_cr != 16)) {
                    str_cr = str.scanForCodeRange();
                }
            }
        }
        if (ptr_cr_ret != null) {
            ptr_cr_ret[0] = ptr_cr;
        }
        if (incompatible || strEnc != ptrEnc && str_cr != 16 && ptr_cr != 16) {
            throw runtime.newEncodingCompatibilityError("incompatible encodings: " + strEnc + " and " + ptrEnc);
        }
        if (str_cr == 0) {
            resEnc = strEnc;
            res_cr = 0;
        } else if (str_cr == 16) {
            if (ptr_cr == 16) {
                resEnc = strEnc;
                res_cr = 16;
            } else {
                resEnc = ptrEnc;
                res_cr = ptr_cr;
            }
        } else if (str_cr == 32) {
            resEnc = strEnc;
            res_cr = ptr_cr == 16 || ptr_cr == 32 ? str_cr : ptr_cr;
        } else {
            resEnc = strEnc;
            res_cr = str_cr;
            if (0 < len) {
                res_cr = 0;
            }
        }
        EncodingUtils.strBufCat(runtime, str, ptrBytes, ptr, len);
        str.setEncodingAndCodeRange(resEnc, res_cr);
    }

    public static void econvArgs(ThreadContext context, IRubyObject[] args2, byte[][] encNames, Encoding[] encs, int[] ecflags_p, IRubyObject[] ecopts_p) {
        Ruby runtime = context.runtime;
        IRubyObject snamev = context.nil;
        IRubyObject dnamev = context.nil;
        IRubyObject flags2 = context.nil;
        IRubyObject opt = context.nil;
        switch (args2.length) {
            case 3: {
                flags2 = args2[2];
            }
            case 2: {
                dnamev = args2[1];
            }
            case 1: {
                snamev = args2[0];
            }
        }
        IRubyObject tmp = TypeConverter.checkHashType(runtime, flags2);
        if (!tmp.isNil()) {
            opt = tmp;
            flags2 = context.nil;
        }
        if (!flags2.isNil()) {
            if (!opt.isNil()) {
                throw runtime.newArgumentError(args2.length, 3);
            }
            ecflags_p[0] = (int)flags2.convertToInteger().getLongValue();
            ecopts_p[0] = context.nil;
        } else if (!opt.isNil()) {
            ecflags_p[0] = EncodingUtils.econvPrepareOpts(context, opt, ecopts_p);
        } else {
            ecflags_p[0] = 0;
            ecopts_p[0] = context.nil;
        }
        encs[0] = runtime.getEncodingService().getEncodingFromObjectNoError(snamev);
        if (encs[0] == null) {
            snamev = snamev.convertToString();
        }
        encs[1] = runtime.getEncodingService().getEncodingFromObjectNoError(dnamev);
        if (encs[1] == null) {
            dnamev = dnamev.convertToString();
        }
        encNames[0] = encs[0] != null ? encs[0].getName() : ((RubyString)snamev).getBytes();
        encNames[1] = encs[1] != null ? encs[1].getName() : ((RubyString)dnamev).getBytes();
    }

    public static EConv econvInitByConvpath(ThreadContext context, IRubyObject convpath2, byte[][] encNames, Encoding[] encs) {
        Ruby runtime = context.runtime;
        final EConv ec = TranscoderDB.alloc((int)convpath2.convertToArray().size());
        IRubyObject[] sname_v = new IRubyObject[]{context.nil};
        IRubyObject[] dname_v = new IRubyObject[]{context.nil};
        byte[][] sname = new byte[][]{null};
        byte[][] dname = new byte[][]{null};
        Encoding[] senc = new Encoding[]{null};
        Encoding[] denc = new Encoding[]{null};
        boolean first2 = true;
        for (int i2 = 0; i2 < ((RubyArray)convpath2).size(); ++i2) {
            IRubyObject elt = ((RubyArray)convpath2).eltOk(i2);
            IRubyObject pair = elt.checkArrayType();
            if (!pair.isNil()) {
                if (((RubyArray)pair).size() != 2) {
                    throw context.runtime.newArgumentError("not a 2-element array in convpath");
                }
                sname_v[0] = ((RubyArray)pair).eltOk(0L);
                EncodingUtils.encArg(context, sname_v[0], sname, senc);
                dname_v[0] = ((RubyArray)pair).eltOk(1L);
                EncodingUtils.encArg(context, dname_v[0], dname, denc);
            } else {
                sname[0] = NULL_BYTE_ARRAY;
                dname[0] = elt.convertToString().getBytes();
            }
            if (EncodingUtils.DECORATOR_P(sname[0], dname[0])) {
                boolean ret = ec.addConverter(sname[0], dname[0], ec.numTranscoders);
                if (ret) continue;
                throw runtime.newArgumentError("decoration failed: " + new String(dname[0]));
            }
            int j = ec.numTranscoders;
            final int[] arg2 = new int[]{j, 0};
            int ret = TranscoderDB.searchPath((byte[])sname[0], (byte[])dname[0], (TranscoderDB.SearchPathCallback)new TranscoderDB.SearchPathCallback(){

                public void call(byte[] source2, byte[] destination, int depth) {
                    if (arg2[1] == -1) {
                        return;
                    }
                    arg2[1] = ec.addConverter(source2, destination, arg2[0]) ? 0 : -1;
                }
            });
            if (ret == -1 || arg2[1] == -1) {
                throw runtime.newArgumentError("adding conversion failed: " + new String(sname[0]) + " to " + new String(dname[0]));
            }
            if (first2) {
                first2 = false;
                encs[0] = senc[0];
                encNames[0] = ec.elements[j].transcoding.transcoder.getSource();
            }
            encs[1] = denc[0];
            encNames[1] = ec.elements[ec.numTranscoders - 1].transcoding.transcoder.getDestination();
        }
        if (first2) {
            encs[0] = null;
            encs[1] = null;
            encNames[0] = new byte[0];
            encNames[1] = new byte[0];
        }
        ec.source = encNames[0];
        ec.destination = encNames[0];
        return ec;
    }

    public static int decorateConvpath(ThreadContext context, IRubyObject convpath2, int ecflags) {
        int n;
        Ruby runtime = context.runtime;
        byte[][] decorators = new byte[32][];
        int num_decorators = TranscoderDB.decoratorNames((int)ecflags, (byte[][])decorators);
        if (num_decorators == -1) {
            return -1;
        }
        int len = n = ((RubyArray)convpath2).size();
        if (n != 0) {
            IRubyObject pair = ((RubyArray)convpath2).eltOk(n - 1);
            if (pair instanceof RubyArray) {
                byte[] dname;
                byte[] sname = runtime.getEncodingService().getEncodingFromObject(((RubyArray)pair).eltOk(0L)).getName();
                TranscoderDB.Entry entry = TranscoderDB.getEntry((byte[])sname, (byte[])(dname = runtime.getEncodingService().getEncodingFromObject(((RubyArray)pair).eltOk(1L)).getName()));
                Transcoder tr = entry.getTranscoder();
                if (tr == null) {
                    return -1;
                }
                if (!EncodingUtils.DECORATOR_P(tr.getSource(), tr.getDestination()) && tr.compatibility.isEncoder()) {
                    --n;
                    ((RubyArray)convpath2).store(len + num_decorators - 1, pair);
                }
            } else {
                ((RubyArray)convpath2).store(len + num_decorators - 1, pair);
            }
        }
        for (int i2 = 0; i2 < num_decorators; ++i2) {
            ((RubyArray)convpath2).store(n + i2, RubyString.newString(runtime, decorators[i2]));
        }
        return 0;
    }

    public static IRubyObject ioEncStr(Ruby runtime, IRubyObject str, OpenFile fptr) {
        str.setTaint(true);
        ((RubyString)str).setEncoding(fptr.readEncoding(runtime));
        return str;
    }

    public static IRubyObject encUintChr(ThreadContext context, int code, Encoding enc) {
        Ruby runtime = context.runtime;
        if (!Character.isValidCodePoint(code)) {
            return new RubyFixnum(runtime, (long)code).chr19(context);
        }
        char[] chars2 = Character.toChars(code);
        RubyString str = RubyString.newString(runtime, new String(chars2), enc);
        return str;
    }

    public static void encMbcput(int c, byte[] buf, int p2, Encoding enc) {
        enc.codeToMbc(c, buf, p2);
    }

    public static int encCodepointLength(Ruby runtime, byte[] pBytes, int p2, int e, int[] len_p, Encoding enc) {
        if (e <= p2) {
            throw runtime.newArgumentError("empty string");
        }
        int r = StringSupport.preciseLength(enc, pBytes, p2, e);
        if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
            throw runtime.newArgumentError("invalid byte sequence in " + enc);
        }
        if (len_p != null) {
            len_p[0] = StringSupport.MBCLEN_CHARFOUND_LEN(r);
        }
        return StringSupport.codePoint(runtime, enc, pBytes, p2, e);
    }

    public static IRubyObject strCompatAndValid(ThreadContext context, IRubyObject _str, Encoding enc) {
        RubyString str = _str.convertToString();
        int cr = str.scanForCodeRange();
        if (cr == 48) {
            throw context.runtime.newArgumentError("replacement must be valid byte sequence '" + str + "'");
        }
        if (cr == 16) {
            Encoding e = str.getEncoding();
            if (!enc.isAsciiCompatible()) {
                throw context.runtime.newEncodingCompatibilityError("incompatible character encodings: " + enc + " and " + e);
            }
        } else {
            Encoding e = str.getEncoding();
            if (enc != e) {
                throw context.runtime.newEncodingCompatibilityError("incompatible character encodings: " + enc + " and " + e);
            }
        }
        return str;
    }

    public static interface TranscodeFallback {
        public IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3);
    }

    public static interface ResizeFunction {
        public int resize(ByteList var1, int var2, int var3);
    }
}

