/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.runtime.Constants;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayNodes;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyEncodingConverter;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.core.RubyTime;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;

public class CoreLibrary {
    private final RubyContext context;
    @CompilerDirectives.CompilationFinal
    private RubyClass argumentErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass arrayClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass basicObjectClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass bignumClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass bindingClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass classClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass continuationClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass complexClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass dirClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass encodingClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass exceptionClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass falseClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass fiberClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass fileClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass fixnumClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass floatClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass floatDomainErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass hashClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass integerClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass indexErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass ioClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass keyErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass loadErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass localJumpErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass matchDataClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass moduleClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass nameErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass nilClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass noMethodErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass numericClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass objectClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass procClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass processClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass rangeClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass rangeErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass rationalClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass regexpClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass regexpErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass rubyTruffleErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass runtimeErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass standardErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass stringClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass symbolClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass syntaxErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass systemCallErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass systemExitClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass threadClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass timeClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass trueClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass typeErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass zeroDivisionErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyModule comparableModule;
    @CompilerDirectives.CompilationFinal
    private RubyModule configModule;
    @CompilerDirectives.CompilationFinal
    private RubyModule enumerableModule;
    @CompilerDirectives.CompilationFinal
    private RubyModule errnoModule;
    @CompilerDirectives.CompilationFinal
    private RubyModule gcModule;
    @CompilerDirectives.CompilationFinal
    private RubyModule kernelModule;
    @CompilerDirectives.CompilationFinal
    private RubyModule mathModule;
    @CompilerDirectives.CompilationFinal
    private RubyModule objectSpaceModule;
    @CompilerDirectives.CompilationFinal
    private RubyModule signalModule;
    @CompilerDirectives.CompilationFinal
    private RubyModule truffleModule;
    @CompilerDirectives.CompilationFinal
    private RubyModule truffleDebugModule;
    @CompilerDirectives.CompilationFinal
    private RubyClass edomClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass encodingConverterClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass encodingCompatibilityErrorClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass methodClass;
    @CompilerDirectives.CompilationFinal
    private RubyClass unboundMethodClass;
    @CompilerDirectives.CompilationFinal
    private RubyArray argv;
    @CompilerDirectives.CompilationFinal
    private RubyBasicObject globalVariablesObject;
    @CompilerDirectives.CompilationFinal
    private RubyBasicObject mainObject;
    @CompilerDirectives.CompilationFinal
    private RubyNilClass nilObject;
    @CompilerDirectives.CompilationFinal
    private RubyHash envHash;
    private ArrayNodes.MinBlock arrayMinBlock;
    private ArrayNodes.MaxBlock arrayMaxBlock;

    public CoreLibrary(RubyContext context) {
        this.context = context;
    }

    public static double toDouble(Object value2) {
        RubyNode.notDesignedForCompilation();
        assert (value2 != null);
        if (value2 instanceof RubyNilClass) {
            return 0.0;
        }
        if (value2 instanceof Integer) {
            return ((Integer)value2).intValue();
        }
        if (value2 instanceof RubyBignum) {
            return ((RubyBignum)value2).doubleValue();
        }
        if (value2 instanceof Double) {
            return (Double)value2;
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException();
    }

    public static boolean fitsIntoInteger(long value2) {
        return value2 >= Integer.MIN_VALUE && value2 <= Integer.MAX_VALUE;
    }

    public void initialize() {
        this.classClass = new RubyClass(this.context, null, null, "Class", false);
        this.classClass.setAllocator(new RubyClass.ClassAllocator());
        this.basicObjectClass = RubyClass.createBootClass(this.context, "BasicObject");
        this.objectClass = RubyClass.createBootClass(this.context, "Object");
        this.moduleClass = new RubyClass(this.context, null, null, "Module", false);
        this.moduleClass.setAllocator(new RubyModule.ModuleAllocator());
        this.classClass.unsafeSetLogicalClass(this.classClass);
        this.objectClass.unsafeSetSuperclass(this.basicObjectClass);
        this.moduleClass.unsafeSetSuperclass(this.objectClass);
        this.classClass.unsafeSetSuperclass(this.moduleClass);
        this.classClass.getAdoptedByLexicalParent(this.objectClass, null);
        this.basicObjectClass.getAdoptedByLexicalParent(this.objectClass, null);
        this.objectClass.getAdoptedByLexicalParent(this.objectClass, null);
        this.moduleClass.getAdoptedByLexicalParent(this.objectClass, null);
        this.basicObjectClass.setConstant(null, "BasicObject", this.basicObjectClass);
        this.numericClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Numeric");
        this.integerClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.numericClass, "Integer");
        this.exceptionClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Exception");
        this.exceptionClass.setAllocator(new RubyException.ExceptionAllocator());
        this.standardErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.exceptionClass, "StandardError");
        this.standardErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        RubyClass signalExceptionClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.exceptionClass, "SignalException");
        signalExceptionClass.setAllocator(new RubyException.ExceptionAllocator());
        RubyClass interruptClass = new RubyClass(this.context, (RubyModule)this.objectClass, signalExceptionClass, "Interrupt");
        interruptClass.setAllocator(new RubyException.ExceptionAllocator());
        this.ioClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "IO");
        this.argumentErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "ArgumentError");
        this.argumentErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.arrayClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Array");
        this.arrayClass.setAllocator(new RubyArray.ArrayAllocator());
        this.bignumClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.integerClass, "Bignum");
        this.bignumClass.setAllocator(new RubyBignum.BignumAllocator());
        this.bindingClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Binding");
        this.comparableModule = new RubyModule(this.context, this.objectClass, "Comparable");
        this.complexClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.numericClass, "Complex");
        this.configModule = new RubyModule(this.context, this.objectClass, "Config");
        this.continuationClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Continuation");
        this.dirClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Dir");
        this.encodingClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Encoding");
        this.encodingClass.setAllocator(new RubyEncoding.EncodingAllocator());
        this.errnoModule = new RubyModule(this.context, this.objectClass, "Errno");
        this.enumerableModule = new RubyModule(this.context, this.objectClass, "Enumerable");
        this.falseClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "FalseClass");
        this.fiberClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Fiber");
        this.fileClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.ioClass, "File");
        this.fixnumClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.integerClass, "Fixnum");
        this.floatClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.numericClass, "Float");
        this.floatDomainErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.rangeErrorClass, "FloatDomainError");
        this.floatDomainErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.gcModule = new RubyModule(this.context, this.objectClass, "GC");
        this.hashClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Hash");
        this.hashClass.setAllocator(new RubyHash.HashAllocator());
        this.indexErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "IndexError");
        this.indexErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.kernelModule = new RubyModule(this.context, this.objectClass, "Kernel");
        this.keyErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.indexErrorClass, "KeyError");
        this.keyErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.loadErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "LoadError");
        this.loadErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.localJumpErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "LocalJumpError");
        this.localJumpErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.matchDataClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "MatchData");
        this.mathModule = new RubyModule(this.context, this.objectClass, "Math");
        this.nameErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "NameError");
        this.nameErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.nilClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "NilClass");
        this.noMethodErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.nameErrorClass, "NoMethodError");
        this.noMethodErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.objectSpaceModule = new RubyModule(this.context, this.objectClass, "ObjectSpace");
        this.procClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Proc");
        this.procClass.setAllocator(new RubyProc.ProcAllocator());
        this.processClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Process");
        this.rangeClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Range");
        this.rangeErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "RangeError");
        this.rangeErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.rationalClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.numericClass, "Rational");
        this.regexpClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Regexp");
        this.regexpClass.setAllocator(new RubyRegexp.RegexpAllocator());
        this.regexpErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "RegexpError");
        this.regexpErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.rubyTruffleErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "RubyTruffleError");
        this.rubyTruffleErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.runtimeErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "RuntimeError");
        this.runtimeErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.signalModule = new RubyModule(this.context, this.objectClass, "Signal");
        this.stringClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "String");
        this.stringClass.setAllocator(new RubyString.StringAllocator());
        this.symbolClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Symbol");
        this.syntaxErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "SyntaxError");
        this.syntaxErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.systemCallErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "SystemCallError");
        this.systemCallErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.systemExitClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.exceptionClass, "SystemExit");
        this.systemExitClass.setAllocator(new RubyException.ExceptionAllocator());
        this.threadClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Thread");
        this.threadClass.setAllocator(new RubyThread.ThreadAllocator());
        this.timeClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Time");
        this.timeClass.setAllocator(new RubyTime.TimeAllocator());
        this.trueClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "TrueClass");
        this.truffleModule = new RubyModule(this.context, this.objectClass, "Truffle");
        this.truffleDebugModule = new RubyModule(this.context, this.truffleModule, "Debug");
        new RubyModule(this.context, this.truffleModule, "Primitive");
        this.typeErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "TypeError");
        this.typeErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.zeroDivisionErrorClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.standardErrorClass, "ZeroDivisionError");
        this.zeroDivisionErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.encodingConverterClass = new RubyClass(this.context, (RubyModule)this.encodingClass, this.objectClass, "Converter");
        this.encodingConverterClass.setAllocator(new RubyEncodingConverter.EncodingConverterAllocator());
        this.methodClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "Method");
        this.unboundMethodClass = new RubyClass(this.context, (RubyModule)this.objectClass, this.objectClass, "UnboundMethod");
        this.encodingCompatibilityErrorClass = new RubyClass(this.context, (RubyModule)this.encodingClass, this.standardErrorClass, "CompatibilityError");
        this.encodingCompatibilityErrorClass.setAllocator(new RubyException.ExceptionAllocator());
        this.objectClass.include(null, this.kernelModule);
        this.numericClass.include(null, this.comparableModule);
        this.stringClass.include(null, this.comparableModule);
        this.symbolClass.include(null, this.comparableModule);
        this.arrayClass.include(null, this.enumerableModule);
        this.dirClass.include(null, this.enumerableModule);
        this.hashClass.include(null, this.enumerableModule);
        this.ioClass.include(null, this.enumerableModule);
        this.rangeClass.include(null, this.enumerableModule);
        this.objectClass.setConstant(null, "RUBY_VERSION", RubyString.fromJavaString(this.stringClass, "2.2.0"));
        this.objectClass.setConstant(null, "RUBY_PATCHLEVEL", Constants.RUBY_PATCHLEVEL);
        this.objectClass.setConstant(null, "RUBY_ENGINE", RubyString.fromJavaString(this.stringClass, "jruby+truffle"));
        this.objectClass.setConstant(null, "RUBY_PLATFORM", RubyString.fromJavaString(this.stringClass, "java"));
        this.edomClass = new RubyClass(this.context, this.errnoModule, this.systemCallErrorClass, "EDOM");
        this.edomClass.setAllocator(new RubyException.ExceptionAllocator());
        RubyClass tempClass = new RubyClass(this.context, this.errnoModule, this.systemCallErrorClass, "ENOENT");
        tempClass.setAllocator(new RubyException.ExceptionAllocator());
        tempClass = new RubyClass(this.context, this.errnoModule, this.systemCallErrorClass, "EPERM");
        tempClass.setAllocator(new RubyException.ExceptionAllocator());
        tempClass = new RubyClass(this.context, this.errnoModule, this.systemCallErrorClass, "ENOTEMPTY");
        tempClass.setAllocator(new RubyException.ExceptionAllocator());
        tempClass = new RubyClass(this.context, this.errnoModule, this.systemCallErrorClass, "EEXIST");
        tempClass.setAllocator(new RubyException.ExceptionAllocator());
        tempClass = new RubyClass(this.context, this.errnoModule, this.systemCallErrorClass, "EXDEV");
        tempClass.setAllocator(new RubyException.ExceptionAllocator());
        tempClass = new RubyClass(this.context, this.errnoModule, this.systemCallErrorClass, "EACCES");
        tempClass.setAllocator(new RubyException.ExceptionAllocator());
        this.mathModule.setConstant(null, "DomainError", this.edomClass);
        this.mainObject = new RubyBasicObject(this.objectClass);
        this.nilObject = new RubyNilClass(this.nilClass);
        this.globalVariablesObject = new RubyBasicObject(this.objectClass);
        this.globalVariablesObject.getOperations().setInstanceVariable(this.globalVariablesObject, "$LOAD_PATH", new RubyArray(this.arrayClass));
        this.globalVariablesObject.getOperations().setInstanceVariable(this.globalVariablesObject, "$LOADED_FEATURES", new RubyArray(this.arrayClass));
        this.globalVariablesObject.getOperations().setInstanceVariable(this.globalVariablesObject, "$:", this.globalVariablesObject.getInstanceVariable("$LOAD_PATH"));
        this.globalVariablesObject.getOperations().setInstanceVariable(this.globalVariablesObject, "$\"", this.globalVariablesObject.getInstanceVariable("$LOADED_FEATURES"));
        this.globalVariablesObject.getOperations().setInstanceVariable(this.globalVariablesObject, "$,", this.nilObject);
        this.initializeEncodingConstants();
        this.arrayMinBlock = new ArrayNodes.MinBlock(this.context);
        this.arrayMaxBlock = new ArrayNodes.MaxBlock(this.context);
        this.argv = new RubyArray(this.arrayClass);
        this.objectClass.setConstant(null, "ARGV", this.argv);
        this.fileClass.setConstant(null, "SEPARATOR", RubyString.fromJavaString(this.stringClass, File.separator));
        this.fileClass.setConstant(null, "Separator", RubyString.fromJavaString(this.stringClass, File.separator));
        this.fileClass.setConstant(null, "ALT_SEPARATOR", this.nilObject);
        this.fileClass.setConstant(null, "PATH_SEPARATOR", RubyString.fromJavaString(this.stringClass, File.pathSeparator));
        this.fileClass.setConstant(null, "FNM_SYSCASE", 0);
        RubyNode.notDesignedForCompilation();
        this.globalVariablesObject.getOperations().setInstanceVariable(this.globalVariablesObject, "$DEBUG", this.context.getRuntime().isDebug());
        RubyNilClass value2 = this.context.getRuntime().warningsEnabled() ? Boolean.valueOf(this.context.getRuntime().isVerbose()) : this.nilObject;
        RubyNode.notDesignedForCompilation();
        this.globalVariablesObject.getOperations().setInstanceVariable(this.globalVariablesObject, "$VERBOSE", value2);
    }

    public void initializeAfterMethodsAdded() {
        this.objectClass.setConstant(null, "RUBY_RELEASE_DATE", this.context.makeString("2015-01-20"));
        this.objectClass.setConstant(null, "RUBY_DESCRIPTION", this.context.makeString(OutputStrings.getVersionString()));
        if (((Boolean)Options.TRUFFLE_LOAD_CORE.load()).booleanValue()) {
            try {
                this.loadRubyCore("jruby/truffle/core.rb");
            }
            catch (RaiseException e) {
                RubyException rubyException = e.getRubyException();
                for (String line : Backtrace.DISPLAY_FORMATTER.format(this.getContext(), rubyException, rubyException.getBacktrace())) {
                    System.err.println(line);
                }
                throw new TruffleFatalException("couldn't load the core library", e);
            }
        }
        this.envHash = this.getSystemEnv();
        this.objectClass.setConstant(null, "ENV", this.envHash);
    }

    public void loadRubyCore(String fileName) {
        Source source2;
        try {
            LoadServiceResource resource2 = this.context.getRuntime().getLoadService().getClassPathResource(this.context.getRuntime().getJRubyClassLoader(), fileName);
            if (resource2 == null) {
                throw new RuntimeException("couldn't load Truffle core library " + fileName);
            }
            source2 = Source.fromReader((Reader)new InputStreamReader(resource2.getInputStream(), StandardCharsets.UTF_8), (String)("core:/" + fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.context.load(source2, null, NodeWrapper.IDENTITY);
    }

    public void initializeEncodingConstants() {
        this.getContext().getRuntime().getEncodingService().defineEncodings(new EncodingService.EncodingDefinitionVisitor(){

            @Override
            public void defineEncoding(EncodingDB.Entry encodingEntry, byte[] name2, int p2, int end2) {
                Encoding e = encodingEntry.getEncoding();
                RubyEncoding re = RubyEncoding.newEncoding(CoreLibrary.this.getContext(), e, name2, p2, end2, encodingEntry.isDummy());
                RubyEncoding.storeEncoding(encodingEntry.getIndex(), re);
            }

            @Override
            public void defineConstant(int encodingListIndex, String constName) {
                CoreLibrary.this.encodingClass.setConstant(null, constName, RubyEncoding.getEncoding(encodingListIndex));
            }
        });
        this.getContext().getRuntime().getEncodingService().defineAliases(new EncodingService.EncodingAliasVisitor(){

            @Override
            public void defineAlias(int encodingListIndex, String constName) {
                RubyEncoding re = RubyEncoding.getEncoding(encodingListIndex);
                RubyEncoding.storeAlias(constName, re);
            }

            @Override
            public void defineConstant(int encodingListIndex, String constName) {
                CoreLibrary.this.encodingClass.setConstant(null, constName, RubyEncoding.getEncoding(encodingListIndex));
            }
        });
    }

    public RubyClass getMetaClass(Object object) {
        RubyNode.notDesignedForCompilation();
        if (object instanceof RubyBasicObject) {
            return ((RubyBasicObject)object).getMetaClass();
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return this.trueClass;
            }
            return this.falseClass;
        }
        if (object instanceof Integer) {
            return this.fixnumClass;
        }
        if (object instanceof Long) {
            return this.fixnumClass;
        }
        if (object instanceof Double) {
            return this.floatClass;
        }
        if (object == null) {
            throw new RuntimeException();
        }
        throw new UnsupportedOperationException(String.format("Don't know how to get the metaclass for %s", object.getClass()));
    }

    public RubyClass getLogicalClass(Object object) {
        RubyNode.notDesignedForCompilation();
        if (object instanceof RubyBasicObject) {
            return ((RubyBasicObject)object).getLogicalClass();
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return this.trueClass;
            }
            return this.falseClass;
        }
        if (object instanceof Integer) {
            return this.fixnumClass;
        }
        if (object instanceof Long) {
            return this.fixnumClass;
        }
        if (object instanceof Double) {
            return this.floatClass;
        }
        if (object == null) {
            throw new RuntimeException();
        }
        throw new UnsupportedOperationException(String.format("Don't know how to get the logical class for %s", object.getClass()));
    }

    public RubyException runtimeError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.runtimeErrorClass, this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException frozenError(String className, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.runtimeError(String.format("FrozenError: can't modify frozen %s", className), currentNode);
    }

    public RubyException argumentError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.argumentErrorClass, this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException argumentErrorInvalidRadix(int radix, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("invalid radix %d", radix), currentNode);
    }

    public RubyException argumentErrorMissingKeyword(String name2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("missing keyword: %s", name2), currentNode);
    }

    public RubyException argumentError(int passed, int required, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("wrong number of arguments (%d for %d)", passed, required), currentNode);
    }

    public RubyException argumentError(int passed, int required, int optional, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("wrong number of arguments (%d for %d..%d)", passed, required, required + optional), currentNode);
    }

    public RubyException argumentErrorEmptyVarargs(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError("wrong number of arguments (0 for 1+)", currentNode);
    }

    public RubyException indexError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.indexErrorClass, this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException indexTooSmallError(String type2, int index2, int length2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.indexError(String.format("index %d too small for %s; minimum: -%d", index2, type2, length2), currentNode);
    }

    public RubyException indexNegativeLength(int length2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.indexError(String.format("negative length (%d)", length2), currentNode);
    }

    public RubyException localJumpError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.localJumpErrorClass, this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException unexpectedReturn(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.localJumpError("unexpected return", currentNode);
    }

    public RubyException noBlockToYieldTo(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.localJumpError("no block given (yield)", currentNode);
    }

    public RubyException typeError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.typeErrorClass, this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException typeErrorCantDefineSingleton(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError("can't define singleton", currentNode);
    }

    public RubyException typeErrorNoClassToMakeAlias(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError("no class to make alias", currentNode);
    }

    public RubyException typeErrorShouldReturn(String object, String method, String expectedType, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("%s#%s should return %s", object, method, expectedType), currentNode);
    }

    public RubyException typeErrorCantConvertTo(String from, String to, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("can't convert %s to %s", from, to), currentNode);
    }

    public RubyException typeErrorCantConvertTo(String from, String to, String methodUsed, String given, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("can't convert %s to %s (%s#%s gives %s)", from, to, from, methodUsed, given), currentNode);
    }

    public RubyException typeErrorCantConvertInto(String from, String to, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("can't convert %s into %s", from, to), currentNode);
    }

    public RubyException typeErrorCantConvertInto(Object from, RubyClass to, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeErrorCantConvertInto(this.getLogicalClass(from).getName(), to.getName(), currentNode);
    }

    public RubyException typeErrorIsNotA(String value2, String expectedType, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("%s is not a %s", value2, expectedType), currentNode);
    }

    public RubyException typeErrorNoImplicitConversion(Object from, String to, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("no implicit conversion of %s into %s", this.getLogicalClass(from).getName(), to), currentNode);
    }

    public RubyException typeErrorMustBe(String variable, String type2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("value of %s must be %s", variable, type2), currentNode);
    }

    public RubyException typeErrorBadCoercion(Object from, String to, String coercionMethod, Object coercedTo, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String badClassName = this.getLogicalClass(from).getName();
        return this.typeError(String.format("can't convert %s to %s (%s#%s gives %s)", badClassName, to, badClassName, coercionMethod, this.getLogicalClass(coercedTo).getName()), currentNode);
    }

    public RubyException typeErrorCantCoerce(Object from, String to, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("%s can't be coerced into %s", from, to), currentNode);
    }

    public RubyException nameError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.nameErrorClass, this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException nameErrorUninitializedConstant(RubyModule module, String name2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("uninitialized constant %s::%s", module.getName(), name2), currentNode);
    }

    public RubyException nameErrorPrivateConstant(RubyModule module, String name2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("private constant %s::%s referenced", module.getName(), name2), currentNode);
    }

    public RubyException nameErrorInstanceNameNotAllowable(String name2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("`%s' is not allowable as an instance variable name", name2), currentNode);
    }

    public RubyException nameErrorReadOnly(String name2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("%s is a read-only variable", name2), currentNode);
    }

    public RubyException nameErrorUndefinedLocalVariableOrMethod(String name2, String object, Node currentNode) {
        return this.nameError(String.format("undefined local variable or method `%s' for %s", name2, object), currentNode);
    }

    public RubyException noMethodError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.context.getCoreLibrary().getNoMethodErrorClass(), this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException noMethodError(String name2, String object, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.noMethodError(String.format("undefined method `%s' for %s", name2, object), currentNode);
    }

    public RubyException privateMethodError(String name2, String object, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.noMethodError(String.format("private method `%s' called for %s", name2, object), currentNode);
    }

    public RubyException loadError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.context.getCoreLibrary().getLoadErrorClass(), this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException loadErrorCannotLoad(String name2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.loadError(String.format("cannot load such file -- %s", name2), currentNode);
    }

    public RubyException zeroDivisionError(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.context.getCoreLibrary().getZeroDivisionErrorClass(), this.context.makeString("divided by 0"), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException syntaxError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.syntaxErrorClass, this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException floatDomainError(String value2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.floatDomainErrorClass, this.context.makeString(value2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException mathDomainError(String method, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.edomClass, this.context.makeString(String.format("Numerical argument is out of domain - \"%s\"", method)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException rangeError(String type2, String value2, String range, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.rangeErrorClass, this.context.makeString(String.format("%s %s out of range of %s", type2, value2, range)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException rangeError(RubyRange.IntegerFixnumRange range, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.rangeErrorClass, this.context.makeString(String.format("%d..%s%d out of range", range.getBegin(), range.doesExcludeEnd() ? "." : "", range.getEnd())), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException internalError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.context.getCoreLibrary().getRubyTruffleErrorClass(), this.context.makeString("internal implementation error - " + message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException regexpError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.regexpErrorClass, this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException encodingCompatibilityErrorIncompatible(String a, String b2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.encodingCompatibilityError(String.format("incompatible character encodings: %s and %s", a, b2), currentNode);
    }

    public RubyException encodingCompatibilityError(String message2, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.encodingCompatibilityErrorClass, this.context.makeString(message2), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyContext getContext() {
        return this.context;
    }

    public RubyClass getArrayClass() {
        return this.arrayClass;
    }

    public RubyClass getBasicObjectClass() {
        return this.basicObjectClass;
    }

    public RubyClass getBignumClass() {
        return this.bignumClass;
    }

    public RubyClass getBindingClass() {
        return this.bindingClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyClass getContinuationClass() {
        return this.continuationClass;
    }

    public RubyClass getExceptionClass() {
        return this.exceptionClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    public RubyClass getFiberClass() {
        return this.fiberClass;
    }

    public RubyClass getFileClass() {
        return this.fileClass;
    }

    public RubyClass getFixnumClass() {
        return this.fixnumClass;
    }

    public RubyClass getFloatClass() {
        return this.floatClass;
    }

    public RubyClass getHashClass() {
        return this.hashClass;
    }

    public RubyClass getLoadErrorClass() {
        return this.loadErrorClass;
    }

    public RubyClass getMatchDataClass() {
        return this.matchDataClass;
    }

    public RubyClass getModuleClass() {
        return this.moduleClass;
    }

    public RubyClass getNameErrorClass() {
        return this.nameErrorClass;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    public RubyClass getNoMethodErrorClass() {
        return this.noMethodErrorClass;
    }

    public RubyClass getObjectClass() {
        return this.objectClass;
    }

    public RubyClass getProcClass() {
        return this.procClass;
    }

    public RubyClass getRangeClass() {
        return this.rangeClass;
    }

    public RubyClass getRationalClass() {
        return this.rationalClass;
    }

    public RubyClass getRegexpClass() {
        return this.regexpClass;
    }

    public RubyClass getRubyTruffleErrorClass() {
        return this.rubyTruffleErrorClass;
    }

    public RubyClass getRuntimeErrorClass() {
        return this.runtimeErrorClass;
    }

    public RubyClass getStringClass() {
        return this.stringClass;
    }

    public RubyClass getEncodingClass() {
        return this.encodingClass;
    }

    public RubyClass getSymbolClass() {
        return this.symbolClass;
    }

    public RubyClass getSyntaxErrorClass() {
        return this.syntaxErrorClass;
    }

    public RubyClass getThreadClass() {
        return this.threadClass;
    }

    public RubyClass getTimeClass() {
        return this.timeClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    public RubyClass getZeroDivisionErrorClass() {
        return this.zeroDivisionErrorClass;
    }

    public RubyModule getKernelModule() {
        return this.kernelModule;
    }

    public RubyArray getArgv() {
        return this.argv;
    }

    public RubyBasicObject getGlobalVariablesObject() {
        return this.globalVariablesObject;
    }

    public RubyArray getLoadPath() {
        return (RubyArray)this.globalVariablesObject.getInstanceVariable("$LOAD_PATH");
    }

    public RubyArray getLoadedFeatures() {
        return (RubyArray)this.globalVariablesObject.getInstanceVariable("$LOADED_FEATURES");
    }

    public RubyBasicObject getMainObject() {
        return this.mainObject;
    }

    public RubyNilClass getNilObject() {
        return this.nilObject;
    }

    public RubyHash getENV() {
        return this.envHash;
    }

    public RubyEncoding getDefaultEncoding() {
        return RubyEncoding.getEncoding("US-ASCII");
    }

    private RubyHash getSystemEnv() {
        ArrayList<KeyValue> entries2 = new ArrayList<KeyValue>();
        for (Map.Entry<String, String> variable : System.getenv().entrySet()) {
            entries2.add(new KeyValue(this.context.makeString(variable.getKey()), this.context.makeString(variable.getValue())));
        }
        return HashOperations.verySlowFromEntries(this.context, entries2);
    }

    public ArrayNodes.MinBlock getArrayMinBlock() {
        return this.arrayMinBlock;
    }

    public ArrayNodes.MaxBlock getArrayMaxBlock() {
        return this.arrayMaxBlock;
    }

    public RubyClass getNumericClass() {
        return this.numericClass;
    }

    public RubyClass getIntegerClass() {
        return this.integerClass;
    }

    public RubyClass getArgumentErrorClass() {
        return this.argumentErrorClass;
    }

    public RubyClass getEncodingConverterClass() {
        return this.encodingConverterClass;
    }

    public RubyClass getUnboundMethodClass() {
        return this.unboundMethodClass;
    }

    public RubyClass getMethodClass() {
        return this.methodClass;
    }

    public RubyClass getComplexClass() {
        return this.complexClass;
    }
}

