/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.backtrace;

import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.nodes.CoreSourceSection;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.RubyException;

public class MRIBacktraceFormatter
implements BacktraceFormatter {
    @Override
    public String[] format(RubyContext context, RubyException exception2, Backtrace backtrace2) {
        try {
            List<Activation> activations = backtrace2.getActivations();
            ArrayList<String> lines2 = new ArrayList<String>();
            if (activations.isEmpty()) {
                lines2.add(String.format("%s (%s)", exception2.getMessage(), exception2.getLogicalClass().getName()));
            } else {
                lines2.add(MRIBacktraceFormatter.formatInLine(activations, exception2));
                for (int n = 1; n < activations.size(); ++n) {
                    lines2.add(MRIBacktraceFormatter.formatFromLine(activations, n));
                }
            }
            return lines2.toArray(new String[lines2.size()]);
        }
        catch (Exception e) {
            throw new TruffleFatalException("Exception while trying to format a Ruby call stack", e);
        }
    }

    private static String formatInLine(List<Activation> activations, RubyException exception2) {
        String reportedName;
        SourceSection reportedSourceSection;
        StringBuilder builder = new StringBuilder();
        SourceSection sourceSection = activations.get(0).getCallNode().getEncapsulatingSourceSection();
        if (sourceSection instanceof CoreSourceSection) {
            reportedSourceSection = MRIBacktraceFormatter.nextUserSourceSection(activations, 1);
            reportedName = ((CoreSourceSection)sourceSection).getMethodName();
        } else {
            reportedSourceSection = sourceSection;
            reportedName = reportedSourceSection.getIdentifier();
        }
        if (reportedSourceSection == null) {
            throw new IllegalStateException("Call node has no encapsulating source section");
        }
        if (reportedSourceSection.getSource() == null) {
            throw new IllegalStateException("Call node source section " + reportedSourceSection + " has no source");
        }
        builder.append(reportedSourceSection.getSource().getName());
        builder.append(":");
        builder.append(reportedSourceSection.getStartLine());
        builder.append(":in `");
        builder.append(reportedName);
        builder.append("'");
        if (exception2 != null) {
            builder.append(": ");
            builder.append(exception2.getMessage());
            builder.append(" (");
            builder.append(exception2.getLogicalClass().getName());
            builder.append(")");
        }
        return builder.toString();
    }

    private static String formatFromLine(List<Activation> activations, int n) {
        return "\tfrom " + MRIBacktraceFormatter.formatCallerLine(activations, n);
    }

    public static String formatCallerLine(List<Activation> activations, int n) {
        String reportedName;
        SourceSection reportedSourceSection;
        SourceSection sourceSection = activations.get(n).getCallNode().getEncapsulatingSourceSection();
        if (sourceSection instanceof CoreSourceSection) {
            reportedSourceSection = activations.get(n + 1).getCallNode().getEncapsulatingSourceSection();
            reportedName = ((CoreSourceSection)sourceSection).getMethodName();
        } else {
            reportedSourceSection = sourceSection;
            reportedName = sourceSection.getIdentifier();
        }
        StringBuilder builder = new StringBuilder();
        if (reportedSourceSection instanceof NullSourceSection) {
            builder.append("NullSourceSection");
        } else {
            builder.append(reportedSourceSection.getSource().getName());
            builder.append(":");
            builder.append(reportedSourceSection.getStartLine());
        }
        builder.append(":in `");
        builder.append(reportedName);
        builder.append("'");
        return builder.toString();
    }

    private static SourceSection nextUserSourceSection(List<Activation> activations, int n) {
        SourceSection sourceSection;
        while ((sourceSection = activations.get(n).getCallNode().getEncapsulatingSourceSection()) instanceof CoreSourceSection) {
            ++n;
        }
        return sourceSection;
    }
}

