/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.yield;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.yield.UninitializedYieldDispatchNode;
import org.jruby.truffle.nodes.yield.YieldDispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;

public class YieldDispatchHeadNode
extends Node {
    @Node.Child
    private YieldDispatchNode dispatch;

    public YieldDispatchHeadNode(RubyContext context) {
        this.dispatch = new UninitializedYieldDispatchNode(context);
    }

    public Object dispatch(VirtualFrame frame, RubyProc block, Object ... argumentsObjects) {
        return this.dispatch.dispatch(frame, block, argumentsObjects);
    }

    public Object dispatchWithModifiedBlock(VirtualFrame frame, RubyProc block, RubyProc modifiedBlock, Object ... argumentsObjects) {
        return this.dispatch.dispatchWithModifiedBlock(frame, block, modifiedBlock, argumentsObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatchWithModifiedSelf(VirtualFrame frame, RubyProc block, Object self2, Object ... argumentsObjects) {
        FrameSlot slot = frame.getFrameDescriptor().findOrAddFrameSlot(RubyModule.VISIBILITY_FRAME_SLOT_ID, (Object)"dynamic visibility for def", FrameSlotKind.Object);
        Object oldVisibility = frame.getValue(slot);
        try {
            frame.setObject(slot, (Object)Visibility.PUBLIC);
            Object object = this.dispatch.dispatchWithModifiedSelf(frame, block, self2, argumentsObjects);
            return object;
        }
        finally {
            frame.setObject(slot, oldVisibility);
        }
    }

    public YieldDispatchNode getDispatch() {
        return this.dispatch;
    }
}

