/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.yield;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import org.jruby.truffle.nodes.yield.CachedYieldDispatchNode;
import org.jruby.truffle.nodes.yield.GeneralYieldDispatchNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.nodes.yield.YieldDispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.util.cli.Options;

@NodeInfo(cost=NodeCost.UNINITIALIZED)
public class UninitializedYieldDispatchNode
extends YieldDispatchNode {
    private int depth = 0;

    public UninitializedYieldDispatchNode(RubyContext context) {
        super(context);
    }

    @Override
    public Object dispatch(VirtualFrame frame, RubyProc block, Object[] argumentsObjects) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        ++this.depth;
        if (this.depth == (Integer)Options.TRUFFLE_DISPATCH_POLYMORPHIC_MAX.load()) {
            YieldDispatchHeadNode dispatchHead = (YieldDispatchHeadNode)NodeUtil.getNthParent((Node)this, (int)this.depth);
            GeneralYieldDispatchNode newGeneralYield = new GeneralYieldDispatchNode(this.getContext());
            dispatchHead.getDispatch().replace(newGeneralYield);
            return newGeneralYield.dispatch(frame, block, argumentsObjects);
        }
        CachedYieldDispatchNode dispatch = new CachedYieldDispatchNode(this.getContext(), block, this);
        this.replace(dispatch);
        return dispatch.dispatch(frame, block, argumentsObjects);
    }

    @Override
    public Object dispatchWithModifiedBlock(VirtualFrame frame, RubyProc block, RubyProc modifiedBlock, Object[] argumentsObjects) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        ++this.depth;
        if (this.depth == (Integer)Options.TRUFFLE_DISPATCH_POLYMORPHIC_MAX.load()) {
            YieldDispatchHeadNode dispatchHead = (YieldDispatchHeadNode)NodeUtil.getNthParent((Node)this, (int)this.depth);
            GeneralYieldDispatchNode newGeneralYield = new GeneralYieldDispatchNode(this.getContext());
            dispatchHead.getDispatch().replace(newGeneralYield);
            return newGeneralYield.dispatch(frame, block, argumentsObjects);
        }
        CachedYieldDispatchNode dispatch = new CachedYieldDispatchNode(this.getContext(), block, this);
        this.replace(dispatch);
        return dispatch.dispatchWithModifiedBlock(frame, block, modifiedBlock, argumentsObjects);
    }

    @Override
    public Object dispatchWithModifiedSelf(VirtualFrame frame, RubyProc block, Object self2, Object ... argumentsObjects) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        ++this.depth;
        if (this.depth == (Integer)Options.TRUFFLE_DISPATCH_POLYMORPHIC_MAX.load()) {
            YieldDispatchHeadNode dispatchHead = (YieldDispatchHeadNode)NodeUtil.getNthParent((Node)this, (int)this.depth);
            GeneralYieldDispatchNode newGeneralYield = new GeneralYieldDispatchNode(this.getContext());
            dispatchHead.getDispatch().replace(newGeneralYield);
            return newGeneralYield.dispatchWithModifiedSelf(frame, block, self2, argumentsObjects);
        }
        CachedYieldDispatchNode dispatch = new CachedYieldDispatchNode(this.getContext(), block, this);
        this.replace(dispatch);
        return dispatch.dispatchWithModifiedSelf(frame, block, self2, argumentsObjects);
    }
}

