/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.joda.time.DateTime;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.nodes.rubinius.RubyTimeToDateTimeNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubyTime;
import org.jruby.truffle.runtime.core.TimeOperations;
import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormatter;

public abstract class TimePrimitiveNodes {

    @RubiniusPrimitive(name="time_utc_offset")
    public static abstract class TimeUTCOffsetPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeUTCOffsetPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeUTCOffsetPrimitiveNode(TimeUTCOffsetPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object timeUTCOffset(RubyTime time) {
            throw new UnsupportedOperationException("time_utc_offset");
        }
    }

    @RubiniusPrimitive(name="time_env_zone")
    public static abstract class TimeEnvZonePrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeEnvZonePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeEnvZonePrimitiveNode(TimeEnvZonePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object timeEnvZone(RubyTime time) {
            throw new UnsupportedOperationException("time_env_zone");
        }
    }

    @RubiniusPrimitive(name="time_set_nseconds")
    public static abstract class TimeSetNSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSetNSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeSetNSecondsPrimitiveNode(TimeSetNSecondsPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public long timeSetNSeconds(RubyTime time, long nanoseconds) {
            time.setNanoseconds(nanoseconds);
            return nanoseconds;
        }
    }

    @RubiniusPrimitive(name="time_nseconds")
    public static abstract class TimeNSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeNSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeNSecondsPrimitiveNode(TimeNSecondsPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public long timeNSeconds(RubyTime time) {
            return time.getNanoseconds();
        }
    }

    @RubiniusPrimitive(name="time_s_from_array", needsSelf=false)
    public static abstract class TimeSFromArrayPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSFromArrayPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeSFromArrayPrimitiveNode(TimeSFromArrayPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyTime timeSFromArray(Object sec2, Object min2, Object hour2, Object mday2, Object month2, Object year2, Object nsec2, Object isdst2, Object fromgmt, Object utcoffset) {
            throw new UnsupportedOperationException("time_s_from_array");
        }
    }

    @RubiniusPrimitive(name="time_strftime")
    public static abstract class TimeStrftimePrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private RubyTimeToDateTimeNode toDateTimeNode;

        public TimeStrftimePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toDateTimeNode = new RubyTimeToDateTimeNode(context, sourceSection);
        }

        public TimeStrftimePrimitiveNode(TimeStrftimePrimitiveNode prev) {
            super(prev);
            this.toDateTimeNode = prev.toDateTimeNode;
        }

        @Specialization
        public RubyString timeStrftime(VirtualFrame frame, RubyTime time, RubyString format) {
            return this.getContext().makeString(this.format(this.toDateTimeNode.toDateTime(frame, time), time.getNanoseconds(), format.getBytes()));
        }

        @CompilerDirectives.TruffleBoundary
        public ByteList format(DateTime time, long nanoseconds, ByteList pattern) {
            RubyDateFormatter rdf = this.getContext().getRuntime().getCurrentContext().getRubyDateFormatter();
            return rdf.formatToByteList(rdf.compilePattern(pattern, false), time, nanoseconds, null);
        }
    }

    @RubiniusPrimitive(name="time_decompose")
    public static abstract class TimeDecomposePrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private RubyTimeToDateTimeNode toDateTimeNode;

        public TimeDecomposePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toDateTimeNode = new RubyTimeToDateTimeNode(context, sourceSection);
        }

        public TimeDecomposePrimitiveNode(TimeDecomposePrimitiveNode prev) {
            super(prev);
            this.toDateTimeNode = prev.toDateTimeNode;
        }

        @Specialization
        public RubyArray timeDecompose(VirtualFrame frame, RubyTime time) {
            DateTime dateTime = this.toDateTimeNode.toDateTime(frame, time);
            Object[] decomposed = this.decompose(dateTime);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), decomposed, decomposed.length);
        }

        @CompilerDirectives.TruffleBoundary
        public Object[] decompose(DateTime dateTime) {
            int sec2 = dateTime.getSecondOfMinute();
            int min2 = dateTime.getMinuteOfDay();
            int hour2 = dateTime.getHourOfDay();
            int day = dateTime.getDayOfMonth();
            int month2 = dateTime.getMonthOfYear();
            int year2 = dateTime.getYear();
            int wday2 = dateTime.getDayOfWeek();
            int yday2 = dateTime.getDayOfYear();
            RubyNilClass isdst2 = this.getContext().getCoreLibrary().getNilObject();
            RubyNilClass zone2 = this.getContext().getCoreLibrary().getNilObject();
            return new Object[]{sec2, min2, hour2, day, month2, year2, wday2, yday2, isdst2, zone2};
        }
    }

    @RubiniusPrimitive(name="time_useconds")
    public static abstract class TimeUSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeUSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeUSecondsPrimitiveNode(TimeUSecondsPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public long timeUSeconds(RubyTime time) {
            return time.getNanoseconds();
        }
    }

    @RubiniusPrimitive(name="time_seconds")
    public static abstract class TimeSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeSecondsPrimitiveNode(TimeSecondsPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public long timeSeconds(RubyTime time) {
            return time.getSeconds();
        }
    }

    @RubiniusPrimitive(name="time_s_specific", needsSelf=false)
    public static abstract class TimeSSpecificPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeIsGMTNode = new WriteHeadObjectFieldNode("@is_gmt");
        @Node.Child
        private WriteHeadObjectFieldNode writeOffsetNode = new WriteHeadObjectFieldNode("@offset");

        public TimeSSpecificPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeSSpecificPrimitiveNode(TimeSSpecificPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyTime timeSSpecific(int seconds, int nanoseconds, Object isGMT, Object offset2) {
            return this.timeSSpecific((long)seconds, (long)nanoseconds, isGMT, offset2);
        }

        @Specialization
        public RubyTime timeSSpecific(long seconds, int nanoseconds, Object isGMT, Object offset2) {
            return this.timeSSpecific(seconds, (long)nanoseconds, isGMT, offset2);
        }

        @Specialization
        public RubyTime timeSSpecific(int seconds, long nanoseconds, Object isGMT, Object offset2) {
            return this.timeSSpecific((long)seconds, nanoseconds, isGMT, offset2);
        }

        @Specialization
        public RubyTime timeSSpecific(long seconds, long nanoseconds, Object isGMT, Object offset2) {
            RubyTime time = new RubyTime(this.getContext().getCoreLibrary().getTimeClass(), seconds, nanoseconds);
            this.writeIsGMTNode.execute((RubyBasicObject)time, isGMT);
            this.writeOffsetNode.execute((RubyBasicObject)time, offset2);
            return time;
        }
    }

    @RubiniusPrimitive(name="time_s_dup", needsSelf=false)
    public static abstract class TimeSDupPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadHeadObjectFieldNode readIsGMTNode = new ReadHeadObjectFieldNode("@is_gmt");
        @Node.Child
        private ReadHeadObjectFieldNode readOffsetNode = new ReadHeadObjectFieldNode("@offset");
        @Node.Child
        private WriteHeadObjectFieldNode writeIsGMTNode = new WriteHeadObjectFieldNode("@is_gmt");
        @Node.Child
        private WriteHeadObjectFieldNode writeOffsetNode = new WriteHeadObjectFieldNode("@offset");

        public TimeSDupPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeSDupPrimitiveNode(TimeSDupPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyTime timeSDup(RubyTime other) {
            RubyTime time = new RubyTime(this.getContext().getCoreLibrary().getTimeClass(), other.getSeconds(), other.getNanoseconds());
            this.writeIsGMTNode.execute((RubyBasicObject)time, this.readIsGMTNode.execute(other));
            this.writeOffsetNode.execute((RubyBasicObject)time, this.readOffsetNode.execute(other));
            return time;
        }
    }

    @RubiniusPrimitive(name="time_s_now")
    public static abstract class TimeSNowPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSNowPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TimeSNowPrimitiveNode(TimeSNowPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyTime timeSNow(RubyClass timeClass) {
            long milliseconds = System.currentTimeMillis();
            return new RubyTime(timeClass, TimeOperations.millisecondsToSeconds(milliseconds), TimeOperations.millisecondsToNanoseconds(TimeOperations.millisecondsInCurrentSecond(milliseconds)));
        }
    }
}

