/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;

@NodeChild(value="object", type=RubyNode.class)
public abstract class SingletonClassNode
extends RubyNode {
    public SingletonClassNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public SingletonClassNode(SingletonClassNode prev) {
        super(prev);
    }

    public abstract RubyClass executeSingletonClass(VirtualFrame var1, Object var2);

    @Specialization(guards={"isTrue"})
    protected RubyClass singletonClassTrue(boolean value2) {
        return this.getContext().getCoreLibrary().getTrueClass();
    }

    @Specialization(guards={"!isTrue"})
    protected RubyClass singletonClassFalse(boolean value2) {
        return this.getContext().getCoreLibrary().getFalseClass();
    }

    @Specialization
    protected RubyClass singletonClass(int value2) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantDefineSingleton(this));
    }

    @Specialization
    protected RubyClass singletonClass(long value2) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantDefineSingleton(this));
    }

    @Specialization
    protected RubyClass singletonClass(double value2) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantDefineSingleton(this));
    }

    @Specialization
    protected RubyClass singletonClass(RubyBasicObject object) {
        return object.getSingletonClass(this);
    }
}

