/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.locals;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.ReadNode;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.locals.FrameSlotNode;
import org.jruby.truffle.nodes.methods.locals.ReadLocalVariableNode;
import org.jruby.truffle.nodes.methods.locals.WriteLevelVariableNodeFactory;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.translator.BodyTranslator;

public abstract class ReadLevelVariableNode
extends FrameSlotNode
implements ReadNode {
    private final int varLevel;

    public ReadLevelVariableNode(RubyContext context, SourceSection sourceSection, FrameSlot slot, int level2) {
        super(context, sourceSection, slot);
        this.varLevel = level2;
    }

    public ReadLevelVariableNode(ReadLevelVariableNode prev) {
        this(prev.getContext(), prev.getSourceSection(), prev.frameSlot, prev.varLevel);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public boolean doBoolean(VirtualFrame frame) throws FrameSlotTypeException {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.varLevel);
        return this.getBoolean((Frame)levelFrame);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public int doFixnum(VirtualFrame frame) throws FrameSlotTypeException {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.varLevel);
        return this.getFixnum((Frame)levelFrame);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public long doLongFixnum(VirtualFrame frame) throws FrameSlotTypeException {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.varLevel);
        return this.getLongFixnum((Frame)levelFrame);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public double doFloat(VirtualFrame frame) throws FrameSlotTypeException {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.varLevel);
        return this.getFloat((Frame)levelFrame);
    }

    @Specialization
    public Object doObject(VirtualFrame frame) {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.varLevel);
        return this.getObject((Frame)levelFrame);
    }

    @Override
    public RubyNode makeWriteNode(RubyNode rhs) {
        return WriteLevelVariableNodeFactory.create(this.getContext(), this.getSourceSection(), this.frameSlot, this.varLevel, rhs);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        if (BodyTranslator.FRAME_LOCAL_GLOBAL_VARIABLES.contains(this.frameSlot.getIdentifier())) {
            if (ReadLocalVariableNode.ALWAYS_DEFINED_GLOBALS.contains(this.frameSlot.getIdentifier()) || this.doObject(frame) != this.getContext().getCoreLibrary().getNilObject()) {
                return this.getContext().makeString("global-variable");
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return this.getContext().makeString("local-variable");
    }
}

