/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class AddMethodNode
extends RubyNode {
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private MethodDefinitionNode methodNode;

    public AddMethodNode(RubyContext context, SourceSection section, RubyNode receiver2, MethodDefinitionNode method) {
        super(context, section);
        this.receiver = receiver2;
        this.methodNode = method;
    }

    @Override
    public RubySymbol execute(VirtualFrame frame) {
        AddMethodNode.notDesignedForCompilation();
        Object receiverObject = this.receiver.execute(frame);
        InternalMethod methodObject = (InternalMethod)this.methodNode.execute(frame);
        RubyModule module = receiverObject instanceof RubyModule ? (RubyModule)receiverObject : ((RubyBasicObject)receiverObject).getSingletonClass(this);
        Visibility visibility = this.getVisibility(frame, methodObject.getName());
        InternalMethod method = methodObject.withDeclaringModule(module).withVisibility(visibility);
        if (method.getVisibility() == Visibility.MODULE_FUNCTION) {
            module.addMethod(this, method.withVisibility(Visibility.PRIVATE));
            module.getSingletonClass(this).addMethod(this, method.withVisibility(Visibility.PUBLIC));
        } else {
            module.addMethod(this, method);
        }
        return this.getContext().newSymbol(method.getName());
    }

    private Visibility getVisibility(VirtualFrame frame, String name2) {
        AddMethodNode.notDesignedForCompilation();
        if (name2.equals("initialize") || name2.equals("initialize_copy") || name2.equals("initialize_clone") || name2.equals("initialize_dup") || name2.equals("respond_to_missing?")) {
            return Visibility.PRIVATE;
        }
        Visibility currentFrameVisibility = AddMethodNode.findVisibility((Frame)frame);
        if (currentFrameVisibility != null) {
            return currentFrameVisibility;
        }
        return (Visibility)((Object)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Visibility>(){

            public Visibility visitFrame(FrameInstance frameInstance) {
                Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
                return AddMethodNode.findVisibility(frame);
            }
        }));
    }

    private static Visibility findVisibility(Frame frame) {
        FrameSlot slot = frame.getFrameDescriptor().findFrameSlot(RubyModule.VISIBILITY_FRAME_SLOT_ID);
        if (slot == null) {
            return null;
        }
        Object visibilityObject = frame.getValue(slot);
        if (visibilityObject instanceof Visibility) {
            return (Visibility)((Object)visibilityObject);
        }
        return Visibility.PUBLIC;
    }
}

