/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.nodes.dispatch.CachedBooleanDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedMethodMissingDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedReturnMissingDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedSymbolDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedUnboxedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.dispatch.UncachedDispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.util.cli.Options;

public final class UnresolvedDispatchNode
extends DispatchNode {
    private int depth = 0;
    private final boolean ignoreVisibility;
    private final boolean indirect;
    private final MissingBehavior missingBehavior;

    public UnresolvedDispatchNode(RubyContext context, boolean ignoreVisibility, boolean indirect, MissingBehavior missingBehavior, DispatchAction dispatchAction) {
        super(context, dispatchAction);
        this.ignoreVisibility = ignoreVisibility;
        this.indirect = indirect;
        this.missingBehavior = missingBehavior;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (this.depth == (Integer)Options.TRUFFLE_DISPATCH_POLYMORPHIC_MAX.load()) {
            return ((UncachedDispatchNode)this.getHeadNode().getFirstDispatchNode().replace(new UncachedDispatchNode(this.getContext(), this.ignoreVisibility, this.getDispatchAction()))).executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        ++this.depth;
        DispatchNode first2 = this.getHeadNode().getFirstDispatchNode();
        if (this.isRubyBasicObject(receiverObject)) {
            return this.doRubyBasicObject(frame, first2, receiverObject, methodName, blockObject, argumentsObjects);
        }
        return this.doUnboxedObject(frame, first2, receiverObject, methodName, blockObject, argumentsObjects);
    }

    private Object doUnboxedObject(VirtualFrame frame, DispatchNode first2, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        DispatchAction dispatchAction = this.getDispatchAction();
        RubyClass callerClass = this.ignoreVisibility ? null : this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(frame.getArguments()));
        if (dispatchAction == DispatchAction.CALL_METHOD || dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
            InternalMethod method = this.lookup(callerClass, receiverObject, methodName.toString(), this.ignoreVisibility);
            if (method == null) {
                DispatchNode newDispatch = this.createMethodMissingNode(methodName, receiverObject);
                return newDispatch.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
            }
            if (receiverObject instanceof Boolean) {
                Assumption falseUnmodifiedAssumption = this.getContext().getCoreLibrary().getFalseClass().getUnmodifiedAssumption();
                InternalMethod falseMethod = this.lookup(callerClass, false, methodName.toString(), this.ignoreVisibility);
                Assumption trueUnmodifiedAssumption = this.getContext().getCoreLibrary().getTrueClass().getUnmodifiedAssumption();
                InternalMethod trueMethod = this.lookup(callerClass, true, methodName.toString(), this.ignoreVisibility);
                if (falseMethod == null && trueMethod == null) {
                    throw new UnsupportedOperationException();
                }
                CachedBooleanDispatchNode newDispatch = new CachedBooleanDispatchNode(this.getContext(), methodName, first2, falseUnmodifiedAssumption, null, falseMethod, trueUnmodifiedAssumption, null, trueMethod, this.indirect, this.getDispatchAction());
                first2.replace(newDispatch);
                return newDispatch.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
            }
            CachedUnboxedDispatchNode newDispatch = new CachedUnboxedDispatchNode(this.getContext(), methodName, first2, receiverObject.getClass(), this.getContext().getCoreLibrary().getLogicalClass(receiverObject).getUnmodifiedAssumption(), null, method, this.indirect, this.getDispatchAction());
            first2.replace(newDispatch);
            return newDispatch.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        throw new UnsupportedOperationException();
    }

    private Object doRubyBasicObject(VirtualFrame frame, DispatchNode first2, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        RubyClass callerClass;
        DispatchAction dispatchAction = this.getDispatchAction();
        RubyClass rubyClass = callerClass = this.ignoreVisibility ? null : this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(frame.getArguments()));
        if (dispatchAction == DispatchAction.CALL_METHOD || dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
            InternalMethod method = this.lookup(callerClass, receiverObject, methodName.toString(), this.ignoreVisibility);
            if (method == null) {
                DispatchNode newDispatch = this.createMethodMissingNode(methodName, receiverObject);
                return newDispatch.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
            }
            CachedDispatchNode newDispatch = receiverObject instanceof RubySymbol ? new CachedBoxedSymbolDispatchNode(this.getContext(), methodName, first2, null, method, this.indirect, this.getDispatchAction()) : new CachedBoxedDispatchNode(this.getContext(), methodName, first2, this.getContext().getCoreLibrary().getMetaClass(receiverObject), null, method, this.indirect, this.getDispatchAction());
            first2.replace(newDispatch);
            return newDispatch.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        if (dispatchAction == DispatchAction.READ_CONSTANT) {
            RubyModule module = (RubyModule)receiverObject;
            RubyConstant constant = this.lookupConstant(module, methodName.toString(), this.ignoreVisibility);
            if (constant == null) {
                DispatchNode newDispatch = this.createConstantMissingNode(methodName, callerClass, module);
                return newDispatch.executeDispatch(frame, module, methodName, blockObject, argumentsObjects);
            }
            CachedBoxedDispatchNode newDispatch = new CachedBoxedDispatchNode(this.getContext(), methodName, first2, module.getSingletonClass(null), module.getUnmodifiedAssumption(), constant.getValue(), null, this.indirect, this.getDispatchAction());
            first2.replace(newDispatch);
            return ((DispatchNode)newDispatch).executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        throw new UnsupportedOperationException();
    }

    private DispatchNode createConstantMissingNode(Object methodName, RubyClass callerClass, RubyBasicObject receiverObject) {
        DispatchNode first2 = this.getHeadNode().getFirstDispatchNode();
        switch (this.missingBehavior) {
            case RETURN_MISSING: {
                return (DispatchNode)first2.replace(new CachedBoxedReturnMissingDispatchNode(this.getContext(), methodName, first2, receiverObject.getMetaClass(), this.indirect, this.getDispatchAction()));
            }
            case CALL_CONST_MISSING: {
                InternalMethod method = this.lookup(callerClass, receiverObject, "const_missing", this.ignoreVisibility);
                if (method == null) {
                    throw new RaiseException(this.getContext().getCoreLibrary().runtimeError(receiverObject.toString() + " didn't have a #const_missing", this));
                }
                if (((Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED.load()).booleanValue()) {
                    return (DispatchNode)first2.replace(new UncachedDispatchNode(this.getContext(), this.ignoreVisibility, this.getDispatchAction()));
                }
                return (DispatchNode)first2.replace(new CachedBoxedMethodMissingDispatchNode(this.getContext(), methodName, first2, receiverObject.getMetaClass(), method, (Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT.load(), this.getDispatchAction()));
            }
        }
        throw new UnsupportedOperationException(this.missingBehavior.toString());
    }

    private DispatchNode createMethodMissingNode(Object methodName, Object receiverObject) {
        DispatchNode first2 = this.getHeadNode().getFirstDispatchNode();
        switch (this.missingBehavior) {
            case RETURN_MISSING: {
                return (DispatchNode)first2.replace(new CachedBoxedReturnMissingDispatchNode(this.getContext(), methodName, first2, this.getContext().getCoreLibrary().getMetaClass(receiverObject), this.indirect, this.getDispatchAction()));
            }
            case CALL_METHOD_MISSING: {
                InternalMethod method = this.lookup(null, receiverObject, "method_missing", true);
                if (method == null) {
                    throw new RaiseException(this.getContext().getCoreLibrary().runtimeError(receiverObject.toString() + " didn't have a #method_missing", this));
                }
                if (((Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED.load()).booleanValue()) {
                    return (DispatchNode)first2.replace(new UncachedDispatchNode(this.getContext(), this.ignoreVisibility, this.getDispatchAction()));
                }
                return (DispatchNode)first2.replace(new CachedBoxedMethodMissingDispatchNode(this.getContext(), methodName, first2, this.getContext().getCoreLibrary().getMetaClass(receiverObject), method, (Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT.load(), this.getDispatchAction()));
            }
        }
        throw new UnsupportedOperationException(this.missingBehavior.toString());
    }
}

