/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.util.cli.Options;

public class CachedBoxedMethodMissingDispatchNode
extends CachedDispatchNode {
    private final RubyClass expectedClass;
    private final Assumption unmodifiedAssumption;
    private final InternalMethod method;
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private IndirectCallNode indirectCallNode;

    public CachedBoxedMethodMissingDispatchNode(RubyContext context, Object cachedName, DispatchNode next2, RubyClass expectedClass, InternalMethod method, boolean indirect, DispatchAction dispatchAction) {
        super(context, cachedName, next2, indirect, dispatchAction);
        this.expectedClass = expectedClass;
        this.unmodifiedAssumption = expectedClass.getUnmodifiedAssumption();
        this.method = method;
        if (indirect) {
            this.indirectCallNode = Truffle.getRuntime().createIndirectCallNode();
        } else {
            this.callNode = Truffle.getRuntime().createDirectCallNode(method.getCallTarget());
            if (this.callNode.isCallTargetCloningAllowed() && (((Boolean)Options.TRUFFLE_DISPATCH_METHODMISSING_ALWAYS_CLONED.load()).booleanValue() || method.getSharedMethodInfo().shouldAlwaysSplit())) {
                this.insert((Node)this.callNode);
                this.callNode.cloneCallTarget();
            }
            if (this.callNode.isInlinable() && ((Boolean)Options.TRUFFLE_DISPATCH_METHODMISSING_ALWAYS_INLINED.load()).booleanValue()) {
                this.insert((Node)this.callNode);
                this.callNode.forceInlining();
            }
        }
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        if (!this.guardName(methodName) || !(receiverObject instanceof RubyBasicObject) || ((RubyBasicObject)receiverObject).getMetaClass() != this.expectedClass) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        try {
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, (RubyProc)CompilerDirectives.unsafeCast((Object)blockObject, RubyProc.class, (boolean)true, (boolean)false), argumentsObjects, "class modified");
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                Object[] argumentsObjectsArray = (Object[])CompilerDirectives.unsafeCast((Object)argumentsObjects, Object[].class, (boolean)true);
                Object[] modifiedArgumentsObjects = new Object[1 + argumentsObjectsArray.length];
                modifiedArgumentsObjects[0] = this.getCachedNameAsSymbol();
                RubyArguments.arraycopy(argumentsObjectsArray, 0, modifiedArgumentsObjects, 1, argumentsObjectsArray.length);
                if (this.isIndirect()) {
                    return this.indirectCallNode.call(frame, this.method.getCallTarget(), RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, (RubyProc)CompilerDirectives.unsafeCast((Object)blockObject, RubyProc.class, (boolean)true, (boolean)false), modifiedArgumentsObjects));
                }
                return this.callNode.call(frame, RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, (RubyProc)CompilerDirectives.unsafeCast((Object)blockObject, RubyProc.class, (boolean)true, (boolean)false), modifiedArgumentsObjects));
            }
            case RESPOND_TO_METHOD: {
                return false;
            }
            case READ_CONSTANT: {
                if (this.isIndirect()) {
                    return this.indirectCallNode.call(frame, this.method.getCallTarget(), RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, (RubyProc)CompilerDirectives.unsafeCast((Object)blockObject, RubyProc.class, (boolean)true, (boolean)false), new Object[]{this.getCachedNameAsSymbol()}));
                }
                return this.callNode.call(frame, RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, (RubyProc)CompilerDirectives.unsafeCast((Object)blockObject, RubyProc.class, (boolean)true, (boolean)false), new Object[]{this.getCachedNameAsSymbol()}));
            }
        }
        throw new UnsupportedOperationException();
    }
}

