/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.joni.Matcher;
import org.joni.Region;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayCoreMethodNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.RegexpNodes;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.StringFormatter;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.StringSupport;

@CoreClass(name="String")
public abstract class StringNodes {

    static class StringNodesHelper {
        StringNodesHelper() {
        }

        public static ByteList capitalize(org.jruby.truffle.runtime.core.RubyString string2) {
            String javaString = string2.toString();
            String head = javaString.substring(0, 1).toUpperCase(Locale.ENGLISH);
            String tail = javaString.substring(1, javaString.length()).toLowerCase(Locale.ENGLISH);
            ByteList byteListString = ByteList.create((CharSequence)(head + tail));
            byteListString.setEncoding(string2.getBytes().getEncoding());
            return byteListString;
        }

        public static ByteList upcase(org.jruby.truffle.runtime.core.RubyString string2) {
            ByteList byteListString = ByteList.create((CharSequence)string2.toString().toUpperCase(Locale.ENGLISH));
            byteListString.setEncoding(string2.getBytes().getEncoding());
            return byteListString;
        }

        public static ByteList downcase(org.jruby.truffle.runtime.core.RubyString string2) {
            ByteList newByteList = ByteList.create((CharSequence)string2.toString().toLowerCase(Locale.ENGLISH));
            newByteList.setEncoding(string2.getBytes().getEncoding());
            return newByteList;
        }

        public static ByteList chomp(org.jruby.truffle.runtime.core.RubyString string2) {
            String javaString = string2.toString();
            if (javaString.endsWith("\r")) {
                String newString = javaString.substring(0, javaString.length() - 1);
                ByteList byteListString = ByteList.create((CharSequence)newString);
                byteListString.setEncoding(string2.getBytes().getEncoding());
                return byteListString;
            }
            ByteList byteListString = ByteList.create((CharSequence)javaString.trim());
            byteListString.setEncoding(string2.getBytes().getEncoding());
            return byteListString;
        }

        public static ByteList chompWithString(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString stringToChomp) {
            String tempString = string2.toString();
            if (tempString.endsWith(stringToChomp.toString())) {
                tempString = tempString.substring(0, tempString.length() - stringToChomp.toString().length());
            }
            ByteList byteList = ByteList.create((CharSequence)tempString);
            byteList.setEncoding(string2.getBytes().getEncoding());
            return byteList;
        }

        public static ByteList reverse(org.jruby.truffle.runtime.core.RubyString string2) {
            ByteList byteListString = ByteList.create((CharSequence)new StringBuilder(string2.toString()).reverse().toString());
            byteListString.setEncoding(string2.getBytes().getEncoding());
            return byteListString;
        }
    }

    @CoreMethod(names={"chr"})
    public static abstract class ChrNode
    extends CoreMethodNode {
        public ChrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ChrNode(ChrNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString chr(org.jruby.truffle.runtime.core.RubyString string2) {
            ChrNode.notDesignedForCompilation();
            if (string2.toString().isEmpty()) {
                return string2;
            }
            String head = string2.toString().substring(0, 1);
            ByteList byteString = ByteList.create((CharSequence)head);
            byteString.setEncoding(string2.getBytes().getEncoding());
            return string2.getContext().makeString(byteString);
        }
    }

    @CoreMethod(names={"clear"})
    public static abstract class ClearNode
    extends CoreMethodNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClearNode(ClearNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString clear(org.jruby.truffle.runtime.core.RubyString string2) {
            ClearNode.notDesignedForCompilation();
            ByteList empty2 = ByteList.EMPTY_BYTELIST;
            empty2.setEncoding(string2.getBytes().getEncoding());
            string2.set(empty2);
            return string2;
        }
    }

    @CoreMethod(names={"capitalize"})
    public static abstract class CapitalizeNode
    extends CoreMethodNode {
        public CapitalizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CapitalizeNode(CapitalizeNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString capitalize(org.jruby.truffle.runtime.core.RubyString string2) {
            CapitalizeNode.notDesignedForCompilation();
            String javaString = string2.toString();
            if (javaString.isEmpty()) {
                return string2;
            }
            ByteList byteListString = StringNodesHelper.capitalize(string2);
            return string2.getContext().makeString(byteListString);
        }
    }

    @CoreMethod(names={"capitalize!"})
    public static abstract class CapitalizeBangNode
    extends CoreMethodNode {
        public CapitalizeBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CapitalizeBangNode(CapitalizeBangNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString capitalizeBang(org.jruby.truffle.runtime.core.RubyString string2) {
            CapitalizeBangNode.notDesignedForCompilation();
            String javaString = string2.toString();
            if (javaString.isEmpty()) {
                return string2;
            }
            ByteList byteListString = StringNodesHelper.capitalize(string2);
            string2.set(byteListString);
            return string2;
        }
    }

    @CoreMethod(names={"upcase!"})
    public static abstract class UpcaseBangNode
    extends CoreMethodNode {
        public UpcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UpcaseBangNode(UpcaseBangNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString upcaseBang(org.jruby.truffle.runtime.core.RubyString string2) {
            UpcaseBangNode.notDesignedForCompilation();
            ByteList byteListString = StringNodesHelper.upcase(string2);
            string2.set(byteListString);
            return string2;
        }
    }

    @CoreMethod(names={"upcase"})
    public static abstract class UpcaseNode
    extends CoreMethodNode {
        public UpcaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UpcaseNode(UpcaseNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString upcase(org.jruby.truffle.runtime.core.RubyString string2) {
            UpcaseNode.notDesignedForCompilation();
            ByteList byteListString = StringNodesHelper.upcase(string2);
            return string2.getContext().makeString(byteListString);
        }
    }

    @CoreMethod(names={"unpack"}, required=1)
    public static abstract class UnpackNode
    extends ArrayCoreMethodNode {
        public UnpackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UnpackNode(UnpackNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray unpack(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString format) {
            RubyArray jrubyArray = Pack.unpack(this.getContext().getRuntime(), string2.getBytes(), format.getBytes());
            return org.jruby.truffle.runtime.core.RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), jrubyArray.toArray());
        }
    }

    @CoreMethod(names={"reverse!"})
    public static abstract class ReverseBangNode
    extends CoreMethodNode {
        public ReverseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReverseBangNode(ReverseBangNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString reverse(org.jruby.truffle.runtime.core.RubyString string2) {
            ReverseBangNode.notDesignedForCompilation();
            string2.set(StringNodesHelper.reverse(string2));
            return string2;
        }
    }

    @CoreMethod(names={"reverse"})
    public static abstract class ReverseNode
    extends CoreMethodNode {
        public ReverseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReverseNode(ReverseNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString reverse(org.jruby.truffle.runtime.core.RubyString string2) {
            ReverseNode.notDesignedForCompilation();
            return org.jruby.truffle.runtime.core.RubyString.fromByteList(string2.getLogicalClass(), StringNodesHelper.reverse(string2));
        }
    }

    @CoreMethod(names={"to_sym", "intern"})
    public static abstract class ToSymNode
    extends CoreMethodNode {
        public ToSymNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSymNode(ToSymNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol toSym(org.jruby.truffle.runtime.core.RubyString string2) {
            ToSymNode.notDesignedForCompilation();
            return this.getContext().newSymbol(string2.toString());
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString toS(org.jruby.truffle.runtime.core.RubyString string2) {
            return string2;
        }
    }

    @CoreMethod(names={"to_i"})
    public static abstract class ToINode
    extends CoreMethodNode {
        public ToINode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToINode(ToINode prev) {
            super(prev);
        }

        @Specialization
        public Object toI(org.jruby.truffle.runtime.core.RubyString string2) {
            ToINode.notDesignedForCompilation();
            if (string2.toString().length() == 0) {
                return 0;
            }
            try {
                return Integer.parseInt(string2.toString());
            }
            catch (NumberFormatException e) {
                return this.bignum(new BigInteger(string2.toString()));
            }
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToFNode(ToFNode prev) {
            super(prev);
        }

        @Specialization
        public double toF(org.jruby.truffle.runtime.core.RubyString string2) {
            try {
                return Double.parseDouble(string2.toString());
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
    }

    @CoreMethod(names={"sum"})
    public static abstract class SumNode
    extends CoreMethodNode {
        public SumNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SumNode(SumNode prev) {
            super(prev);
        }

        @Specialization
        public int sum(org.jruby.truffle.runtime.core.RubyString string2) {
            SumNode.notDesignedForCompilation();
            return (Integer)this.getContext().toTruffle(this.getContext().toJRuby(string2).sum(this.getContext().getRuntime().getCurrentContext()));
        }
    }

    @CoreMethod(names={"succ!"})
    public static abstract class SuccBangNode
    extends CoreMethodNode {
        public SuccBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SuccBangNode(SuccBangNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString succBang(org.jruby.truffle.runtime.core.RubyString string2) {
            SuccBangNode.notDesignedForCompilation();
            if (string2.isFrozen()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().frozenError("String", this));
            }
            if (string2.length() > 0) {
                string2.set(StringSupport.succCommon(string2.getBytes()));
            }
            return string2;
        }
    }

    @CoreMethod(names={"succ"})
    public static abstract class SuccNode
    extends CoreMethodNode {
        public SuccNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SuccNode(SuccNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString succ(org.jruby.truffle.runtime.core.RubyString string2) {
            SuccNode.notDesignedForCompilation();
            if (string2.length() > 0) {
                return this.getContext().makeString(StringSupport.succCommon(string2.getBytes()));
            }
            return this.getContext().makeString("");
        }
    }

    @CoreMethod(names={"sub"}, required=2)
    public static abstract class SubNode
    extends RegexpNodes.EscapingNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SubNode(SubNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString sub(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString regexpString, org.jruby.truffle.runtime.core.RubyString replacement2) {
            SubNode.notDesignedForCompilation();
            RubyRegexp regexp2 = new RubyRegexp(this, this.getContext().getCoreLibrary().getRegexpClass(), this.escape(frame, regexpString).getBytes(), 0);
            return this.sub(string2, regexp2, replacement2);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString sub(org.jruby.truffle.runtime.core.RubyString string2, RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString replacement2) {
            SubNode.notDesignedForCompilation();
            return regexp2.sub(string2.toString(), replacement2.toString());
        }
    }

    @CoreMethod(names={"start_with?"}, required=1)
    public static abstract class StartWithNode
    extends CoreMethodNode {
        public StartWithNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StartWithNode(StartWithNode prev) {
            super(prev);
        }

        @Specialization
        public boolean endWith(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString b2) {
            StartWithNode.notDesignedForCompilation();
            return string2.toString().startsWith(b2.toString());
        }
    }

    @CoreMethod(names={"split"}, optional=1)
    public static abstract class SplitNode
    extends CoreMethodNode {
        public SplitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SplitNode(SplitNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray split(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString sep) {
            SplitNode.notDesignedForCompilation();
            return this.splitHelper(string2, sep.toString());
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray split(org.jruby.truffle.runtime.core.RubyString string2, RubyRegexp sep) {
            SplitNode.notDesignedForCompilation();
            return org.jruby.truffle.runtime.core.RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), sep.split(string2.toString()));
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray split(org.jruby.truffle.runtime.core.RubyString string2, UndefinedPlaceholder sep) {
            SplitNode.notDesignedForCompilation();
            return this.splitHelper(string2, " ");
        }

        private org.jruby.truffle.runtime.core.RubyArray splitHelper(org.jruby.truffle.runtime.core.RubyString string2, String sep) {
            String[] components = string2.toString().split(Pattern.quote(sep));
            Object[] objects = new Object[components.length];
            for (int n = 0; n < objects.length; ++n) {
                objects[n] = this.getContext().makeString(components[n]);
            }
            return org.jruby.truffle.runtime.core.RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), objects);
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends CoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        @Specialization
        public int size(org.jruby.truffle.runtime.core.RubyString string2) {
            return string2.length();
        }
    }

    @CoreMethod(names={"setbyte"}, required=2)
    public static abstract class SetByteNode
    extends CoreMethodNode {
        public SetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SetByteNode(SetByteNode prev) {
            super(prev);
        }

        @Specialization
        public Object setByte(org.jruby.truffle.runtime.core.RubyString string2, int index2, Object value2) {
            SetByteNode.notDesignedForCompilation();
            throw new UnsupportedOperationException("getbyte not implemented");
        }
    }

    @CoreMethod(names={"scan"}, required=1, needsBlock=true)
    public static abstract class ScanNode
    extends YieldingCoreMethodNode {
        public ScanNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ScanNode(ScanNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray scan(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString regexpString, UndefinedPlaceholder block) {
            ScanNode.notDesignedForCompilation();
            RubyRegexp regexp2 = new RubyRegexp(this, this.getContext().getCoreLibrary().getRegexpClass(), regexpString.getBytes(), 0);
            return this.scan(string2, regexp2, block);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString scan(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString regexpString, RubyProc block) {
            ScanNode.notDesignedForCompilation();
            RubyRegexp regexp2 = new RubyRegexp(this, this.getContext().getCoreLibrary().getRegexpClass(), regexpString.getBytes(), 0);
            return this.scan(frame, string2, regexp2, block);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray scan(org.jruby.truffle.runtime.core.RubyString string2, RubyRegexp regexp2, UndefinedPlaceholder block) {
            ScanNode.notDesignedForCompilation();
            return org.jruby.truffle.runtime.core.RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), (Object[])regexp2.scan(string2));
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString scan(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2, RubyRegexp regexp2, RubyProc block) {
            ScanNode.notDesignedForCompilation();
            RubyContext context = this.getContext();
            byte[] stringBytes = string2.getBytes().bytes();
            Encoding encoding2 = string2.getBytes().getEncoding();
            Matcher matcher = regexp2.getRegex().matcher(stringBytes);
            int p2 = string2.getBytes().getBegin();
            int end2 = 0;
            int range = p2 + string2.getBytes().getRealSize();
            Object lastGoodMatchData = this.getContext().getCoreLibrary().getNilObject();
            if (regexp2.getRegex().numberOfCaptures() == 0) {
                Object matchData;
                while ((matchData = regexp2.matchCommon(string2.getBytes(), false, true, matcher, p2 + end2, range)) != context.getCoreLibrary().getNilObject()) {
                    RubyMatchData md = (RubyMatchData)matchData;
                    Object[] values2 = md.getValues();
                    assert (values2.length == 1);
                    this.yield(frame, block, values2[0]);
                    lastGoodMatchData = matchData;
                    end2 = StringSupport.positionEndForScan(string2.getBytes(), matcher, encoding2, p2, range);
                }
                regexp2.setThread("$~", lastGoodMatchData);
            } else {
                Object matchData;
                while ((matchData = regexp2.matchCommon(string2.getBytes(), false, true, matcher, p2 + end2, stringBytes.length)) != context.getCoreLibrary().getNilObject()) {
                    Object[] captures2 = ((RubyMatchData)matchData).getCaptures();
                    this.yield(frame, block, new org.jruby.truffle.runtime.core.RubyArray(context.getCoreLibrary().getArrayClass(), captures2, captures2.length));
                    lastGoodMatchData = matchData;
                    end2 = StringSupport.positionEndForScan(string2.getBytes(), matcher, encoding2, p2, range);
                }
                regexp2.setThread("$~", lastGoodMatchData);
            }
            return string2;
        }
    }

    @CoreMethod(names={"dump"})
    public static abstract class DumpNode
    extends CoreMethodNode {
        public DumpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DumpNode(DumpNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString rstrip(org.jruby.truffle.runtime.core.RubyString string2) {
            DumpNode.notDesignedForCompilation();
            return string2.dump();
        }
    }

    @CoreMethod(names={"rstrip"})
    public static abstract class RStripNode
    extends CoreMethodNode {
        public RStripNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RStripNode(RStripNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString rstrip(org.jruby.truffle.runtime.core.RubyString string2) {
            int last2;
            RStripNode.notDesignedForCompilation();
            String str = string2.toString();
            for (last2 = str.length() - 1; last2 >= 0 && " \r\n\t".indexOf(str.charAt(last2)) != -1; --last2) {
            }
            return this.getContext().makeString(str.substring(0, last2 + 1));
        }
    }

    @CoreMethod(names={"rjust"}, required=1, optional=1, lowerFixnumParameters={0})
    public static abstract class RjustNode
    extends CoreMethodNode {
        public RjustNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RjustNode(RjustNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString rjust(org.jruby.truffle.runtime.core.RubyString string2, int length2, UndefinedPlaceholder padding) {
            RjustNode.notDesignedForCompilation();
            return this.getContext().makeString(org.jruby.truffle.runtime.core.RubyString.rjust(string2.toString(), length2, " "));
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString rjust(org.jruby.truffle.runtime.core.RubyString string2, int length2, org.jruby.truffle.runtime.core.RubyString padding) {
            RjustNode.notDesignedForCompilation();
            return this.getContext().makeString(org.jruby.truffle.runtime.core.RubyString.rjust(string2.toString(), length2, padding.toString()));
        }
    }

    @CoreMethod(names={"rindex"}, required=1, optional=1, lowerFixnumParameters={1})
    public static abstract class RindexNode
    extends CoreMethodNode {
        public RindexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RindexNode(RindexNode prev) {
            super(prev);
        }

        @Specialization
        public Object rindex(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString subString, UndefinedPlaceholder endPosition) {
            RindexNode.notDesignedForCompilation();
            return this.rindex(string2, subString, string2.length());
        }

        @Specialization
        public Object rindex(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString subString, int endPosition) {
            int result2;
            RindexNode.notDesignedForCompilation();
            int normalizedEndPosition = endPosition;
            if (endPosition < 0) {
                normalizedEndPosition = endPosition + string2.length();
                if (normalizedEndPosition < 0) {
                    return this.getContext().getCoreLibrary().getNilObject();
                }
            } else if (endPosition > string2.length()) {
                normalizedEndPosition = string2.length();
            }
            if ((result2 = StringSupport.rindex(string2.getBytes(), string2.length(), subString.length(), normalizedEndPosition, subString, string2.getBytes().getEncoding())) >= 0) {
                return result2;
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"ord"})
    public static abstract class OrdNode
    extends CoreMethodNode {
        public OrdNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public OrdNode(OrdNode prev) {
            super(prev);
        }

        @Specialization
        public int ord(org.jruby.truffle.runtime.core.RubyString string2) {
            OrdNode.notDesignedForCompilation();
            return ((RubyFixnum)this.getContext().toJRuby(string2).ord(this.getContext().getRuntime().getCurrentContext())).getIntValue();
        }
    }

    @CoreMethod(names={"match"}, required=1)
    public static abstract class MatchNode
    extends CoreMethodNode {
        public MatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MatchNode(MatchNode prev) {
            super(prev);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString regexpString) {
            MatchNode.notDesignedForCompilation();
            RubyRegexp regexp2 = new RubyRegexp(this, this.getContext().getCoreLibrary().getRegexpClass(), regexpString.getBytes(), 0);
            return regexp2.matchCommon(string2.getBytes(), false, false);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyString string2, RubyRegexp regexp2) {
            return regexp2.matchCommon(string2.getBytes(), false, false);
        }
    }

    @CoreMethod(names={"ljust"}, required=1, optional=1, lowerFixnumParameters={0})
    public static abstract class LjustNode
    extends CoreMethodNode {
        public LjustNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LjustNode(LjustNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString ljust(org.jruby.truffle.runtime.core.RubyString string2, int length2, UndefinedPlaceholder padding) {
            LjustNode.notDesignedForCompilation();
            return this.getContext().makeString(org.jruby.truffle.runtime.core.RubyString.ljust(string2.toString(), length2, " "));
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString ljust(org.jruby.truffle.runtime.core.RubyString string2, int length2, org.jruby.truffle.runtime.core.RubyString padding) {
            LjustNode.notDesignedForCompilation();
            return this.getContext().makeString(org.jruby.truffle.runtime.core.RubyString.ljust(string2.toString(), length2, padding.toString()));
        }
    }

    @CoreMethod(names={"insert"}, required=2, lowerFixnumParameters={0})
    public static abstract class InsertNode
    extends CoreMethodNode {
        @Node.Child
        private ConcatNode concatNode;
        @Node.Child
        private GetIndexNode getIndexNode;

        public InsertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.concatNode = StringNodesFactory.ConcatNodeFactory.create(context, sourceSection, new RubyNode[0]);
            this.getIndexNode = StringNodesFactory.GetIndexNodeFactory.create(context, sourceSection, new RubyNode[0]);
        }

        public InsertNode(InsertNode prev) {
            super(prev);
            this.concatNode = prev.concatNode;
            this.getIndexNode = prev.getIndexNode;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString insert(org.jruby.truffle.runtime.core.RubyString string2, int index2, org.jruby.truffle.runtime.core.RubyString otherString) {
            InsertNode.notDesignedForCompilation();
            if (string2.isFrozen()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().frozenError("String", this));
            }
            if (index2 == -1) {
                this.concatNode.concat(string2, otherString);
                return string2;
            }
            if (index2 < 0) {
                if (-(++index2) > string2.length()) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index2), this));
                }
                index2 += string2.length();
            } else if (index2 > string2.length()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index2), this));
            }
            org.jruby.truffle.runtime.core.RubyString firstPart = (org.jruby.truffle.runtime.core.RubyString)this.getIndexNode.slice(string2, 0, index2);
            org.jruby.truffle.runtime.core.RubyString secondPart = (org.jruby.truffle.runtime.core.RubyString)this.getIndexNode.slice(string2, index2, string2.length());
            org.jruby.truffle.runtime.core.RubyString concatenated = this.concatNode.concat(this.concatNode.concat(firstPart, otherString), secondPart);
            string2.set(concatenated.getBytes());
            return string2;
        }
    }

    @CoreMethod(names={"initialize_copy"}, visibility=Visibility.PRIVATE, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization
        public Object initializeCopy(org.jruby.truffle.runtime.core.RubyString self2, org.jruby.truffle.runtime.core.RubyString from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self2 == from) {
                return self2;
            }
            self2.getBytes().replace(from.getBytes().bytes());
            return self2;
        }
    }

    @CoreMethod(names={"initialize"}, required=1)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString initialize(org.jruby.truffle.runtime.core.RubyString self2, UndefinedPlaceholder from) {
            return self2;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString initialize(org.jruby.truffle.runtime.core.RubyString self2, org.jruby.truffle.runtime.core.RubyString from) {
            InitializeNode.notDesignedForCompilation();
            self2.set(from.getBytes());
            return self2;
        }
    }

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString inspect(org.jruby.truffle.runtime.core.RubyString string2) {
            InspectNode.notDesignedForCompilation();
            RubyString inspected = (RubyString)RubyString.inspect19(this.getContext().getRuntime(), string2.getBytes());
            return this.getContext().makeString(inspected.getByteList());
        }
    }

    @CoreMethod(names={"getbyte"}, required=1)
    public static abstract class GetByteNode
    extends CoreMethodNode {
        public GetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetByteNode(GetByteNode prev) {
            super(prev);
        }

        @Specialization
        public int getByte(org.jruby.truffle.runtime.core.RubyString string2, int index2) {
            return string2.getBytes().get(index2);
        }
    }

    @CoreMethod(names={"gsub"}, required=1, optional=1, needsBlock=true)
    public static abstract class GsubNode
    extends RegexpNodes.EscapingYieldingNode {
        @Node.Child
        private CallDispatchHeadNode toS;

        public GsubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toS = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public GsubNode(GsubNode prev) {
            super(prev);
            this.toS = prev.toS;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString gsub(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString regexpString, org.jruby.truffle.runtime.core.RubyString replacement2, UndefinedPlaceholder block) {
            GsubNode.notDesignedForCompilation();
            RubyRegexp regexp2 = new RubyRegexp(this, this.getContext().getCoreLibrary().getRegexpClass(), this.escape(frame, regexpString).getBytes(), 0);
            return this.gsub(string2, regexp2, replacement2, block);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString gsub(org.jruby.truffle.runtime.core.RubyString string2, RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString replacement2, UndefinedPlaceholder block) {
            GsubNode.notDesignedForCompilation();
            return regexp2.gsub(string2, replacement2.toString());
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString gsub(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString regexpString, org.jruby.truffle.runtime.core.RubyString replacement2, RubyProc block) {
            GsubNode.notDesignedForCompilation();
            RubyRegexp regexp2 = new RubyRegexp(this, this.getContext().getCoreLibrary().getRegexpClass(), this.escape(frame, regexpString).getBytes(), 0);
            return this.gsub(string2, regexp2, replacement2, block);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString gsub(org.jruby.truffle.runtime.core.RubyString string2, RubyRegexp regexp2, org.jruby.truffle.runtime.core.RubyString replacement2, RubyProc block) {
            GsubNode.notDesignedForCompilation();
            return regexp2.gsub(string2, replacement2.toString());
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString gsub(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString regexpString, UndefinedPlaceholder replacement2, RubyProc block) {
            GsubNode.notDesignedForCompilation();
            RubyRegexp regexp2 = new RubyRegexp(this, this.getContext().getCoreLibrary().getRegexpClass(), this.escape(frame, regexpString).getBytes(), 0);
            return this.gsub(frame, string2, regexp2, replacement2, block);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString gsub(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2, RubyRegexp regexp2, UndefinedPlaceholder replacement2, RubyProc block) {
            GsubNode.notDesignedForCompilation();
            RubyContext context = this.getContext();
            byte[] stringBytes = string2.getBytes().bytes();
            Encoding encoding2 = string2.getBytes().getEncoding();
            Matcher matcher = regexp2.getRegex().matcher(stringBytes);
            int p2 = string2.getBytes().getBegin();
            int end2 = 0;
            int range = p2 + string2.getBytes().getRealSize();
            int lastMatchEnd = 0;
            int matchedStringIndex = 0;
            StringBuilder builder = new StringBuilder();
            while (true) {
                Object matchData;
                if ((matchData = regexp2.matchCommon(string2.getBytes(), false, true, matcher, p2 + end2, range)) == context.getCoreLibrary().getNilObject()) break;
                Region region = matcher.getEagerRegion();
                RubyMatchData md = (RubyMatchData)matchData;
                Object[] values2 = md.getValues();
                int regionStart = region.beg[matchedStringIndex];
                int regionEnd = region.end[matchedStringIndex];
                builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, lastMatchEnd, regionStart - lastMatchEnd)));
                Object yieldResult = this.yield(frame, block, values2[matchedStringIndex]);
                builder.append(this.toS.call(frame, yieldResult, "to_s", null, new Object[0]).toString());
                lastMatchEnd = regionEnd;
                end2 = StringSupport.positionEndForScan(string2.getBytes(), matcher, encoding2, p2, range);
            }
            builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, lastMatchEnd, range - lastMatchEnd)));
            return context.makeString(builder.toString());
        }
    }

    @CoreMethod(names={"force_encoding"}, required=1)
    public static abstract class ForceEncodingNode
    extends CoreMethodNode {
        public ForceEncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ForceEncodingNode(ForceEncodingNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString forceEncoding(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString encodingName) {
            ForceEncodingNode.notDesignedForCompilation();
            RubyEncoding encoding2 = RubyEncoding.getEncoding(encodingName.toString());
            return this.forceEncoding(string2, encoding2);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString forceEncoding(org.jruby.truffle.runtime.core.RubyString string2, RubyEncoding encoding2) {
            ForceEncodingNode.notDesignedForCompilation();
            string2.forceEncoding(encoding2.getEncoding());
            return string2;
        }
    }

    @CoreMethod(names={"end_with?"}, required=1)
    public static abstract class EndWithNode
    extends CoreMethodNode {
        public EndWithNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EndWithNode(EndWithNode prev) {
            super(prev);
        }

        @Specialization
        public boolean endWith(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString b2) {
            EndWithNode.notDesignedForCompilation();
            return string2.toString().endsWith(b2.toString());
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodNode {
        public EncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EncodingNode(EncodingNode prev) {
            super(prev);
        }

        @Specialization
        public RubyEncoding encoding(org.jruby.truffle.runtime.core.RubyString string2) {
            EncodingNode.notDesignedForCompilation();
            return RubyEncoding.getEncoding(string2.getBytes().getEncoding());
        }
    }

    @CoreMethod(names={"encode"}, required=1)
    public static abstract class EncodeNode
    extends CoreMethodNode {
        public EncodeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EncodeNode(EncodeNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString encode(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString encoding2) {
            EncodeNode.notDesignedForCompilation();
            RubyString jrubyString = this.getContext().toJRuby(string2);
            RubyString jrubyEncodingString = this.getContext().toJRuby(encoding2);
            RubyString jrubyTranscoded = (RubyString)jrubyString.encode(this.getContext().getRuntime().getCurrentContext(), jrubyEncodingString);
            return this.getContext().toTruffle(jrubyTranscoded);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString encode(org.jruby.truffle.runtime.core.RubyString string2, RubyEncoding encoding2) {
            EncodeNode.notDesignedForCompilation();
            RubyString jrubyString = this.getContext().toJRuby(string2);
            RubyString jrubyEncodingString = this.getContext().toJRuby(this.getContext().makeString(encoding2.getName()));
            RubyString jrubyTranscoded = (RubyString)jrubyString.encode(this.getContext().getRuntime().getCurrentContext(), jrubyEncodingString);
            return this.getContext().toTruffle(jrubyTranscoded);
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EmptyNode(EmptyNode prev) {
            super(prev);
        }

        @Specialization
        public boolean empty(org.jruby.truffle.runtime.core.RubyString string2) {
            EmptyNode.notDesignedForCompilation();
            return string2.toString().isEmpty();
        }
    }

    @CoreMethod(names={"each_line"})
    public static abstract class EachLineNode
    extends YieldingCoreMethodNode {
        public EachLineNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachLineNode(EachLineNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray eachLine(org.jruby.truffle.runtime.core.RubyString string2) {
            EachLineNode.notDesignedForCompilation();
            ArrayList<org.jruby.truffle.runtime.core.RubyString> lines2 = new ArrayList<org.jruby.truffle.runtime.core.RubyString>();
            String str = string2.toString();
            int start2 = 0;
            while (start2 < str.length()) {
                int end2 = str.indexOf(10, start2);
                if (end2 == -1) {
                    lines2.add(this.getContext().makeString(str.substring(start2)));
                    break;
                }
                String line = str.substring(start2, end2 + 1);
                start2 = end2 + 1;
                lines2.add(this.getContext().makeString(line));
            }
            return org.jruby.truffle.runtime.core.RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), lines2.toArray(new Object[lines2.size()]));
        }
    }

    @CoreMethod(names={"downcase!"})
    public static abstract class DowncaseBangNode
    extends CoreMethodNode {
        public DowncaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DowncaseBangNode(DowncaseBangNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject downcase(org.jruby.truffle.runtime.core.RubyString string2) {
            DowncaseBangNode.notDesignedForCompilation();
            ByteList newByteList = StringNodesHelper.downcase(string2);
            if (newByteList.equals((Object)string2.getBytes())) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            string2.set(newByteList);
            return string2;
        }
    }

    @CoreMethod(names={"downcase"})
    public static abstract class DowncaseNode
    extends CoreMethodNode {
        public DowncaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DowncaseNode(DowncaseNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString downcase(org.jruby.truffle.runtime.core.RubyString string2) {
            DowncaseNode.notDesignedForCompilation();
            ByteList newByteList = StringNodesHelper.downcase(string2);
            return string2.getContext().makeString(newByteList);
        }
    }

    @CoreMethod(names={"count"}, argumentsAsArray=true)
    public static abstract class CountNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toStr;

        public CountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toStr = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public CountNode(CountNode prev) {
            super(prev);
            this.toStr = prev.toStr;
        }

        @Specialization
        public int count(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2, Object[] otherStrings) {
            CountNode.notDesignedForCompilation();
            if (otherStrings.length == 0) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentErrorEmptyVarargs(this));
            }
            return this.countSlow(frame, string2, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private int countSlow(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string2, Object[] args2) {
            org.jruby.truffle.runtime.core.RubyString[] otherStrings = new org.jruby.truffle.runtime.core.RubyString[args2.length];
            for (int i2 = 0; i2 < args2.length; ++i2) {
                Object coerced;
                if (args2[i2] instanceof org.jruby.truffle.runtime.core.RubyString) {
                    otherStrings[i2] = (org.jruby.truffle.runtime.core.RubyString)args2[i2];
                    continue;
                }
                try {
                    coerced = this.toStr.call(frame, args2[i2], "to_str", null, new Object[0]);
                }
                catch (RaiseException e) {
                    if (e.getRubyException().getLogicalClass() == this.getContext().getCoreLibrary().getNoMethodErrorClass()) {
                        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(args2[i2], "String", this));
                    }
                    throw e;
                }
                if (coerced instanceof org.jruby.truffle.runtime.core.RubyString) {
                    otherStrings[i2] = (org.jruby.truffle.runtime.core.RubyString)coerced;
                    continue;
                }
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorBadCoercion(args2[i2], "String", "to_str", coerced, this));
            }
            return string2.count(otherStrings);
        }
    }

    @CoreMethod(names={"chomp!"})
    public static abstract class ChompBangNode
    extends CoreMethodNode {
        public ChompBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ChompBangNode(ChompBangNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString chompBang(org.jruby.truffle.runtime.core.RubyString string2) {
            ChompBangNode.notDesignedForCompilation();
            string2.set(StringNodesHelper.chomp(string2));
            return string2;
        }
    }

    @CoreMethod(names={"chomp"}, optional=1)
    public static abstract class ChompNode
    extends CoreMethodNode {
        public ChompNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ChompNode(ChompNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString chomp(org.jruby.truffle.runtime.core.RubyString string2, UndefinedPlaceholder undefined) {
            ChompNode.notDesignedForCompilation();
            return string2.getContext().makeString(StringNodesHelper.chomp(string2));
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString chompWithString(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString stringToChomp) {
            ChompNode.notDesignedForCompilation();
            return this.getContext().makeString(StringNodesHelper.chompWithString(string2, stringToChomp));
        }
    }

    @CoreMethod(names={"bytes"})
    public static abstract class BytesNode
    extends CoreMethodNode {
        public BytesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BytesNode(BytesNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray bytes(org.jruby.truffle.runtime.core.RubyString string2) {
            byte[] bytes2 = string2.getBytes().bytes();
            int[] store = new int[bytes2.length];
            for (int n = 0; n < store.length; ++n) {
                store[n] = BytesNode.toUnsignedInt(bytes2[n]);
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), store, bytes2.length);
        }

        public static int toUnsignedInt(byte x) {
            return x & 0xFF;
        }
    }

    @CoreMethod(names={"b"})
    public static abstract class BNode
    extends CoreMethodNode {
        public BNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BNode(BNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString b(org.jruby.truffle.runtime.core.RubyString string2) {
            ByteList bytes2 = string2.getBytes().dup();
            bytes2.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            return this.getContext().makeString(bytes2);
        }
    }

    @CoreMethod(names={"=~"}, required=1)
    public static abstract class MatchOperatorNode
    extends CoreMethodNode {
        public MatchOperatorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MatchOperatorNode(MatchOperatorNode prev) {
            super(prev);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyString string2, RubyRegexp regexp2) {
            return regexp2.matchCommon(string2.getBytes(), true, false);
        }
    }

    @CoreMethod(names={"[]="}, required=2, lowerFixnumParameters={0})
    public static abstract class ElementSetNode
    extends CoreMethodNode {
        public ElementSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ElementSetNode(ElementSetNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString elementSet(org.jruby.truffle.runtime.core.RubyString string2, int index2, org.jruby.truffle.runtime.core.RubyString replacement2) {
            ElementSetNode.notDesignedForCompilation();
            if (string2.isFrozen()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().frozenError("String", this));
            }
            if (index2 < 0) {
                if (-index2 > string2.length()) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index2), this));
                }
                index2 += string2.length();
            } else if (index2 > string2.length()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index2), this));
            }
            StringSupport.replaceInternal19(index2, 1, string2, replacement2);
            return replacement2;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString elementSet(org.jruby.truffle.runtime.core.RubyString string2, RubyRange.IntegerFixnumRange range, org.jruby.truffle.runtime.core.RubyString replacement2) {
            int length2;
            ElementSetNode.notDesignedForCompilation();
            if (string2.isFrozen()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().frozenError("String", this));
            }
            int begin2 = range.getBegin();
            int end2 = range.getEnd();
            int stringLength = string2.length();
            if (begin2 < 0) {
                if ((begin2 += stringLength) < 0) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().rangeError(range, this));
                }
            } else if (begin2 > stringLength) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().rangeError(range, this));
            }
            if (end2 > stringLength) {
                end2 = stringLength;
            } else if (end2 < 0) {
                end2 += stringLength;
            }
            if (!range.doesExcludeEnd()) {
                ++end2;
            }
            if ((length2 = end2 - begin2) < 0) {
                length2 = 0;
            }
            StringSupport.replaceInternal19(begin2, length2, string2, replacement2);
            return replacement2;
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnumParameters={0, 1})
    public static abstract class GetIndexNode
    extends CoreMethodNode {
        private final BranchProfile outOfBounds = BranchProfile.create();

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetIndexNode(GetIndexNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyString getIndexInBounds(org.jruby.truffle.runtime.core.RubyString string2, int index2, UndefinedPlaceholder undefined) throws UnexpectedResultException {
            int normalisedIndex = string2.normaliseIndex(index2);
            ByteList bytes2 = string2.getBytes();
            if (normalisedIndex < 0 || normalisedIndex >= bytes2.length()) {
                throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
            }
            return this.getContext().makeString(bytes2.charAt(normalisedIndex));
        }

        @Specialization(contains={"getIndexInBounds"})
        public Object getIndex(org.jruby.truffle.runtime.core.RubyString string2, int index2, UndefinedPlaceholder undefined) {
            int normalisedIndex = string2.normaliseIndex(index2);
            ByteList bytes2 = string2.getBytes();
            if (normalisedIndex < 0 || normalisedIndex >= bytes2.length()) {
                this.outOfBounds.enter();
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return this.getContext().makeString(bytes2.charAt(normalisedIndex));
        }

        @Specialization
        public Object slice(org.jruby.truffle.runtime.core.RubyString string2, RubyRange.IntegerFixnumRange range, UndefinedPlaceholder undefined) {
            GetIndexNode.notDesignedForCompilation();
            String javaString = string2.toString();
            int begin2 = string2.normaliseIndex(range.getBegin());
            if (begin2 < 0 || begin2 > javaString.length()) {
                this.outOfBounds.enter();
                return this.getContext().getCoreLibrary().getNilObject();
            }
            int end2 = string2.normaliseIndex(range.getEnd());
            int excludingEnd = string2.clampExclusiveIndex(range.doesExcludeEnd() ? end2 : end2 + 1);
            return this.getContext().makeString(javaString.substring(begin2, excludingEnd));
        }

        @Specialization
        public Object slice(org.jruby.truffle.runtime.core.RubyString string2, int start2, int length2) {
            ByteList bytes2 = string2.getBytes();
            int begin2 = string2.normaliseIndex(start2);
            if (begin2 < 0 || begin2 > bytes2.length() || length2 < 0) {
                this.outOfBounds.enter();
                return this.getContext().getCoreLibrary().getNilObject();
            }
            int end2 = Math.min(bytes2.length(), begin2 + length2);
            return new org.jruby.truffle.runtime.core.RubyString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(bytes2, begin2, end2 - begin2));
        }
    }

    @CoreMethod(names={"%"}, required=1, argumentsAsArray=true)
    public static abstract class FormatNode
    extends CoreMethodNode {
        private final BranchProfile singleArrayProfile = BranchProfile.create();
        private final BranchProfile multipleArgumentsProfile = BranchProfile.create();

        public FormatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FormatNode(FormatNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString format(org.jruby.truffle.runtime.core.RubyString format, Object[] args2) {
            return this.formatSlow(format, args2);
        }

        @CompilerDirectives.TruffleBoundary
        private org.jruby.truffle.runtime.core.RubyString formatSlow(org.jruby.truffle.runtime.core.RubyString format, Object[] args2) {
            RubyContext context = this.getContext();
            if (args2.length == 1 && args2[0] instanceof org.jruby.truffle.runtime.core.RubyArray) {
                this.singleArrayProfile.enter();
                return context.makeString(StringFormatter.format(this.getContext(), format.toString(), Arrays.asList(((org.jruby.truffle.runtime.core.RubyArray)args2[0]).slowToArray())), format.getByteList().getEncoding());
            }
            this.multipleArgumentsProfile.enter();
            return context.makeString(StringFormatter.format(this.getContext(), format.toString(), Arrays.asList(args2)), format.getByteList().getEncoding());
        }
    }

    @CoreMethod(names={"<<", "concat"}, required=1)
    public static abstract class ConcatNode
    extends CoreMethodNode {
        public ConcatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConcatNode(ConcatNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString concat(org.jruby.truffle.runtime.core.RubyString string2, org.jruby.truffle.runtime.core.RubyString other) {
            string2.getBytes().append(other.getBytes());
            return string2;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        @Specialization
        public int compare(org.jruby.truffle.runtime.core.RubyString a, org.jruby.truffle.runtime.core.RubyString b2) {
            CompareNode.notDesignedForCompilation();
            return a.toString().compareTo(b2.toString());
        }
    }

    @CoreMethod(names={"==", "===", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(org.jruby.truffle.runtime.core.RubyString a, org.jruby.truffle.runtime.core.RubyString b2) {
            return a.equals(b2.toString());
        }

        @Specialization(guards={"!isRubyString(arguments[1])"})
        public boolean equal(org.jruby.truffle.runtime.core.RubyString a, Object b2) {
            return false;
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnumParameters={0})
    public static abstract class MulNode
    extends CoreMethodNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MulNode(MulNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString add(org.jruby.truffle.runtime.core.RubyString string2, int times2) {
            MulNode.notDesignedForCompilation();
            ByteList inputBytes = string2.getBytes();
            ByteList outputBytes = new ByteList(string2.getBytes().length() * times2);
            for (int n = 0; n < times2; ++n) {
                outputBytes.append(inputBytes);
            }
            outputBytes.setEncoding(inputBytes.getEncoding());
            return new org.jruby.truffle.runtime.core.RubyString(this.getContext().getCoreLibrary().getStringClass(), outputBytes);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends CoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AddNode(AddNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString add(org.jruby.truffle.runtime.core.RubyString a, org.jruby.truffle.runtime.core.RubyString b2) {
            AddNode.notDesignedForCompilation();
            return this.getContext().makeString(a.toString() + b2.toString());
        }
    }
}

