/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.core.ArrayBuilderNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="Range")
public abstract class RangeNodes {

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toS;

        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toS = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
            this.toS = prev.toS;
        }

        @Specialization
        public RubyString toS(RubyRange.IntegerFixnumRange range) {
            ToSNode.notDesignedForCompilation();
            return this.getContext().makeString(range.getBegin() + (range.doesExcludeEnd() ? "..." : "..") + range.getEnd());
        }

        @Specialization
        public RubyString toS(VirtualFrame frame, RubyRange.ObjectRange range) {
            ToSNode.notDesignedForCompilation();
            RubyString begin2 = (RubyString)this.toS.call(frame, range.getBegin(), "to_s", null, new Object[0]);
            RubyString end2 = (RubyString)this.toS.call(frame, range.getBegin(), "to_s", null, new Object[0]);
            return this.getContext().makeString(begin2 + (range.doesExcludeEnd() ? "..." : "..") + end2);
        }
    }

    @CoreMethod(names={"to_a"}, lowerFixnumSelf=true)
    public static abstract class ToANode
    extends CoreMethodNode {
        public ToANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToANode(ToANode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray toA(RubyRange.IntegerFixnumRange range) {
            int begin2 = range.getBegin();
            int length2 = range.getExclusiveEnd() - begin2;
            if (length2 < 0) {
                return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            }
            int[] values2 = new int[length2];
            for (int n = 0; n < length2; ++n) {
                values2[n] = begin2 + n;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), values2, length2);
        }
    }

    @CoreMethod(names={"step"}, needsBlock=true, required=1)
    public static abstract class StepNode
    extends YieldingCoreMethodNode {
        private final BranchProfile breakProfile = BranchProfile.create();
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public StepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StepNode(StepNode prev) {
            super(prev);
        }

        /*
         * Exception decompiling
         */
        @Specialization
        public Object step(VirtualFrame frame, RubyRange.IntegerFixnumRange range, int step, RubyProc block) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @CoreMethod(names={"last", "end"})
    public static abstract class LastNode
    extends CoreMethodNode {
        public LastNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LastNode(LastNode prev) {
            super(prev);
        }

        @Specialization
        public int last(RubyRange.IntegerFixnumRange range) {
            return range.getEnd();
        }

        @Specialization
        public Object last(RubyRange.ObjectRange range) {
            return range.getEnd();
        }
    }

    @CoreMethod(names={"include?", "==="}, required=1)
    public static abstract class IncludeNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode callLess;
        @Node.Child
        private CallDispatchHeadNode callGreater;
        @Node.Child
        private CallDispatchHeadNode callGreaterEqual;

        public IncludeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.callLess = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
            this.callGreater = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
            this.callGreaterEqual = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public IncludeNode(IncludeNode prev) {
            super(prev);
            this.callLess = prev.callLess;
            this.callGreater = prev.callGreater;
            this.callGreaterEqual = prev.callGreaterEqual;
        }

        @Specialization
        public boolean include(RubyRange.IntegerFixnumRange range, int value2) {
            return value2 >= range.getBegin() && value2 < range.getExclusiveEnd();
        }

        @Specialization
        public boolean include(VirtualFrame frame, RubyRange.ObjectRange range, Object value2) {
            IncludeNode.notDesignedForCompilation();
            if (this.callLess.callBoolean(frame, value2, "<", null, range.getBegin())) {
                return false;
            }
            return !(range.doesExcludeEnd() ? this.callGreaterEqual.callBoolean(frame, value2, ">=", null, range.getEnd()) : this.callGreater.callBoolean(frame, value2, ">", null, range.getEnd()));
        }
    }

    @CoreMethod(names={"first", "begin"})
    public static abstract class FirstNode
    extends CoreMethodNode {
        public FirstNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FirstNode(FirstNode prev) {
            super(prev);
        }

        @Specialization
        public int each(RubyRange.IntegerFixnumRange range) {
            return range.getBegin();
        }

        @Specialization
        public Object each(RubyRange.ObjectRange range) {
            return range.getBegin();
        }
    }

    @CoreMethod(names={"exclude_end?"})
    public static abstract class ExcludeEndNode
    extends CoreMethodNode {
        public ExcludeEndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExcludeEndNode(ExcludeEndNode prev) {
            super(prev);
        }

        @Specialization
        public boolean excludeEnd(RubyRange range) {
            return range.doesExcludeEnd();
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true, lowerFixnumSelf=true)
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        private final BranchProfile breakProfile = BranchProfile.create();
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachNode(EachNode prev) {
            super(prev);
        }

        /*
         * Exception decompiling
         */
        @Specialization
        public Object each(VirtualFrame frame, RubyRange.IntegerFixnumRange range, RubyProc block) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @CoreMethod(names={"collect", "map"}, needsBlock=true, lowerFixnumSelf=true)
    public static abstract class CollectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public CollectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public CollectNode(CollectNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public RubyArray collect(VirtualFrame frame, RubyRange.IntegerFixnumRange range, RubyProc block) {
            int begin2 = range.getBegin();
            int exclusiveEnd = range.getExclusiveEnd();
            int length2 = exclusiveEnd - begin2;
            Object store = this.arrayBuilder.start(length2);
            int count2 = 0;
            try {
                for (int n = 0; n < length2; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    store = this.arrayBuilder.append(store, n, this.yield(frame, block, n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(store, length2), length2);
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        protected boolean equal(VirtualFrame frame, Object a, Object b2) {
            if (this.equalNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.equalNode = (KernelNodes.SameOrEqualNode)this.insert(KernelNodesFactory.SameOrEqualNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.equalNode.executeSameOrEqual(frame, a, b2);
        }

        @Specialization
        public boolean equal(RubyRange.IntegerFixnumRange a, RubyRange.IntegerFixnumRange b2) {
            EqualNode.notDesignedForCompilation();
            return a.doesExcludeEnd() == b2.doesExcludeEnd() && a.getBegin() == b2.getBegin() && a.getEnd() == b2.getEnd();
        }

        @Specialization
        public boolean equal(RubyRange.IntegerFixnumRange a, RubyRange.LongFixnumRange b2) {
            EqualNode.notDesignedForCompilation();
            return a.doesExcludeEnd() == b2.doesExcludeEnd() && (long)a.getBegin() == b2.getBegin() && (long)a.getEnd() == b2.getEnd();
        }

        @Specialization
        public boolean equal(RubyRange.LongFixnumRange a, RubyRange.LongFixnumRange b2) {
            EqualNode.notDesignedForCompilation();
            return a.doesExcludeEnd() == b2.doesExcludeEnd() && a.getBegin() == b2.getBegin() && a.getEnd() == b2.getEnd();
        }

        @Specialization
        public boolean equal(RubyRange.LongFixnumRange a, RubyRange.IntegerFixnumRange b2) {
            EqualNode.notDesignedForCompilation();
            return a.doesExcludeEnd() == b2.doesExcludeEnd() && a.getBegin() == (long)b2.getBegin() && a.getEnd() == (long)b2.getEnd();
        }

        @Specialization
        public boolean equal(VirtualFrame frame, RubyRange.ObjectRange a, RubyRange.ObjectRange b2) {
            EqualNode.notDesignedForCompilation();
            return a.doesExcludeEnd() == b2.doesExcludeEnd() && this.equal(frame, a.getBegin(), b2.getBegin()) && this.equal(frame, a.getEnd(), b2.getEnd());
        }
    }
}

