/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.NumericNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;

@GeneratedBy(value=NumericNodes.class)
public final class NumericNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(PosNodeFactory.getInstance(), NonZeroNodeFactory.getInstance(), StepNodeFactory.getInstance());
    }

    @GeneratedBy(value=NumericNodes.StepNode.class)
    public static final class StepNodeFactory
    extends NodeFactoryBase<NumericNodes.StepNode> {
        private static StepNodeFactory stepNodeFactoryInstance;

        private StepNodeFactory() {
            super(NumericNodes.StepNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public NumericNodes.StepNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StepNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NumericNodes.StepNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StepUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<NumericNodes.StepNode> getInstance() {
            if (stepNodeFactoryInstance == null) {
                stepNodeFactoryInstance = new StepNodeFactory();
            }
            return stepNodeFactoryInstance;
        }

        @GeneratedBy(value=NumericNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StepPolymorphicNode
        extends StepBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;

            StepPolymorphicNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }
        }

        @GeneratedBy(value=NumericNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepIntNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, RubyProc.class}, 0, 0);

            StepIntNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments3Value;
                int arguments2Value;
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof int");
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static NumericNodes.StepNode create0(NumericNodes.StepNode current2) {
                return new StepIntNode((StepBaseNode)current2);
            }
        }

        @GeneratedBy(value=NumericNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StepUninitializedNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StepUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StepUninitializedNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                StepBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StepBaseNode rootNode = (StepBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3]}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StepBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static NumericNodes.StepNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StepUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=NumericNodes.StepNode.class)
        private static abstract class StepBaseNode
        extends NumericNodes.StepNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StepBaseNode next0;

            StepBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StepBaseNode(StepBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, String reason2) {
                String message2;
                StepBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StepBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    newNode = new StepUninitializedNode(this);
                    ((StepUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StepBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = StepBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value, arguments3Value)))) == null) {
                    returnNode = (StepBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StepUninitializedNode(this), (Node)new StepPolymorphicNode(this), (DSLNode)((StepBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StepBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    return (StepBaseNode)StepIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                } else {
                    StepBaseNode otherCast = (StepBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                }
                this.next0 = newNext == null ? null : (StepBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=NumericNodes.NonZeroNode.class)
    public static final class NonZeroNodeFactory
    extends NodeFactoryBase<NumericNodes.NonZeroNode> {
        private static NonZeroNodeFactory nonZeroNodeFactoryInstance;

        private NonZeroNodeFactory() {
            super(NumericNodes.NonZeroNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public NumericNodes.NonZeroNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NonZeroNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NumericNodes.NonZeroNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NonZeroUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<NumericNodes.NonZeroNode> getInstance() {
            if (nonZeroNodeFactoryInstance == null) {
                nonZeroNodeFactoryInstance = new NonZeroNodeFactory();
            }
            return nonZeroNodeFactoryInstance;
        }

        @GeneratedBy(value=NumericNodes.NonZeroNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NonZeroPolymorphicNode
        extends NonZeroBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            NonZeroPolymorphicNode(NonZeroBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=NumericNodes.NonZeroNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NonZeroDoubleNode
        extends NonZeroBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NonZeroDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            NonZeroDoubleNode(NonZeroBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.nonZero(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.nonZero(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static NumericNodes.NonZeroNode create0(NumericNodes.NonZeroNode current2) {
                return new NonZeroDoubleNode((NonZeroBaseNode)current2);
            }
        }

        @GeneratedBy(value=NumericNodes.NonZeroNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NonZeroRubyBignumNode
        extends NonZeroBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NonZeroRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            NonZeroRubyBignumNode(NonZeroBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.nonZero(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.nonZero(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static NumericNodes.NonZeroNode create0(NumericNodes.NonZeroNode current2) {
                return new NonZeroRubyBignumNode((NonZeroBaseNode)current2);
            }
        }

        @GeneratedBy(value=NumericNodes.NonZeroNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NonZeroLongNode
        extends NonZeroBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NonZeroLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            NonZeroLongNode(NonZeroBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.nonZero(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.nonZero(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static NumericNodes.NonZeroNode create0(NumericNodes.NonZeroNode current2) {
                return new NonZeroLongNode((NonZeroBaseNode)current2);
            }
        }

        @GeneratedBy(value=NumericNodes.NonZeroNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NonZeroIntNode
        extends NonZeroBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NonZeroIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            NonZeroIntNode(NonZeroBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.nonZero(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.nonZero(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static NumericNodes.NonZeroNode create0(NumericNodes.NonZeroNode current2) {
                return new NonZeroIntNode((NonZeroBaseNode)current2);
            }
        }

        @GeneratedBy(value=NumericNodes.NonZeroNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NonZeroUninitializedNode
        extends NonZeroBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NonZeroUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NonZeroUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            NonZeroUninitializedNode(NonZeroBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                NonZeroBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NonZeroBaseNode rootNode = (NonZeroBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((NonZeroBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static NumericNodes.NonZeroNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NonZeroUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=NumericNodes.NonZeroNode.class)
        private static abstract class NonZeroBaseNode
        extends NumericNodes.NonZeroNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected NonZeroBaseNode next0;

            NonZeroBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            NonZeroBaseNode(NonZeroBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                NonZeroBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NonZeroBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new NonZeroUninitializedNode(this);
                    ((NonZeroUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (NonZeroBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = NonZeroBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (NonZeroBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NonZeroUninitializedNode(this), (Node)new NonZeroPolymorphicNode(this), (DSLNode)((NonZeroBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NonZeroBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (NonZeroBaseNode)NonZeroIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (NonZeroBaseNode)NonZeroLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (NonZeroBaseNode)NonZeroRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (NonZeroBaseNode)NonZeroDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((NonZeroBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (NonZeroBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=NumericNodes.PosNode.class)
    public static final class PosNodeFactory
    extends NodeFactoryBase<NumericNodes.PosNode> {
        private static PosNodeFactory posNodeFactoryInstance;

        private PosNodeFactory() {
            super(NumericNodes.PosNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public NumericNodes.PosNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PosNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NumericNodes.PosNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PosUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<NumericNodes.PosNode> getInstance() {
            if (posNodeFactoryInstance == null) {
                posNodeFactoryInstance = new PosNodeFactory();
            }
            return posNodeFactoryInstance;
        }

        @GeneratedBy(value=NumericNodes.PosNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PosPolymorphicNode
        extends PosBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            PosPolymorphicNode(PosBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=NumericNodes.PosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PosDoubleNode
        extends PosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PosDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            PosDoubleNode(PosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double"));
                }
                return super.pos(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.pos(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static NumericNodes.PosNode create0(NumericNodes.PosNode current2) {
                return new PosDoubleNode((PosBaseNode)current2);
            }
        }

        @GeneratedBy(value=NumericNodes.PosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PosRubyBignumNode
        extends PosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PosRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            PosRubyBignumNode(PosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum"));
                }
                return super.pos(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.pos(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static NumericNodes.PosNode create0(NumericNodes.PosNode current2) {
                return new PosRubyBignumNode((PosBaseNode)current2);
            }
        }

        @GeneratedBy(value=NumericNodes.PosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PosLongNode
        extends PosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PosLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            PosLongNode(PosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long"));
                }
                return super.pos(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.pos(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static NumericNodes.PosNode create0(NumericNodes.PosNode current2) {
                return new PosLongNode((PosBaseNode)current2);
            }
        }

        @GeneratedBy(value=NumericNodes.PosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PosIntNode
        extends PosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PosIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            PosIntNode(PosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int"));
                }
                return super.pos(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.pos(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static NumericNodes.PosNode create0(NumericNodes.PosNode current2) {
                return new PosIntNode((PosBaseNode)current2);
            }
        }

        @GeneratedBy(value=NumericNodes.PosNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PosUninitializedNode
        extends PosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PosUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PosUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PosUninitializedNode(PosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                PosBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PosBaseNode rootNode = (PosBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PosBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static NumericNodes.PosNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PosUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=NumericNodes.PosNode.class)
        private static abstract class PosBaseNode
        extends NumericNodes.PosNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PosBaseNode next0;

            PosBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PosBaseNode(PosBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                PosBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PosBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new PosUninitializedNode(this);
                    ((PosUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PosBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PosBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (PosBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PosUninitializedNode(this), (Node)new PosPolymorphicNode(this), (DSLNode)((PosBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PosBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (PosBaseNode)PosIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (PosBaseNode)PosLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (PosBaseNode)PosRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (PosBaseNode)PosDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((PosBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (PosBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

