/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.methods.SetMethodDeclarationContext;
import org.jruby.truffle.nodes.methods.arguments.CheckArityNode;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.methods.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.nodes.objects.SelfNode;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleChain;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyUnboundMethod;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.IdUtil;

@CoreClass(name="Module")
public abstract class ModuleNodes {

    @CoreMethod(names={"undef_method"}, required=1)
    public static abstract class UndefMethodNode
    extends CoreMethodNode {
        public UndefMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UndefMethodNode(UndefMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule undefMethod(RubyClass rubyClass, RubyString name2) {
            UndefMethodNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(rubyClass, name2.toString());
            if (method == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(name2.toString(), rubyClass.toString(), this));
            }
            rubyClass.undefMethod((RubyNode)this, method);
            return rubyClass;
        }

        @Specialization
        public RubyModule undefMethod(RubyClass rubyClass, RubySymbol name2) {
            UndefMethodNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(rubyClass, name2.toString());
            if (method == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(name2.toString(), rubyClass.toString(), this));
            }
            rubyClass.undefMethod((RubyNode)this, method);
            return rubyClass;
        }

        @Specialization
        public RubyModule undefMethod(RubyModule module, RubyString name2) {
            UndefMethodNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(module, name2.toString());
            if (method == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(name2.toString(), module.toString(), this));
            }
            module.undefMethod((RubyNode)this, method);
            return module;
        }

        @Specialization
        public RubyModule undefMethod(RubyModule module, RubySymbol name2) {
            UndefMethodNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(module, name2.toString());
            if (method == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(name2.toString(), module.toString(), this));
            }
            module.undefMethod((RubyNode)this, method);
            return module;
        }
    }

    @CoreMethod(names={"remove_method"}, required=1)
    public static abstract class RemoveMethodNode
    extends CoreMethodNode {
        public RemoveMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RemoveMethodNode(RemoveMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule removeMethod(RubyModule module, RubyString name2) {
            RemoveMethodNode.notDesignedForCompilation();
            module.removeMethod(this, name2.toString());
            return module;
        }

        @Specialization
        public RubyModule removeMethod(RubyModule module, RubySymbol name2) {
            RemoveMethodNode.notDesignedForCompilation();
            module.removeMethod(this, name2.toString());
            return module;
        }
    }

    @CoreMethod(names={"remove_class_variable"}, required=1)
    public static abstract class RemoveClassVariableNode
    extends CoreMethodNode {
        public RemoveClassVariableNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RemoveClassVariableNode(RemoveClassVariableNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule removeClassVariable(RubyModule module, RubyString name2) {
            RemoveClassVariableNode.notDesignedForCompilation();
            module.removeClassVariable(this, name2.toString());
            return module;
        }

        @Specialization
        public RubyModule removeClassVariable(RubyModule module, RubySymbol name2) {
            RemoveClassVariableNode.notDesignedForCompilation();
            module.removeClassVariable(this, name2.toString());
            return module;
        }
    }

    @CoreMethod(names={"protected"}, argumentsAsArray=true)
    public static abstract class ProtectedNode
    extends CoreMethodNode {
        public ProtectedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ProtectedNode(ProtectedNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule doProtected(VirtualFrame frame, RubyModule module, Object ... args2) {
            ProtectedNode.notDesignedForCompilation();
            module.visibilityMethod(this, args2, Visibility.PROTECTED);
            return module;
        }
    }

    @CoreMethod(names={"public_constant"}, argumentsAsArray=true)
    public static abstract class PublicConstantNode
    extends CoreMethodNode {
        public PublicConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicConstantNode(PublicConstantNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule publicConstant(RubyModule module, Object[] args2) {
            PublicConstantNode.notDesignedForCompilation();
            for (Object ob : args2) {
                if (!(ob instanceof RubySymbol)) continue;
                module.changeConstantVisibility(this, (RubySymbol)ob, false);
            }
            return module;
        }
    }

    @CoreMethod(names={"private_constant"}, argumentsAsArray=true)
    public static abstract class PrivateConstantNode
    extends CoreMethodNode {
        public PrivateConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrivateConstantNode(PrivateConstantNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule privateConstant(RubyModule module, Object[] args2) {
            PrivateConstantNode.notDesignedForCompilation();
            for (Object ob : args2) {
                if (!(ob instanceof RubySymbol)) continue;
                module.changeConstantVisibility(this, (RubySymbol)ob, true);
            }
            return module;
        }
    }

    @CoreMethod(names={"instance_method"}, required=1)
    public static abstract class InstanceMethodNode
    extends CoreMethodNode {
        public InstanceMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceMethodNode(InstanceMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyUnboundMethod instanceMethod(RubyModule module, RubySymbol name2) {
            InstanceMethodNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(module, name2.toString());
            if (method == null) {
                throw new UnsupportedOperationException();
            }
            return new RubyUnboundMethod(this.getContext().getCoreLibrary().getUnboundMethodClass(), method);
        }
    }

    @CoreMethod(names={"instance_methods"}, optional=1)
    public static abstract class InstanceMethodsNode
    extends CoreMethodNode {
        public InstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceMethodsNode(InstanceMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray instanceMethods(RubyModule module, UndefinedPlaceholder argument) {
            InstanceMethodsNode.notDesignedForCompilation();
            return this.instanceMethods(module, true);
        }

        @Specialization
        public RubyArray instanceMethods(RubyModule module, boolean includeAncestors) {
            InstanceMethodsNode.notDesignedForCompilation();
            Map<String, InternalMethod> methods2 = includeAncestors ? ModuleOperations.getAllMethods(module) : module.getMethods();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            for (InternalMethod method : methods2.values()) {
                if (method.getVisibility() == Visibility.PRIVATE || method.isUndefined()) continue;
                array.slowPush(this.getContext().newSymbol(method.getName()));
            }
            return array;
        }
    }

    @CoreMethod(names={"public_instance_methods"}, optional=1)
    public static abstract class PublicInstanceMethodsNode
    extends CoreMethodNode {
        public PublicInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicInstanceMethodsNode(PublicInstanceMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray publicInstanceMethods(RubyModule module, UndefinedPlaceholder argument) {
            return this.publicInstanceMethods(module, false);
        }

        @Specialization
        public RubyArray publicInstanceMethods(RubyModule module, boolean includeAncestors) {
            PublicInstanceMethodsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            ArrayList<InternalMethod> methods2 = new ArrayList<InternalMethod>(module.getMethods().values());
            if (includeAncestors) {
                for (RubyModule parent : module.parentAncestors()) {
                    methods2.addAll(parent.getMethods().values());
                }
            }
            for (InternalMethod method : methods2) {
                if (method.getVisibility() != Visibility.PUBLIC) continue;
                RubySymbol m = this.getContext().newSymbol(method.getName());
                array.slowPush(m);
            }
            return array;
        }
    }

    @CoreMethod(names={"private_instance_methods"}, optional=1)
    public static abstract class PrivateInstanceMethodsNode
    extends CoreMethodNode {
        public PrivateInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrivateInstanceMethodsNode(PrivateInstanceMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray privateInstanceMethods(RubyModule module, UndefinedPlaceholder argument) {
            return this.privateInstanceMethods(module, false);
        }

        @Specialization
        public RubyArray privateInstanceMethods(RubyModule module, boolean includeAncestors) {
            PrivateInstanceMethodsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            ArrayList<InternalMethod> methods2 = new ArrayList<InternalMethod>(module.getMethods().values());
            if (includeAncestors) {
                for (RubyModule parent : module.parentAncestors()) {
                    methods2.addAll(parent.getMethods().values());
                }
            }
            for (InternalMethod method : methods2) {
                if (method.getVisibility() != Visibility.PRIVATE) continue;
                RubySymbol m = this.getContext().newSymbol(method.getName());
                array.slowPush(m);
            }
            return array;
        }
    }

    @CoreMethod(names={"private_class_method"}, argumentsAsArray=true)
    public static abstract class PrivateClassMethodNode
    extends CoreMethodNode {
        public PrivateClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrivateClassMethodNode(PrivateClassMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule privateClassMethod(RubyModule module, Object ... args2) {
            PrivateClassMethodNode.notDesignedForCompilation();
            RubyClass moduleSingleton = module.getSingletonClass(this);
            for (Object arg2 : args2) {
                if (!(arg2 instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                String methodName = arg2.toString();
                InternalMethod method = ModuleOperations.lookupMethod(moduleSingleton, methodName);
                if (method == null) {
                    throw new RuntimeException("Couldn't find method " + arg2.toString());
                }
                moduleSingleton.addMethod(this, method.withVisibility(Visibility.PRIVATE));
            }
            return module;
        }
    }

    @CoreMethod(names={"private"}, argumentsAsArray=true)
    public static abstract class PrivateNode
    extends CoreMethodNode {
        public PrivateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrivateNode(PrivateNode prev) {
            super(prev);
        }

        public abstract RubyModule executePrivate(VirtualFrame var1, RubyModule var2, Object[] var3);

        @Specialization
        public RubyModule doPrivate(RubyModule module, Object[] args2) {
            PrivateNode.notDesignedForCompilation();
            module.visibilityMethod(this, args2, Visibility.PRIVATE);
            return module;
        }
    }

    @CoreMethod(names={"public_class_method"}, argumentsAsArray=true)
    public static abstract class PublicClassMethodNode
    extends CoreMethodNode {
        public PublicClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicClassMethodNode(PublicClassMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule publicClassMethod(RubyModule module, Object ... args2) {
            PublicClassMethodNode.notDesignedForCompilation();
            RubyClass moduleSingleton = module.getSingletonClass(this);
            for (Object arg2 : args2) {
                if (!(arg2 instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                String methodName = arg2.toString();
                InternalMethod method = ModuleOperations.lookupMethod(moduleSingleton, methodName);
                if (method == null) {
                    throw new RuntimeException("Couldn't find method " + arg2.toString());
                }
                moduleSingleton.addMethod(this, method.withVisibility(Visibility.PUBLIC));
            }
            return module;
        }
    }

    @CoreMethod(names={"public"}, argumentsAsArray=true)
    public static abstract class PublicNode
    extends CoreMethodNode {
        public PublicNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicNode(PublicNode prev) {
            super(prev);
        }

        public abstract RubyModule executePublic(VirtualFrame var1, RubyModule var2, Object[] var3);

        @Specialization
        public RubyModule doPublic(RubyModule module, Object[] args2) {
            PublicNode.notDesignedForCompilation();
            module.visibilityMethod(this, args2, Visibility.PUBLIC);
            return module;
        }
    }

    @CoreMethod(names={"nesting"}, onSingleton=true)
    public static abstract class NestingNode
    extends CoreMethodNode {
        public NestingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NestingNode(NestingNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray nesting() {
            RubyModule enclosing;
            NestingNode.notDesignedForCompilation();
            ArrayList<RubyModule> modules = new ArrayList<RubyModule>();
            InternalMethod method = RubyCallStack.getCallingMethod();
            RubyClass object = this.getContext().getCoreLibrary().getObjectClass();
            for (LexicalScope lexicalScope = method == null ? null : method.getSharedMethodInfo().getLexicalScope(); lexicalScope != null && (enclosing = lexicalScope.getLiveModule()) != object; lexicalScope = lexicalScope.getParent()) {
                modules.add(enclosing);
            }
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), modules.toArray(new Object[modules.size()]));
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodNode {
        public NameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NameNode(NameNode prev) {
            super(prev);
        }

        @Specialization
        public Object name(RubyModule module) {
            NameNode.notDesignedForCompilation();
            if (module.getName() == null) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            StringBuilder builder = new StringBuilder();
            builder.append(module.getName());
            for (LexicalScope lexicalScope = module.getLexicalScope(); lexicalScope != null && lexicalScope.getLiveModule() != this.getContext().getCoreLibrary().getObjectClass(); lexicalScope = lexicalScope.getParent()) {
                builder.insert(0, "::");
                builder.insert(0, lexicalScope.getLiveModule().getName());
            }
            return this.getContext().makeString(builder.toString());
        }
    }

    @CoreMethod(names={"module_function"}, argumentsAsArray=true)
    public static abstract class ModuleFunctionNode
    extends CoreMethodNode {
        public ModuleFunctionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ModuleFunctionNode(ModuleFunctionNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule moduleFunction(RubyModule module, Object ... args2) {
            ModuleFunctionNode.notDesignedForCompilation();
            module.visibilityMethod(this, args2, Visibility.MODULE_FUNCTION);
            return module;
        }
    }

    @CoreMethod(names={"method_defined?"}, required=1, optional=1)
    public static abstract class MethodDefinedNode
    extends CoreMethodNode {
        public MethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MethodDefinedNode(MethodDefinedNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isMethodDefined(RubyModule module, RubyString name2, UndefinedPlaceholder inherit) {
            MethodDefinedNode.notDesignedForCompilation();
            return ModuleOperations.lookupMethod(module, name2.toString()) != null;
        }

        @Specialization
        public boolean isMethodDefined(RubyModule module, RubyString name2, boolean inherit) {
            MethodDefinedNode.notDesignedForCompilation();
            if (inherit) {
                return ModuleOperations.lookupMethod(module, name2.toString()) != null;
            }
            return module.getMethods().containsKey(name2.toString());
        }

        @Specialization
        public boolean isMethodDefined(RubyModule module, RubySymbol name2, UndefinedPlaceholder inherit) {
            MethodDefinedNode.notDesignedForCompilation();
            return ModuleOperations.lookupMethod(module, name2.toString()) != null;
        }
    }

    @CoreMethod(names={"include?"}, required=1)
    public static abstract class IncludePNode
    extends CoreMethodNode {
        @Node.Child
        private DispatchHeadNode appendFeaturesNode;

        public IncludePNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.appendFeaturesNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public IncludePNode(IncludePNode prev) {
            super(prev);
            this.appendFeaturesNode = prev.appendFeaturesNode;
        }

        @Specialization
        public boolean include(RubyModule module, RubyModule included2) {
            IncludePNode.notDesignedForCompilation();
            for (ModuleChain ancestor = module.getParentModule(); ancestor != null; ancestor = ancestor.getParentModule()) {
                if (ancestor.getActualModule() != included2) continue;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"include"}, argumentsAsArray=true, required=1)
    public static abstract class IncludeNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode appendFeaturesNode;

        public IncludeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.appendFeaturesNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public IncludeNode(IncludeNode prev) {
            super(prev);
            this.appendFeaturesNode = prev.appendFeaturesNode;
        }

        @Specialization
        public RubyNilClass include(VirtualFrame frame, RubyModule module, Object[] args2) {
            IncludeNode.notDesignedForCompilation();
            for (int n = args2.length - 1; n >= 0; --n) {
                if (!(args2[n] instanceof RubyModule)) continue;
                RubyModule included2 = (RubyModule)args2[n];
                this.appendFeaturesNode.call(frame, included2, "append_features", null, module);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"initialize_copy"}, visibility=Visibility.PRIVATE, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization
        public Object initializeCopy(RubyModule self2, RubyModule other) {
            InitializeCopyNode.notDesignedForCompilation();
            self2.initCopy(other);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        @Node.Child
        private ClassExecNode classExecNode;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        public abstract RubyModule executeInitialize(VirtualFrame var1, RubyModule var2, RubyProc var3);

        void classEval(VirtualFrame frame, RubyModule module, RubyProc block) {
            if (this.classExecNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.classExecNode = (ClassExecNode)this.insert(ModuleNodesFactory.ClassExecNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            this.classExecNode.executeClassEval(frame, module, new Object[0], block);
        }

        @Specialization
        public RubyModule initialize(RubyModule module, UndefinedPlaceholder block) {
            return module;
        }

        @Specialization
        public RubyModule initialize(VirtualFrame frame, RubyModule module, RubyProc block) {
            this.classEval(frame, module, block);
            return module;
        }
    }

    @CoreMethod(names={"define_method"}, needsBlock=true, required=1, optional=1)
    public static abstract class DefineMethodNode
    extends CoreMethodNode {
        public DefineMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DefineMethodNode(DefineMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol defineMethod(RubyModule module, RubyString name2, UndefinedPlaceholder proc, RubyProc block) {
            DefineMethodNode.notDesignedForCompilation();
            return this.defineMethod(module, name2, block, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization
        public RubySymbol defineMethod(RubyModule module, RubyString name2, RubyProc proc, UndefinedPlaceholder block) {
            DefineMethodNode.notDesignedForCompilation();
            RubySymbol symbol = this.getContext().getSymbolTable().getSymbol(name2.getBytes());
            this.defineMethod(module, symbol, proc);
            return symbol;
        }

        @Specialization
        public RubySymbol defineMethod(RubyModule module, RubySymbol name2, UndefinedPlaceholder proc, RubyProc block) {
            DefineMethodNode.notDesignedForCompilation();
            return this.defineMethod(module, name2, block, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization
        public RubySymbol defineMethod(RubyModule module, RubySymbol name2, RubyProc proc, UndefinedPlaceholder block) {
            DefineMethodNode.notDesignedForCompilation();
            this.defineMethod(module, name2, proc);
            return name2;
        }

        @Specialization
        public RubySymbol defineMethod(RubyModule module, RubySymbol name2, RubyMethod method, UndefinedPlaceholder block) {
            DefineMethodNode.notDesignedForCompilation();
            module.addMethod(this, method.getMethod().withNewName(name2.toString()));
            return name2;
        }

        private void defineMethod(RubyModule module, RubySymbol name2, RubyProc proc) {
            DefineMethodNode.notDesignedForCompilation();
            CallTarget modifiedCallTarget = proc.getCallTargetForMethods();
            InternalMethod modifiedMethod = new InternalMethod(proc.getSharedMethodInfo(), name2.toString(), module, Visibility.PUBLIC, false, modifiedCallTarget, proc.getDeclarationFrame());
            module.addMethod(this, modifiedMethod);
        }
    }

    @CoreMethod(names={"const_set"}, required=2)
    public static abstract class ConstSetNode
    extends CoreMethodNode {
        public ConstSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConstSetNode(ConstSetNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule setConstant(RubyModule module, RubyString name2, Object object) {
            ConstSetNode.notDesignedForCompilation();
            this.setConstant(module, name2.toString(), object);
            return module;
        }

        @Specialization
        public RubyModule setConstant(RubyModule module, RubySymbol name2, Object object) {
            ConstSetNode.notDesignedForCompilation();
            this.setConstant(module, name2.toString(), object);
            return module;
        }

        public void setConstant(RubyModule module, String name2, Object object) {
            RubyModule setModule;
            if (!IdUtil.isConstant(name2)) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameError(String.format("wrong constant name %s", name2), this));
            }
            if (object instanceof RubyModule && (setModule = (RubyModule)object).getName() == null) {
                setModule.setLexicalScope(new LexicalScope(null, module));
                setModule.setName(name2);
            }
            module.setConstant(this, name2, object);
        }
    }

    @CoreMethod(names={"const_missing"}, required=1)
    public static abstract class ConstMissingNode
    extends CoreMethodNode {
        public ConstMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConstMissingNode(ConstMissingNode prev) {
            super(prev);
        }

        @Specialization
        public Object methodMissing(RubyModule module, RubySymbol name2) {
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedConstant(module, name2.toString(), this));
        }
    }

    @CoreMethod(names={"const_get"}, required=1)
    public static abstract class ConstGetNode
    extends CoreMethodNode {
        @Node.Child
        private DispatchHeadNode dispatch;

        public ConstGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = new DispatchHeadNode(context, false, false, MissingBehavior.CALL_CONST_MISSING, null, DispatchAction.READ_CONSTANT);
        }

        public ConstGetNode(ConstGetNode prev) {
            super(prev);
            this.dispatch = prev.dispatch;
        }

        @Specialization
        public Object getConstant(VirtualFrame frame, RubyModule module, RubyString name2) {
            ConstGetNode.notDesignedForCompilation();
            return this.dispatch.dispatch(frame, module, name2, null, new Object[0]);
        }

        @Specialization
        public Object getConstant(VirtualFrame frame, RubyModule module, RubySymbol name2) {
            ConstGetNode.notDesignedForCompilation();
            return this.dispatch.dispatch(frame, module, name2, null, new Object[0]);
        }
    }

    @CoreMethod(names={"const_defined?"}, required=1, optional=1)
    public static abstract class ConstDefinedNode
    extends CoreMethodNode {
        public ConstDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConstDefinedNode(ConstDefinedNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isConstDefined(RubyModule module, RubyString name2, UndefinedPlaceholder inherit) {
            ConstDefinedNode.notDesignedForCompilation();
            return ModuleOperations.lookupConstant(this.getContext(), LexicalScope.NONE, module, name2.toString()) != null;
        }

        @Specialization
        public boolean isConstDefined(RubyModule module, RubyString name2, boolean inherit) {
            ConstDefinedNode.notDesignedForCompilation();
            if (inherit) {
                return ModuleOperations.lookupConstant(this.getContext(), LexicalScope.NONE, module, name2.toString()) != null;
            }
            return module.getConstants().containsKey(name2.toString());
        }

        @Specialization
        public boolean isConstDefined(RubyModule module, RubySymbol name2, UndefinedPlaceholder inherit) {
            ConstDefinedNode.notDesignedForCompilation();
            return ModuleOperations.lookupConstant(this.getContext(), LexicalScope.NONE, module, name2.toString()) != null;
        }
    }

    @CoreMethod(names={"constants"}, optional=1)
    public static abstract class ConstantsNode
    extends CoreMethodNode {
        public ConstantsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConstantsNode(ConstantsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray constants(RubyModule module, UndefinedPlaceholder unused2) {
            return this.constants(module, true);
        }

        @Specialization
        public RubyArray constants(RubyModule module, boolean inherit) {
            ConstantsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            for (String constant : module.getConstants().keySet()) {
                array.slowPush(this.getContext().newSymbol(constant));
            }
            return array;
        }
    }

    @CoreMethod(names={"class_variables"})
    public static abstract class ClassVariablesNode
    extends CoreMethodNode {
        public ClassVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClassVariablesNode(ClassVariablesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray getClassVariables(RubyModule module) {
            ClassVariablesNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(module.getContext().getCoreLibrary().getArrayClass());
            for (String variable : ModuleOperations.getAllClassVariables(module).keySet()) {
                array.slowPush(RubySymbol.newSymbol(module.getContext(), variable));
            }
            return array;
        }
    }

    @CoreMethod(names={"class_variable_get"}, required=1)
    public static abstract class ClassVariableGetNode
    extends CoreMethodNode {
        public ClassVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClassVariableGetNode(ClassVariableGetNode prev) {
            super(prev);
        }

        @Specialization
        public Object getClassVariable(RubyModule module, RubyString name2) {
            ClassVariableGetNode.notDesignedForCompilation();
            return ModuleOperations.lookupClassVariable(module, RubyContext.checkClassVariableName(this.getContext(), name2.toString(), this));
        }

        @Specialization
        public Object getClassVariable(RubyModule module, RubySymbol name2) {
            ClassVariableGetNode.notDesignedForCompilation();
            return ModuleOperations.lookupClassVariable(module, RubyContext.checkClassVariableName(this.getContext(), name2.toString(), this));
        }
    }

    @CoreMethod(names={"class_variable_defined?"}, required=1)
    public static abstract class ClassVariableDefinedNode
    extends CoreMethodNode {
        public ClassVariableDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClassVariableDefinedNode(ClassVariableDefinedNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isClassVariableDefined(RubyModule module, RubyString name2) {
            ClassVariableDefinedNode.notDesignedForCompilation();
            return module.getClassVariables().containsKey(name2.toString());
        }

        @Specialization
        public boolean isClassVariableDefined(RubyModule module, RubySymbol name2) {
            ClassVariableDefinedNode.notDesignedForCompilation();
            return module.getClassVariables().containsKey(name2.toString());
        }
    }

    @CoreMethod(names={"class_exec", "module_exec"}, argumentsAsArray=true, needsBlock=true)
    public static abstract class ClassExecNode
    extends CoreMethodNode {
        @Node.Child
        private YieldDispatchHeadNode yield;

        public ClassExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context);
        }

        public ClassExecNode(ClassExecNode prev) {
            super(prev);
            this.yield = prev.yield;
        }

        public abstract Object executeClassEval(VirtualFrame var1, RubyModule var2, Object[] var3, RubyProc var4);

        @Specialization
        public Object classExec(VirtualFrame frame, RubyModule self2, Object[] args2, RubyProc block) {
            ClassExecNode.notDesignedForCompilation();
            return this.yield.dispatchWithModifiedSelf(frame, block, self2, new Object[0]);
        }
    }

    @CoreMethod(names={"class_eval", "module_eval"}, optional=3, needsBlock=true)
    public static abstract class ClassEvalNode
    extends CoreMethodNode {
        @Node.Child
        private YieldDispatchHeadNode yield;

        public ClassEvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context);
        }

        public ClassEvalNode(ClassEvalNode prev) {
            super(prev);
            this.yield = prev.yield;
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule module, RubyString code, UndefinedPlaceholder file2, UndefinedPlaceholder line, UndefinedPlaceholder block) {
            ClassEvalNode.notDesignedForCompilation();
            Source source2 = Source.fromText((CharSequence)code.getBytes(), (String)"(eval)");
            return this.classEvalSource(frame, module, source2, code.getBytes().getEncoding());
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule module, RubyString code, RubyString file2, UndefinedPlaceholder line, UndefinedPlaceholder block) {
            ClassEvalNode.notDesignedForCompilation();
            Source source2 = Source.asPseudoFile((CharSequence)code.getBytes(), (String)file2.toString());
            return this.classEvalSource(frame, module, source2, code.getBytes().getEncoding());
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule module, RubyString code, RubyString file2, int line, UndefinedPlaceholder block) {
            ClassEvalNode.notDesignedForCompilation();
            Source source2 = Source.asPseudoFile((CharSequence)code.getBytes(), (String)file2.toString());
            return this.classEvalSource(frame, module, source2, code.getBytes().getEncoding());
        }

        private Object classEvalSource(VirtualFrame frame, RubyModule module, Source source2, Encoding encoding2) {
            return this.getContext().execute(this.getContext(), source2, encoding2, TranslatorDriver.ParserContext.MODULE, module, frame.materialize(), this, new NodeWrapper(){

                @Override
                public RubyNode wrap(RubyNode node) {
                    return new SetMethodDeclarationContext(node.getContext(), node.getSourceSection(), "class_eval", node);
                }
            });
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule self2, UndefinedPlaceholder code, UndefinedPlaceholder file2, UndefinedPlaceholder line, RubyProc block) {
            ClassEvalNode.notDesignedForCompilation();
            return this.yield.dispatchWithModifiedSelf(frame, block, self2, new Object[0]);
        }

        @Specialization
        public Object classEval(RubyModule self2, UndefinedPlaceholder code, UndefinedPlaceholder file2, UndefinedPlaceholder line, UndefinedPlaceholder block) {
            ClassEvalNode.notDesignedForCompilation();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(0, 1, 2, this));
        }
    }

    @CoreMethod(names={"attr_accessor", "attr"}, argumentsAsArray=true)
    public static abstract class AttrAccessorNode
    extends CoreMethodNode {
        public AttrAccessorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AttrAccessorNode(AttrAccessorNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass attrAccessor(RubyModule module, Object[] args2) {
            AttrAccessorNode.notDesignedForCompilation();
            SourceSection sourceSection = Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection();
            for (Object arg2 : args2) {
                if (!(arg2 instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                String accessorName = ((RubySymbol)arg2).toString();
                AttrAccessorNode.attrAccessor(this, this.getContext(), sourceSection, module, accessorName);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        public static void attrAccessor(RubyNode currentNode, RubyContext context, SourceSection sourceSection, RubyModule module, String name2) {
            CompilerDirectives.transferToInterpreter();
            AttrReaderNode.attrReader(currentNode, context, sourceSection, module, name2);
            AttrWriterNode.attrWriter(currentNode, context, sourceSection, module, name2);
        }
    }

    @CoreMethod(names={"attr_writer"}, argumentsAsArray=true)
    public static abstract class AttrWriterNode
    extends CoreMethodNode {
        public AttrWriterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AttrWriterNode(AttrWriterNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass attrWriter(RubyModule module, Object[] args2) {
            AttrWriterNode.notDesignedForCompilation();
            SourceSection sourceSection = Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection();
            for (Object arg2 : args2) {
                if (!(arg2 instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                String accessorName = ((RubySymbol)arg2).toString();
                AttrWriterNode.attrWriter(this, this.getContext(), sourceSection, module, accessorName);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        public static void attrWriter(RubyNode currentNode, RubyContext context, SourceSection sourceSection, RubyModule module, String name2) {
            CompilerDirectives.transferToInterpreter();
            CheckArityNode checkArity = new CheckArityNode(context, sourceSection, new Arity(1, 0, false, false));
            SelfNode self2 = new SelfNode(context, sourceSection);
            ReadPreArgumentNode readArgument = new ReadPreArgumentNode(context, sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR);
            WriteInstanceVariableNode writeInstanceVariable = new WriteInstanceVariableNode(context, sourceSection, "@" + name2, self2, readArgument, false);
            RubyNode block = SequenceNode.sequence(context, sourceSection, checkArity, writeInstanceVariable);
            String indicativeName = name2 + "(attr_writer)";
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, null, indicativeName, false, null, false);
            RubyRootNode rootNode = new RubyRootNode(context, sourceSection, null, sharedMethodInfo, block);
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
            InternalMethod method = new InternalMethod(sharedMethodInfo, name2 + "=", module, Visibility.PUBLIC, false, (CallTarget)callTarget, null);
            module.addMethod(currentNode, method);
        }
    }

    @CoreMethod(names={"attr_reader"}, argumentsAsArray=true)
    public static abstract class AttrReaderNode
    extends CoreMethodNode {
        public AttrReaderNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AttrReaderNode(AttrReaderNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass attrReader(RubyModule module, Object[] args2) {
            AttrReaderNode.notDesignedForCompilation();
            SourceSection sourceSection = Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection();
            for (Object arg2 : args2) {
                if (!(arg2 instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                String accessorName = ((RubySymbol)arg2).toString();
                AttrReaderNode.attrReader(this, this.getContext(), sourceSection, module, accessorName);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        public static void attrReader(RubyNode currentNode, RubyContext context, SourceSection sourceSection, RubyModule module, String name2) {
            CompilerDirectives.transferToInterpreter();
            CheckArityNode checkArity = new CheckArityNode(context, sourceSection, new Arity(0, 0, false, false));
            SelfNode self2 = new SelfNode(context, sourceSection);
            ReadInstanceVariableNode readInstanceVariable = new ReadInstanceVariableNode(context, sourceSection, "@" + name2, self2, false);
            RubyNode block = SequenceNode.sequence(context, sourceSection, checkArity, readInstanceVariable);
            String indicativeName = name2 + "(attr_reader)";
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, null, indicativeName, false, null, false);
            RubyRootNode rootNode = new RubyRootNode(context, sourceSection, null, sharedMethodInfo, block);
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
            InternalMethod method = new InternalMethod(sharedMethodInfo, name2, module, Visibility.PUBLIC, false, (CallTarget)callTarget, null);
            module.addMethod(currentNode, method);
        }
    }

    @CoreMethod(names={"append_features"}, required=1)
    public static abstract class AppendFeaturesNode
    extends CoreMethodNode {
        public AppendFeaturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AppendFeaturesNode(AppendFeaturesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass appendFeatures(RubyModule module, RubyModule other) {
            AppendFeaturesNode.notDesignedForCompilation();
            module.appendFeatures(this, other);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"ancestors"})
    public static abstract class AncestorsNode
    extends CoreMethodNode {
        public AncestorsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AncestorsNode(AncestorsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray ancestors(RubyModule self2) {
            AncestorsNode.notDesignedForCompilation();
            ArrayList<RubyModule> ancestors2 = new ArrayList<RubyModule>();
            for (RubyModule module : self2.ancestors()) {
                ancestors2.add(module);
            }
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), ancestors2.toArray(new Object[ancestors2.size()]));
        }
    }

    @CoreMethod(names={"alias_method"}, required=2)
    public static abstract class AliasMethodNode
    extends CoreMethodNode {
        public AliasMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AliasMethodNode(AliasMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule aliasMethod(RubyModule module, RubySymbol newName, RubySymbol oldName) {
            AliasMethodNode.notDesignedForCompilation();
            module.alias(this, newName.toString(), oldName.toString());
            return module;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        @Node.Child
        private IsSubclassOfNode subclassNode;
        @Node.Child
        private BooleanCastNode booleanCastNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        private Object isSubclass(VirtualFrame frame, RubyModule self2, RubyModule other) {
            if (this.subclassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.subclassNode = (IsSubclassOfNode)this.insert(ModuleNodesFactory.IsSubclassOfNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.subclassNode.executeIsSubclassOf(frame, self2, other);
        }

        private boolean booleanCast(VirtualFrame frame, Object value2) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.booleanCastNode.executeBoolean(frame, value2);
        }

        @Specialization
        public Object compare(VirtualFrame frame, RubyModule self2, RubyModule other) {
            CompareNode.notDesignedForCompilation();
            if (self2 == other) {
                return 0;
            }
            Object isSubclass = this.isSubclass(frame, self2, other);
            if (isSubclass instanceof RubyNilClass) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            if (this.booleanCast(frame, isSubclass)) {
                return -1;
            }
            return 1;
        }

        @Specialization
        public Object compare(VirtualFrame frame, RubyModule self2, RubyBasicObject other) {
            CompareNode.notDesignedForCompilation();
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class IsSubclassOfNode
    extends CoreMethodNode {
        public IsSubclassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IsSubclassOfNode(IsSubclassOfNode prev) {
            super(prev);
        }

        public abstract Object executeIsSubclassOf(VirtualFrame var1, RubyModule var2, RubyModule var3);

        @Specialization
        public Object isSubclassOf(VirtualFrame frame, RubyModule self2, RubyModule other) {
            IsSubclassOfNode.notDesignedForCompilation();
            if (self2 == other || ModuleOperations.includesModule(self2, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self2)) {
                return false;
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization
        public Object isSubclassOf(VirtualFrame frame, RubyModule self2, RubyBasicObject other) {
            IsSubclassOfNode.notDesignedForCompilation();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class ContainsInstanceNode
    extends CoreMethodNode {
        public ContainsInstanceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ContainsInstanceNode(ContainsInstanceNode prev) {
            super(prev);
        }

        @Specialization
        public boolean containsInstance(RubyModule module, RubyBasicObject instance) {
            ContainsInstanceNode.notDesignedForCompilation();
            return ModuleOperations.includesModule(instance.getMetaClass(), module);
        }

        @Specialization
        public boolean containsInstance(RubyModule module, Object instance) {
            ContainsInstanceNode.notDesignedForCompilation();
            return ModuleOperations.includesModule(this.getContext().getCoreLibrary().getMetaClass(instance), module);
        }
    }
}

