/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.MainNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyModule;

@GeneratedBy(value=MainNodes.class)
public final class MainNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(PublicNodeFactory.getInstance(), PrivateNodeFactory.getInstance());
    }

    @GeneratedBy(value=MainNodes.PrivateNode.class)
    public static final class PrivateNodeFactory
    extends NodeFactoryBase<MainNodes.PrivateNode> {
        private static PrivateNodeFactory privateNodeFactoryInstance;

        private PrivateNodeFactory() {
            super(MainNodes.PrivateNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MainNodes.PrivateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MainNodes.PrivateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PrivateUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MainNodes.PrivateNode> getInstance() {
            if (privateNodeFactoryInstance == null) {
                privateNodeFactoryInstance = new PrivateNodeFactory();
            }
            return privateNodeFactoryInstance;
        }

        @GeneratedBy(value=MainNodes.PrivateNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivatePolymorphicNode
        extends PrivateBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            PrivatePolymorphicNode(PrivateBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MainNodes.PrivateNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateObjectArrayNode
        extends PrivateBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateObjectArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object[].class}, 0, 0);

            PrivateObjectArrayNode(PrivateBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof Object[]");
                }
                return super.doPrivate(frameValue, arguments0Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    Object[] arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments0Value);
                    return super.doPrivate(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MainNodes.PrivateNode create0(MainNodes.PrivateNode current2) {
                return new PrivateObjectArrayNode((PrivateBaseNode)current2);
            }
        }

        @GeneratedBy(value=MainNodes.PrivateNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateUninitializedNode
        extends PrivateBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PrivateUninitializedNode(PrivateBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                PrivateBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateBaseNode rootNode = (PrivateBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PrivateBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MainNodes.PrivateNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PrivateUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MainNodes.PrivateNode.class)
        private static abstract class PrivateBaseNode
        extends MainNodes.PrivateNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PrivateBaseNode next0;

            PrivateBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PrivateBaseNode(PrivateBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                PrivateBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new PrivateUninitializedNode(this);
                    ((PrivateUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PrivateBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PrivateBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (PrivateBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PrivateUninitializedNode(this), (Node)new PrivatePolymorphicNode(this), (DSLNode)((PrivateBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    return (PrivateBaseNode)PrivateObjectArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((PrivateBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (PrivateBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MainNodes.PublicNode.class)
    public static final class PublicNodeFactory
    extends NodeFactoryBase<MainNodes.PublicNode> {
        private static PublicNodeFactory publicNodeFactoryInstance;

        private PublicNodeFactory() {
            super(MainNodes.PublicNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MainNodes.PublicNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MainNodes.PublicNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PublicUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MainNodes.PublicNode> getInstance() {
            if (publicNodeFactoryInstance == null) {
                publicNodeFactoryInstance = new PublicNodeFactory();
            }
            return publicNodeFactoryInstance;
        }

        @GeneratedBy(value=MainNodes.PublicNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicPolymorphicNode
        extends PublicBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            PublicPolymorphicNode(PublicBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MainNodes.PublicNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicObjectArrayNode
        extends PublicBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicObjectArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object[].class}, 0, 0);

            PublicObjectArrayNode(PublicBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof Object[]");
                }
                return super.doPublic(frameValue, arguments0Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    Object[] arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments0Value);
                    return super.doPublic(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MainNodes.PublicNode create0(MainNodes.PublicNode current2) {
                return new PublicObjectArrayNode((PublicBaseNode)current2);
            }
        }

        @GeneratedBy(value=MainNodes.PublicNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicUninitializedNode
        extends PublicBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PublicUninitializedNode(PublicBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value2;
                try {
                    value2 = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                PublicBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicBaseNode rootNode = (PublicBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PublicBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MainNodes.PublicNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PublicUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MainNodes.PublicNode.class)
        private static abstract class PublicBaseNode
        extends MainNodes.PublicNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PublicBaseNode next0;

            PublicBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PublicBaseNode(PublicBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                PublicBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new PublicUninitializedNode(this);
                    ((PublicUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PublicBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PublicBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (PublicBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PublicUninitializedNode(this), (Node)new PublicPolymorphicNode(this), (DSLNode)((PublicBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    return (PublicBaseNode)PublicObjectArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((PublicBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (PublicBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

