/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.util.RegexpOptions;

public class InteroplatedRegexpNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] children;
    private final RegexpOptions options;
    @Node.Child
    private CallDispatchHeadNode toS;

    public InteroplatedRegexpNode(RubyContext context, SourceSection sourceSection, RubyNode[] children, RegexpOptions options2) {
        super(context, sourceSection);
        this.children = children;
        this.options = options2;
        this.toS = DispatchHeadNodeFactory.createMethodCall(context);
    }

    @Override
    public org.jruby.truffle.runtime.core.RubyRegexp executeRubyRegexp(VirtualFrame frame) {
        InteroplatedRegexpNode.notDesignedForCompilation();
        IRubyObject[] strings = new RubyString[this.children.length];
        for (int n = 0; n < this.children.length; ++n) {
            Object child = this.children[n].execute(frame);
            strings[n] = RubyString.newString(this.getContext().getRuntime(), ((org.jruby.truffle.runtime.core.RubyString)this.toS.call(frame, child, "to_s", null, new Object[0])).getBytes());
        }
        RubyString preprocessed = RubyRegexp.preprocessDRegexp(this.getContext().getRuntime(), strings, this.options);
        org.jruby.truffle.runtime.core.RubyRegexp regexp2 = new org.jruby.truffle.runtime.core.RubyRegexp(this, this.getContext().getCoreLibrary().getRegexpClass(), preprocessed.getByteList(), this.options.toOptions());
        if (this.options.isEncodingNone()) {
            if (!BodyTranslator.all7Bit(preprocessed.getByteList().bytes())) {
                regexp2.forceEncoding((RubyEncoding)this.getContext().getCoreLibrary().getEncodingClass().getConstants().get("ASCII_8BIT").getValue());
            } else {
                regexp2.forceEncoding((RubyEncoding)this.getContext().getCoreLibrary().getEncodingClass().getConstants().get("US_ASCII").getValue());
            }
        }
        return regexp2;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeRubyRegexp(frame);
    }
}

