/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyFile;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="IO")
public abstract class IONodes {

    @CoreMethod(names={"readlines"}, onSingleton=true, required=1)
    public static abstract class ReadLinesNode
    extends CoreMethodNode {
        public ReadLinesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReadLinesNode(ReadLinesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray readLines(RubyString file2) {
            ReadLinesNode.notDesignedForCompilation();
            ArrayList<RubyString> lines2 = new ArrayList<RubyString>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2.toString()), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    lines2.add(this.getContext().makeString(line));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), lines2.toArray(new Object[lines2.size()]));
        }
    }

    @CoreMethod(names={"open"}, onSingleton=true, needsBlock=true, required=2)
    public static abstract class OpenNode
    extends YieldingCoreMethodNode {
        public OpenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public OpenNode(OpenNode prev) {
            super(prev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object open(VirtualFrame frame, RubyString fileName, RubyString mode2, RubyProc block) {
            OpenNode.notDesignedForCompilation();
            RubyFile file2 = RubyFile.open(this.getContext(), fileName.toString(), mode2.toString());
            if (block != null) {
                try {
                    this.yield(frame, block, file2);
                }
                finally {
                    file2.close();
                }
            }
            return file2;
        }
    }
}

