/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.HashGuards;
import org.jruby.truffle.nodes.core.HashNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=HashNodes.class)
public final class HashNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(EqualNodeFactory.getInstance(), ConstructNodeFactory.getInstance(), GetIndexNodeFactory.getInstance(), SetIndexNodeFactory.getInstance(), ClearNodeFactory.getInstance(), DeleteNodeFactory.getInstance(), EachNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InspectNodeFactory.getInstance(), KeyNodeFactory.getInstance(), KeysNodeFactory.getInstance(), MapNodeFactory.getInstance(), MergeNodeFactory.getInstance(), DefaultNodeFactory.getInstance(), SizeNodeFactory.getInstance(), ValuesNodeFactory.getInstance(), ToArrayNodeFactory.getInstance());
    }

    @GeneratedBy(value=HashNodes.ToArrayNode.class)
    public static final class ToArrayNodeFactory
    extends NodeFactoryBase<HashNodes.ToArrayNode> {
        private static ToArrayNodeFactory toArrayNodeFactoryInstance;

        private ToArrayNodeFactory() {
            super(HashNodes.ToArrayNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.ToArrayNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToArrayNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.ToArrayNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToArrayUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.ToArrayNode> getInstance() {
            if (toArrayNodeFactoryInstance == null) {
                toArrayNodeFactoryInstance = new ToArrayNodeFactory();
            }
            return toArrayNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.ToArrayNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToArrayPolymorphicNode
        extends ToArrayBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToArrayPolymorphicNode(ToArrayBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.ToArrayNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToArrayRubyHash2Node
        extends ToArrayBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToArrayRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ToArrayRubyHash2Node(ToArrayBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.toArrayBuckets(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.toArrayBuckets(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ToArrayNode create0(HashNodes.ToArrayNode current2) {
                return new ToArrayRubyHash2Node((ToArrayBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.ToArrayNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToArrayRubyHash1Node
        extends ToArrayBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToArrayRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ToArrayRubyHash1Node(ToArrayBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.toArrayPackedArray(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.toArrayPackedArray(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ToArrayNode create0(HashNodes.ToArrayNode current2) {
                return new ToArrayRubyHash1Node((ToArrayBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.ToArrayNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToArrayRubyHash0Node
        extends ToArrayBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToArrayRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ToArrayRubyHash0Node(ToArrayBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.toArrayNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.toArrayNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ToArrayNode create0(HashNodes.ToArrayNode current2) {
                return new ToArrayRubyHash0Node((ToArrayBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.ToArrayNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToArrayUninitializedNode
        extends ToArrayBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToArrayUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToArrayUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToArrayUninitializedNode(ToArrayBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToArrayBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToArrayBaseNode rootNode = (ToArrayBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToArrayBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ToArrayNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToArrayUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.ToArrayNode.class)
        private static abstract class ToArrayBaseNode
        extends HashNodes.ToArrayNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToArrayBaseNode next0;

            ToArrayBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToArrayBaseNode(ToArrayBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToArrayBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToArrayBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToArrayUninitializedNode(this);
                    ((ToArrayUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToArrayBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToArrayBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ToArrayBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToArrayUninitializedNode(this), (Node)new ToArrayPolymorphicNode(this), (DSLNode)((ToArrayBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToArrayBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (ToArrayBaseNode)ToArrayRubyHash0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (ToArrayBaseNode)ToArrayRubyHash1Node.create0(this);
                    }
                    return (ToArrayBaseNode)ToArrayRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToArrayBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToArrayBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.ValuesNode.class)
    public static final class ValuesNodeFactory
    extends NodeFactoryBase<HashNodes.ValuesNode> {
        private static ValuesNodeFactory valuesNodeFactoryInstance;

        private ValuesNodeFactory() {
            super(HashNodes.ValuesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.ValuesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ValuesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.ValuesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ValuesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.ValuesNode> getInstance() {
            if (valuesNodeFactoryInstance == null) {
                valuesNodeFactoryInstance = new ValuesNodeFactory();
            }
            return valuesNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.ValuesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ValuesPolymorphicNode
        extends ValuesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ValuesPolymorphicNode(ValuesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.ValuesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ValuesRubyHash2Node
        extends ValuesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ValuesRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ValuesRubyHash2Node(ValuesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.valuesBuckets(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.valuesBuckets(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ValuesNode create0(HashNodes.ValuesNode current2) {
                return new ValuesRubyHash2Node((ValuesBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.ValuesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ValuesRubyHash1Node
        extends ValuesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ValuesRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ValuesRubyHash1Node(ValuesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.valuesPackedArray(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.valuesPackedArray(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ValuesNode create0(HashNodes.ValuesNode current2) {
                return new ValuesRubyHash1Node((ValuesBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.ValuesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ValuesRubyHash0Node
        extends ValuesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ValuesRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ValuesRubyHash0Node(ValuesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.valuesNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.valuesNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ValuesNode create0(HashNodes.ValuesNode current2) {
                return new ValuesRubyHash0Node((ValuesBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.ValuesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ValuesUninitializedNode
        extends ValuesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ValuesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ValuesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ValuesUninitializedNode(ValuesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ValuesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ValuesBaseNode rootNode = (ValuesBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ValuesBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ValuesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ValuesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.ValuesNode.class)
        private static abstract class ValuesBaseNode
        extends HashNodes.ValuesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ValuesBaseNode next0;

            ValuesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ValuesBaseNode(ValuesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ValuesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ValuesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ValuesUninitializedNode(this);
                    ((ValuesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ValuesBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ValuesBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ValuesBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ValuesUninitializedNode(this), (Node)new ValuesPolymorphicNode(this), (DSLNode)((ValuesBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ValuesBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (ValuesBaseNode)ValuesRubyHash0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (ValuesBaseNode)ValuesRubyHash1Node.create0(this);
                    }
                    return (ValuesBaseNode)ValuesRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ValuesBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ValuesBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<HashNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(HashNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SizePolymorphicNode
        extends SizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SizePolymorphicNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubyHash1Node
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            SizeRubyHash1Node(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value)) {
                    return super.sizePackedArray(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isNull] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.sizePackedArray(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.SizeNode create0(HashNodes.SizeNode current2) {
                return new SizeRubyHash1Node((SizeBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubyHash0Node
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            SizeRubyHash0Node(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.sizeNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.sizeNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.SizeNode create0(HashNodes.SizeNode current2) {
                return new SizeRubyHash0Node((SizeBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SizeUninitializedNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SizeUninitializedNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SizeBaseNode rootNode = (SizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.SizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        private static abstract class SizeBaseNode
        extends HashNodes.SizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SizeBaseNode next0;

            SizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SizeBaseNode(SizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SizeUninitializedNode(this);
                    ((SizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SizeBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SizeUninitializedNode(this), (Node)new SizePolymorphicNode(this), (DSLNode)((SizeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (SizeBaseNode)SizeRubyHash0Node.create0(this);
                    }
                    return (SizeBaseNode)SizeRubyHash1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.DefaultNode.class)
    public static final class DefaultNodeFactory
    extends NodeFactoryBase<HashNodes.DefaultNode> {
        private static DefaultNodeFactory defaultNodeFactoryInstance;

        private DefaultNodeFactory() {
            super(HashNodes.DefaultNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.DefaultNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DefaultNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.DefaultNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DefaultUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.DefaultNode> getInstance() {
            if (defaultNodeFactoryInstance == null) {
                defaultNodeFactoryInstance = new DefaultNodeFactory();
            }
            return defaultNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.DefaultNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DefaultPolymorphicNode
        extends DefaultBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DefaultPolymorphicNode(DefaultBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.DefaultNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefaultRubyHashObjectNode
        extends DefaultBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefaultRubyHashObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            DefaultRubyHashObjectNode(DefaultBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.defaultElement(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    return super.defaultElement(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.DefaultNode create0(HashNodes.DefaultNode current2) {
                return new DefaultRubyHashObjectNode((DefaultBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.DefaultNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefaultRubyHashUndefinedPlaceholderNode
        extends DefaultBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefaultRubyHashUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, UndefinedPlaceholder.class}, 0, 0);

            DefaultRubyHashUndefinedPlaceholderNode(DefaultBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.defaultElement(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.defaultElement(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.DefaultNode create0(HashNodes.DefaultNode current2) {
                return new DefaultRubyHashUndefinedPlaceholderNode((DefaultBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.DefaultNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DefaultUninitializedNode
        extends DefaultBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefaultUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DefaultUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DefaultUninitializedNode(DefaultBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DefaultBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DefaultBaseNode rootNode = (DefaultBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DefaultBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.DefaultNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DefaultUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.DefaultNode.class)
        private static abstract class DefaultBaseNode
        extends HashNodes.DefaultNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DefaultBaseNode next0;

            DefaultBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DefaultBaseNode(DefaultBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                DefaultBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DefaultBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DefaultUninitializedNode(this);
                    ((DefaultUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DefaultBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DefaultBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DefaultBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DefaultUninitializedNode(this), (Node)new DefaultPolymorphicNode(this), (DSLNode)((DefaultBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DefaultBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (DefaultBaseNode)DefaultRubyHashUndefinedPlaceholderNode.create0(this);
                    }
                    return (DefaultBaseNode)DefaultRubyHashObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DefaultBaseNode otherCast = (DefaultBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DefaultBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.MergeNode.class)
    public static final class MergeNodeFactory
    extends NodeFactoryBase<HashNodes.MergeNode> {
        private static MergeNodeFactory mergeNodeFactoryInstance;

        private MergeNodeFactory() {
            super(HashNodes.MergeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.MergeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MergeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.MergeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MergeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.MergeNode> getInstance() {
            if (mergeNodeFactoryInstance == null) {
                mergeNodeFactoryInstance = new MergeNodeFactory();
            }
            return mergeNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MergePolymorphicNode
        extends MergeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MergePolymorphicNode(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MergeRubyHash2Node
        extends MergeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MergeRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            MergeRubyHash2Node(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash");
                }
                return super.mergeBucketsBuckets(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    return super.mergeBucketsBuckets(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MergeNode create0(HashNodes.MergeNode current2) {
                return new MergeRubyHash2Node((MergeBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MergeRubyHash1Node
        extends MergeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MergeRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            MergeRubyHash1Node(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash");
                }
                if (!(HashGuards.isNull(arguments0Value) || HashGuards.isBuckets(arguments0Value) || HashGuards.isNull(arguments1Value) || HashGuards.isBuckets(arguments1Value))) {
                    return super.mergePackedArrayPackedArray(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets, !isNull, !isBuckets] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (!(HashGuards.isNull(arguments0ValueCast) || HashGuards.isBuckets(arguments0ValueCast) || HashGuards.isNull(arguments1ValueCast) || HashGuards.isBuckets(arguments1ValueCast))) {
                        return super.mergePackedArrayPackedArray(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MergeNode create0(HashNodes.MergeNode current2) {
                return new MergeRubyHash1Node((MergeBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MergeRubyHash0Node
        extends MergeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MergeRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            MergeRubyHash0Node(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value) && HashGuards.isNull(arguments1Value)) {
                    return super.mergePackedArrayNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets, isNull] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (!HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast) && HashGuards.isNull(arguments1ValueCast)) {
                        return super.mergePackedArrayNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MergeNode create0(HashNodes.MergeNode current2) {
                return new MergeRubyHash0Node((MergeBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MergeUninitializedNode
        extends MergeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MergeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MergeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MergeUninitializedNode(MergeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyHash executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MergeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MergeBaseNode rootNode = (MergeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MergeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MergeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MergeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        private static abstract class MergeBaseNode
        extends HashNodes.MergeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MergeBaseNode next0;

            MergeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MergeBaseNode(MergeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyHash executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyHash rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                MergeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MergeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MergeUninitializedNode(this);
                    ((MergeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MergeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MergeBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MergeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MergeUninitializedNode(this), (Node)new MergePolymorphicNode(this), (DSLNode)((MergeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MergeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (!HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast)) {
                        if (HashGuards.isNull(arguments1ValueCast)) {
                            return (MergeBaseNode)MergeRubyHash0Node.create0(this);
                        }
                        if (!HashGuards.isBuckets(arguments1ValueCast)) {
                            return (MergeBaseNode)MergeRubyHash1Node.create0(this);
                        }
                    }
                    return (MergeBaseNode)MergeRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MergeBaseNode otherCast = (MergeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MergeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.MapNode.class)
    public static final class MapNodeFactory
    extends NodeFactoryBase<HashNodes.MapNode> {
        private static MapNodeFactory mapNodeFactoryInstance;

        private MapNodeFactory() {
            super(HashNodes.MapNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.MapNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MapNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.MapNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MapUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.MapNode> getInstance() {
            if (mapNodeFactoryInstance == null) {
                mapNodeFactoryInstance = new MapNodeFactory();
            }
            return mapNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MapPolymorphicNode
        extends MapBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MapPolymorphicNode(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyHash1Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            MapRubyHash1Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.mapBuckets(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (HashGuards.isBuckets(arguments0ValueCast)) {
                        return super.mapBuckets(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MapNode create0(HashNodes.MapNode current2) {
                return new MapRubyHash1Node((MapBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyHash0Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            MapRubyHash0Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.mapPackedArray(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (!HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast)) {
                        return super.mapPackedArray(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MapNode create0(HashNodes.MapNode current2) {
                return new MapRubyHash0Node((MapBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MapUninitializedNode
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MapUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MapUninitializedNode(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MapBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MapBaseNode rootNode = (MapBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MapBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.MapNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MapUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        private static abstract class MapBaseNode
        extends HashNodes.MapNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MapBaseNode next0;

            MapBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MapBaseNode(MapBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                MapBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MapBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MapUninitializedNode(this);
                    ((MapUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MapBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MapBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MapBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MapUninitializedNode(this), (Node)new MapPolymorphicNode(this), (DSLNode)((MapBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MapBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (!HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast)) {
                        return (MapBaseNode)MapRubyHash0Node.create0(this);
                    }
                    if (HashGuards.isBuckets(arguments0ValueCast)) {
                        return (MapBaseNode)MapRubyHash1Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MapBaseNode otherCast = (MapBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MapBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.KeysNode.class)
    public static final class KeysNodeFactory
    extends NodeFactoryBase<HashNodes.KeysNode> {
        private static KeysNodeFactory keysNodeFactoryInstance;

        private KeysNodeFactory() {
            super(HashNodes.KeysNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.KeysNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KeysNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.KeysNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return KeysUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.KeysNode> getInstance() {
            if (keysNodeFactoryInstance == null) {
                keysNodeFactoryInstance = new KeysNodeFactory();
            }
            return keysNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.KeysNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class KeysPolymorphicNode
        extends KeysBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            KeysPolymorphicNode(KeysBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.KeysNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KeysRubyHash2Node
        extends KeysBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KeysRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            KeysRubyHash2Node(KeysBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.keysBuckets(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.keysBuckets(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.KeysNode create0(HashNodes.KeysNode current2) {
                return new KeysRubyHash2Node((KeysBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.KeysNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KeysRubyHash1Node
        extends KeysBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KeysRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            KeysRubyHash1Node(KeysBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.keysPackedArray(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.keysPackedArray(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.KeysNode create0(HashNodes.KeysNode current2) {
                return new KeysRubyHash1Node((KeysBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.KeysNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KeysRubyHash0Node
        extends KeysBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KeysRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            KeysRubyHash0Node(KeysBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.keysNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.keysNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.KeysNode create0(HashNodes.KeysNode current2) {
                return new KeysRubyHash0Node((KeysBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.KeysNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class KeysUninitializedNode
        extends KeysBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KeysUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            KeysUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            KeysUninitializedNode(KeysBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                KeysBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    KeysBaseNode rootNode = (KeysBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((KeysBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.KeysNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new KeysUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.KeysNode.class)
        private static abstract class KeysBaseNode
        extends HashNodes.KeysNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected KeysBaseNode next0;

            KeysBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            KeysBaseNode(KeysBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                KeysBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                KeysBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new KeysUninitializedNode(this);
                    ((KeysUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (KeysBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = KeysBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (KeysBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new KeysUninitializedNode(this), (Node)new KeysPolymorphicNode(this), (DSLNode)((KeysBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final KeysBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (KeysBaseNode)KeysRubyHash0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (KeysBaseNode)KeysRubyHash1Node.create0(this);
                    }
                    return (KeysBaseNode)KeysRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((KeysBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (KeysBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.KeyNode.class)
    public static final class KeyNodeFactory
    extends NodeFactoryBase<HashNodes.KeyNode> {
        private static KeyNodeFactory keyNodeFactoryInstance;

        private KeyNodeFactory() {
            super(HashNodes.KeyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.KeyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KeyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.KeyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return KeyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.KeyNode> getInstance() {
            if (keyNodeFactoryInstance == null) {
                keyNodeFactoryInstance = new KeyNodeFactory();
            }
            return keyNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.KeyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class KeyPolymorphicNode
        extends KeyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            KeyPolymorphicNode(KeyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.KeyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KeyRubyHash2Node
        extends KeyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KeyRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            KeyRubyHash2Node(KeyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.keyBuckets(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.keyBuckets(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.KeyNode create0(HashNodes.KeyNode current2) {
                return new KeyRubyHash2Node((KeyBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.KeyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KeyRubyHash1Node
        extends KeyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KeyRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            KeyRubyHash1Node(KeyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.keyPackedArray(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.keyPackedArray(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.KeyNode create0(HashNodes.KeyNode current2) {
                return new KeyRubyHash1Node((KeyBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.KeyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KeyRubyHash0Node
        extends KeyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KeyRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            KeyRubyHash0Node(KeyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (HashGuards.isNull(arguments0Value)) {
                    return super.keyNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.keyNull(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.KeyNode create0(HashNodes.KeyNode current2) {
                return new KeyRubyHash0Node((KeyBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.KeyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class KeyUninitializedNode
        extends KeyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KeyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            KeyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            KeyUninitializedNode(KeyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                KeyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    KeyBaseNode rootNode = (KeyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((KeyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.KeyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new KeyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.KeyNode.class)
        private static abstract class KeyBaseNode
        extends HashNodes.KeyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected KeyBaseNode next0;

            KeyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            KeyBaseNode(KeyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                KeyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                KeyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new KeyUninitializedNode(this);
                    ((KeyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (KeyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = KeyBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (KeyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new KeyUninitializedNode(this), (Node)new KeyPolymorphicNode(this), (DSLNode)((KeyBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final KeyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (KeyBaseNode)KeyRubyHash0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (KeyBaseNode)KeyRubyHash1Node.create0(this);
                    }
                    return (KeyBaseNode)KeyRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    KeyBaseNode otherCast = (KeyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (KeyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.InspectNode.class)
    public static final class InspectNodeFactory
    extends NodeFactoryBase<HashNodes.InspectNode> {
        private static InspectNodeFactory inspectNodeFactoryInstance;

        private InspectNodeFactory() {
            super(HashNodes.InspectNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.InspectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InspectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.InspectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InspectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.InspectNode> getInstance() {
            if (inspectNodeFactoryInstance == null) {
                inspectNodeFactoryInstance = new InspectNodeFactory();
            }
            return inspectNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InspectPolymorphicNode
        extends InspectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            InspectPolymorphicNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InspectRubyHash1Node
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            InspectRubyHash1Node(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                return super.inspectPackedArray(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    return super.inspectPackedArray(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.InspectNode create0(HashNodes.InspectNode current2) {
                return new InspectRubyHash1Node((InspectBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InspectRubyHash0Node
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            InspectRubyHash0Node(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.inspectNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.inspectNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.InspectNode create0(HashNodes.InspectNode current2) {
                return new InspectRubyHash0Node((InspectBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InspectUninitializedNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InspectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InspectUninitializedNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InspectBaseNode rootNode = (InspectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InspectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.InspectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InspectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.InspectNode.class)
        private static abstract class InspectBaseNode
        extends HashNodes.InspectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InspectBaseNode next0;

            InspectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InspectBaseNode(InspectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                InspectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new InspectUninitializedNode(this);
                    ((InspectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InspectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InspectBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (InspectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InspectUninitializedNode(this), (Node)new InspectPolymorphicNode(this), (DSLNode)((InspectBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InspectBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (InspectBaseNode)InspectRubyHash0Node.create0(this);
                    }
                    return (InspectBaseNode)InspectRubyHash1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((InspectBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (InspectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<HashNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(HashNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeCopyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeCopyPolymorphicNode
        extends InitializeCopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializeCopyPolymorphicNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyHash2Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            InitializeCopyRubyHash2Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash");
                }
                if (HashGuards.isBuckets(arguments1Value)) {
                    return super.dupBuckets(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (HashGuards.isBuckets(arguments1ValueCast)) {
                        return super.dupBuckets(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.InitializeCopyNode create0(HashNodes.InitializeCopyNode current2) {
                return new InitializeCopyRubyHash2Node((InitializeCopyBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyHash1Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            InitializeCopyRubyHash1Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments1Value) && !HashGuards.isBuckets(arguments1Value)) {
                    return super.dupPackedArray(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (!HashGuards.isNull(arguments1ValueCast) && !HashGuards.isBuckets(arguments1ValueCast)) {
                        return super.dupPackedArray(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.InitializeCopyNode create0(HashNodes.InitializeCopyNode current2) {
                return new InitializeCopyRubyHash1Node((InitializeCopyBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyHash0Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            InitializeCopyRubyHash0Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments1Value)) {
                    return super.dupNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (HashGuards.isNull(arguments1ValueCast)) {
                        return super.dupNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.InitializeCopyNode create0(HashNodes.InitializeCopyNode current2) {
                return new InitializeCopyRubyHash0Node((InitializeCopyBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeCopyUninitializedNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeCopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeCopyUninitializedNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyHash executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeCopyBaseNode rootNode = (InitializeCopyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeCopyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.InitializeCopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeCopyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        private static abstract class InitializeCopyBaseNode
        extends HashNodes.InitializeCopyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeCopyBaseNode next0;

            InitializeCopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeCopyBaseNode(InitializeCopyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyHash executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyHash rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                InitializeCopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeCopyUninitializedNode(this);
                    ((InitializeCopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeCopyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InitializeCopyBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeCopyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeCopyUninitializedNode(this), (Node)new InitializeCopyPolymorphicNode(this), (DSLNode)((InitializeCopyBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeCopyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (HashGuards.isNull(arguments1ValueCast)) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyHash0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments1ValueCast)) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyHash1Node.create0(this);
                    }
                    return (InitializeCopyBaseNode)InitializeCopyRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeCopyBaseNode otherCast = (InitializeCopyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeCopyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<HashNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(HashNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyHashObjectUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyHashObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyHashObjectUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.initialize(arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.InitializeNode create0(HashNodes.InitializeNode current2) {
                return new InitializeRubyHashObjectUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyHashUndefinedPlaceholderRubyProcNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyHashUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            InitializeRubyHashUndefinedPlaceholderRubyProcNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.InitializeNode create0(HashNodes.InitializeNode current2) {
                return new InitializeRubyHashUndefinedPlaceholderRubyProcNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyHashUndefinedPlaceholderUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyHashUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyHashUndefinedPlaceholderUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.InitializeNode create0(HashNodes.InitializeNode current2) {
                return new InitializeRubyHashUndefinedPlaceholderUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = (InitializeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends HashNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InitializeBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (InitializeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeUninitializedNode(this), (Node)new InitializePolymorphicNode(this), (DSLNode)((InitializeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (InitializeBaseNode)InitializeRubyHashUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                            return (InitializeBaseNode)InitializeRubyHashUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (InitializeBaseNode)InitializeRubyHashObjectUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<HashNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(HashNodes.EmptyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.EmptyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EmptyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.EmptyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EmptyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EmptyPolymorphicNode
        extends EmptyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EmptyPolymorphicNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EmptyRubyHash1Node
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            EmptyRubyHash1Node(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value)) {
                    return super.emptyPackedArray(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isNull] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.emptyPackedArray(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.EmptyNode create0(HashNodes.EmptyNode current2) {
                return new EmptyRubyHash1Node((EmptyBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EmptyRubyHash0Node
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            EmptyRubyHash0Node(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.emptyNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.emptyNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.EmptyNode create0(HashNodes.EmptyNode current2) {
                return new EmptyRubyHash0Node((EmptyBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EmptyUninitializedNode
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EmptyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EmptyUninitializedNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EmptyBaseNode rootNode = (EmptyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EmptyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.EmptyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EmptyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        private static abstract class EmptyBaseNode
        extends HashNodes.EmptyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EmptyBaseNode next0;

            EmptyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EmptyBaseNode(EmptyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                EmptyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EmptyUninitializedNode(this);
                    ((EmptyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EmptyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EmptyBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (EmptyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EmptyUninitializedNode(this), (Node)new EmptyPolymorphicNode(this), (DSLNode)((EmptyBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EmptyBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (EmptyBaseNode)EmptyRubyHash0Node.create0(this);
                    }
                    return (EmptyBaseNode)EmptyRubyHash1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EmptyBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EmptyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<HashNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(HashNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachPolymorphicNode
        extends EachBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachPolymorphicNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyHash2Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            EachRubyHash2Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.eachBuckets(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (HashGuards.isBuckets(arguments0ValueCast)) {
                        return super.eachBuckets(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EachNode create0(HashNodes.EachNode current2) {
                return new EachRubyHash2Node((EachBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyHash1Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            EachRubyHash1Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.eachPackedArray(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (!HashGuards.isNull(arguments0ValueCast) && !HashGuards.isBuckets(arguments0ValueCast)) {
                        return super.eachPackedArray(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EachNode create0(HashNodes.EachNode current2) {
                return new EachRubyHash1Node((EachBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyHash0Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyProc.class}, 0, 0);

            EachRubyHash0Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.eachNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return super.eachNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EachNode create0(HashNodes.EachNode current2) {
                return new EachRubyHash0Node((EachBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachUninitializedNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachUninitializedNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyHash executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachBaseNode rootNode = (EachBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EachNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        private static abstract class EachBaseNode
        extends HashNodes.EachNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachBaseNode next0;

            EachBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachBaseNode(EachBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyHash executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyHash rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EachBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachUninitializedNode(this);
                    ((EachUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EachBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachUninitializedNode(this), (Node)new EachPolymorphicNode(this), (DSLNode)((EachBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (EachBaseNode)EachRubyHash0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (EachBaseNode)EachRubyHash1Node.create0(this);
                    }
                    return (EachBaseNode)EachRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachBaseNode otherCast = (EachBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.DeleteNode.class)
    public static final class DeleteNodeFactory
    extends NodeFactoryBase<HashNodes.DeleteNode> {
        private static DeleteNodeFactory deleteNodeFactoryInstance;

        private DeleteNodeFactory() {
            super(HashNodes.DeleteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.DeleteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.DeleteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DeleteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.DeleteNode> getInstance() {
            if (deleteNodeFactoryInstance == null) {
                deleteNodeFactoryInstance = new DeleteNodeFactory();
            }
            return deleteNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DeletePolymorphicNode
        extends DeleteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DeletePolymorphicNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteObject1Node
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            DeleteObject1Node(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.delete(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.delete(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.DeleteNode create0(HashNodes.DeleteNode current2) {
                return new DeleteObject1Node((DeleteBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteObject0Node
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            DeleteObject0Node(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.deletePackedArray(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.deletePackedArray(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.DeleteNode create0(HashNodes.DeleteNode current2) {
                return new DeleteObject0Node((DeleteBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteRubyNilClassObjectNode
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteRubyNilClassObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            DeleteRubyNilClassObjectNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (HashGuards.isNull(arguments0Value)) {
                    return super.deleteNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.deleteNull(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.DeleteNode create0(HashNodes.DeleteNode current2) {
                return new DeleteRubyNilClassObjectNode((DeleteBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DeleteUninitializedNode
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DeleteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DeleteUninitializedNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DeleteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DeleteBaseNode rootNode = (DeleteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DeleteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.DeleteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DeleteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        private static abstract class DeleteBaseNode
        extends HashNodes.DeleteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DeleteBaseNode next0;

            DeleteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DeleteBaseNode(DeleteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                DeleteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DeleteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DeleteUninitializedNode(this);
                    ((DeleteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DeleteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DeleteBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DeleteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DeleteUninitializedNode(this), (Node)new DeletePolymorphicNode(this), (DSLNode)((DeleteBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DeleteBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (DeleteBaseNode)DeleteRubyNilClassObjectNode.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (DeleteBaseNode)DeleteObject0Node.create0(this);
                    }
                    return (DeleteBaseNode)DeleteObject1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DeleteBaseNode otherCast = (DeleteBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DeleteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<HashNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(HashNodes.ClearNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.ClearNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClearNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.ClearNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClearUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClearPolymorphicNode
        extends ClearBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ClearPolymorphicNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClearRubyHash1Node
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ClearRubyHash1Node(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (!HashGuards.isNull(arguments0Value)) {
                    return super.empty(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isNull] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.empty(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ClearNode create0(HashNodes.ClearNode current2) {
                return new ClearRubyHash1Node((ClearBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClearRubyHash0Node
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class}, 0, 0);

            ClearRubyHash0Node(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value)) {
                    return super.emptyNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.emptyNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ClearNode create0(HashNodes.ClearNode current2) {
                return new ClearRubyHash0Node((ClearBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClearUninitializedNode
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClearUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClearUninitializedNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyHash executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ClearBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClearBaseNode rootNode = (ClearBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClearBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ClearNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClearUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        private static abstract class ClearBaseNode
        extends HashNodes.ClearNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClearBaseNode next0;

            ClearBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClearBaseNode(ClearBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyHash executeChained0(VirtualFrame var1, Object var2);

            protected final RubyHash rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ClearBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClearBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ClearUninitializedNode(this);
                    ((ClearUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClearBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ClearBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ClearBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClearUninitializedNode(this), (Node)new ClearPolymorphicNode(this), (DSLNode)((ClearBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClearBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (ClearBaseNode)ClearRubyHash0Node.create0(this);
                    }
                    return (ClearBaseNode)ClearRubyHash1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ClearBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ClearBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetIndexNode.class)
    public static final class SetIndexNodeFactory
    extends NodeFactoryBase<HashNodes.SetIndexNode> {
        private static SetIndexNodeFactory setIndexNodeFactoryInstance;

        private SetIndexNodeFactory() {
            super(HashNodes.SetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.SetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.SetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SetIndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.SetIndexNode> getInstance() {
            if (setIndexNodeFactoryInstance == null) {
                setIndexNodeFactoryInstance = new SetIndexNodeFactory();
            }
            return setIndexNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetIndexPolymorphicNode
        extends SetIndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            SetIndexPolymorphicNode(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetIndexRubyHashObject2Node
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexRubyHashObject2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, Object.class}, 0, 0);

            SetIndexRubyHashObject2Node(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.setBuckets(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.setBuckets(arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(HashNodes.SetIndexNode current2) {
                return new SetIndexRubyHashObject2Node((SetIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetIndexRubyHashObject1Node
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexRubyHashObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, Object.class}, 0, 0);

            SetIndexRubyHashObject1Node(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.setPackedArray(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.setPackedArray(frameValue, arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(HashNodes.SetIndexNode current2) {
                return new SetIndexRubyHashObject1Node((SetIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetIndexRubyHashObject0Node
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexRubyHashObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class, Object.class}, 0, 0);

            SetIndexRubyHashObject0Node(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (HashGuards.isNull(arguments0Value)) {
                    return super.setNull(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.setNull(arguments0ValueCast, arguments1Value, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(HashNodes.SetIndexNode current2) {
                return new SetIndexRubyHashObject0Node((SetIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetIndexUninitializedNode
        extends SetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetIndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SetIndexUninitializedNode(SetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                SetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetIndexBaseNode rootNode = (SetIndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetIndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static HashNodes.SetIndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SetIndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        private static abstract class SetIndexBaseNode
        extends HashNodes.SetIndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SetIndexBaseNode next0;

            SetIndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SetIndexBaseNode(SetIndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                SetIndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new SetIndexUninitializedNode(this);
                    ((SetIndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetIndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SetIndexBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (SetIndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetIndexUninitializedNode(this), (Node)new SetIndexPolymorphicNode(this), (DSLNode)((SetIndexBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetIndexBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (SetIndexBaseNode)SetIndexRubyHashObject0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (SetIndexBaseNode)SetIndexRubyHashObject1Node.create0(this);
                    }
                    return (SetIndexBaseNode)SetIndexRubyHashObject2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    SetIndexBaseNode otherCast = (SetIndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (SetIndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    extends NodeFactoryBase<HashNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
            super(HashNodes.GetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.GetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.GetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetIndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GetIndexPolymorphicNode
        extends GetIndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GetIndexPolymorphicNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyHash2Node
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyHash2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            GetIndexRubyHash2Node(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (HashGuards.isBuckets(arguments0Value)) {
                    return super.getBuckets(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isBuckets(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.getBuckets(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.GetIndexNode create0(HashNodes.GetIndexNode current2) {
                return new GetIndexRubyHash2Node((GetIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyHash1Node
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            GetIndexRubyHash1Node(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!HashGuards.isNull(arguments0Value) && !HashGuards.isBuckets(arguments0Value)) {
                    return super.getPackedArray(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isBuckets] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value)) && !HashGuards.isBuckets(arguments0ValueCast)) {
                    return super.getPackedArray(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.GetIndexNode create0(HashNodes.GetIndexNode current2) {
                return new GetIndexRubyHash1Node((GetIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyHash0Node
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            GetIndexRubyHash0Node(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (HashGuards.isNull(arguments0Value)) {
                    return super.getNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyHash arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && HashGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value))) {
                    return super.getNull(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.GetIndexNode create0(HashNodes.GetIndexNode current2) {
                return new GetIndexRubyHash0Node((GetIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GetIndexUninitializedNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GetIndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GetIndexUninitializedNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GetIndexBaseNode rootNode = (GetIndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GetIndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.GetIndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetIndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        private static abstract class GetIndexBaseNode
        extends HashNodes.GetIndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GetIndexBaseNode next0;

            GetIndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GetIndexBaseNode(GetIndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                GetIndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GetIndexUninitializedNode(this);
                    ((GetIndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GetIndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = GetIndexBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GetIndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GetIndexUninitializedNode(this), (Node)new GetIndexPolymorphicNode(this), (DSLNode)((GetIndexBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GetIndexBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (HashGuards.isNull(arguments0ValueCast)) {
                        return (GetIndexBaseNode)GetIndexRubyHash0Node.create0(this);
                    }
                    if (!HashGuards.isBuckets(arguments0ValueCast)) {
                        return (GetIndexBaseNode)GetIndexRubyHash1Node.create0(this);
                    }
                    return (GetIndexBaseNode)GetIndexRubyHash2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GetIndexBaseNode otherCast = (GetIndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GetIndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.ConstructNode.class)
    public static final class ConstructNodeFactory
    extends NodeFactoryBase<HashNodes.ConstructNode> {
        private static ConstructNodeFactory constructNodeFactoryInstance;

        private ConstructNodeFactory() {
            super(HashNodes.ConstructNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.ConstructNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstructNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.ConstructNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConstructUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.ConstructNode> getInstance() {
            if (constructNodeFactoryInstance == null) {
                constructNodeFactoryInstance = new ConstructNodeFactory();
            }
            return constructNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConstructPolymorphicNode
        extends ConstructBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ConstructPolymorphicNode(ConstructBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConstructObjectArrayNode
        extends ConstructBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstructObjectArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object[].class}, 0, 0);

            ConstructObjectArrayNode(ConstructBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof Object[]");
                }
                return super.construct(arguments0Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    Object[] arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments0Value);
                    return super.construct(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ConstructNode create0(HashNodes.ConstructNode current2) {
                return new ConstructObjectArrayNode((ConstructBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConstructUninitializedNode
        extends ConstructBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConstructUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConstructUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConstructUninitializedNode(ConstructBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyHash value2;
                try {
                    value2 = this.executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyHash executeRubyHash(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyHash executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyHash executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ConstructBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConstructBaseNode rootNode = (ConstructBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ConstructBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static HashNodes.ConstructNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConstructUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        private static abstract class ConstructBaseNode
        extends HashNodes.ConstructNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConstructBaseNode next0;

            ConstructBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConstructBaseNode(ConstructBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyHash executeChained0(VirtualFrame var1, Object var2);

            protected final RubyHash rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ConstructBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConstructBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ConstructUninitializedNode(this);
                    ((ConstructUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ConstructBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ConstructBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ConstructBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ConstructUninitializedNode(this), (Node)new ConstructPolymorphicNode(this), (DSLNode)((ConstructBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConstructBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    return (ConstructBaseNode)ConstructObjectArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ConstructBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ConstructBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=HashNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<HashNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(HashNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public HashNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static HashNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<HashNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=HashNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyHash.class ? this.arguments[1].executeRubyHash(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=HashNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyHashObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyHashObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, Object.class}, 0, 0);

            EqualRubyHashObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyHash");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyHash(arguments1Value)) {
                    return super.equalNonHash(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyHash] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && !super.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    return super.equalNonHash(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EqualNode create0(HashNodes.EqualNode current2) {
                return new EqualRubyHashObjectNode((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyHash1Node
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyHash1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            EqualRubyHash1Node(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EqualNode create0(HashNodes.EqualNode current2) {
                return new EqualRubyHash1Node((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyHash0Node
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyHash0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyHash.class, RubyHash.class}, 0, 0);

            EqualRubyHash0Node(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyHash arguments1Value;
                RubyHash arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyHash");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyHash(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyHash");
                }
                if (HashGuards.isNull(arguments0Value) && HashGuards.isNull(arguments1Value)) {
                    return super.equalNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull, isNull] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                    if (HashGuards.isNull(arguments0ValueCast) && HashGuards.isNull(arguments1ValueCast)) {
                        return super.equalNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EqualNode create0(HashNodes.EqualNode current2) {
                return new EqualRubyHash0Node((EqualBaseNode)current2);
            }
        }

        @GeneratedBy(value=HashNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = (EqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static HashNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=HashNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends HashNodes.EqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EqualBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EqualUninitializedNode(this), (Node)new EqualPolymorphicNode(this), (DSLNode)((EqualBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments0Value)) {
                    RubyHash arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isRubyHash(arguments1Value)) {
                        RubyHash arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyHash(arguments1Value);
                        if (HashGuards.isNull(arguments0ValueCast) && HashGuards.isNull(arguments1ValueCast)) {
                            return (EqualBaseNode)EqualRubyHash0Node.create0(this);
                        }
                        return (EqualBaseNode)EqualRubyHash1Node.create0(this);
                    }
                    if (!super.isRubyHash(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyHashObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

