/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.math.BigInteger;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumNodesFactory;
import org.jruby.truffle.nodes.core.GeneralDivModNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="Fixnum")
public abstract class FixnumNodes {
    private static final int BITS = 64;

    @CoreMethod(names={"zero?"})
    public static abstract class ZeroNode
    extends CoreMethodNode {
        public ZeroNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ZeroNode(ZeroNode prev) {
            super(prev);
        }

        @Specialization
        public boolean zero(int n) {
            return n == 0;
        }

        @Specialization
        public boolean zero(long n) {
            return n == 0L;
        }
    }

    @CoreMethod(names={"to_s"}, optional=1)
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(int n, UndefinedPlaceholder undefined) {
            return this.getContext().makeString(Integer.toString(n));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(long n, UndefinedPlaceholder undefined) {
            return this.getContext().makeString(Long.toString(n));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(int n, int base) {
            return this.toS((long)n, base);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(long n, int base) {
            if (base < 2 || base > 36) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentErrorInvalidRadix(base, this));
            }
            return this.getContext().makeString(Long.toString(n, base));
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToFNode(ToFNode prev) {
            super(prev);
        }

        @Specialization
        public double toF(int n) {
            return n;
        }

        @Specialization
        public double toF(long n) {
            return n;
        }
    }

    @CoreMethod(names={"size"}, needsSelf=false)
    public static abstract class SizeNode
    extends CoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        @Specialization
        public int size() {
            return 8;
        }
    }

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString inspect(int n) {
            return this.getContext().makeString(Integer.toString(n));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString inspect(long n) {
            return this.getContext().makeString(Long.toString(n));
        }
    }

    @CoreMethod(names={"floor"})
    public static abstract class FloorNode
    extends CoreMethodNode {
        public FloorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FloorNode(FloorNode prev) {
            super(prev);
        }

        @Specialization
        public int floor(int n) {
            return n;
        }

        @Specialization
        public long floor(long n) {
            return n;
        }
    }

    @CoreMethod(names={"bit_length"})
    public static abstract class BitLengthNode
    extends CoreMethodNode {
        private static final int INTEGER_BITS = Integer.numberOfLeadingZeros(0);
        private static final int LONG_BITS = Long.numberOfLeadingZeros(0L);

        public BitLengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitLengthNode(BitLengthNode prev) {
            super(prev);
        }

        @Specialization
        public int bitLength(int n) {
            return this.bitLength((long)n);
        }

        @Specialization
        public int bitLength(long n) {
            if (n < 0L) {
                n ^= 0xFFFFFFFFFFFFFFFFL;
            }
            if (n == Long.MAX_VALUE) {
                return LONG_BITS - 1;
            }
            return LONG_BITS - Long.numberOfLeadingZeros(n);
        }
    }

    @CoreMethod(names={"abs"})
    public static abstract class AbsNode
    extends CoreMethodNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AbsNode(AbsNode prev) {
            super(prev);
        }

        @Specialization
        public int abs(int n) {
            return Math.abs(n);
        }

        @Specialization
        public long abs(long n) {
            return Math.abs(n);
        }
    }

    @CoreMethod(names={">>"}, required=1)
    public static abstract class RightShiftNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;
        @Node.Child
        private LeftShiftNode leftShiftNode;

        public RightShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RightShiftNode(RightShiftNode prev) {
            super(prev);
            this.fallbackCallNode = prev.fallbackCallNode;
            this.leftShiftNode = prev.leftShiftNode;
        }

        protected abstract Object executeRightShift(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public Object rightShift(VirtualFrame frame, int a, int b2) {
            if (b2 > 0) {
                if (b2 >= 63) {
                    if (a < 0) {
                        return -1;
                    }
                    return 0;
                }
                return a >> b2;
            }
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftShiftNode = (LeftShiftNode)this.insert(FixnumNodesFactory.LeftShiftNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.leftShiftNode.executeLeftShift(frame, a, -b2);
        }

        @Specialization
        public Object rightShift(VirtualFrame frame, long a, int b2) {
            if (b2 > 0) {
                if (b2 >= 63) {
                    if (a < 0L) {
                        return -1;
                    }
                    return 0;
                }
                return a >> b2;
            }
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftShiftNode = (LeftShiftNode)this.insert(FixnumNodesFactory.LeftShiftNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.leftShiftNode.executeLeftShift(frame, a, -b2);
        }

        @Specialization
        public int rightShift(int a, RubyBignum b2) {
            return 0;
        }

        @Specialization
        public int rightShift(long a, RubyBignum b2) {
            return 0;
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])"})
        public Object rightShiftFallback(VirtualFrame frame, Object a, Object b2) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            return this.fallbackCallNode.call(frame, a, "right_shift_fallback", null, b2);
        }
    }

    @CoreMethod(names={"<<"}, required=1)
    public static abstract class LeftShiftNode
    extends BignumNodes.BignumCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;

        public LeftShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LeftShiftNode(LeftShiftNode prev) {
            super(prev);
            this.fallbackCallNode = prev.fallbackCallNode;
        }

        protected Object lower(RubyBignum value2) {
            return this.fixnumOrBignum(value2);
        }

        public abstract Object executeLeftShift(VirtualFrame var1, Object var2, Object var3);

        @Specialization(guards={"isPositive(arguments[1])", "canShiftIntoInt"})
        public int leftShift(int a, int b2) {
            return a << b2;
        }

        @Specialization(guards={"isPositive(arguments[1])", "canShiftIntoLong"})
        public long leftShiftToLong(int a, int b2) {
            return this.leftShiftToLong((long)a, b2);
        }

        @Specialization(guards={"isPositive(arguments[1])"})
        public Object leftShiftWithOverflow(int a, int b2) {
            return this.leftShiftWithOverflow((long)a, b2);
        }

        @Specialization(guards={"isStrictlyNegative(arguments[1])"})
        public int leftShiftNeg(int a, int b2) {
            if (-b2 >= 32) {
                return 0;
            }
            return a >> -b2;
        }

        @Specialization(guards={"isPositive(arguments[1])", "canShiftIntoLong"})
        public long leftShiftToLong(long a, int b2) {
            return a << b2;
        }

        @Specialization(guards={"isPositive(arguments[1])"})
        public Object leftShiftWithOverflow(long a, int b2) {
            if (LeftShiftNode.canShiftIntoLong(a, b2)) {
                return this.leftShiftToLong(a, b2);
            }
            return this.lower(this.bignum(a).shiftLeft(b2));
        }

        @Specialization(guards={"isStrictlyNegative(arguments[1])"})
        public long leftShiftNeg(long a, int b2) {
            if (-b2 >= 32) {
                return 0L;
            }
            return a >> -b2;
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])"})
        public Object leftShiftFallback(VirtualFrame frame, Object a, Object b2) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            return this.fallbackCallNode.call(frame, a, "left_shift_fallback", null, b2);
        }

        static boolean canShiftIntoInt(int a, int b2) {
            return Integer.numberOfLeadingZeros(a) - b2 > 0;
        }

        static boolean canShiftIntoLong(int a, int b2) {
            return LeftShiftNode.canShiftIntoLong((long)a, b2);
        }

        static boolean canShiftIntoLong(long a, int b2) {
            return Long.numberOfLeadingZeros(a) - b2 > 0;
        }

        static boolean isPositive(int value2) {
            return value2 >= 0;
        }

        static boolean isStrictlyNegative(int value2) {
            return value2 < 0;
        }
    }

    @CoreMethod(names={"^"}, required=1)
    public static abstract class BitXOrNode
    extends BignumNodes.BignumCoreMethodNode {
        public BitXOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitXOrNode(BitXOrNode prev) {
            super(prev);
        }

        @Specialization
        public int bitXOr(int a, int b2) {
            return a ^ b2;
        }

        @Specialization
        public long bitXOr(int a, long b2) {
            return (long)a ^ b2;
        }

        @Specialization
        public Object bitXOr(int a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).xor(b2));
        }

        @Specialization
        public long bitXOr(long a, int b2) {
            return a ^ (long)b2;
        }

        @Specialization
        public long bitXOr(long a, long b2) {
            return a ^ b2;
        }

        @Specialization
        public Object bitXOr(long a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).xor(b2));
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class BitOrNode
    extends BignumNodes.BignumCoreMethodNode {
        public BitOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitOrNode(BitOrNode prev) {
            super(prev);
        }

        @Specialization
        public int bitOr(int a, int b2) {
            return a | b2;
        }

        @Specialization
        public long bitOr(int a, long b2) {
            return (long)a | b2;
        }

        @Specialization
        public Object bitOr(int a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).or(b2));
        }

        @Specialization
        public long bitOr(long a, int b2) {
            return a | (long)b2;
        }

        @Specialization
        public long bitOr(long a, long b2) {
            return a | b2;
        }

        @Specialization
        public Object bitOr(long a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).or(b2));
        }
    }

    @CoreMethod(names={"&"}, required=1)
    public static abstract class BitAndNode
    extends BignumNodes.BignumCoreMethodNode {
        public BitAndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitAndNode(BitAndNode prev) {
            super(prev);
        }

        @Specialization
        public int bitAnd(int a, int b2) {
            return a & b2;
        }

        @Specialization
        public long bitAnd(int a, long b2) {
            return (long)a & b2;
        }

        @Specialization
        public Object bitAnd(int a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).and(b2));
        }

        @Specialization
        public long bitAnd(long a, int b2) {
            return a & (long)b2;
        }

        @Specialization
        public long bitAnd(long a, long b2) {
            return a & b2;
        }

        @Specialization
        public Object bitAnd(long a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).and(b2));
        }
    }

    @CoreMethod(names={"~"})
    public static abstract class ComplementNode
    extends CoreMethodNode {
        public ComplementNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ComplementNode(ComplementNode prev) {
            super(prev);
        }

        @Specialization
        public int complement(int n) {
            return ~n;
        }

        @Specialization
        public long complement(long n) {
            return n ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    @CoreMethod(names={">"}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class GreaterNode
    extends CoreMethodNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterNode(GreaterNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greater(int a, int b2) {
            return a > b2;
        }

        @Specialization
        public boolean greater(int a, long b2) {
            return (long)a > b2;
        }

        @Specialization
        public boolean greater(int a, double b2) {
            return (double)a > b2;
        }

        @Specialization
        public boolean greater(int a, RubyBignum b2) {
            return this.bignum(a).compare(b2) > 0;
        }

        @Specialization
        public boolean greater(long a, int b2) {
            return a > (long)b2;
        }

        @Specialization
        public boolean greater(long a, long b2) {
            return a > b2;
        }

        @Specialization
        public boolean greater(long a, double b2) {
            return (double)a > b2;
        }

        @Specialization
        public boolean greater(long a, RubyBignum b2) {
            return this.bignum(a).compare(b2) > 0;
        }
    }

    @CoreMethod(names={">="}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class GreaterEqualNode
    extends CoreMethodNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterEqualNode(GreaterEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greaterEqual(int a, int b2) {
            return a >= b2;
        }

        @Specialization
        public boolean greaterEqual(int a, long b2) {
            return (long)a >= b2;
        }

        @Specialization
        public boolean greaterEqual(int a, double b2) {
            return (double)a >= b2;
        }

        @Specialization
        public boolean greaterEqual(int a, RubyBignum b2) {
            return this.bignum(a).compare(b2) >= 0;
        }

        @Specialization
        public boolean greaterEqual(long a, int b2) {
            return a >= (long)b2;
        }

        @Specialization
        public boolean greaterEqual(long a, long b2) {
            return a >= b2;
        }

        @Specialization
        public boolean greaterEqual(long a, double b2) {
            return (double)a >= b2;
        }

        @Specialization
        public boolean greaterEqual(long a, RubyBignum b2) {
            return this.bignum(a).compare(b2) >= 0;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        @Specialization
        public int compare(int a, int b2) {
            return Integer.compare(a, b2);
        }

        @Specialization
        public int compare(int a, long b2) {
            return Long.compare(a, b2);
        }

        @Specialization
        public int compare(int a, double b2) {
            return Double.compare(a, b2);
        }

        @Specialization
        public int compare(int a, RubyBignum b2) {
            return this.bignum(a).compare(b2);
        }

        @Specialization
        public int compare(long a, int b2) {
            return Long.compare(a, b2);
        }

        @Specialization
        public int compare(long a, long b2) {
            return Long.compare(a, b2);
        }

        @Specialization
        public int compare(long a, double b2) {
            return Double.compare(a, b2);
        }

        @Specialization
        public int compare(long a, RubyBignum b2) {
            return this.bignum(a).compare(b2);
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])", "!isDouble(arguments[1])", "!isRubyBignum(arguments[1])"})
        public RubyNilClass compare(Object a, Object b2) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode reverseCallNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.reverseCallNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
            this.reverseCallNode = prev.reverseCallNode;
        }

        @Specialization
        public boolean equal(int a, int b2) {
            return a == b2;
        }

        @Specialization
        public boolean equal(int a, long b2) {
            return (long)a == b2;
        }

        @Specialization
        public boolean equal(int a, double b2) {
            return (double)a == b2;
        }

        @Specialization
        public boolean equal(int a, RubyBignum b2) {
            return this.bignum(a).equals(b2);
        }

        @Specialization
        public boolean equal(long a, int b2) {
            return a == (long)b2;
        }

        @Specialization
        public boolean equal(long a, long b2) {
            return a == b2;
        }

        @Specialization
        public boolean equal(long a, double b2) {
            return (double)a == b2;
        }

        @Specialization
        public boolean equal(long a, RubyBignum b2) {
            return this.bignum(a).equals(b2);
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])", "!isRubyBignum(arguments[1])"})
        public Object equal(VirtualFrame frame, Object a, Object b2) {
            return this.reverseCallNode.call(frame, b2, this.getName(), null, a);
        }
    }

    @CoreMethod(names={"<="}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class LessEqualNode
    extends CoreMethodNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessEqualNode(LessEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean lessEqual(int a, int b2) {
            return a <= b2;
        }

        @Specialization
        public boolean lessEqual(int a, long b2) {
            return (long)a <= b2;
        }

        @Specialization
        public boolean lessEqual(int a, double b2) {
            return (double)a <= b2;
        }

        @Specialization
        public boolean lessEqual(int a, RubyBignum b2) {
            return this.bignum(a).compare(b2) <= 0;
        }

        @Specialization
        public boolean lessEqual(long a, int b2) {
            return a <= (long)b2;
        }

        @Specialization
        public boolean lessEqual(long a, long b2) {
            return a <= b2;
        }

        @Specialization
        public boolean lessEqual(long a, double b2) {
            return (double)a <= b2;
        }

        @Specialization
        public boolean lessEqual(long a, RubyBignum b2) {
            return this.bignum(a).compare(b2) <= 0;
        }
    }

    @CoreMethod(names={"<"}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class LessNode
    extends CoreMethodNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessNode(LessNode prev) {
            super(prev);
        }

        @Specialization
        public boolean less(int a, int b2) {
            return a < b2;
        }

        @Specialization
        public boolean less(int a, long b2) {
            return (long)a < b2;
        }

        @Specialization
        public boolean less(int a, double b2) {
            return (double)a < b2;
        }

        @Specialization
        public boolean less(int a, RubyBignum b2) {
            return this.bignum(a).compare(b2) < 0;
        }

        @Specialization
        public boolean less(long a, int b2) {
            return a < (long)b2;
        }

        @Specialization
        public boolean less(long a, long b2) {
            return a < b2;
        }

        @Specialization
        public boolean less(long a, double b2) {
            return (double)a < b2;
        }

        @Specialization
        public boolean less(long a, RubyBignum b2) {
            return this.bignum(a).compare(b2) < 0;
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        public DivModNode(DivModNode prev) {
            super(prev);
            this.divModNode = prev.divModNode;
        }

        @Specialization
        public RubyArray divMod(int a, int b2) {
            return this.divModNode.execute(a, b2);
        }

        @Specialization
        public RubyArray divMod(int a, long b2) {
            return this.divModNode.execute(a, b2);
        }

        @Specialization
        public RubyArray divMod(int a, RubyBignum b2) {
            return this.divModNode.execute((long)a, b2);
        }

        @Specialization
        public RubyArray divMod(int a, double b2) {
            return this.divModNode.execute(a, b2);
        }

        @Specialization
        public RubyArray divMod(long a, int b2) {
            return this.divModNode.execute(a, b2);
        }

        @Specialization
        public RubyArray divMod(long a, long b2) {
            return this.divModNode.execute(a, b2);
        }

        @Specialization
        public RubyArray divMod(long a, RubyBignum b2) {
            return this.divModNode.execute(a, b2);
        }

        @Specialization
        public RubyArray divMod(long a, double b2) {
            return this.divModNode.execute(a, b2);
        }
    }

    @CoreMethod(names={"%"}, required=1)
    public static abstract class ModNode
    extends BignumNodes.BignumCoreMethodNode {
        private final BranchProfile adjustProfile = BranchProfile.create();

        public ModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ModNode(ModNode prev) {
            super(prev);
        }

        @Specialization
        public int mod(int a, int b2) {
            int mod = a % b2;
            if (mod < 0 && b2 > 0 || mod > 0 && b2 < 0) {
                this.adjustProfile.enter();
                mod += b2;
            }
            return mod;
        }

        @Specialization
        public long mod(int a, long b2) {
            return this.mod((long)a, b2);
        }

        @Specialization
        public double mod(int a, double b2) {
            return this.mod((long)a, b2);
        }

        @Specialization
        public double mod(long a, double b2) {
            if (b2 == 0.0) {
                throw new ArithmeticException("divide by zero");
            }
            double mod = (double)a % b2;
            if (mod < 0.0 && b2 > 0.0 || mod > 0.0 && b2 < 0.0) {
                this.adjustProfile.enter();
                mod += b2;
            }
            return mod;
        }

        @Specialization
        public long mod(long a, int b2) {
            return this.mod(a, (long)b2);
        }

        @Specialization
        public long mod(long a, long b2) {
            long mod = a % b2;
            if (mod < 0L && b2 > 0L || mod > 0L && b2 < 0L) {
                this.adjustProfile.enter();
                mod += b2;
            }
            return mod;
        }

        @Specialization
        public Object mod(int a, RubyBignum b2) {
            return this.mod((long)a, b2);
        }

        @Specialization
        public Object mod(long a, RubyBignum b2) {
            ModNode.notDesignedForCompilation();
            long mod = BigInteger.valueOf(a).mod(b2.bigIntegerValue()).longValue();
            if (mod < 0L && b2.bigIntegerValue().compareTo(BigInteger.ZERO) > 0 || mod > 0L && b2.bigIntegerValue().compareTo(BigInteger.ZERO) < 0) {
                this.adjustProfile.enter();
                return new RubyBignum(this.getContext().getCoreLibrary().getBignumClass(), BigInteger.valueOf(mod).add(b2.bigIntegerValue()));
            }
            return mod;
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends CoreMethodNode {
        private final BranchProfile bGreaterZero = BranchProfile.create();
        private final BranchProfile bGreaterZeroAGreaterEqualZero = BranchProfile.create();
        private final BranchProfile bGreaterZeroALessZero = BranchProfile.create();
        private final BranchProfile aGreaterZero = BranchProfile.create();
        private final BranchProfile bMinusOne = BranchProfile.create();
        private final BranchProfile bMinusOneAMinimum = BranchProfile.create();
        private final BranchProfile bMinusOneANotMinimum = BranchProfile.create();
        private final BranchProfile finalCase = BranchProfile.create();

        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DivNode(DivNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public int div(int a, int b2) throws UnexpectedResultException {
            if (b2 > 0) {
                this.bGreaterZero.enter();
                if (a >= 0) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b2;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1) / b2 - 1;
            }
            if (a > 0) {
                this.aGreaterZero.enter();
                return (a - 1) / b2 - 1;
            }
            if (b2 == -1) {
                this.bMinusOne.enter();
                if (a == Integer.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    throw new UnexpectedResultException((Object)this.bignum(a).negate());
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b2;
        }

        @Specialization
        public Object divEdgeCase(int a, int b2) {
            if (b2 > 0) {
                this.bGreaterZero.enter();
                if (a >= 0) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b2;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1) / b2 - 1;
            }
            if (a > 0) {
                this.aGreaterZero.enter();
                return (a - 1) / b2 - 1;
            }
            if (b2 == -1) {
                this.bMinusOne.enter();
                if (a == Integer.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    return this.bignum(a).negate();
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b2;
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public long div(int a, long b2) throws UnexpectedResultException {
            return this.div((long)a, b2);
        }

        @Specialization
        public Object divEdgeCase(int a, long b2) {
            return this.divEdgeCase((long)a, b2);
        }

        @Specialization
        public double div(int a, double b2) {
            return (double)a / b2;
        }

        @Specialization
        public int div(int a, RubyBignum b2) {
            return 0;
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public long div(long a, int b2) throws UnexpectedResultException {
            return this.div(a, (long)b2);
        }

        @Specialization
        public Object divEdgeCase(long a, int b2) {
            return this.divEdgeCase(a, (long)b2);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public long div(long a, long b2) throws UnexpectedResultException {
            if (b2 > 0L) {
                this.bGreaterZero.enter();
                if (a >= 0L) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b2;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1L) / b2 - 1L;
            }
            if (a > 0L) {
                this.aGreaterZero.enter();
                return (a - 1L) / b2 - 1L;
            }
            if (b2 == -1L) {
                this.bMinusOne.enter();
                if (a == Long.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    throw new UnexpectedResultException((Object)this.bignum(a).negate());
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b2;
        }

        @Specialization
        public Object divEdgeCase(long a, long b2) {
            if (b2 > 0L) {
                this.bGreaterZero.enter();
                if (a >= 0L) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b2;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1L) / b2 - 1L;
            }
            if (a > 0L) {
                this.aGreaterZero.enter();
                return (a - 1L) / b2 - 1L;
            }
            if (b2 == -1L) {
                this.bMinusOne.enter();
                if (a == Long.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    return this.bignum(a).negate();
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b2;
        }

        @Specialization
        public double div(long a, double b2) {
            return (double)a / b2;
        }

        @Specialization
        public int div(long a, RubyBignum b2) {
            return 0;
        }
    }

    @CoreMethod(names={"**"}, required=1)
    public static abstract class PowNode
    extends BignumNodes.BignumCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode complexConvertNode;
        @Node.Child
        private CallDispatchHeadNode complexPowNode;
        @Node.Child
        private CallDispatchHeadNode rationalConvertNode;
        @Node.Child
        private CallDispatchHeadNode rationalPowNode;
        private final ConditionProfile negativeProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile complexProfile = ConditionProfile.createBinaryProfile();

        public PowNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PowNode(PowNode prev) {
            super(prev);
            this.complexConvertNode = prev.complexConvertNode;
            this.complexPowNode = prev.complexPowNode;
            this.rationalConvertNode = prev.rationalConvertNode;
            this.rationalPowNode = prev.rationalPowNode;
        }

        @Specialization(guards={"canShiftIntoInt"})
        public int powTwo(int a, int b2) {
            return 1 << b2;
        }

        @Specialization(guards={"canShiftIntoInt"})
        public int powTwo(int a, long b2) {
            return 1 << (int)b2;
        }

        @Specialization
        public Object pow(int a, int b2) {
            return this.pow(a, (long)b2);
        }

        @Specialization
        public Object pow(int a, long b2) {
            return this.pow((long)a, b2);
        }

        @Specialization
        public Object pow(VirtualFrame frame, int a, double b2) {
            return this.pow(frame, (long)a, b2);
        }

        @Specialization
        public Object pow(int a, RubyBignum b2) {
            return this.pow((long)a, b2);
        }

        @Specialization(guards={"canShiftIntoLong"})
        public long powTwo(long a, int b2) {
            return 1 << b2;
        }

        @Specialization(guards={"canShiftIntoLong"})
        public long powTwo(long a, long b2) {
            return 1 << (int)b2;
        }

        @Specialization
        public Object pow(long a, int b2) {
            return this.pow(a, (long)b2);
        }

        @Specialization
        public Object pow(long a, long b2) {
            if (this.negativeProfile.profile(b2 < 0L)) {
                return Math.pow(a, b2);
            }
            return this.fixnumOrBignum(this.bignum(a).pow(b2));
        }

        @Specialization
        public Object pow(VirtualFrame frame, long a, double b2) {
            if (this.complexProfile.profile(a < 0L && b2 != (double)Math.round(b2))) {
                if (this.complexConvertNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.complexConvertNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
                    this.complexPowNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                Object aComplex = this.complexConvertNode.call(frame, this.getContext().getCoreLibrary().getComplexClass(), "convert", null, a, 0);
                return this.complexPowNode.call(frame, aComplex, "**", null, b2);
            }
            return Math.pow(a, b2);
        }

        @Specialization
        public Object pow(long a, RubyBignum b2) {
            PowNode.notDesignedForCompilation();
            if (a == 0L) {
                return 0;
            }
            if (a == 1L) {
                return 1;
            }
            if (a == -1L) {
                if (b2.bigIntegerValue().testBit(0)) {
                    return -1;
                }
                return 1;
            }
            return Math.pow(a, b2.doubleValue());
        }

        @Specialization(guards={"isRational(arguments[1])"})
        public Object pow(VirtualFrame frame, Object a, RubyBasicObject b2) {
            if (this.rationalConvertNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.rationalConvertNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
                this.rationalPowNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object aRational = this.rationalConvertNode.call(frame, this.getContext().getCoreLibrary().getRationalClass(), "convert", null, a, 1);
            return this.rationalPowNode.call(frame, aRational, "**", null, b2);
        }

        protected static boolean canShiftIntoInt(int a, int b2) {
            return PowNode.canShiftIntoInt(a, (long)b2);
        }

        protected static boolean canShiftIntoInt(int a, long b2) {
            return a == 2 && b2 <= 30L;
        }

        protected static boolean canShiftIntoLong(long a, int b2) {
            return PowNode.canShiftIntoLong(a, (long)b2);
        }

        protected static boolean canShiftIntoLong(long a, long b2) {
            return a == 2L && b2 <= 62L;
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends BignumNodes.BignumCoreMethodNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MulNode(MulNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int mul(int a, int b2) {
            return ExactMath.multiplyExact((int)a, (int)b2);
        }

        @Specialization
        public long mulWithOverflow(int a, int b2) {
            return (long)a * (long)b2;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public Object mul(int a, long b2) {
            return ExactMath.multiplyExact((long)a, (long)b2);
        }

        @Specialization
        public Object mulWithOverflow(int a, long b2) {
            return this.fixnumOrBignum(this.bignum(a).multiply(this.bignum(b2)));
        }

        @Specialization
        public double mul(int a, double b2) {
            return (double)a * b2;
        }

        @Specialization
        public Object mul(int a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).multiply(b2));
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long mul(long a, int b2) {
            return ExactMath.multiplyExact((long)a, (long)b2);
        }

        @Specialization
        public Object mulWithOverflow(long a, int b2) {
            return this.fixnumOrBignum(this.bignum(a).multiply(this.bignum(b2)));
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long mul(long a, long b2) {
            return ExactMath.multiplyExact((long)a, (long)b2);
        }

        @Specialization
        public Object mulWithOverflow(long a, long b2) {
            return this.fixnumOrBignum(this.bignum(a).multiply(this.bignum(b2)));
        }

        @Specialization
        public double mul(long a, double b2) {
            return (double)a * b2;
        }

        @Specialization
        public Object mul(long a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).multiply(b2));
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends BignumNodes.BignumCoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SubNode(SubNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int sub(int a, int b2) {
            return ExactMath.subtractExact((int)a, (int)b2);
        }

        @Specialization
        public long subWithOverflow(int a, int b2) {
            return (long)a - (long)b2;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long sub(int a, long b2) {
            return ExactMath.subtractExact((long)a, (long)b2);
        }

        @Specialization
        public Object subWithOverflow(int a, long b2) {
            return this.fixnumOrBignum(this.bignum(a).subtract(this.bignum(b2)));
        }

        @Specialization
        public Object sub(int a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).subtract(b2));
        }

        @Specialization
        public double sub(int a, double b2) {
            return (double)a - b2;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long sub(long a, int b2) {
            return ExactMath.subtractExact((long)a, (long)b2);
        }

        @Specialization
        public Object subWithOverflow(long a, int b2) {
            return this.fixnumOrBignum(this.bignum(a).subtract(this.bignum(b2)));
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long sub(long a, long b2) {
            return ExactMath.subtractExact((long)a, (long)b2);
        }

        @Specialization
        public Object subWithOverflow(long a, long b2) {
            return this.fixnumOrBignum(this.bignum(a).subtract(this.bignum(b2)));
        }

        @Specialization
        public double sub(long a, double b2) {
            return (double)a - b2;
        }

        @Specialization
        public Object sub(long a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).subtract(b2));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends BignumNodes.BignumCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode rationalAdd;

        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AddNode(AddNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int add(int a, int b2) {
            return ExactMath.addExact((int)a, (int)b2);
        }

        @Specialization
        public long addWithOverflow(int a, int b2) {
            return (long)a + (long)b2;
        }

        @Specialization
        public double add(int a, double b2) {
            return (double)a + b2;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long add(int a, long b2) {
            return ExactMath.addExact((long)a, (long)b2);
        }

        @Specialization
        public Object addWithOverflow(int a, long b2) {
            return this.fixnumOrBignum(this.bignum(a).add(this.bignum(b2)));
        }

        @Specialization
        public Object add(int a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).add(b2));
        }

        @Specialization(guards={"isRational(arguments[1])"})
        public Object add(VirtualFrame frame, int a, RubyBasicObject b2) {
            if (this.rationalAdd == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.rationalAdd = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.rationalAdd.call(frame, b2, "+", null, a);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long add(long a, int b2) {
            return ExactMath.addExact((long)a, (long)b2);
        }

        @Specialization
        public Object addWithOverflow(long a, int b2) {
            return this.fixnumOrBignum(this.bignum(a).add(this.bignum(b2)));
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long add(long a, long b2) {
            return ExactMath.addExact((long)a, (long)b2);
        }

        @Specialization
        public Object addWithOverflow(long a, long b2) {
            return this.fixnumOrBignum(this.bignum(a).add(this.bignum(b2)));
        }

        @Specialization
        public double add(long a, double b2) {
            return (double)a + b2;
        }

        @Specialization
        public Object add(long a, RubyBignum b2) {
            return this.fixnumOrBignum(this.bignum(a).add(b2));
        }

        @Specialization(guards={"isRational(arguments[1])"})
        public Object add(VirtualFrame frame, long a, RubyBasicObject b2) {
            if (this.rationalAdd == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.rationalAdd = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.rationalAdd.call(frame, b2, "+", null, a);
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends CoreMethodNode {
        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NegNode(NegNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int neg(int value2) {
            return ExactMath.subtractExact((int)0, (int)value2);
        }

        @Specialization
        public long negWithOverflow(int value2) {
            return -((long)value2);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long neg(long value2) {
            return ExactMath.subtractExact((long)0L, (long)value2);
        }

        @Specialization
        public RubyBignum negWithOverflow(long value2) {
            return this.bignum(value2).negate();
        }
    }
}

