/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FileNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyFile;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=FileNodes.class)
public final class FileNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AbsolutePathNodeFactory.getInstance(), CloseNodeFactory.getInstance(), DeleteNodeFactory.getInstance(), DirectoryNodeFactory.getInstance(), DirnameNodeFactory.getInstance(), EachLineNodeFactory.getInstance(), ExecutableNodeFactory.getInstance(), ExistsNodeFactory.getInstance(), ExpandPathNodeFactory.getInstance(), FileNodeFactory.getInstance(), JoinNodeFactory.getInstance(), PathNodeFactory.getInstance(), PutsNodeFactory.getInstance(), ReadFunctionNodeFactory.getInstance(), ReadNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SymlinkQueryNodeFactory.getInstance(), WriteNodeFactory.getInstance());
    }

    @GeneratedBy(value=FileNodes.WriteNode.class)
    public static final class WriteNodeFactory
    extends NodeFactoryBase<FileNodes.WriteNode> {
        private static WriteNodeFactory writeNodeFactoryInstance;

        private WriteNodeFactory() {
            super(FileNodes.WriteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.WriteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return WriteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.WriteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return WriteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.WriteNode> getInstance() {
            if (writeNodeFactoryInstance == null) {
                writeNodeFactoryInstance = new WriteNodeFactory();
            }
            return writeNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.WriteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class WritePolymorphicNode
        extends WriteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            WritePolymorphicNode(WriteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FileNodes.WriteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class WriteRubyFileNode
        extends WriteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(WriteRubyFileNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyFile.class, RubyString.class}, 0, 0);

            WriteRubyFileNode(WriteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyFile arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyFile(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyFile");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.write(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyFile(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyFile arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyFile(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.write(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FileNodes.WriteNode create0(FileNodes.WriteNode current2) {
                return new WriteRubyFileNode((WriteBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.WriteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class WriteUninitializedNode
        extends WriteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(WriteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            WriteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            WriteUninitializedNode(WriteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                WriteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    WriteBaseNode rootNode = (WriteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((WriteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FileNodes.WriteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new WriteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.WriteNode.class)
        private static abstract class WriteBaseNode
        extends FileNodes.WriteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected WriteBaseNode next0;

            WriteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            WriteBaseNode(WriteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                WriteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                WriteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new WriteUninitializedNode(this);
                    ((WriteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (WriteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = WriteBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (WriteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new WriteUninitializedNode(this), (Node)new WritePolymorphicNode(this), (DSLNode)((WriteBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final WriteBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyFile(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (WriteBaseNode)WriteRubyFileNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    WriteBaseNode otherCast = (WriteBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (WriteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.SymlinkQueryNode.class)
    public static final class SymlinkQueryNodeFactory
    extends NodeFactoryBase<FileNodes.SymlinkQueryNode> {
        private static SymlinkQueryNodeFactory symlinkQueryNodeFactoryInstance;

        private SymlinkQueryNodeFactory() {
            super(FileNodes.SymlinkQueryNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.SymlinkQueryNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SymlinkQueryNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.SymlinkQueryNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SymlinkQueryUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.SymlinkQueryNode> getInstance() {
            if (symlinkQueryNodeFactoryInstance == null) {
                symlinkQueryNodeFactoryInstance = new SymlinkQueryNodeFactory();
            }
            return symlinkQueryNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.SymlinkQueryNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SymlinkQueryPolymorphicNode
        extends SymlinkQueryBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SymlinkQueryPolymorphicNode(SymlinkQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.SymlinkQueryNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SymlinkQueryRubyStringNode
        extends SymlinkQueryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SymlinkQueryRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SymlinkQueryRubyStringNode(SymlinkQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.symlinkQuery(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.symlinkQuery(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.SymlinkQueryNode create0(FileNodes.SymlinkQueryNode current2) {
                return new SymlinkQueryRubyStringNode((SymlinkQueryBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.SymlinkQueryNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SymlinkQueryUninitializedNode
        extends SymlinkQueryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SymlinkQueryUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SymlinkQueryUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SymlinkQueryUninitializedNode(SymlinkQueryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SymlinkQueryBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SymlinkQueryBaseNode rootNode = (SymlinkQueryBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SymlinkQueryBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.SymlinkQueryNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SymlinkQueryUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.SymlinkQueryNode.class)
        private static abstract class SymlinkQueryBaseNode
        extends FileNodes.SymlinkQueryNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SymlinkQueryBaseNode next0;

            SymlinkQueryBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SymlinkQueryBaseNode(SymlinkQueryBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SymlinkQueryBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SymlinkQueryBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SymlinkQueryUninitializedNode(this);
                    ((SymlinkQueryUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SymlinkQueryBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SymlinkQueryBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SymlinkQueryBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SymlinkQueryUninitializedNode(this), (Node)new SymlinkQueryPolymorphicNode(this), (DSLNode)((SymlinkQueryBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SymlinkQueryBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (SymlinkQueryBaseNode)SymlinkQueryRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SymlinkQueryBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SymlinkQueryBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<FileNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(FileNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SizePolymorphicNode
        extends SizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SizePolymorphicNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubyStringNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SizeRubyStringNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.read(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.read(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.SizeNode create0(FileNodes.SizeNode current2) {
                return new SizeRubyStringNode((SizeBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SizeUninitializedNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SizeUninitializedNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SizeBaseNode rootNode = (SizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.SizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.SizeNode.class)
        private static abstract class SizeBaseNode
        extends FileNodes.SizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SizeBaseNode next0;

            SizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SizeBaseNode(SizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SizeUninitializedNode(this);
                    ((SizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SizeBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SizeUninitializedNode(this), (Node)new SizePolymorphicNode(this), (DSLNode)((SizeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (SizeBaseNode)SizeRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.ReadNode.class)
    public static final class ReadNodeFactory
    extends NodeFactoryBase<FileNodes.ReadNode> {
        private static ReadNodeFactory readNodeFactoryInstance;

        private ReadNodeFactory() {
            super(FileNodes.ReadNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.ReadNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReadNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.ReadNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ReadUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.ReadNode> getInstance() {
            if (readNodeFactoryInstance == null) {
                readNodeFactoryInstance = new ReadNodeFactory();
            }
            return readNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.ReadNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReadPolymorphicNode
        extends ReadBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ReadPolymorphicNode(ReadBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.ReadNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReadRubyFileNode
        extends ReadBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReadRubyFileNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyFile.class}, 0, 0);

            ReadRubyFileNode(ReadBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyFile arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyFile(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyFile");
                }
                return super.read(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyFile(arguments0Value)) {
                    RubyFile arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyFile(arguments0Value);
                    return super.read(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.ReadNode create0(FileNodes.ReadNode current2) {
                return new ReadRubyFileNode((ReadBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.ReadNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReadUninitializedNode
        extends ReadBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReadUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReadUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ReadUninitializedNode(ReadBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ReadBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReadBaseNode rootNode = (ReadBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ReadBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.ReadNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ReadUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.ReadNode.class)
        private static abstract class ReadBaseNode
        extends FileNodes.ReadNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ReadBaseNode next0;

            ReadBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ReadBaseNode(ReadBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ReadBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReadBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ReadUninitializedNode(this);
                    ((ReadUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ReadBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ReadBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ReadBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ReadUninitializedNode(this), (Node)new ReadPolymorphicNode(this), (DSLNode)((ReadBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReadBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyFile(arguments0Value)) {
                    return (ReadBaseNode)ReadRubyFileNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ReadBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ReadBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.ReadFunctionNode.class)
    public static final class ReadFunctionNodeFactory
    extends NodeFactoryBase<FileNodes.ReadFunctionNode> {
        private static ReadFunctionNodeFactory readFunctionNodeFactoryInstance;

        private ReadFunctionNodeFactory() {
            super(FileNodes.ReadFunctionNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.ReadFunctionNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReadFunctionNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.ReadFunctionNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ReadFunctionUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.ReadFunctionNode> getInstance() {
            if (readFunctionNodeFactoryInstance == null) {
                readFunctionNodeFactoryInstance = new ReadFunctionNodeFactory();
            }
            return readFunctionNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.ReadFunctionNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReadFunctionPolymorphicNode
        extends ReadFunctionBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ReadFunctionPolymorphicNode(ReadFunctionBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.ReadFunctionNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReadFunctionRubyStringNode
        extends ReadFunctionBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReadFunctionRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ReadFunctionRubyStringNode(ReadFunctionBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.read(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.read(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.ReadFunctionNode create0(FileNodes.ReadFunctionNode current2) {
                return new ReadFunctionRubyStringNode((ReadFunctionBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.ReadFunctionNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReadFunctionUninitializedNode
        extends ReadFunctionBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReadFunctionUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReadFunctionUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ReadFunctionUninitializedNode(ReadFunctionBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ReadFunctionBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReadFunctionBaseNode rootNode = (ReadFunctionBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ReadFunctionBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.ReadFunctionNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ReadFunctionUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.ReadFunctionNode.class)
        private static abstract class ReadFunctionBaseNode
        extends FileNodes.ReadFunctionNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ReadFunctionBaseNode next0;

            ReadFunctionBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ReadFunctionBaseNode(ReadFunctionBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ReadFunctionBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReadFunctionBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ReadFunctionUninitializedNode(this);
                    ((ReadFunctionUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ReadFunctionBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ReadFunctionBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ReadFunctionBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ReadFunctionUninitializedNode(this), (Node)new ReadFunctionPolymorphicNode(this), (DSLNode)((ReadFunctionBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReadFunctionBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ReadFunctionBaseNode)ReadFunctionRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ReadFunctionBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ReadFunctionBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.PutsNode.class)
    public static final class PutsNodeFactory
    extends NodeFactoryBase<FileNodes.PutsNode> {
        private static PutsNodeFactory putsNodeFactoryInstance;

        private PutsNodeFactory() {
            super(FileNodes.PutsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.PutsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PutsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.PutsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PutsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.PutsNode> getInstance() {
            if (putsNodeFactoryInstance == null) {
                putsNodeFactoryInstance = new PutsNodeFactory();
            }
            return putsNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.PutsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PutsPolymorphicNode
        extends PutsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PutsPolymorphicNode(PutsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FileNodes.PutsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PutsRubyFileNode
        extends PutsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PutsRubyFileNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyFile.class, RubyString.class}, 0, 0);

            PutsRubyFileNode(PutsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyFile arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyFile(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyFile");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.puts(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyFile(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyFile arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyFile(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.puts(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FileNodes.PutsNode create0(FileNodes.PutsNode current2) {
                return new PutsRubyFileNode((PutsBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.PutsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PutsUninitializedNode
        extends PutsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PutsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PutsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PutsUninitializedNode(PutsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PutsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PutsBaseNode rootNode = (PutsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PutsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FileNodes.PutsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PutsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.PutsNode.class)
        private static abstract class PutsBaseNode
        extends FileNodes.PutsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PutsBaseNode next0;

            PutsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PutsBaseNode(PutsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PutsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PutsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PutsUninitializedNode(this);
                    ((PutsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PutsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PutsBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PutsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PutsUninitializedNode(this), (Node)new PutsPolymorphicNode(this), (DSLNode)((PutsBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PutsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyFile(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (PutsBaseNode)PutsRubyFileNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PutsBaseNode otherCast = (PutsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PutsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.PathNode.class)
    public static final class PathNodeFactory
    extends NodeFactoryBase<FileNodes.PathNode> {
        private static PathNodeFactory pathNodeFactoryInstance;

        private PathNodeFactory() {
            super(FileNodes.PathNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.PathNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PathNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.PathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PathUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.PathNode> getInstance() {
            if (pathNodeFactoryInstance == null) {
                pathNodeFactoryInstance = new PathNodeFactory();
            }
            return pathNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.PathNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PathPolymorphicNode
        extends PathBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            PathPolymorphicNode(PathBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.PathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PathRubyStringNode
        extends PathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PathRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            PathRubyStringNode(PathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.path(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.path(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.PathNode create0(FileNodes.PathNode current2) {
                return new PathRubyStringNode((PathBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.PathNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PathUninitializedNode
        extends PathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PathUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PathUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PathUninitializedNode(PathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                PathBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PathBaseNode rootNode = (PathBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PathBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.PathNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PathUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.PathNode.class)
        private static abstract class PathBaseNode
        extends FileNodes.PathNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PathBaseNode next0;

            PathBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PathBaseNode(PathBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                PathBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PathBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new PathUninitializedNode(this);
                    ((PathUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PathBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PathBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (PathBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PathUninitializedNode(this), (Node)new PathPolymorphicNode(this), (DSLNode)((PathBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PathBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (PathBaseNode)PathRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((PathBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (PathBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.JoinNode.class)
    public static final class JoinNodeFactory
    extends NodeFactoryBase<FileNodes.JoinNode> {
        private static JoinNodeFactory joinNodeFactoryInstance;

        private JoinNodeFactory() {
            super(FileNodes.JoinNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.JoinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return JoinNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.JoinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return JoinUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.JoinNode> getInstance() {
            if (joinNodeFactoryInstance == null) {
                joinNodeFactoryInstance = new JoinNodeFactory();
            }
            return joinNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class JoinPolymorphicNode
        extends JoinBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            JoinPolymorphicNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class JoinObjectArrayNode
        extends JoinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JoinObjectArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object[].class}, 0, 0);

            JoinObjectArrayNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof Object[]");
                }
                return super.join(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    Object[] arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments0Value);
                    return super.join(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.JoinNode create0(FileNodes.JoinNode current2) {
                return new JoinObjectArrayNode((JoinBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class JoinUninitializedNode
        extends JoinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JoinUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            JoinUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            JoinUninitializedNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                JoinBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    JoinBaseNode rootNode = (JoinBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((JoinBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.JoinNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new JoinUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.JoinNode.class)
        private static abstract class JoinBaseNode
        extends FileNodes.JoinNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected JoinBaseNode next0;

            JoinBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            JoinBaseNode(JoinBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                JoinBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                JoinBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new JoinUninitializedNode(this);
                    ((JoinUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (JoinBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = JoinBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (JoinBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new JoinUninitializedNode(this), (Node)new JoinPolymorphicNode(this), (DSLNode)((JoinBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final JoinBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    return (JoinBaseNode)JoinObjectArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((JoinBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (JoinBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.FileNode.class)
    public static final class FileNodeFactory
    extends NodeFactoryBase<FileNodes.FileNode> {
        private static FileNodeFactory fileNodeFactoryInstance;

        private FileNodeFactory() {
            super(FileNodes.FileNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.FileNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FileNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.FileNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FileUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.FileNode> getInstance() {
            if (fileNodeFactoryInstance == null) {
                fileNodeFactoryInstance = new FileNodeFactory();
            }
            return fileNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.FileNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FilePolymorphicNode
        extends FileBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            FilePolymorphicNode(FileBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.FileNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FileRubyStringNode
        extends FileBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FileRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            FileRubyStringNode(FileBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.file(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.file(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.FileNode create0(FileNodes.FileNode current2) {
                return new FileRubyStringNode((FileBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.FileNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FileUninitializedNode
        extends FileBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FileUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FileUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FileUninitializedNode(FileBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                FileBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FileBaseNode rootNode = (FileBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((FileBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.FileNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FileUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.FileNode.class)
        private static abstract class FileBaseNode
        extends FileNodes.FileNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FileBaseNode next0;

            FileBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FileBaseNode(FileBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                FileBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FileBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new FileUninitializedNode(this);
                    ((FileUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (FileBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = FileBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (FileBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FileUninitializedNode(this), (Node)new FilePolymorphicNode(this), (DSLNode)((FileBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FileBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (FileBaseNode)FileRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((FileBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (FileBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.ExpandPathNode.class)
    public static final class ExpandPathNodeFactory
    extends NodeFactoryBase<FileNodes.ExpandPathNode> {
        private static ExpandPathNodeFactory expandPathNodeFactoryInstance;

        private ExpandPathNodeFactory() {
            super(FileNodes.ExpandPathNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.ExpandPathNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExpandPathNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.ExpandPathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ExpandPathUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.ExpandPathNode> getInstance() {
            if (expandPathNodeFactoryInstance == null) {
                expandPathNodeFactoryInstance = new ExpandPathNodeFactory();
            }
            return expandPathNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.ExpandPathNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ExpandPathPolymorphicNode
        extends ExpandPathBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ExpandPathPolymorphicNode(ExpandPathBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FileNodes.ExpandPathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExpandPathRubyStringNode
        extends ExpandPathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExpandPathRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            ExpandPathRubyStringNode(ExpandPathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.expandPath(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.expandPath(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FileNodes.ExpandPathNode create0(FileNodes.ExpandPathNode current2) {
                return new ExpandPathRubyStringNode((ExpandPathBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.ExpandPathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExpandPathRubyStringUndefinedPlaceholderNode
        extends ExpandPathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExpandPathRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            ExpandPathRubyStringUndefinedPlaceholderNode(ExpandPathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.expandPath(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.expandPath(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FileNodes.ExpandPathNode create0(FileNodes.ExpandPathNode current2) {
                return new ExpandPathRubyStringUndefinedPlaceholderNode((ExpandPathBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.ExpandPathNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ExpandPathUninitializedNode
        extends ExpandPathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExpandPathUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ExpandPathUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ExpandPathUninitializedNode(ExpandPathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ExpandPathBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ExpandPathBaseNode rootNode = (ExpandPathBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ExpandPathBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FileNodes.ExpandPathNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ExpandPathUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.ExpandPathNode.class)
        private static abstract class ExpandPathBaseNode
        extends FileNodes.ExpandPathNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ExpandPathBaseNode next0;

            ExpandPathBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ExpandPathBaseNode(ExpandPathBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ExpandPathBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ExpandPathBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ExpandPathUninitializedNode(this);
                    ((ExpandPathUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ExpandPathBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ExpandPathBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ExpandPathBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ExpandPathUninitializedNode(this), (Node)new ExpandPathPolymorphicNode(this), (DSLNode)((ExpandPathBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ExpandPathBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (ExpandPathBaseNode)ExpandPathRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (ExpandPathBaseNode)ExpandPathRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ExpandPathBaseNode otherCast = (ExpandPathBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ExpandPathBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.ExistsNode.class)
    public static final class ExistsNodeFactory
    extends NodeFactoryBase<FileNodes.ExistsNode> {
        private static ExistsNodeFactory existsNodeFactoryInstance;

        private ExistsNodeFactory() {
            super(FileNodes.ExistsNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.ExistsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExistsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.ExistsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ExistsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.ExistsNode> getInstance() {
            if (existsNodeFactoryInstance == null) {
                existsNodeFactoryInstance = new ExistsNodeFactory();
            }
            return existsNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.ExistsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ExistsPolymorphicNode
        extends ExistsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ExistsPolymorphicNode(ExistsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.ExistsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExistsRubyStringNode
        extends ExistsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExistsRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ExistsRubyStringNode(ExistsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.exists(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.exists(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.ExistsNode create0(FileNodes.ExistsNode current2) {
                return new ExistsRubyStringNode((ExistsBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.ExistsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ExistsUninitializedNode
        extends ExistsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExistsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ExistsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ExistsUninitializedNode(ExistsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ExistsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ExistsBaseNode rootNode = (ExistsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ExistsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.ExistsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ExistsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.ExistsNode.class)
        private static abstract class ExistsBaseNode
        extends FileNodes.ExistsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ExistsBaseNode next0;

            ExistsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ExistsBaseNode(ExistsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ExistsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ExistsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ExistsUninitializedNode(this);
                    ((ExistsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ExistsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ExistsBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ExistsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ExistsUninitializedNode(this), (Node)new ExistsPolymorphicNode(this), (DSLNode)((ExistsBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ExistsBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ExistsBaseNode)ExistsRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ExistsBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ExistsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.ExecutableNode.class)
    public static final class ExecutableNodeFactory
    extends NodeFactoryBase<FileNodes.ExecutableNode> {
        private static ExecutableNodeFactory executableNodeFactoryInstance;

        private ExecutableNodeFactory() {
            super(FileNodes.ExecutableNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.ExecutableNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExecutableNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.ExecutableNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ExecutableUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.ExecutableNode> getInstance() {
            if (executableNodeFactoryInstance == null) {
                executableNodeFactoryInstance = new ExecutableNodeFactory();
            }
            return executableNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.ExecutableNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ExecutablePolymorphicNode
        extends ExecutableBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ExecutablePolymorphicNode(ExecutableBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.ExecutableNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExecutableRubyStringNode
        extends ExecutableBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExecutableRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ExecutableRubyStringNode(ExecutableBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.executable(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.executable(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.ExecutableNode create0(FileNodes.ExecutableNode current2) {
                return new ExecutableRubyStringNode((ExecutableBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.ExecutableNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ExecutableUninitializedNode
        extends ExecutableBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExecutableUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ExecutableUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ExecutableUninitializedNode(ExecutableBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ExecutableBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ExecutableBaseNode rootNode = (ExecutableBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ExecutableBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.ExecutableNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ExecutableUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.ExecutableNode.class)
        private static abstract class ExecutableBaseNode
        extends FileNodes.ExecutableNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ExecutableBaseNode next0;

            ExecutableBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ExecutableBaseNode(ExecutableBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ExecutableBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ExecutableBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ExecutableUninitializedNode(this);
                    ((ExecutableUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ExecutableBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ExecutableBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ExecutableBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ExecutableUninitializedNode(this), (Node)new ExecutablePolymorphicNode(this), (DSLNode)((ExecutableBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ExecutableBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ExecutableBaseNode)ExecutableRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ExecutableBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ExecutableBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.EachLineNode.class)
    public static final class EachLineNodeFactory
    extends NodeFactoryBase<FileNodes.EachLineNode> {
        private static EachLineNodeFactory eachLineNodeFactoryInstance;

        private EachLineNodeFactory() {
            super(FileNodes.EachLineNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.EachLineNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachLineNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.EachLineNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachLineUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.EachLineNode> getInstance() {
            if (eachLineNodeFactoryInstance == null) {
                eachLineNodeFactoryInstance = new EachLineNodeFactory();
            }
            return eachLineNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.EachLineNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachLinePolymorphicNode
        extends EachLineBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachLinePolymorphicNode(EachLineBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FileNodes.EachLineNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachLineRubyFileNode
        extends EachLineBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachLineRubyFileNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyFile.class, RubyProc.class}, 0, 0);

            EachLineRubyFileNode(EachLineBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyFile arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyFile(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyFile");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.eachLine(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyFile(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyFile arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyFile(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.eachLine(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FileNodes.EachLineNode create0(FileNodes.EachLineNode current2) {
                return new EachLineRubyFileNode((EachLineBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.EachLineNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachLineUninitializedNode
        extends EachLineBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachLineUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachLineUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachLineUninitializedNode(EachLineBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachLineBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachLineBaseNode rootNode = (EachLineBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachLineBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FileNodes.EachLineNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachLineUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.EachLineNode.class)
        private static abstract class EachLineBaseNode
        extends FileNodes.EachLineNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachLineBaseNode next0;

            EachLineBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachLineBaseNode(EachLineBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EachLineBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachLineBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachLineUninitializedNode(this);
                    ((EachLineUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachLineBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EachLineBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachLineBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachLineUninitializedNode(this), (Node)new EachLinePolymorphicNode(this), (DSLNode)((EachLineBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachLineBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyFile(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    return (EachLineBaseNode)EachLineRubyFileNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachLineBaseNode otherCast = (EachLineBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachLineBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.DirnameNode.class)
    public static final class DirnameNodeFactory
    extends NodeFactoryBase<FileNodes.DirnameNode> {
        private static DirnameNodeFactory dirnameNodeFactoryInstance;

        private DirnameNodeFactory() {
            super(FileNodes.DirnameNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.DirnameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DirnameNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.DirnameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DirnameUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.DirnameNode> getInstance() {
            if (dirnameNodeFactoryInstance == null) {
                dirnameNodeFactoryInstance = new DirnameNodeFactory();
            }
            return dirnameNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.DirnameNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DirnamePolymorphicNode
        extends DirnameBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DirnamePolymorphicNode(DirnameBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.DirnameNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DirnameRubyStringNode
        extends DirnameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DirnameRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DirnameRubyStringNode(DirnameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.dirname(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.dirname(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.DirnameNode create0(FileNodes.DirnameNode current2) {
                return new DirnameRubyStringNode((DirnameBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.DirnameNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DirnameUninitializedNode
        extends DirnameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DirnameUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DirnameUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DirnameUninitializedNode(DirnameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DirnameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DirnameBaseNode rootNode = (DirnameBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DirnameBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.DirnameNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DirnameUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.DirnameNode.class)
        private static abstract class DirnameBaseNode
        extends FileNodes.DirnameNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DirnameBaseNode next0;

            DirnameBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DirnameBaseNode(DirnameBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                DirnameBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DirnameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DirnameUninitializedNode(this);
                    ((DirnameUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DirnameBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DirnameBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (DirnameBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DirnameUninitializedNode(this), (Node)new DirnamePolymorphicNode(this), (DSLNode)((DirnameBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DirnameBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DirnameBaseNode)DirnameRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DirnameBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DirnameBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.DirectoryNode.class)
    public static final class DirectoryNodeFactory
    extends NodeFactoryBase<FileNodes.DirectoryNode> {
        private static DirectoryNodeFactory directoryNodeFactoryInstance;

        private DirectoryNodeFactory() {
            super(FileNodes.DirectoryNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.DirectoryNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DirectoryNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.DirectoryNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DirectoryUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.DirectoryNode> getInstance() {
            if (directoryNodeFactoryInstance == null) {
                directoryNodeFactoryInstance = new DirectoryNodeFactory();
            }
            return directoryNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.DirectoryNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DirectoryPolymorphicNode
        extends DirectoryBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DirectoryPolymorphicNode(DirectoryBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.DirectoryNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DirectoryRubyStringNode
        extends DirectoryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DirectoryRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DirectoryRubyStringNode(DirectoryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.directory(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.directory(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.DirectoryNode create0(FileNodes.DirectoryNode current2) {
                return new DirectoryRubyStringNode((DirectoryBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.DirectoryNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DirectoryUninitializedNode
        extends DirectoryBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DirectoryUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DirectoryUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DirectoryUninitializedNode(DirectoryBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DirectoryBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DirectoryBaseNode rootNode = (DirectoryBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DirectoryBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.DirectoryNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DirectoryUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.DirectoryNode.class)
        private static abstract class DirectoryBaseNode
        extends FileNodes.DirectoryNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DirectoryBaseNode next0;

            DirectoryBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DirectoryBaseNode(DirectoryBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                DirectoryBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DirectoryBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DirectoryUninitializedNode(this);
                    ((DirectoryUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DirectoryBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DirectoryBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (DirectoryBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DirectoryUninitializedNode(this), (Node)new DirectoryPolymorphicNode(this), (DSLNode)((DirectoryBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DirectoryBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DirectoryBaseNode)DirectoryRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DirectoryBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DirectoryBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.DeleteNode.class)
    public static final class DeleteNodeFactory
    extends NodeFactoryBase<FileNodes.DeleteNode> {
        private static DeleteNodeFactory deleteNodeFactoryInstance;

        private DeleteNodeFactory() {
            super(FileNodes.DeleteNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.DeleteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.DeleteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DeleteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.DeleteNode> getInstance() {
            if (deleteNodeFactoryInstance == null) {
                deleteNodeFactoryInstance = new DeleteNodeFactory();
            }
            return deleteNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DeletePolymorphicNode
        extends DeleteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DeletePolymorphicNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteRubyStringNode
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            DeleteRubyStringNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.delete(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.delete(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.DeleteNode create0(FileNodes.DeleteNode current2) {
                return new DeleteRubyStringNode((DeleteBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DeleteUninitializedNode
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DeleteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DeleteUninitializedNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DeleteBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DeleteBaseNode rootNode = (DeleteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DeleteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.DeleteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DeleteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.DeleteNode.class)
        private static abstract class DeleteBaseNode
        extends FileNodes.DeleteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DeleteBaseNode next0;

            DeleteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DeleteBaseNode(DeleteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                DeleteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DeleteBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DeleteUninitializedNode(this);
                    ((DeleteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DeleteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DeleteBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (DeleteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DeleteUninitializedNode(this), (Node)new DeletePolymorphicNode(this), (DSLNode)((DeleteBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DeleteBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (DeleteBaseNode)DeleteRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DeleteBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DeleteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.CloseNode.class)
    public static final class CloseNodeFactory
    extends NodeFactoryBase<FileNodes.CloseNode> {
        private static CloseNodeFactory closeNodeFactoryInstance;

        private CloseNodeFactory() {
            super(FileNodes.CloseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.CloseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CloseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.CloseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CloseUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.CloseNode> getInstance() {
            if (closeNodeFactoryInstance == null) {
                closeNodeFactoryInstance = new CloseNodeFactory();
            }
            return closeNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.CloseNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClosePolymorphicNode
        extends CloseBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ClosePolymorphicNode(CloseBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.CloseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CloseRubyFileNode
        extends CloseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CloseRubyFileNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyFile.class}, 0, 0);

            CloseRubyFileNode(CloseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyFile arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyFile(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyFile");
                }
                return super.close(arguments0Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyFile(arguments0Value)) {
                    RubyFile arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyFile(arguments0Value);
                    return super.close(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.CloseNode create0(FileNodes.CloseNode current2) {
                return new CloseRubyFileNode((CloseBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.CloseNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CloseUninitializedNode
        extends CloseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CloseUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CloseUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CloseUninitializedNode(CloseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CloseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CloseBaseNode rootNode = (CloseBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CloseBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.CloseNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CloseUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.CloseNode.class)
        private static abstract class CloseBaseNode
        extends FileNodes.CloseNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CloseBaseNode next0;

            CloseBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CloseBaseNode(CloseBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                CloseBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CloseBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CloseUninitializedNode(this);
                    ((CloseUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CloseBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = CloseBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (CloseBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CloseUninitializedNode(this), (Node)new ClosePolymorphicNode(this), (DSLNode)((CloseBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CloseBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyFile(arguments0Value)) {
                    return (CloseBaseNode)CloseRubyFileNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CloseBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CloseBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=FileNodes.AbsolutePathNode.class)
    public static final class AbsolutePathNodeFactory
    extends NodeFactoryBase<FileNodes.AbsolutePathNode> {
        private static AbsolutePathNodeFactory absolutePathNodeFactoryInstance;

        private AbsolutePathNodeFactory() {
            super(FileNodes.AbsolutePathNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FileNodes.AbsolutePathNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AbsolutePathNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FileNodes.AbsolutePathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AbsolutePathUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FileNodes.AbsolutePathNode> getInstance() {
            if (absolutePathNodeFactoryInstance == null) {
                absolutePathNodeFactoryInstance = new AbsolutePathNodeFactory();
            }
            return absolutePathNodeFactoryInstance;
        }

        @GeneratedBy(value=FileNodes.AbsolutePathNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AbsolutePathPolymorphicNode
        extends AbsolutePathBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            AbsolutePathPolymorphicNode(AbsolutePathBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FileNodes.AbsolutePathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AbsolutePathRubyStringNode
        extends AbsolutePathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AbsolutePathRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            AbsolutePathRubyStringNode(AbsolutePathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.absolutePath(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.absolutePath(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.AbsolutePathNode create0(FileNodes.AbsolutePathNode current2) {
                return new AbsolutePathRubyStringNode((AbsolutePathBaseNode)current2);
            }
        }

        @GeneratedBy(value=FileNodes.AbsolutePathNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AbsolutePathUninitializedNode
        extends AbsolutePathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AbsolutePathUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AbsolutePathUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AbsolutePathUninitializedNode(AbsolutePathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                AbsolutePathBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AbsolutePathBaseNode rootNode = (AbsolutePathBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AbsolutePathBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FileNodes.AbsolutePathNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AbsolutePathUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FileNodes.AbsolutePathNode.class)
        private static abstract class AbsolutePathBaseNode
        extends FileNodes.AbsolutePathNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AbsolutePathBaseNode next0;

            AbsolutePathBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AbsolutePathBaseNode(AbsolutePathBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                AbsolutePathBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AbsolutePathBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new AbsolutePathUninitializedNode(this);
                    ((AbsolutePathUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AbsolutePathBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = AbsolutePathBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (AbsolutePathBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AbsolutePathUninitializedNode(this), (Node)new AbsolutePathPolymorphicNode(this), (DSLNode)((AbsolutePathBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AbsolutePathBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (AbsolutePathBaseNode)AbsolutePathRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((AbsolutePathBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (AbsolutePathBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

