/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jruby.RubyEncoding;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.ByteList;

@CoreClass(name="Encoding")
public abstract class EncodingNodes {

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(org.jruby.truffle.runtime.core.RubyEncoding encoding2) {
            ByteList nameByteList = encoding2.getName().dup();
            nameByteList.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            if (encoding2.isDummy()) {
                return this.getContext().makeString(String.format("#<Encoding:%s (dummy)>", nameByteList.toString()));
            }
            return this.getContext().makeString(String.format("#<Encoding:%s>", nameByteList.toString()));
        }
    }

    @CoreMethod(names={"name", "to_s"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(org.jruby.truffle.runtime.core.RubyEncoding encoding2) {
            ByteList name2 = encoding2.getName().dup();
            name2.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            return this.getContext().makeString(name2);
        }
    }

    @CoreMethod(names={"dummy?"})
    public static abstract class DummyNode
    extends CoreMethodNode {
        public DummyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DummyNode(DummyNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isDummy(org.jruby.truffle.runtime.core.RubyEncoding encoding2) {
            DummyNode.notDesignedForCompilation();
            return encoding2.isDummy();
        }
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodNode {
        public ListNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ListNode(ListNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray list() {
            ListNode.notDesignedForCompilation();
            org.jruby.truffle.runtime.core.RubyEncoding[] encodings = org.jruby.truffle.runtime.core.RubyEncoding.cloneEncodingList();
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), encodings, encodings.length);
        }
    }

    @CoreMethod(names={"name_list"}, onSingleton=true)
    public static abstract class NameListNode
    extends CoreMethodNode {
        public NameListNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NameListNode(NameListNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray find() {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e;
            NameListNode.notDesignedForCompilation();
            EncodingService service = this.getContext().getRuntime().getEncodingService();
            Object[] array = new Object[service.getEncodings().size() + service.getAliases().size() + 2];
            int n = 0;
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i2 = service.getEncodings().entryIterator();
            while (i2.hasNext()) {
                e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)i2.next();
                array[n++] = new RubyString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(e.bytes, e.p, e.end - e.p));
            }
            i2 = service.getAliases().entryIterator();
            while (i2.hasNext()) {
                e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)i2.next();
                array[n++] = new RubyString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(e.bytes, e.p, e.end - e.p));
            }
            array[n++] = new RubyString(this.getContext().getCoreLibrary().getStringClass(), RubyEncoding.EXTERNAL);
            array[n++] = new RubyString(this.getContext().getCoreLibrary().getStringClass(), RubyEncoding.LOCALE);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), array, array.length);
        }
    }

    @CoreMethod(names={"find"}, onSingleton=true, required=1)
    public static abstract class FindNode
    extends CoreMethodNode {
        public FindNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FindNode(FindNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyEncoding find(RubyString name2) {
            FindNode.notDesignedForCompilation();
            return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(name2.toString());
        }
    }

    @CoreMethod(names={"default_internal="}, onSingleton=true, required=1)
    public static abstract class SetDefaultInternalNode
    extends CoreMethodNode {
        public SetDefaultInternalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SetDefaultInternalNode(SetDefaultInternalNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyEncoding defaultExternal(org.jruby.truffle.runtime.core.RubyEncoding encoding2) {
            SetDefaultInternalNode.notDesignedForCompilation();
            this.getContext().getRuntime().setDefaultInternalEncoding(encoding2.getEncoding());
            return encoding2;
        }

        @Specialization
        public RubyNilClass defaultExternal(RubyNilClass encoding2) {
            SetDefaultInternalNode.notDesignedForCompilation();
            this.getContext().getRuntime().setDefaultInternalEncoding((Encoding)ASCIIEncoding.INSTANCE);
            return encoding2;
        }
    }

    @CoreMethod(names={"default_external="}, onSingleton=true, required=1)
    public static abstract class SetDefaultExternalNode
    extends CoreMethodNode {
        public SetDefaultExternalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SetDefaultExternalNode(SetDefaultExternalNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyEncoding defaultExternal(org.jruby.truffle.runtime.core.RubyEncoding encoding2) {
            SetDefaultExternalNode.notDesignedForCompilation();
            this.getContext().getRuntime().setDefaultExternalEncoding(encoding2.getEncoding());
            return encoding2;
        }
    }

    @CoreMethod(names={"default_internal"}, onSingleton=true)
    public static abstract class DefaultInternalNode
    extends CoreMethodNode {
        public DefaultInternalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DefaultInternalNode(DefaultInternalNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyEncoding defaultInternal() {
            DefaultInternalNode.notDesignedForCompilation();
            Encoding encoding2 = this.getContext().getRuntime().getDefaultInternalEncoding();
            if (encoding2 == null) {
                encoding2 = UTF8Encoding.INSTANCE;
            }
            return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(encoding2);
        }
    }

    @CoreMethod(names={"default_external"}, onSingleton=true)
    public static abstract class DefaultExternalNode
    extends CoreMethodNode {
        public DefaultExternalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DefaultExternalNode(DefaultExternalNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyEncoding defaultExternal() {
            DefaultExternalNode.notDesignedForCompilation();
            Encoding encoding2 = this.getContext().getRuntime().getDefaultExternalEncoding();
            if (encoding2 == null) {
                encoding2 = UTF8Encoding.INSTANCE;
            }
            return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(encoding2);
        }
    }

    @CoreMethod(names={"compatible?"}, needsSelf=false, onSingleton=true, required=2)
    public static abstract class CompatibleQueryNode
    extends CoreMethodNode {
        ConditionProfile compatibleEncodingProfile = ConditionProfile.createBinaryProfile();

        public CompatibleQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompatibleQueryNode(CompatibleQueryNode prev) {
            super(prev);
        }

        @Specialization
        public Object isCompatible(RubyString first2, RubyString second) {
            CompatibleQueryNode.notDesignedForCompilation();
            Encoding compatibleEncoding = RubyEncoding.areCompatible(first2, second);
            if (this.compatibleEncodingProfile.profile(compatibleEncoding != null)) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization
        public Object isCompatible(org.jruby.truffle.runtime.core.RubyEncoding first2, org.jruby.truffle.runtime.core.RubyEncoding second) {
            CompatibleQueryNode.notDesignedForCompilation();
            Encoding compatibleEncoding = RubyEncoding.areCompatible(first2.getEncoding(), second.getEncoding());
            if (this.compatibleEncodingProfile.profile(compatibleEncoding != null)) {
                return org.jruby.truffle.runtime.core.RubyEncoding.getEncoding(compatibleEncoding);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }
}

